/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.addressbook;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.addressbook.VoiceChatMode;
import com.blisscloud.ezuc.client.component.EntryPanel;
import com.blisscloud.ezuc.client.component.PersonalPhoto;
import com.blisscloud.ezuc.client.component.RoundedCornerLabel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.tool.CustomBorder;
import com.blisscloud.ezuc.client.util.ChatRoomUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBConf;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.OutboundPrefixManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.Timer;

public class ChatRoomEntryPanel
extends EntryPanel {
    private PersonalPhoto icon;
    private JLabel title;
    private JLabel lblMemberCount;
    private JLabel lblSummary;
    private RoundedCornerLabel btnCall;
    String roomJID;
    ChatRoomInfo roomInfo;
    VoiceChatMode mode;
    Timer timer1 = null;

    public ChatRoomEntryPanel(String roomJID) {
        this.initGUI();
        this.setChatRoomInfo(ChatRoomManager.getChatRoom(UCChatClient.context, roomJID));
    }

    public ChatRoomEntryPanel(ChatRoomInfo roomInfo) {
        this.initGUI();
        this.setChatRoomInfo(roomInfo);
    }

    public void setChatRoomInfo(ChatRoomInfo roomInfo) {
        if (roomInfo == null) {
            throw new RuntimeException("roomInfo is null!");
        }
        int type = roomInfo.getType();
        if (type != 2 && type != 1) {
            throw new RuntimeException("roomInfo is not conf or chatroom type!");
        }
        this.roomInfo = roomInfo;
        this.roomJID = roomInfo.getChatRoomId();
        this.icon.setImage(UIConstants.ICON_CHATROOM_48.getImage());
        this.lblSummary.setText("");
        this.lblMemberCount.setText("");
        Activity ctx = UCChatClient.context;
        LiteConferenceRoom confRoom = UCDBConf.getConfRoomByChatRoomId(ctx, this.roomJID);
        ArrayList<String> participantJidList = UCDBChatRoom.findChatRoomParticipants((Context)ctx, this.roomJID);
        HashMap<String, LiteContact> contactsMap = new HashMap<String, LiteContact>();
        String chatRoomTitle = ChatRoomUtil.getChatRoomTitleForList(ctx, roomInfo, participantJidList, contactsMap);
        Object titleStr = chatRoomTitle;
        if (confRoom != null) {
            titleStr = chatRoomTitle + " (" + OutboundPrefixManager.getMeetmePrefix(ctx) + confRoom.getRoomNo() + ")";
        }
        this.title.setText((String)titleStr);
        this.icon.setImage(GraphicUtil.getChatRoomImage(ctx, participantJidList, contactsMap, false, true));
        int count = 0;
        for (int i = 0; i < participantJidList.size(); ++i) {
            LiteContact contact = ContactManager.getContact((Context)UCChatClient.context, (String)participantJidList.get(i));
            if (contact == null) continue;
            ++count;
        }
        this.lblMemberCount.setText(String.format(I18NUtil.getString("conference_member_count"), count));
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            this.setLayout(thisLayout);
            this.setPreferredSize(EntryPanel.ENTRY_SIZE);
            this.setBorder(new CustomBorder());
            this.setBackground(EntryPanel.ENTRY_BACKGROUND);
            this.setOpaque(false);
            this.icon = new PersonalPhoto();
            this.add((Component)this.icon, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.icon.setPreferredSize(new Dimension(48, 48));
            this.icon.setMinimumSize(new Dimension(48, 48));
            this.title = new JLabel();
            this.add((Component)this.title, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(2, 10, 0, 0), 0, 0));
            this.title.setFont(UIConstants.FONT_14_PLAIN);
            this.title.setText("");
            JPanel panelCall = new JPanel();
            this.add((Component)panelCall, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
            FlowLayout panelFunctionLayout = new FlowLayout();
            panelFunctionLayout.setHgap(4);
            panelFunctionLayout.setVgap(0);
            panelCall.setLayout(panelFunctionLayout);
            panelCall.setOpaque(false);
            this.btnCall = new RoundedCornerLabel(I18NUtil.getString("call_btn_callout"), UIConstants.ICON_DIAL, UIConstants.BACKGROUND_CALL_NORMAL, UIConstants.BACKGROUND_CALL_OVER, UIConstants.BACKGROUND_CALL_PRESSED);
            panelCall.add(this.btnCall);
            this.btnCall.setForeground(Color.WHITE);
            this.btnCall.setCursor(UIConstants.CURSOR_HAND);
            this.setCallBtnVisible(false);
            this.btnCall.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (ChatRoomEntryPanel.this.btnCall.isEnabled() && evt.getButton() == 1) {
                        ChatRoomEntryPanel.this.startDialOut();
                    }
                }
            });
            this.lblMemberCount = new JLabel();
            this.add((Component)this.lblMemberCount, new GridBagConstraints(5, 0, 1, 3, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.lblMemberCount.setFont(UIConstants.FONT_12_PLAIN);
            this.lblMemberCount.setForeground(UIConstants.COLOR_LIGHT_GRAY);
            this.lblSummary = new JLabel();
            this.add((Component)this.lblSummary, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(0, 10, 2, 0), 0, 0));
            this.lblSummary.setFont(UIConstants.FONT_12_PLAIN);
            this.lblSummary.setForeground(UIConstants.COLOR_LIGHT_GRAY);
            this.lblSummary.setText("");
            this.lblSummary.setVisible(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startDialOut() {
        if (this.btnCall.isEnabled()) {
            ChatRoomManager.startDialOut(this.btnCall, this.roomJID);
        }
    }

    @Override
    public EntryPanel.Type getType() {
        return EntryPanel.Type.CHAT_ROOM;
    }

    @Override
    public String getEntryId() {
        return EntryPanel.Type.CHAT_ROOM.name() + "-" + this.roomJID;
    }

    @Override
    public String getValueId() {
        return this.roomJID;
    }

    @Override
    public String getChatId() {
        return this.roomJID;
    }

    @Override
    public String getPhoneNumber() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return this.title.getText();
    }

    @Override
    public String getSummary() {
        return this.lblSummary.getText();
    }

    public VoiceChatMode getVoiceChatMode() {
        return this.mode;
    }

    @Override
    public void setSelected(boolean b) {
        super.setSelected(b);
        if (!this.selected) {
            this.setCallBtnVisible(false);
        } else {
            PhoneAgent.LineAvailableType ableToCall = PhoneAgent.getInstance().isAvailableToCall();
            this.setCallBtnVisible(ableToCall != PhoneAgent.LineAvailableType.NONE);
        }
    }

    private synchronized void setCallBtnVisible(final boolean btnVisible) {
        if (this.timer1 != null) {
            this.timer1.stop();
            this.timer1 = null;
        }
        if (btnVisible) {
            this.timer1 = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ld2) {
                    ChatRoomEntryPanel.this.btnCall.setVisible(btnVisible);
                }
            });
            this.timer1.setRepeats(false);
            this.timer1.start();
        } else {
            this.btnCall.setVisible(btnVisible);
        }
    }

    public String getRoomJID() {
        return this.roomJID;
    }
}

