/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.addressbook;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteGenderType;
import com.blisscloud.ezuc.bean.web.LiteDepartment;
import com.blisscloud.ezuc.bean.web.LiteSite;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.bean.ExtenNode;
import com.blisscloud.ezuc.client.bean.ExtendedSysNode;
import com.blisscloud.ezuc.client.bean.Node;
import com.blisscloud.ezuc.client.component.EmailLabel;
import com.blisscloud.ezuc.client.component.HintTextField;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.component.UCPopupWindow;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.LiteContactHelper;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.db.UCDBDept;
import com.blisscloud.mobile.ezuc.db.UCDBSite;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.DialoutManager;
import com.blisscloud.mobile.ezuc.manager.SiteManager;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.EmpExtendedSysPhoneConfig;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import org.apache.commons.lang3.StringUtils;

public class EmployeeInfoPopup
extends UCPopupWindow {
    private JPanel panelContent;
    private JLabel lblGender;
    private JLabel lblName;
    private JLabel lblOtherName;
    private JButton btnClose;
    private JLabel lblDepartmentHeader;
    private JLabel lblDepartment;
    private JLabel lblExtensionHeader;
    private JLabel lblExtension;
    private JLabel lblBirthdayHeader;
    private JLabel lblBirthday;
    private JLabel lblMobilePhoneHeader;
    private JTextPane lblMobilePhone;
    private JLabel lblHomeAddressHeader;
    private JTextPane lblHomeAddress;
    private EmailLabel lblEmail;
    private JLabel lblEmailHeader;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JSeparator jSeparator5;
    private JSeparator jSeparator4;
    private JSeparator jSeparator3;
    private JSeparator jSeparator2;
    private JSeparator jSeparator1;
    private String mJid;
    boolean mShowSite;
    final int Extra_Extension_Init_GridY = 3;
    int extensionCount = 0;
    int currentExtraExtensionGridY = 3;
    List<Component> extraExtensionComps = new ArrayList<Component>();

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                EmployeeInfoPopup inst = new EmployeeInfoPopup(frame);
                inst.setVisible(true);
            }
        });
    }

    public EmployeeInfoPopup(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.panelContent = new RoundedCornerPanel();
            BorderLayout panelContentLayout = new BorderLayout();
            panelContentLayout.setVgap(10);
            this.getContentPane().add((Component)this.panelContent, "Center");
            this.panelContent.setLayout(panelContentLayout);
            this.panelContent.setBorder(BorderFactory.createEmptyBorder(8, 15, 8, 15));
            this.panelContent.setBackground(new Color(233, 248, 255));
            this.jPanel3 = new JPanel();
            this.panelContent.add((Component)this.jPanel3, "North");
            GridBagLayout jPanel3Layout = new GridBagLayout();
            this.jPanel3.setLayout(jPanel3Layout);
            this.jPanel3.setOpaque(false);
            this.lblGender = new JLabel();
            this.jPanel3.add((Component)this.lblGender, new GridBagConstraints(0, 0, 1, 2, 0.0, 0.0, 10, 0, new Insets(0, 3, 0, 0), 0, 0));
            this.lblName = new JLabel();
            this.jPanel3.add((Component)this.lblName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 10, 0, 10), 0, 0));
            this.lblName.setText("Albert.Chiou");
            this.lblName.setFont(UIConstants.FONT_14_BOLD);
            this.lblOtherName = new JLabel();
            this.jPanel3.add((Component)this.lblOtherName, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 10, 0, 10), 0, 0));
            this.lblOtherName.setText("");
            this.lblOtherName.setFont(UIConstants.FONT_14_BOLD);
            this.btnClose = new JButton();
            this.jPanel3.add((Component)this.btnClose, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 12, 2, new Insets(5, 5, 0, 5), 0, 0));
            this.btnClose.setIcon(UIConstants.ICON_CLOSE);
            this.btnClose.setPreferredSize(new Dimension(20, 20));
            this.btnClose.setFocusPainted(false);
            this.btnClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EmployeeInfoPopup.this.btnCloseActionPerformed(evt);
                }
            });
            this.jPanel1 = new RoundedCornerPanel();
            GridBagLayout jPanel1Layout = new GridBagLayout();
            this.panelContent.add((Component)this.jPanel1, "Center");
            this.jPanel1.setLayout(jPanel1Layout);
            this.jPanel1.setBackground(Color.WHITE);
            this.lblDepartmentHeader = new JLabel();
            this.jPanel1.add((Component)this.lblDepartmentHeader, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblDepartmentHeader.setText(I18NUtil.getString("abook_department"));
            this.lblDepartmentHeader.setFont(UIConstants.FONT_12_BOLD);
            this.lblDepartment = new JLabel();
            this.jPanel1.add((Component)this.lblDepartment, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblDepartment.setText(I18NUtil.getString("common_not_yet_setting"));
            this.lblDepartment.setForeground(HintTextField.HINT_COLOR);
            this.lblDepartment.setFont(UIConstants.FONT_12_PLAIN);
            this.jSeparator1 = new JSeparator();
            this.jPanel1.add((Component)this.jSeparator1, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator1.setForeground(Color.LIGHT_GRAY);
            this.jSeparator1.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
            this.lblExtensionHeader = new JLabel();
            this.jPanel1.add((Component)this.lblExtensionHeader, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblExtensionHeader.setText(I18NUtil.getString("abook_extension"));
            this.lblExtensionHeader.setFont(UIConstants.FONT_12_BOLD);
            this.lblExtension = new JLabel();
            this.jPanel1.add((Component)this.lblExtension, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblExtension.setText(I18NUtil.getString("common_not_yet_setting"));
            this.lblExtension.setForeground(HintTextField.HINT_COLOR);
            this.lblExtension.setFont(UIConstants.FONT_12_PLAIN);
            this.jSeparator2 = new JSeparator();
            this.jPanel1.add((Component)this.jSeparator2, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator2.setForeground(Color.LIGHT_GRAY);
            this.jSeparator2.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
            this.jPanel2 = new RoundedCornerPanel();
            GridBagLayout jPanel2Layout = new GridBagLayout();
            this.panelContent.add((Component)this.jPanel2, "South");
            this.jPanel2.setLayout(jPanel2Layout);
            this.jPanel2.setBackground(Color.WHITE);
            this.lblMobilePhoneHeader = new JLabel();
            this.jPanel2.add((Component)this.lblMobilePhoneHeader, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblMobilePhoneHeader.setText(I18NUtil.getString("abook_mobile"));
            this.lblMobilePhoneHeader.setIcon(UIConstants.ICON_MOBILEPHONE);
            this.lblMobilePhoneHeader.setFont(UIConstants.FONT_12_BOLD);
            this.lblMobilePhone = new JTextPane();
            this.jPanel2.add((Component)this.lblMobilePhone, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 13, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblMobilePhone.setText(I18NUtil.getString("common_not_yet_setting"));
            this.lblMobilePhone.setBorder(BorderFactory.createEmptyBorder());
            this.lblMobilePhone.setEditorKit(new HTMLEditorKit());
            this.lblMobilePhone.setDocument(new HTMLDocument());
            this.lblMobilePhone.setFont(UIConstants.FONT_12_PLAIN);
            this.lblMobilePhone.setEditable(false);
            this.lblMobilePhone.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent evt) {
                    if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        EmployeeInfoPopup.this.tpMobilePhoneHyperlinkActivated(evt);
                    }
                }
            });
            this.jSeparator3 = new JSeparator();
            this.jPanel2.add((Component)this.jSeparator3, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator3.setForeground(Color.LIGHT_GRAY);
            this.jSeparator3.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
            this.lblHomeAddressHeader = new JLabel();
            this.jPanel2.add((Component)this.lblHomeAddressHeader, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblHomeAddressHeader.setText(I18NUtil.getString("abook_home"));
            this.lblHomeAddressHeader.setIcon(UIConstants.ICON_HOME);
            this.lblHomeAddressHeader.setFont(UIConstants.FONT_12_BOLD);
            this.lblHomeAddress = new JTextPane();
            this.jPanel2.add((Component)this.lblHomeAddress, new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 13, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblHomeAddress.setText(I18NUtil.getString("common_not_yet_setting"));
            this.lblHomeAddress.setBorder(BorderFactory.createEmptyBorder());
            this.lblHomeAddress.setEditorKit(new HTMLEditorKit());
            this.lblHomeAddress.setDocument(new HTMLDocument());
            this.lblHomeAddress.setFont(UIConstants.FONT_12_PLAIN);
            this.lblHomeAddress.setEditable(false);
            this.lblHomeAddress.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent evt) {
                    if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        EmployeeInfoPopup.this.tpHomePhoneHyperlinkActivated(evt);
                    }
                }
            });
            this.jSeparator4 = new JSeparator();
            this.jPanel2.add((Component)this.jSeparator4, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator4.setForeground(Color.LIGHT_GRAY);
            this.jSeparator4.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
            this.lblBirthdayHeader = new JLabel();
            this.jPanel2.add((Component)this.lblBirthdayHeader, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblBirthdayHeader.setText(I18NUtil.getString("abook_birthday"));
            this.lblBirthdayHeader.setIcon(UIConstants.ICON_BIRTHDAY);
            this.lblBirthdayHeader.setFont(UIConstants.FONT_12_BOLD);
            this.lblBirthday = new JLabel();
            this.jPanel2.add((Component)this.lblBirthday, new GridBagConstraints(1, 4, 1, 1, 1.0, 0.0, 13, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblBirthday.setText(I18NUtil.getString("common_not_yet_setting"));
            this.lblBirthday.setFont(UIConstants.FONT_12_PLAIN);
            this.jSeparator5 = new JSeparator();
            this.jPanel2.add((Component)this.jSeparator5, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.jSeparator5.setForeground(Color.LIGHT_GRAY);
            this.jSeparator5.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
            this.lblEmailHeader = new JLabel();
            this.jPanel2.add((Component)this.lblEmailHeader, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblEmailHeader.setText(I18NUtil.getString("abook_email"));
            this.lblEmailHeader.setIcon(UIConstants.ICON_MAIL);
            this.lblEmailHeader.setFont(UIConstants.FONT_12_BOLD);
            this.lblEmail = new EmailLabel();
            this.jPanel2.add((Component)this.lblEmail, new GridBagConstraints(1, 6, 1, 1, 1.0, 0.0, 13, 0, new Insets(6, 8, 6, 8), 0, 0));
            this.lblEmail.setEmail(I18NUtil.getString("common_not_yet_setting"));
            this.lblEmail.setFont(UIConstants.FONT_12_PLAIN);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void tpMobilePhoneHyperlinkActivated(HyperlinkEvent evt) {
        DialoutManager.dialEmpOutboundNumber(UCChatClient.context, evt.getDescription(), this.mJid);
    }

    private void tpHomePhoneHyperlinkActivated(HyperlinkEvent evt) {
        DialoutManager.dialEmpOutboundNumber(UCChatClient.context, evt.getDescription(), this.mJid);
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension prefSize = super.getPreferredSize();
        prefSize.width = 300;
        return prefSize;
    }

    public void setContact(LiteContact contact) {
        if (contact == null) {
            return;
        }
        this.mJid = contact.getJid();
        List<LiteSite> siteList = UCDBSite.getAllSites(UCChatClient.context);
        this.mShowSite = siteList != null && siteList.size() > 1;
        LiteGenderType gender = contact.getGender();
        if (gender == LiteGenderType.MALE) {
            this.lblGender.setIcon(UIConstants.ICON_GENDER_MALE);
        } else if (gender == LiteGenderType.FEMALE) {
            this.lblGender.setIcon(UIConstants.ICON_GENDER_FEMALE);
        } else if (gender == LiteGenderType.OTHERS) {
            this.lblGender.setIcon(UIConstants.ICON_GENDER_OTHER);
        }
        this.lblName.setText(ContactManager.getFullEnglishName(contact));
        this.lblOtherName.setText(ContactManager.getNonEnglishName(contact));
        if (TextUtils.isBlank((CharSequence)contact.getDepartmentNamePath())) {
            this.lblDepartment.setText(I18NUtil.getString("common_not_yet_setting"));
            this.lblDepartment.setForeground(HintTextField.HINT_COLOR);
        } else {
            LiteDepartment dept = UCDBDept.getDeptByNamePath(UCChatClient.context, contact.getDepartmentNamePath());
            if (dept != null) {
                this.lblDepartment.setText(dept.getDispName());
                this.lblDepartment.setForeground(UIManager.getColor("Label.foreground"));
            } else {
                this.lblDepartment.setText(contact.getDepartmentNamePath());
                this.lblDepartment.setForeground(UIManager.getColor("Label.foreground"));
            }
        }
        this.loadExtension(contact);
        if (contact.getMobilePhone() == null || contact.getMobilePhone().size() == 0) {
            this.lblMobilePhone.setContentType("text/plan");
            this.lblMobilePhone.setText(I18NUtil.getString("common_not_yet_setting"));
            this.lblMobilePhone.setForeground(HintTextField.HINT_COLOR);
        } else {
            this.lblMobilePhone.setContentType("text/html");
            this.lblMobilePhone.setText(CommonUtil.getNumberHtmlTable(contact.getMobilePhone(), true));
            this.lblMobilePhone.setForeground(UIManager.getColor("Label.foreground"));
        }
        if (contact.getHomePhone() == null || contact.getHomePhone().size() == 0) {
            this.lblHomeAddress.setContentType("text/plan");
            this.lblHomeAddress.setText(I18NUtil.getString("common_not_yet_setting"));
            this.lblHomeAddress.setForeground(HintTextField.HINT_COLOR);
        } else {
            this.lblHomeAddress.setContentType("text/html");
            this.lblHomeAddress.setText(CommonUtil.getNumberHtmlTable(contact.getHomePhone(), true));
            this.lblHomeAddress.setForeground(UIManager.getColor("Label.foreground"));
        }
        if (TextUtils.isBlank((CharSequence)contact.getBirthDayStr())) {
            this.lblBirthday.setText(I18NUtil.getString("common_not_yet_setting"));
            this.lblBirthday.setForeground(HintTextField.HINT_COLOR);
        } else {
            this.lblBirthday.setText(contact.getBirthDayStr());
            this.lblBirthday.setForeground(UIManager.getColor("Label.foreground"));
        }
        if (TextUtils.isBlank((CharSequence)contact.getEmail())) {
            this.lblEmail.setText(I18NUtil.getString("common_not_yet_setting"));
            this.lblEmail.setForeground(HintTextField.HINT_COLOR);
        } else {
            this.lblEmail.setText(contact.getEmail());
            this.lblEmail.setForeground(UIManager.getColor("Label.foreground"));
        }
        this.revalidate();
        this.repaint();
    }

    private void loadExtension(LiteContact contact) {
        String label;
        this.extensionCount = 0;
        this.currentExtraExtensionGridY = 3;
        for (Component extraExtensionComp : this.extraExtensionComps) {
            this.jPanel1.remove(extraExtensionComp);
        }
        this.extraExtensionComps.clear();
        Activity ctx = UCChatClient.context;
        ArrayList<Node> data = new ArrayList<Node>();
        LiteContactHelper.addExtNoByContact(ctx, data, true, contact);
        EmpExtendedSysPhoneConfig config = PreferencesUtil.getEmpExtendedSysPhoneConfig(ctx);
        if (config.isEmpExtendedSystemPhoneFlag1() && StringUtils.isNotBlank((CharSequence)contact.getExtendedPhoneNumber1())) {
            label = config.getEmpExtendedSysPhoneName1(I18NUtil.getAppLocale());
            data.add(new ExtendedSysNode(contact.getJid(), label, contact.getExtendedPhoneNumber1(), true));
        }
        if (config.isEmpExtendedSystemPhoneFlag2() && StringUtils.isNotBlank((CharSequence)contact.getExtendedPhoneNumber2())) {
            label = config.getEmpExtendedSysPhoneName2(I18NUtil.getAppLocale());
            data.add(new ExtendedSysNode(contact.getJid(), label, contact.getExtendedPhoneNumber2(), true));
        }
        if (config.isEmpExtendedSystemPhoneFlag3() && StringUtils.isNotBlank((CharSequence)contact.getExtendedPhoneNumber3())) {
            label = config.getEmpExtendedSysPhoneName3(I18NUtil.getAppLocale());
            data.add(new ExtendedSysNode(contact.getJid(), label, contact.getExtendedPhoneNumber3(), true));
        }
        if (config.isEmpExtendedSystemPhoneFlag4() && StringUtils.isNotBlank((CharSequence)contact.getExtendedPhoneNumber4())) {
            label = config.getEmpExtendedSysPhoneName4(I18NUtil.getAppLocale());
            data.add(new ExtendedSysNode(contact.getJid(), label, contact.getExtendedPhoneNumber4(), true));
        }
        String unknown = I18NUtil.getString("common_not_yet_setting");
        for (Node node : data) {
            if (node instanceof ExtenNode) {
                ExtenNode extenNode = (ExtenNode)node;
                LiteSite site = null;
                Object ext = "";
                if (extenNode.getSiteId() != null) {
                    site = SiteManager.getSite(ctx, extenNode.getSiteId());
                }
                boolean hasData = false;
                if (TextUtils.isBlank((CharSequence)node.getSubText())) {
                    ext = unknown;
                } else {
                    hasData = true;
                    ext = node.getSubText();
                    if (this.mShowSite && site != null) {
                        ext = site.getName() + " " + (String)ext;
                    }
                }
                this.addExtensionData(node.getMainText(), (String)ext, hasData, node);
                continue;
            }
            if (!(node instanceof ExtendedSysNode)) continue;
            String ext = "";
            boolean hasData = false;
            if (TextUtils.isBlank((CharSequence)node.getSubText())) {
                ext = unknown;
            } else {
                hasData = true;
                ext = node.getSubText();
            }
            this.addExtensionData(node.getMainText(), ext, hasData, node);
        }
    }

    private void addExtensionData(String title, String extension, boolean hasData, Node node) {
        if (this.extensionCount == 0) {
            this.lblExtensionHeader.setText(title);
            this.lblExtension.setText(extension);
            if (!hasData) {
                this.lblExtension.setForeground(HintTextField.HINT_COLOR);
            } else {
                this.lblExtension.setForeground(UIManager.getColor("Label.foreground"));
                this.lblExtension.setCursor(UIConstants.CURSOR_HAND);
                this.lblExtension.setForeground(Color.BLUE);
                this.applyListener(this.lblExtension, node);
            }
        } else {
            JSeparator sep = new JSeparator();
            this.jPanel1.add((Component)sep, new GridBagConstraints(0, this.currentExtraExtensionGridY, 2, 1, 0.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            sep.setForeground(Color.LIGHT_GRAY);
            sep.setPreferredSize(new Dimension(Integer.MAX_VALUE, 1));
            JLabel extExtensionTitle = new JLabel();
            this.jPanel1.add((Component)extExtensionTitle, new GridBagConstraints(0, this.currentExtraExtensionGridY + 1, 1, 1, 1.0, 0.0, 17, 0, new Insets(6, 8, 6, 8), 0, 0));
            extExtensionTitle.setText(title);
            extExtensionTitle.setFont(UIConstants.FONT_12_BOLD);
            JLabel extExtension = new JLabel();
            this.jPanel1.add((Component)extExtension, new GridBagConstraints(1, this.currentExtraExtensionGridY + 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(6, 8, 6, 8), 0, 0));
            extExtension.setText(extension);
            extExtension.setFont(UIConstants.FONT_12_PLAIN);
            if (!hasData) {
                extExtension.setForeground(HintTextField.HINT_COLOR);
            } else {
                extExtension.setForeground(UIManager.getColor("Label.foreground"));
                extExtension.setCursor(UIConstants.CURSOR_HAND);
                extExtension.setForeground(Color.BLUE);
                this.applyListener(extExtension, node);
            }
            this.extraExtensionComps.add(sep);
            this.extraExtensionComps.add(extExtensionTitle);
            this.extraExtensionComps.add(extExtension);
            this.currentExtraExtensionGridY += 2;
        }
        ++this.extensionCount;
    }

    private void applyListener(JLabel lblExtension, final Node node) {
        lblExtension.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (node instanceof ExtendedSysNode) {
                    DialoutManager.dialEmpExtendedSys(UCChatClient.context, node.getSubText(), EmployeeInfoPopup.this.mJid);
                } else if (node instanceof ExtenNode) {
                    ExtenNode extNode = (ExtenNode)node;
                    String targetJid = node.getJid();
                    if (JidUtil.isEmployeeJid(targetJid)) {
                        DialoutManager.dialEmpExt(UCChatClient.context, extNode.getSubText(), extNode.getSiteId(), extNode.getJid());
                    } else if (JidUtil.isLocationJid(targetJid)) {
                        LiteContact location = ContactManager.getContact((Context)UCChatClient.context, extNode.getJid());
                        DialoutManager.dialLocation(UCChatClient.context, location);
                    }
                }
            }
        });
    }
}

