/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.addressbook;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.addressbook.VoiceChatMode;
import com.blisscloud.ezuc.client.chat.roomimpl.ConferenceChatroom;
import com.blisscloud.ezuc.client.component.EntryPanel;
import com.blisscloud.ezuc.client.component.PersonalPhoto;
import com.blisscloud.ezuc.client.component.RoundedCornerLabel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.tool.CustomBorder;
import com.blisscloud.ezuc.client.util.ChatRoomUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.Utils;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBContact;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ConferenceHelper;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import com.blisscloud.mobile.ezuc.manager.OutboundPrefixManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class MeetmeEntryPanel
extends EntryPanel
implements ConferenceHelper.VerifyResult {
    private PersonalPhoto lblHeadIcon;
    private JPanel jPanel1;
    private JLabel lblSubject;
    private JLabel lblRoomNo;
    private RoundedCornerLabel lblCount;
    private JLabel lblSummary;
    private RoundedCornerLabel btnJoin;
    private RoundedCornerLabel btnLocked;
    private RoundedCornerLabel btnCall;
    LiteConferenceRoom liteConfRoom;
    Long mRoomId;
    String mRoomJID;
    boolean mRoomJoined = false;
    VoiceChatMode mode;
    private ConferenceHelper mConferenceHelper = null;
    Timer timer1 = null;

    public MeetmeEntryPanel(LiteConferenceRoom liteConfRoom) {
        this.initGUI();
        this.liteConfRoom = liteConfRoom;
        this.mRoomId = liteConfRoom.getRoomId();
        this.updateMeetme();
    }

    public void updateMeetme() {
        LiteConferenceRoom uLiteConfRoom = MeetmeManager.getMeetme((Context)UCChatClient.context, this.mRoomId);
        if (uLiteConfRoom == null) {
            Log.e(MeetmeEntryPanel.class.getSimpleName(), "cannot find LiteConferenceRoom for " + this.mRoomId);
            return;
        }
        this.liteConfRoom = uLiteConfRoom;
        this.mRoomJID = this.liteConfRoom.getChatRoomId();
        this.mRoomJoined = UCDBChatRoom.hasParticipants(UCChatClient.context, this.mRoomJID);
        String roomNo = OutboundPrefixManager.getMeetmePrefix(UCChatClient.context) + this.liteConfRoom.getRoomNo();
        this.lblRoomNo.setText("(" + roomNo + ")");
        ChatRoomInfo roomInfo = ChatRoomManager.getChatRoom(UCChatClient.context, this.mRoomJID);
        if (this.mRoomJoined) {
            this.lblSubject.setText(ChatRoomUtil.getConfRoomTitle(UCChatClient.context, roomInfo, this.liteConfRoom, false, true));
            int count = Utils.getConferenceRoomCount(UCChatClient.context, this.liteConfRoom.getRoomId(), this.mRoomJID);
            this.lblCount.setText(String.valueOf(count));
            this.lblCount.setVisible(true);
        } else {
            this.lblSubject.setText(ChatRoomUtil.getConfRoomTitle(UCChatClient.context, roomInfo, this.liteConfRoom, false, false));
            this.lblCount.setVisible(false);
        }
        this.lblSummary.setText(I18NUtil.getString("conference_label_chairman") + this.getMeetmeMemberName());
        if (TextUtils.isBlank((CharSequence)this.mRoomJID)) {
            this.btnJoin.setVisible(false);
            this.setCallBtnVisible(false);
            this.lblHeadIcon.setImage(UIConstants.ICON_CONFERENCEROOM_IDLE_48.getImage());
            this.btnLocked.setVisible(false);
        } else {
            if (this.mRoomJoined) {
                PhoneAgent.LineAvailableType ableToCallConf = PhoneAgent.getInstance().isAvailableToCall();
                this.btnJoin.setVisible(false);
                this.setCallBtnVisible(this.selected && ableToCallConf != PhoneAgent.LineAvailableType.NONE);
                this.lblHeadIcon.setImage(UIConstants.ICON_CONFERENCEROOM_USING_48.getImage());
            } else {
                this.btnJoin.setVisible(true);
                this.setCallBtnVisible(false);
                this.lblHeadIcon.setImage(UIConstants.ICON_CONFERENCEROOM_IDLE_48.getImage());
            }
            this.btnLocked.setVisible(this.liteConfRoom.isLocked());
        }
    }

    public void updateMeetmeTitile(String title) {
        this.lblSubject.setText(title);
    }

    private String getMeetmeMemberName() {
        LiteContact managerContact;
        StringBuffer summary2Buffer = new StringBuffer();
        String comma = I18NUtil.getString("comma");
        if (this.liteConfRoom.getChairmanIds() != null && this.liteConfRoom.getChairmanIds().size() > 0) {
            for (int k = 0; k < this.liteConfRoom.getChairmanIds().size(); ++k) {
                Long chairmanId;
                LiteContact managerContact2;
                if (k != 0) {
                    summary2Buffer.append(comma);
                }
                if ((managerContact2 = UCDBContact.getContactByEmpId(UCChatClient.context, chairmanId = this.liteConfRoom.getChairmanIds().get(k))) == null) continue;
                summary2Buffer.append(ContactManager.getContactShortName((Context)UCChatClient.context, managerContact2));
            }
        } else if (this.liteConfRoom.getManagerId() != null && (managerContact = UCDBContact.getContactByEmpId(UCChatClient.context, this.liteConfRoom.getManagerId())) != null) {
            summary2Buffer.append(ContactManager.getContactShortName((Context)UCChatClient.context, managerContact));
        }
        return summary2Buffer.toString();
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            this.setLayout(thisLayout);
            this.setPreferredSize(EntryPanel.ENTRY_SIZE);
            this.setBorder(new CustomBorder());
            this.setBackground(EntryPanel.ENTRY_BACKGROUND);
            this.setOpaque(false);
            this.lblHeadIcon = new PersonalPhoto();
            this.add((Component)this.lblHeadIcon, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblHeadIcon.setPreferredSize(new Dimension(48, 48));
            this.lblHeadIcon.setMinimumSize(new Dimension(48, 48));
            this.jPanel1 = new JPanel();
            FlowLayout jPanel1Layout = new FlowLayout();
            jPanel1Layout.setHgap(2);
            jPanel1Layout.setVgap(0);
            jPanel1Layout.setAlignment(0);
            this.jPanel1.setLayout(jPanel1Layout);
            this.add((Component)this.jPanel1, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 17, 1, new Insets(5, 10, 2, 0), 0, 0));
            this.jPanel1.setOpaque(false);
            this.lblSubject = new JLabel();
            this.jPanel1.add(this.lblSubject);
            this.lblSubject.setFont(UIConstants.FONT_14_PLAIN);
            this.lblSubject.setText("Room Subject");
            this.lblRoomNo = new JLabel();
            this.jPanel1.add(this.lblRoomNo);
            this.lblRoomNo.setFont(UIConstants.FONT_12_PLAIN);
            this.lblRoomNo.setText("");
            this.lblCount = new RoundedCornerLabel("0", null, Color.WHITE, 0.5f);
            this.jPanel1.add(this.lblCount);
            this.lblCount.setBorderColor(Color.BLACK);
            this.lblCount.setForeground(Color.BLACK);
            this.lblCount.setArc(10);
            this.lblCount.setBorder(BorderFactory.createEmptyBorder(1, 4, 1, 4));
            this.lblCount.setFont(UIConstants.FONT_12_PLAIN);
            this.lblCount.setText("");
            JPanel panelJoin = new JPanel();
            this.add((Component)panelJoin, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
            FlowLayout panelUnjoinedLayout = new FlowLayout();
            panelUnjoinedLayout.setHgap(4);
            panelUnjoinedLayout.setVgap(0);
            panelJoin.setLayout(panelUnjoinedLayout);
            panelJoin.setOpaque(false);
            this.btnLocked = new RoundedCornerLabel(I18NUtil.getString("conference_locked_s"), null, UIConstants.COLOR_LIGHT_GRAY, 0.0f);
            panelJoin.add(this.btnLocked);
            this.btnLocked.setForeground(Color.WHITE);
            this.btnLocked.setFont(UIConstants.FONT_12_PLAIN);
            this.btnJoin = new RoundedCornerLabel(I18NUtil.getString("common_btn_join"), null, UIConstants.BACKGROUND_UNJOINED_NORMAL, UIConstants.BACKGROUND_UNJOINED_OVER, UIConstants.BACKGROUND_UNJOINED_PRESSED);
            panelJoin.add(this.btnJoin);
            this.btnJoin.setForeground(Color.WHITE);
            this.btnJoin.setCursor(UIConstants.CURSOR_HAND);
            this.btnJoin.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(MeetmeEntryPanel.this.btnJoin, evt, MeetmeEntryPanel.this);
                    MeetmeEntryPanel.this.dispatchEvent(newEvt);
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(MeetmeEntryPanel.this.btnJoin, evt, MeetmeEntryPanel.this);
                    MeetmeEntryPanel.this.dispatchEvent(newEvt);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(MeetmeEntryPanel.this.btnJoin, evt, MeetmeEntryPanel.this);
                    MeetmeEntryPanel.this.dispatchEvent(newEvt);
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(MeetmeEntryPanel.this.btnJoin, evt, MeetmeEntryPanel.this);
                    MeetmeEntryPanel.this.dispatchEvent(newEvt);
                }

                @Override
                public void mouseClicked(MouseEvent evt) {
                    MeetmeEntryPanel.this.btnJoinMouseClicked(evt);
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(MeetmeEntryPanel.this.btnJoin, evt, MeetmeEntryPanel.this);
                    MeetmeEntryPanel.this.dispatchEvent(newEvt);
                }
            });
            this.btnCall = new RoundedCornerLabel(I18NUtil.getString("call_btn_callout"), UIConstants.ICON_DIAL, UIConstants.BACKGROUND_CALL_NORMAL, UIConstants.BACKGROUND_CALL_OVER, UIConstants.BACKGROUND_CALL_PRESSED);
            panelJoin.add(this.btnCall);
            this.btnCall.setForeground(Color.WHITE);
            this.btnCall.setCursor(UIConstants.CURSOR_HAND);
            this.setCallBtnVisible(false);
            this.btnCall.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (MeetmeEntryPanel.this.btnCall.isEnabled() && evt.getButton() == 1) {
                        MeetmeEntryPanel.this.startDialOut();
                    }
                }
            });
            this.lblSummary = new JLabel();
            this.add((Component)this.lblSummary, new GridBagConstraints(1, 1, 3, 1, 1.0, 0.0, 17, 1, new Insets(2, 10, 5, 0), 0, 0));
            this.lblSummary.setFont(UIConstants.FONT_12_PLAIN);
            this.lblSummary.setForeground(UIConstants.COLOR_LIGHT_GRAY);
            this.lblSummary.setText("Summary");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void startDialOut() {
        if (this.btnCall.isEnabled()) {
            ChatRoomManager.startDialOut(this.btnCall, this.liteConfRoom.getChatRoomId());
        }
    }

    @Override
    public EntryPanel.Type getType() {
        return EntryPanel.Type.CONFERENCE_ROOM;
    }

    @Override
    public String getEntryId() {
        return EntryPanel.Type.CONFERENCE_ROOM.name() + "-" + this.liteConfRoom.getRoomId();
    }

    @Override
    public String getValueId() {
        return String.valueOf(this.liteConfRoom.getRoomId());
    }

    @Override
    public String getChatId() {
        return this.liteConfRoom.getChatRoomId();
    }

    @Override
    public String getPhoneNumber() {
        return this.liteConfRoom.getRoomNo();
    }

    @Override
    public String getDisplayName() {
        return this.lblSubject.getText();
    }

    @Override
    public String getSummary() {
        return this.lblSummary.getText();
    }

    public VoiceChatMode getVoiceChatMode() {
        return this.mode;
    }

    @Override
    public void setSelected(boolean b) {
        super.setSelected(b);
        this.updateMeetme();
    }

    public long getRoomId() {
        return this.liteConfRoom.getRoomId();
    }

    public String getRoomJID() {
        return this.liteConfRoom.getChatRoomId();
    }

    private void btnJoinMouseClicked(MouseEvent evt) {
        if (this.btnJoin.isEnabled() && evt.getButton() == 1) {
            this.meetmeJoinAction();
        }
    }

    public void meetmeJoinAction() {
        if (!this.mRoomJoined) {
            if (this.mConferenceHelper != null) {
                this.mConferenceHelper.release();
            }
            this.mConferenceHelper = new ConferenceHelper(UCChatClient.context, this.mRoomId, this);
            this.mConferenceHelper.doVerify();
        }
    }

    @Override
    public void verifyOK() {
        if (this.mConferenceHelper != null) {
            this.mConferenceHelper.release();
            this.mConferenceHelper = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Intent intent = new Intent();
                intent.putExtra("unjoined_display_mode", (Serializable)((Object)ConferenceChatroom.UnjoinedDisplayMode.JOIN));
                UCChatClient.getInstance().getMainPanel().showChatroom(MeetmeEntryPanel.this.getRoomJID(), intent);
            }
        });
    }

    @Override
    public void verifyFailed(int returnCode, String msg) {
        if (this.mConferenceHelper != null) {
            this.mConferenceHelper.release();
            this.mConferenceHelper = null;
        }
    }

    private synchronized void setCallBtnVisible(final boolean btnVisible) {
        if (this.timer1 != null) {
            this.timer1.stop();
            this.timer1 = null;
        }
        if (btnVisible) {
            this.timer1 = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ld2) {
                    MeetmeEntryPanel.this.btnCall.setVisible(btnVisible);
                }
            });
            this.timer1.setRepeats(false);
            this.timer1.start();
        } else {
            this.btnCall.setVisible(btnVisible);
        }
    }
}

