/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.addressbook;

import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.EntryPanel;
import com.blisscloud.ezuc.client.component.PersonalPhoto;
import com.blisscloud.ezuc.client.tool.CustomBorder;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.JLabel;

public class MyContactEntryPanel
extends EntryPanel {
    private PersonalPhoto lblHeadIcon;
    private JLabel lblName;
    private JLabel lblPresence;
    LiteMyContact liteMyContact;

    public MyContactEntryPanel(LiteMyContact myContact) {
        this.initGUI();
        this.setLiteMyContact(myContact);
    }

    public void setLiteMyContact(LiteMyContact myContact) {
        this.liteMyContact = myContact;
        this.setDisplayName(this.liteMyContact.getName());
        Image image = ContactManager.getExternalContactImage(this.liteMyContact, 48, false, true);
        this.setPersonalPhoto(image);
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            this.setLayout(thisLayout);
            this.setPreferredSize(EntryPanel.ENTRY_SIZE);
            this.setBorder(new CustomBorder());
            this.setBackground(EntryPanel.ENTRY_BACKGROUND);
            this.setOpaque(false);
            this.lblHeadIcon = new PersonalPhoto();
            this.add((Component)this.lblHeadIcon, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblHeadIcon.setPreferredSize(new Dimension(48, 48));
            this.lblHeadIcon.setMinimumSize(new Dimension(48, 48));
            this.lblHeadIcon.setCursor(UIConstants.CURSOR_HAND);
            this.lblName = new JLabel();
            this.add((Component)this.lblName, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(2, 10, 0, 0), 0, 0));
            this.lblName.setFont(UIConstants.FONT_14_PLAIN);
            this.lblPresence = new JLabel();
            this.add((Component)this.lblPresence, new GridBagConstraints(3, 0, 1, 2, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.lblPresence.setFont(UIConstants.FONT_12_PLAIN);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public EntryPanel.Type getType() {
        return EntryPanel.Type.MY_CONTACT;
    }

    @Override
    public String getEntryId() {
        return EntryPanel.Type.MY_CONTACT.name() + "-" + this.liteMyContact.getId();
    }

    @Override
    public String getValueId() {
        return String.valueOf(this.liteMyContact.getId());
    }

    @Override
    public String getChatId() {
        return null;
    }

    @Override
    public String getPhoneNumber() {
        return null;
    }

    @Override
    public String getDisplayName() {
        return this.lblName.getText();
    }

    @Override
    public String getSummary() {
        return null;
    }

    public void setDisplayName(String displayName) {
        this.lblName.setText(displayName);
    }

    public void setPersonalPhoto(Image photo) {
        if (photo == null || photo.getWidth(this) <= 0 || photo.getHeight(this) <= 0) {
            this.lblHeadIcon.setImage(UIConstants.ICON_PERSON48.getImage());
        } else {
            this.lblHeadIcon.setImage(photo);
        }
    }

    public LiteMyContact getMyContact() {
        return this.liteMyContact;
    }
}

