/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.bulletin;

import com.blisscloud.ezuc.bean.web.LiteBulletinHeader;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.EntryPanel;
import com.blisscloud.ezuc.client.tool.CustomBorder;
import com.blisscloud.ezuc.client.util.DateTimeUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.db.UCDBBulletin;
import com.blisscloud.mobile.ezuc.db.UCDBRemoteMark;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class BulletinEntryPanel
extends JPanel {
    private JLabel lblTypeName;
    private JLabel lblStatus;
    private JLabel lblTime;
    private JLabel lblSubject;
    private Long mBulletinId;
    private String statusText;
    private Color statusColor;
    private boolean selected;

    public BulletinEntryPanel(Long bulletinId) {
        this.initGUI();
        this.mBulletinId = bulletinId;
    }

    public void updateBulletin(LiteBulletinHeader bulletin) {
        if (bulletin == null) {
            return;
        }
        this.lblTypeName.setText(bulletin.getTypeName());
        this.lblSubject.setText(bulletin.getSubject());
        if (bulletin.isRead()) {
            this.lblSubject.setFont(UIConstants.FONT_14_PLAIN);
        } else {
            this.lblSubject.setFont(UIConstants.FONT_14_BOLD);
        }
        this.add((Component)this.lblTime, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 2, 5), 0, 0));
        if (!bulletin.isRead()) {
            this.lblStatus.setVisible(true);
            this.lblStatus.setIcon(UIConstants.ICON_BULLETIN_UNREAD);
        } else if (bulletin.isMark()) {
            this.lblStatus.setVisible(true);
            this.lblStatus.setIcon(UIConstants.ICON_BULLETIN_MARKED);
        } else {
            this.lblStatus.setVisible(false);
            this.add((Component)this.lblTime, new GridBagConstraints(1, 0, 1, 2, 0.0, 0.0, 13, 0, new Insets(0, 5, 2, 5), 0, 0));
        }
        String timeStr = DateTimeUtil.getTimeStr(bulletin.getStart(), false);
        this.updateStatusText(timeStr);
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            this.setLayout(thisLayout);
            this.setBorder(new CustomBorder(true));
            this.setBackground(EntryPanel.ENTRY_BACKGROUND);
            this.setPreferredSize(new Dimension(305, 60));
            this.setMinimumSize(new Dimension(200, 60));
            this.setOpaque(false);
            this.lblTypeName = new JLabel();
            this.add((Component)this.lblTypeName, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(2, 5, 0, 0), 0, 0));
            this.lblTypeName.setFont(UIConstants.FONT_12_PLAIN);
            this.lblTypeName.setForeground(UIConstants.COLOR_LIGHT_GRAY);
            this.lblSubject = new JLabel();
            this.add((Component)this.lblSubject, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 1, new Insets(0, 5, 2, 0), 0, 0));
            this.lblSubject.setForeground(Color.BLACK);
            this.lblSubject.setFont(UIConstants.FONT_14_PLAIN);
            this.lblSubject.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(BulletinEntryPanel.this.lblSubject, evt, BulletinEntryPanel.this);
                    BulletinEntryPanel.this.dispatchEvent(newEvt);
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(BulletinEntryPanel.this.lblSubject, evt, BulletinEntryPanel.this);
                    BulletinEntryPanel.this.dispatchEvent(newEvt);
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(BulletinEntryPanel.this.lblSubject, evt, BulletinEntryPanel.this);
                    BulletinEntryPanel.this.dispatchEvent(newEvt);
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(BulletinEntryPanel.this.lblSubject, evt, BulletinEntryPanel.this);
                    BulletinEntryPanel.this.dispatchEvent(newEvt);
                }

                @Override
                public void mouseClicked(MouseEvent evt) {
                    MouseEvent newEvt = SwingUtilities.convertMouseEvent(BulletinEntryPanel.this.lblSubject, evt, BulletinEntryPanel.this);
                    BulletinEntryPanel.this.dispatchEvent(newEvt);
                }
            });
            this.lblStatus = new JLabel();
            this.add((Component)this.lblStatus, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 5, 0, 5), 0, 0));
            this.lblStatus.setFont(UIConstants.FONT_12_PLAIN);
            this.lblStatus.setForeground(UIConstants.COLOR_LIGHT_GRAY);
            this.lblTime = new JLabel();
            this.add((Component)this.lblTime, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 2, 5), 0, 0));
            this.lblTime.setFont(UIConstants.FONT_12_PLAIN);
            this.lblTime.setForeground(UIConstants.COLOR_LIGHT_GRAY);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Long getBulletinId() {
        return this.mBulletinId;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean b) {
        LiteBulletinHeader header;
        this.selected = b;
        if (this.selected && (header = UCDBBulletin.getBulletinHeader(UCChatClient.context, this.mBulletinId)) != null && !header.isRead()) {
            UCDBBulletin.markBulletinAsReaded(UCChatClient.context, this.mBulletinId);
            UCDBRemoteMark.addRemoteMark((Context)UCChatClient.context, 0, this.mBulletinId);
            WebAgent.getInstance().markBulletinAsRead(this.mBulletinId);
            BroadcastUtil.sendBulletinStatusChangedEvent(UCChatClient.context, this.mBulletinId);
        }
        this.setBackground(EntryPanel.ENTRY_BACKGROUND);
        this.setOpaque(this.selected);
        this.revalidate();
        this.repaint();
    }

    public void setMenuDisplayed(boolean b) {
        if (!this.selected) {
            this.setBackground(EntryPanel.ENTRY_MENU_DISPLAYED_BACKGROUND);
            this.setOpaque(b);
        }
        this.revalidate();
        this.repaint();
    }

    private void updateStatusText(String timeStr) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><table cellspacing=\"1\" cellpadding=\"1\">");
        if (TextUtils.isNotBlank((CharSequence)this.statusText)) {
            if (this.statusColor == null) {
                this.statusColor = Color.BLACK;
            }
            String colorHex = String.format("#%02x%02x%02x", this.statusColor.getRed(), this.statusColor.getGreen(), this.statusColor.getBlue());
            sb.append("<rd><td nowrap align=\"right\"><font color=\"").append(colorHex).append("\">").append(this.statusText).append("</font></td></tr>");
        }
        if (TextUtils.isNotBlank((CharSequence)timeStr)) {
            sb.append("<rd><td nowrap align=\"right\">").append(timeStr).append("</td></tr>");
        }
        sb.append("</table></html>");
        this.lblTime.setText(sb.toString());
    }
}

