/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.bulletin;

import com.blisscloud.ezuc.bean.web.LiteBulletinHeader;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.bulletin.BulletinEntryPanel;
import com.blisscloud.ezuc.client.bulletin.BulletinFilterMenuPopup;
import com.blisscloud.ezuc.client.bulletin.BulletinListener;
import com.blisscloud.ezuc.client.bulletin.BulletinSortingMode;
import com.blisscloud.ezuc.client.component.SearchField;
import com.blisscloud.ezuc.client.component.UCScrollPane;
import com.blisscloud.ezuc.client.main.MainPanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.QueryThread;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.db.UCDBBulletin;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class BulletinPanel
extends JPanel {
    private BulletinFilterMenuPopup popupSortingMode;
    private BulletinSortingMode sortingMode = BulletinSortingMode.ALL;
    private JLabel btnBulletinSort;
    private JPanel panelSearch;
    private SearchField sfHistory;
    private JPanel noContentPanel;
    private JLabel noContentLabel;
    private JPanel panelContent;
    private JScrollPane spContentEntries;
    private JPanel panelContentEntries;
    private Map<Long, BulletinEntryPanel> entryPanelMap = Collections.synchronizedMap(new HashMap());
    EntryPanelMouseListener epml = new EntryPanelMouseListener();
    BroadcastReceiver receiver = null;
    IntentFilter filter = null;
    private QueryThread queryThread = null;
    private static String BULLETIN_PREFIX = "BULLETIN_";
    BulletinEntryPanel selectedEntryPanel;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new BulletinPanel());
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public BulletinPanel() {
        int modeIndex = PreferencesUtil.getBulletinMenuSelection(UCChatClient.context);
        if (modeIndex == 0) {
            this.sortingMode = BulletinSortingMode.ALL;
        } else if (modeIndex == 1) {
            this.sortingMode = BulletinSortingMode.UNREAD;
        } else if (modeIndex == 2) {
            this.sortingMode = BulletinSortingMode.MARKED;
        }
        this.initGUI();
        this.initReceiver();
        this.queryThread = new QueryThread(UCChatClient.context, "BulletinPanel", new QueryThread.QueryListener(){

            @Override
            public void performAction() {
                try {
                    BulletinPanel.this.refreshBulletinListForMenu();
                }
                catch (Throwable t) {
                    Log.i(BulletinPanel.class.getName(), t.getMessage(), t);
                }
            }
        });
        this.queryThread.start();
    }

    public void scrollTop() {
        if (this.spContentEntries != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BulletinPanel.this.spContentEntries.getVerticalScrollBar().setValue(0);
                }
            });
        }
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.setLayout(thisLayout);
            this.setBackground(Color.WHITE);
            this.panelSearch = new JPanel();
            BorderLayout panelSearchLayout = new BorderLayout();
            panelSearchLayout.setHgap(5);
            this.panelSearch.setLayout(panelSearchLayout);
            this.add((Component)this.panelSearch, "North");
            this.panelSearch.setBorder(UIConstants.BORDER_SEARCH_TOOLBAR);
            this.panelSearch.setBackground(UIConstants.BACKGROUND_SELECTED_TAB);
            this.sfHistory = new SearchField();
            this.sfHistory.setSearchCallback(new SearchField.SearchCallback(){

                @Override
                public void doSearch(String key) {
                    BulletinPanel.this.queryThread.requestRefresh();
                }
            });
            this.panelSearch.add((Component)this.sfHistory, "Center");
            this.btnBulletinSort = new JLabel();
            this.panelSearch.add((Component)this.btnBulletinSort, "East");
            this.btnBulletinSort.setIcon(UIConstants.ICON_SORT);
            this.btnBulletinSort.setToolTipText(I18NUtil.getString("common_btn_sorting"));
            this.btnBulletinSort.setPreferredSize(new Dimension(28, 28));
            this.btnBulletinSort.setMinimumSize(new Dimension(28, 28));
            this.btnBulletinSort.setCursor(UIConstants.CURSOR_HAND);
            this.btnBulletinSort.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (BulletinPanel.this.isEnabled()) {
                        BulletinPanel.this.btnBulletinSort.setIcon(UIConstants.ICON_SORT);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (BulletinPanel.this.isEnabled()) {
                        BulletinPanel.this.btnBulletinSort.setIcon(UIConstants.ICON_SORT_OVER);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (BulletinPanel.this.isEnabled()) {
                        BulletinPanel.this.btnBulletinSort.setIcon(UIConstants.ICON_SORT_OVER);
                    }
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    if (BulletinPanel.this.popupSortingMode == null) {
                        BulletinPanel.this.initPopupSortingMode();
                    }
                    BulletinPanel.this.popupSortingMode.show(BulletinPanel.this.btnBulletinSort, -13, BulletinPanel.this.btnBulletinSort.getHeight() - 2);
                }
            });
            this.panelContent = new JPanel();
            BorderLayout panelContentLayout = new BorderLayout();
            this.panelContent.setLayout(panelContentLayout);
            this.add((Component)this.panelContent, "Center");
            this.spContentEntries = new UCScrollPane(60);
            this.panelContent.add((Component)this.spContentEntries, "Center");
            this.spContentEntries.setHorizontalScrollBarPolicy(31);
            this.panelContentEntries = new JPanel();
            BoxLayout panelContentEntriesLayout = new BoxLayout(this.panelContentEntries, 1);
            this.panelContentEntries.setLayout(panelContentEntriesLayout);
            this.spContentEntries.setViewportView(this.panelContentEntries);
            this.panelContentEntries.setBackground(Color.WHITE);
            this.noContentPanel = new JPanel();
            BorderLayout bLayout2 = new BorderLayout();
            this.noContentPanel.setLayout(bLayout2);
            this.noContentPanel.setOpaque(true);
            this.noContentPanel.setBackground(Color.WHITE);
            this.noContentPanel.setMinimumSize(new Dimension(100, 100));
            this.noContentPanel.setPreferredSize(new Dimension(100, 100));
            this.noContentLabel = new JLabel();
            this.noContentLabel.setOpaque(true);
            this.noContentLabel.setBackground(Color.WHITE);
            this.noContentLabel.setHorizontalAlignment(0);
            this.noContentLabel.setText(I18NUtil.getString("bulletin_no_data"));
            this.noContentLabel.setForeground(Color.LIGHT_GRAY);
            this.noContentLabel.setFont(UIConstants.FONT_16_BOLD);
            this.noContentPanel.add((Component)this.noContentLabel, "Center");
            this.panelContent.add((Component)this.noContentPanel, "North");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initPopupSortingMode() {
        this.popupSortingMode = new BulletinFilterMenuPopup(UCChatClient.getInstance(), this.sortingMode, new BulletinFilterMenuPopup.SortingModeCallback(){

            @Override
            public void onSortingModeChanged(BulletinSortingMode mode) {
                BulletinPanel.this.sortingMode = mode;
                if (BulletinPanel.this.sortingMode == BulletinSortingMode.ALL) {
                    PreferencesUtil.setBulletinMenuSelection(UCChatClient.context, 0);
                } else if (BulletinPanel.this.sortingMode == BulletinSortingMode.UNREAD) {
                    PreferencesUtil.setBulletinMenuSelection(UCChatClient.context, 1);
                } else if (BulletinPanel.this.sortingMode == BulletinSortingMode.MARKED) {
                    PreferencesUtil.setBulletinMenuSelection(UCChatClient.context, 2);
                }
                BulletinPanel.this.queryThread.requestRefresh();
            }
        });
    }

    private void initReceiver() {
        this.receiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                try {
                    String action = intent.getAction();
                    Log.d(BulletinPanel.class.getSimpleName(), " \u6536\u5230\u5ee3\u64ad:" + action);
                    if ("ezphone.intent.action.event.BULLETIN_LIST_CHANGED".equals(action)) {
                        BulletinPanel.this.queryThread.requestRefresh();
                    } else if ("ezphone.intent.action.event.BULLETIN_STATUS_CHANGED".equals(action)) {
                        BulletinPanel.this.queryThread.requestRefresh();
                    }
                }
                catch (Throwable t) {
                    Log.e(BulletinPanel.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                }
            }
        };
        this.filter = new IntentFilter();
        this.filter.addAction("ezphone.intent.action.event.BULLETIN_LIST_CHANGED");
        this.filter.addAction("ezphone.intent.action.event.BULLETIN_STATUS_CHANGED");
        UCChatClient.context.registerReceiver(this.receiver, this.filter);
    }

    public void prepare() {
        this.refreshBulletinListForMenu();
    }

    public void release() {
        this.sfHistory.clearSearchKey();
        this.panelContentEntries.removeAll();
        this.entryPanelMap.clear();
        this.noContentPanel.setVisible(this.entryPanelMap.keySet().size() == 0);
        this.selectedEntryPanel = null;
    }

    public void addBulletinListener(BulletinListener l) {
        this.listenerList.add(BulletinListener.class, l);
    }

    public void removeBulletinListener(BulletinListener l) {
        this.listenerList.remove(BulletinListener.class, l);
    }

    protected void fireBulletinSelected(Long bulletinId) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != BulletinListener.class) continue;
            ((BulletinListener)listeners[i + 1]).bulletinSelected(bulletinId);
        }
    }

    protected void fireUnreadMessageChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != BulletinListener.class) continue;
            ((BulletinListener)listeners[i + 1]).unreadMessageChanged();
        }
    }

    private BulletinEntryPanel getBulletinEntryPanel(Long bulletinId) {
        Component[] comps;
        for (Component comp : comps = this.panelContentEntries.getComponents()) {
            BulletinEntryPanel bulletinPanel;
            if (!(comp instanceof BulletinEntryPanel) || !(bulletinPanel = (BulletinEntryPanel)comp).getBulletinId().equals(bulletinId)) continue;
            return bulletinPanel;
        }
        return null;
    }

    public Collection<BulletinEntryPanel> getAllBulletinEntryPanel() {
        Component[] comps;
        ArrayList<BulletinEntryPanel> ret = new ArrayList<BulletinEntryPanel>();
        for (Component comp : comps = this.panelContentEntries.getComponents()) {
            if (!(comp instanceof BulletinEntryPanel)) continue;
            ret.add((BulletinEntryPanel)comp);
        }
        return ret;
    }

    private void moveBulletin(final LiteBulletinHeader bulletin, final int index) {
        final BulletinEntryPanel bulletinPanel = this.entryPanelMap.get(bulletin.getId());
        if (bulletinPanel != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean selected = bulletinPanel.isSelected();
                    BulletinPanel.this.panelContentEntries.remove(bulletinPanel);
                    BulletinPanel.this.panelContentEntries.add((Component)bulletinPanel, index);
                    BulletinPanel.this.noContentPanel.setVisible(BulletinPanel.this.entryPanelMap.keySet().size() == 0);
                    bulletinPanel.updateBulletin(bulletin);
                    BulletinPanel.this.panelContentEntries.revalidate();
                    BulletinPanel.this.panelContentEntries.repaint();
                    bulletinPanel.setSelected(selected);
                }
            });
        }
    }

    private void insertBulletin(final LiteBulletinHeader bulletin, final int index) {
        final BulletinEntryPanel bulletinPanel = new BulletinEntryPanel(bulletin.getId());
        this.entryPanelMap.put(bulletin.getId(), bulletinPanel);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                bulletinPanel.setMinimumSize(new Dimension(100, 60));
                bulletinPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 60));
                bulletinPanel.setAlignmentX(0.0f);
                bulletinPanel.setSelected(false);
                bulletinPanel.addMouseListener(BulletinPanel.this.epml);
                bulletinPanel.updateBulletin(bulletin);
                BulletinPanel.this.panelContentEntries.add((Component)bulletinPanel, index);
                BulletinPanel.this.noContentPanel.setVisible(BulletinPanel.this.entryPanelMap.keySet().size() == 0);
                BulletinPanel.this.panelContentEntries.revalidate();
                BulletinPanel.this.panelContentEntries.repaint();
            }
        });
    }

    private void removeBulletin(Long bulletinId) {
        final BulletinEntryPanel bulletinPanel = this.entryPanelMap.get(bulletinId);
        if (bulletinPanel != null) {
            this.entryPanelMap.remove(bulletinPanel.getBulletinId());
            if (this.selectedEntryPanel == bulletinPanel) {
                this.selectedEntryPanel = null;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BulletinPanel.this.panelContentEntries.remove(bulletinPanel);
                    BulletinPanel.this.noContentLabel.setText(I18NUtil.getString("bulletin_no_data"));
                    BulletinPanel.this.noContentPanel.setVisible(BulletinPanel.this.entryPanelMap.keySet().size() == 0);
                    BulletinPanel.this.panelContentEntries.revalidate();
                    BulletinPanel.this.panelContentEntries.repaint();
                    bulletinPanel.removeMouseListener(BulletinPanel.this.epml);
                    UCChatClient.getInstance().getMainPanel().closeBulletin(bulletinPanel.getBulletinId());
                }
            });
        }
    }

    private void refreshBulletinListForMenu() {
        this.doSearch(this.sfHistory.getSearchKey());
    }

    private synchronized void doSearch(String searchKey) {
        Log.d(BulletinPanel.class.getSimpleName(), "run doSearch, searchKeu:" + searchKey);
        long t = System.currentTimeMillis();
        Activity ctx = UCChatClient.context;
        List<LiteBulletinHeader> headerList = null;
        switch (this.sortingMode) {
            case ALL: {
                headerList = UCDBBulletin.getBulletinList(ctx, searchKey);
                break;
            }
            case UNREAD: {
                headerList = UCDBBulletin.getBulletinListByUnread(ctx, searchKey);
                break;
            }
            case MARKED: {
                headerList = UCDBBulletin.getBulletinListByMarked(ctx, searchKey);
            }
        }
        Set<Long> oldBulletinIds = this.getOldBulletinIds();
        HashSet<Long> unchangedBulletinIds = new HashSet<Long>(oldBulletinIds);
        Set<Long> newBulletinIds = this.getNewBulletinIds(headerList);
        unchangedBulletinIds.retainAll(newBulletinIds);
        newBulletinIds.removeAll(unchangedBulletinIds);
        oldBulletinIds.removeAll(unchangedBulletinIds);
        for (Long oldBulletinId : oldBulletinIds) {
            this.removeBulletin(oldBulletinId);
        }
        for (int i = 0; headerList != null && i < headerList.size(); ++i) {
            LiteBulletinHeader bulletin = headerList.get(i);
            Long bulletinId = bulletin.getId();
            if (unchangedBulletinIds.contains(bulletinId)) {
                this.moveBulletin(bulletin, i);
                continue;
            }
            if (!newBulletinIds.contains(bulletinId)) continue;
            this.insertBulletin(bulletin, i);
        }
        this.fireUnreadMessageChanged();
        if (this.selectedEntryPanel != null && this.selectedEntryPanel.getParent() == null) {
            this.selectedEntryPanel = null;
        }
    }

    private Set<Long> getOldBulletinIds() {
        return new HashSet<Long>(this.entryPanelMap.keySet());
    }

    private Set<Long> getNewBulletinIds(List<LiteBulletinHeader> headerList) {
        HashSet<Long> ret = new HashSet<Long>();
        for (LiteBulletinHeader header : headerList) {
            ret.add(header.getId());
        }
        return ret;
    }

    public void setUnselectedBulletin() {
        if (this.selectedEntryPanel != null) {
            this.selectedEntryPanel.setSelected(false);
            this.selectedEntryPanel = null;
        }
    }

    public static String convertBulletinToViewId(Long bulletinId) {
        return BULLETIN_PREFIX + bulletinId;
    }

    public Long convertViewToBulletinId(String viewId) {
        try {
            String id = viewId.substring(BULLETIN_PREFIX.length());
            return Long.parseLong(id);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public void setSelectedBulletin(String viewId, boolean showViewer) {
        if (!viewId.startsWith(BULLETIN_PREFIX)) {
            this.cleanSelectedEntryPanel();
            return;
        }
        Long bulletinId = this.convertViewToBulletinId(viewId);
        if (bulletinId == null) {
            this.cleanSelectedEntryPanel();
            return;
        }
        BulletinEntryPanel bulletinPanel = this.getBulletinEntryPanel(bulletinId);
        if (bulletinPanel == null) {
            this.cleanSelectedEntryPanel();
            return;
        }
        if (this.selectedEntryPanel != null && this.selectedEntryPanel == bulletinPanel) {
            this.selectedEntryPanel.setSelected(true);
            return;
        }
        this.cleanSelectedEntryPanel();
        this.selectedEntryPanel = bulletinPanel;
        this.selectedEntryPanel.setSelected(true);
        this.fireUnreadMessageChanged();
        this.fireBulletinSelected(this.selectedEntryPanel.getBulletinId());
        if (showViewer) {
            MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
            mainPanel.showBulletin(this.selectedEntryPanel.getBulletinId());
        }
    }

    private void cleanSelectedEntryPanel() {
        if (this.selectedEntryPanel != null) {
            this.selectedEntryPanel.setSelected(false);
            this.selectedEntryPanel = null;
        }
    }

    class EntryPanelMouseListener
    extends MouseAdapter {
        EntryPanelMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (evt.getButton() == 1) {
                BulletinEntryPanel panel = (BulletinEntryPanel)evt.getComponent();
                this.switchSelectedContactHistory(panel);
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
        }

        private void switchSelectedContactHistory(BulletinEntryPanel bulletinPanel) {
            BulletinPanel.this.setSelectedBulletin(BulletinPanel.convertBulletinToViewId(bulletinPanel.getBulletinId()), true);
        }
    }
}

