/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat;

import com.blisscloud.ezuc.client.chat.DownloadFileTaskCallBack;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URI;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;

public class DownloadFileTask
extends Thread {
    private static final String RESULT_FAILED = "FAILED";
    private static final String RESULT_DONE = "DONE";
    private static final String RESULT_NOTFOUND = "NOTFOUND";
    private String url;
    private DownloadFileTaskCallBack callback;
    private Context ctx;
    private HttpGet request = null;
    private boolean isAbort = false;
    private File toFile = null;
    private int mProgress = 0;
    private long targetFileSize;

    public DownloadFileTask(Context ctx, String url, File toFile, long fileSize, DownloadFileTaskCallBack callback) {
        this.url = url;
        this.callback = callback;
        this.ctx = ctx;
        this.toFile = toFile;
        this.targetFileSize = fileSize;
    }

    public void setDownloadFileTaskCallBack(DownloadFileTaskCallBack callback) {
        this.callback = callback;
    }

    public void abortHttp() {
        if (this.request != null) {
            this.isAbort = true;
            this.request.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doInBackground(String ... urls) {
        InputStream is = null;
        FileOutputStream fos = null;
        try {
            HttpClient mHttpClient = CommonUtil.getHttpsClient(this.ctx, true);
            fos = new FileOutputStream(this.toFile);
            URI uri = new URI(this.url);
            this.request = new HttpGet();
            this.request.setURI(uri);
            HttpResponse response = mHttpClient.execute((HttpUriRequest)this.request);
            if (response.getStatusLine().getStatusCode() != 200) {
                this.request.abort();
                String string = RESULT_NOTFOUND;
                return string;
            }
            if (this.callback != null) {
                this.callback.onDownloadFileStarted();
            }
            is = response.getEntity().getContent();
            int contentLength = (int)response.getEntity().getContentLength();
            if (this.callback != null) {
                this.callback.onFileLengthGot(contentLength);
            }
            this.publishProgress(0);
            byte[] buffer = new byte[2048];
            int received = 0;
            int inlen = 0;
            while ((inlen = is.read(buffer)) > 0) {
                fos.write(buffer, 0, inlen);
                this.publishProgress((int)((float)(received += inlen) / (float)contentLength * 100.0f));
            }
            String string = RESULT_DONE;
            return string;
        }
        catch (Exception e) {
            Log.e(this.getClass().getSimpleName(), "fail", e);
            String string = RESULT_FAILED;
            return string;
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            fos = null;
            is = null;
        }
    }

    protected void onProgressUpdate(Integer ... progress) {
        this.mProgress = progress[0];
        if (this.callback != null) {
            this.callback.onProgressUpdated(progress[0]);
        }
    }

    protected void onPostExecute(String result) {
        if (this.isAbort) {
            if (this.toFile != null && this.toFile.exists()) {
                this.toFile.delete();
            }
            if (this.callback != null) {
                this.callback.onDownloadFileCancelled();
            }
        } else if (RESULT_NOTFOUND.equalsIgnoreCase(result)) {
            if (this.toFile != null && this.toFile.exists()) {
                this.toFile.delete();
            }
            if (this.callback != null) {
                this.callback.onDownloadFileNotFound();
            }
        } else if (RESULT_FAILED.equalsIgnoreCase(result)) {
            if (this.toFile != null && this.toFile.exists()) {
                this.toFile.delete();
            }
            if (this.callback != null) {
                this.callback.onDownloadFileFailed();
            }
        } else if (RESULT_DONE.equalsIgnoreCase(result)) {
            if (this.targetFileSize != 0L && this.targetFileSize != this.toFile.length()) {
                if (this.toFile != null && this.toFile.exists()) {
                    this.toFile.delete();
                }
                if (this.callback != null) {
                    this.callback.onDownloadFileFailed();
                }
            } else if (this.callback != null) {
                this.callback.onDownloadFileCompleted();
            }
        }
    }

    @Override
    public void run() {
        String result = this.doInBackground(new String[0]);
        this.onPostExecute(result);
    }

    public void cancel() {
        this.abortHttp();
        this.interrupt();
        this.onPostExecute(null);
    }

    private void publishProgress(int progress) {
        if (this.callback != null) {
            this.callback.onProgressUpdated(progress);
        }
    }

    public int getProgress() {
        return this.mProgress;
    }

    public void setProgress(int progress) {
        this.mProgress = progress;
    }
}

