/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.component.EmployeeReadCellRenderer;
import com.blisscloud.ezuc.client.component.EmployeeUnreadCellRenderer;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.component.UCScrollPane;
import com.blisscloud.ezuc.client.model.ToggleListSelectionModel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Bundle;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.ContactReadTime;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.bean.MsgReaderTime;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBContact;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.db.UCDBReaderLog;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.util.ApiVersion;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ShowMsgReadUnreadStatusDialog
extends GenericDialog
implements ListSelectionListener {
    private JPanel mainPanel;
    private JTabbedPane jTabbedPane1;
    private JLabel lblTitle;
    private JPanel readContentPanel;
    private JPanel unreadContentPanel;
    private JList<ContactReadTime> listRead;
    DefaultComboBoxModel<ContactReadTime> listModelRead = new DefaultComboBoxModel();
    private JList<LiteContact> listUnread;
    DefaultComboBoxModel<LiteContact> listModelUnread = new DefaultComboBoxModel();
    private String mPacketId = null;
    private String mChatRoomJid = null;
    EmployeeReadCellRenderer ccread = new EmployeeReadCellRenderer();
    EmployeeUnreadCellRenderer ccunread = new EmployeeUnreadCellRenderer();
    BroadcastReceiver receiver = null;
    IntentFilter filter = null;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                ShowMsgReadUnreadStatusDialog inst = new ShowMsgReadUnreadStatusDialog(frame, null, null);
                inst.showDialog();
            }
        });
    }

    public ShowMsgReadUnreadStatusDialog(JFrame frame, String chatRoomJid, String packetId) {
        super(frame);
        this.initGUI();
        this.mPacketId = packetId;
        this.mChatRoomJid = chatRoomJid;
        this.filter = new IntentFilter();
        this.filter.addAction("ezphone.intent.action.event.CHAT_MSG_READER_LIST_CHANGED");
        this.receiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                try {
                    String action = intent.getAction();
                    Bundle bundle = intent.getExtras();
                    if (action.equals("ezphone.intent.action.event.CHAT_MSG_READER_LIST_CHANGED")) {
                        if (!bundle.getString("chatPacketId").equals(ShowMsgReadUnreadStatusDialog.this.mPacketId)) {
                            return;
                        }
                        ShowMsgReadUnreadStatusDialog.this.loadData();
                    }
                }
                catch (Throwable t) {
                    Log.e(ShowMsgReadUnreadStatusDialog.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                }
            }
        };
        UCChatClient.context.registerReceiver(this.receiver, this.filter);
        if (ApiVersion.isApi14Later()) {
            WebAgent.getInstance().getReaderTime(packetId);
        }
    }

    private void initGUI() {
        try {
            this.setTitle(I18NUtil.getString("chat_title_msg_read_unread_details"));
            this.setModal(true);
            this.setLocationRelativeTo(null);
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout());
            this.getContentPane().add((Component)this.mainPanel, "Center");
            this.mainPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.jTabbedPane1 = new JTabbedPane();
            this.mainPanel.add((Component)this.jTabbedPane1, "Center");
            this.readContentPanel = new JPanel();
            this.readContentPanel.setLayout(new BorderLayout());
            UCScrollPane scroll1 = new UCScrollPane(10);
            scroll1.setViewportView(this.readContentPanel);
            this.jTabbedPane1.addTab(I18NUtil.getString("chat_title_msg_read"), null, scroll1, null);
            this.unreadContentPanel = new JPanel();
            this.unreadContentPanel.setLayout(new BorderLayout());
            UCScrollPane scroll2 = new UCScrollPane(10);
            scroll2.setViewportView(this.unreadContentPanel);
            this.jTabbedPane1.addTab(I18NUtil.getString("chat_title_msg_unread"), null, scroll2, null);
            this.listRead = new JList();
            this.readContentPanel.add(this.listRead, "Center");
            this.listRead.setVisible(true);
            this.listRead.setCellRenderer(this.ccread);
            this.listRead.setModel(this.listModelRead);
            this.listRead.setSelectionMode(0);
            this.listRead.setSelectionModel(new ToggleListSelectionModel(this.listRead));
            this.listRead.getSelectionModel().addListSelectionListener(this);
            this.listUnread = new JList();
            this.unreadContentPanel.add(this.listUnread, "Center");
            this.listUnread.setVisible(true);
            this.listUnread.setCellRenderer(this.ccunread);
            this.listUnread.setModel(this.listModelUnread);
            this.listUnread.setSelectionMode(0);
            this.listUnread.setSelectionModel(new ToggleListSelectionModel(this.listUnread));
            this.listUnread.getSelectionModel().addListSelectionListener(this);
            JPanel actionPanel = new JPanel();
            this.mainPanel.add((Component)actionPanel, "South");
            FlowLayout jPanel3Layout = new FlowLayout();
            jPanel3Layout.setAlignment(1);
            actionPanel.setLayout(jPanel3Layout);
            actionPanel.setOpaque(false);
            JButton btnClose = new JButton();
            actionPanel.add(btnClose);
            btnClose.setText(I18NUtil.getString("common_btn_close"));
            btnClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ShowMsgReadUnreadStatusDialog.this.btnCloseActionPerformed(evt);
                }
            });
            this.setSize(400, 500);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void btnCloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    @Override
    protected void onESCPressed() {
        this.dispose();
    }

    public void showDialog() {
        this.loadData();
        this.setVisible(true);
    }

    private synchronized void loadData() {
        this.listModelRead.removeAllElements();
        this.listModelUnread.removeAllElements();
        if (this.mChatRoomJid == null || this.mPacketId == null) {
            return;
        }
        Message msg = UCDBMessage.findMsgByPacketId(UCChatClient.context, this.mPacketId);
        if (msg == null) {
            return;
        }
        ArrayList<Object> participantJidList = new ArrayList<String>();
        if (JidUtil.isChatConfJid(this.mChatRoomJid)) {
            participantJidList = UCDBChatRoom.findChatRoomParticipants((Context)UCChatClient.context, this.mChatRoomJid);
        } else {
            participantJidList.add(this.mChatRoomJid);
        }
        ArrayList<String> jidList = new ArrayList<String>();
        ArrayList<Long> empIdList = new ArrayList<Long>();
        List<LiteContact> contactList = UCDBChatRoom.findChatRoomParticipantsWithoutNumber(UCChatClient.context, this.mChatRoomJid, jidList, empIdList);
        int readCount = 0;
        int unreadCount = 0;
        Long userEmpId = PreferencesUtil.getUserId(UCChatClient.context);
        String userJid = PreferencesUtil.getUserJid(UCChatClient.context);
        if (ApiVersion.isApi14Later()) {
            List<MsgReaderTime> readerTimeList = UCDBReaderLog.getMsgReaderTimeList(UCChatClient.context, this.mPacketId, false);
            if (readerTimeList != null) {
                for (i = 0; readerTimeList != null && i < readerTimeList.size(); ++i) {
                    MsgReaderTime readerTime = readerTimeList.get(i);
                    try {
                        LiteContact contact = this.getContactFromCacheFirst(readerTime.getReaderEmpId(), contactList, empIdList);
                        if (contact != null) {
                            participantJidList.remove(contact.getJid());
                            if (readerTime.getReaderEmpId() == userEmpId.longValue()) continue;
                            ++readCount;
                            ContactReadTime b = new ContactReadTime();
                            b.setContact(contact);
                            b.setReaderEmpId(readerTime.getReaderEmpId());
                            b.setReadTimestamp(readerTime.getReaderTimestamp());
                            this.listModelRead.addElement(b);
                            continue;
                        }
                        if (readerTime.getReaderEmpId() == userEmpId.longValue()) continue;
                        ++readCount;
                        LiteContact contactLeft = UCDBContact.getContactByEmpId(UCChatClient.context, readerTime.getReaderEmpId());
                        b = new ContactReadTime();
                        b.setContact(contactLeft);
                        b.setReaderEmpId(readerTime.getReaderEmpId());
                        b.setReadTimestamp(readerTime.getReaderTimestamp());
                        this.listModelRead.addElement(b);
                        continue;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
        } else if (msg.getReaderList() != null) {
            String[] readerIdStrList = msg.getReaderList().split(",");
            for (i = 0; readerIdStrList != null && i < readerIdStrList.length; ++i) {
                if (TextUtils.isBlank((CharSequence)readerIdStrList[i])) continue;
                try {
                    long readerEmpId = Long.parseLong(readerIdStrList[i]);
                    LiteContact contact = this.getContactFromCacheFirst(readerEmpId, contactList, empIdList);
                    if (contact != null) {
                        participantJidList.remove(contact.getJid());
                        if (readerEmpId == userEmpId) continue;
                        ++readCount;
                        b = new ContactReadTime();
                        b.setContact(contact);
                        b.setReaderEmpId(contact.getId());
                        this.listModelRead.addElement(b);
                        continue;
                    }
                    if (readerEmpId == userEmpId) continue;
                    ++readCount;
                    LiteContact contactLeft = UCDBContact.getContactByEmpId(UCChatClient.context, readerEmpId);
                    ContactReadTime b = new ContactReadTime();
                    b.setContact(contactLeft);
                    b.setReaderEmpId(readerEmpId);
                    this.listModelRead.addElement(b);
                    continue;
                }
                catch (Throwable readerEmpId) {
                    // empty catch block
                }
            }
        }
        if (participantJidList != null) {
            for (int i = 0; participantJidList != null && i < participantJidList.size(); ++i) {
                String jid = (String)participantJidList.get(i);
                if (TextUtils.isBlank((CharSequence)jid)) continue;
                try {
                    LiteContact contact;
                    if (userJid.equalsIgnoreCase(jid) || (contact = this.getContactFromCacheFirst(jid, contactList, jidList)) == null) continue;
                    ++unreadCount;
                    this.listModelUnread.addElement(contact);
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        if (this.jTabbedPane1 != null) {
            this.jTabbedPane1.setTitleAt(0, String.format(I18NUtil.getString("chat_title_msg_read_with_count_2"), readCount));
            this.jTabbedPane1.setTitleAt(1, String.format(I18NUtil.getString("chat_title_msg_unread_with_count_2"), unreadCount));
        }
    }

    private LiteContact getContactFromCacheFirst(Long empId, List<LiteContact> contactsList, List<Long> empIdList) {
        LiteContact contact = null;
        int size = contactsList.size();
        int index = empIdList.indexOf(empId);
        if (index >= 0 && index < size) {
            contact = contactsList.get(index);
        }
        if (contact == null) {
            contact = ContactManager.getContact((Context)UCChatClient.context, empId);
        }
        return contact;
    }

    private LiteContact getContactFromCacheFirst(String jid, List<LiteContact> contactsList, List<String> empJidList) {
        LiteContact contact = null;
        int size = contactsList.size();
        int index = empJidList.indexOf(jid);
        if (index >= 0 && index < size) {
            contact = contactsList.get(index);
        }
        if (contact == null) {
            contact = ContactManager.getContact((Context)UCChatClient.context, jid);
        }
        return contact;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
    }
}

