/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat;

import com.blisscloud.ezuc.client.util.simulate.Log;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SimpleAudioPlayer {
    Long currentFrame;
    Clip clip;
    String status;
    AudioInputStream audioInputStream;
    File file = null;

    public SimpleAudioPlayer(File file, LineListener lineListener) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this.file = file;
        try {
            this.audioInputStream = AudioSystem.getAudioInputStream(file.getAbsoluteFile());
        }
        catch (UnsupportedAudioFileException ex) {
            Log.i(SimpleAudioPlayer.class.getSimpleName(), ">>" + String.valueOf(file.getAbsoluteFile()));
            throw ex;
        }
        this.clip = AudioSystem.getClip();
        this.clip.open(this.audioInputStream);
        if (lineListener != null) {
            this.clip.addLineListener(lineListener);
        }
    }

    public void play() {
        this.clip.start();
        this.status = "play";
    }

    public void pause() {
        if (this.status.equals("paused")) {
            System.out.println("audio is already paused");
            return;
        }
        this.currentFrame = this.clip.getMicrosecondPosition();
        this.clip.stop();
        this.status = "paused";
    }

    public void resumeAudio() throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        if (this.status.equals("play")) {
            System.out.println("Audio is already being played");
            return;
        }
        this.clip.close();
        this.resetAudioStream();
        this.clip.setMicrosecondPosition(this.currentFrame);
        this.play();
    }

    public void restart() throws IOException, LineUnavailableException, UnsupportedAudioFileException {
        this.clip.stop();
        this.clip.close();
        this.resetAudioStream();
        this.currentFrame = 0L;
        this.clip.setMicrosecondPosition(0L);
        this.play();
    }

    public void stop() throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this.currentFrame = 0L;
        this.clip.stop();
        this.clip.close();
    }

    public void jump(long c) throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        if (c > 0L && c < this.clip.getMicrosecondLength()) {
            this.clip.stop();
            this.clip.close();
            this.resetAudioStream();
            this.currentFrame = c;
            this.clip.setMicrosecondPosition(c);
            this.play();
        }
    }

    public void resetAudioStream() throws UnsupportedAudioFileException, IOException, LineUnavailableException {
        this.audioInputStream = AudioSystem.getAudioInputStream(this.file.getAbsoluteFile());
        this.clip.open(this.audioInputStream);
    }
}

