/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.action;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.chat.ActionService;
import com.blisscloud.ezuc.client.chat.DownloadFileTask;
import com.blisscloud.ezuc.client.chat.ElementAttrMap;
import com.blisscloud.ezuc.client.chat.FaxActionUtil;
import com.blisscloud.ezuc.client.chat.MessageArea;
import com.blisscloud.ezuc.client.chat.SelectFileHandler;
import com.blisscloud.ezuc.client.chat.action.ActionBase;
import com.blisscloud.ezuc.client.chat.action.MyDownloadFaxCallBack;
import com.blisscloud.ezuc.client.chat.dom.FileProgressBarRenderer;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.FaxTransferInfo;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.FaxSelectionCallback;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import javafx.application.Platform;
import javax.swing.JOptionPane;

public class FaxMsg
extends ActionBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handle(final ActionService actionService, final ElementAttrMap targetMap) {
        ActionService actionService2 = actionService;
        synchronized (actionService2) {
            final String packetId = targetMap.get("packetId");
            if (actionService.hasDownloadTask(packetId)) {
                return;
            }
            final String fileInfoStorageId = targetMap.get("fileInfoStorageId");
            Message message = actionService.getMessageByPacketId(packetId);
            String fileDownloadURL = message.getFileDownloadURL();
            FaxSelectionCallback faxSelectionCallback = new FaxSelectionCallback(){

                @Override
                public void onSendFile(FaxTransferInfo fileTransferInfo) {
                    try {
                        FaxActionUtil.uploadFax(fileTransferInfo, actionService.getParentPanel());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            File cacheFile = FileUtil.getDownloadCacheFile(fileDownloadURL);
            if (cacheFile.exists()) {
                long fileSize = cacheFile.length();
                if (fileSize > 0x1400000L) {
                    JOptionPane.showMessageDialog(actionService.getParentPanel(), String.format(I18NUtil.getString("chat_validation_doc_maxsize"), FileUtil.convertFileSizeDisplay(0x1400000L)), I18NUtil.getString("common_title_error"), 0);
                    return;
                }
                ArrayList<File> fileList = new ArrayList<File>();
                fileList.add(cacheFile);
                SelectFileHandler.handleSelectedFileForFax(fileList, null, faxSelectionCallback);
            } else {
                if (actionService.hasDownloadUrl(fileDownloadURL)) {
                    return;
                }
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            FileProgressBarRenderer.render(actionService, packetId, fileInfoStorageId, ActionBase.isLeft(targetMap));
                        }
                        catch (UCThreadException e) {
                            Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                        }
                    }
                });
                String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL.substring(fileDownloadURL.indexOf("/ucrm"));
                DownloadFileTask task = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, 0L, new MyDownloadFaxCallBack(actionService, packetId, cacheFile, faxSelectionCallback));
                actionService.registerDownloadMap(packetId, task);
                actionService.registerDownloadUrlMap(packetId, fileDownloadURL);
                task.start();
            }
        }
    }
}

