/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.action;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.chat.ActionService;
import com.blisscloud.ezuc.client.chat.ElementAttrMap;
import com.blisscloud.ezuc.client.main.SelectChatroomDialog;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.ChatActionUtil;
import com.blisscloud.mobile.ezuc.agent.ChatReceiver;
import com.blisscloud.mobile.ezuc.agent.ChatSendFileTask;
import com.blisscloud.mobile.ezuc.agent.ChatSendMsgTask;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.util.AppUtils;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class ForwardMsg {
    public static void handle(ActionService actionService, ElementAttrMap targetMap) {
        String packetId = targetMap.get("packetId");
        Message forwardedMessage = actionService.getMessageByPacketId(packetId);
        SelectChatroomDialog scd = new SelectChatroomDialog(UCChatClient.getInstance());
        scd.setLocationRelativeTo(UCChatClient.getInstance().getMainPanel());
        SelectChatroomDialog.SelectChatroomResult result = scd.showDialog();
        if (result == null) {
            return;
        }
        List<String> selectedJids = result.getChatroomJids();
        ArrayList<ChatReceiver> chatReceiverList = new ArrayList<ChatReceiver>();
        for (String receiverJid : selectedJids) {
            chatReceiverList.add(new ChatReceiver(receiverJid));
        }
        int type = forwardedMessage.getMsgType();
        switch (type) {
            case 0: {
                if (forwardedMessage.getContent() == null) {
                    return;
                }
                ChatActionUtil.sendMessage(null, chatReceiverList, forwardedMessage.getContent());
                if (chatReceiverList.size() <= 0) break;
                ChatReceiver lastReceiver = (ChatReceiver)chatReceiverList.get(chatReceiverList.size() - 1);
                AppUtils.startChat(UCChatClient.context, lastReceiver.getReceiverJid());
                break;
            }
            case 8: {
                String title = null;
                double latitude = 0.0;
                double longitude = 0.0;
                if (forwardedMessage.getProps() != null) {
                    try {
                        JSONObject obj = new JSONObject(forwardedMessage.getProps());
                        if (obj.has("title")) {
                            title = obj.getString("title");
                        }
                        if (obj.has("latitude")) {
                            String latitudeStr = obj.getString("latitude");
                            try {
                                latitude = Double.parseDouble(latitudeStr);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (obj.has("longitude")) {
                            String longitudeStr = obj.getString("longitude");
                            try {
                                longitude = Double.parseDouble(longitudeStr);
                            }
                            catch (Throwable throwable) {}
                        }
                    }
                    catch (JSONException e) {
                        Log.e(ForwardMsg.class.getSimpleName(), "ERROR:" + e.getMessage(), e);
                    }
                }
                String address = forwardedMessage.getContent();
                ChatActionUtil.sendLocation(null, chatReceiverList, title, address, latitude, longitude);
                if (chatReceiverList.size() <= 0) break;
                ChatReceiver lastReceiver = (ChatReceiver)chatReceiverList.get(chatReceiverList.size() - 1);
                AppUtils.startChat(UCChatClient.context, lastReceiver.getReceiverJid());
                break;
            }
            case 1: 
            case 6: {
                ChatSendMsgTask info = new ChatSendMsgTask(null, chatReceiverList, forwardedMessage.getContent(), forwardedMessage.getContent(), type);
                info.setDuration(forwardedMessage.getDuration());
                WebAgent.getInstance().sendChatText(info);
                if (chatReceiverList.size() <= 0) break;
                ChatReceiver lastReceiver = (ChatReceiver)chatReceiverList.get(chatReceiverList.size() - 1);
                AppUtils.startChat(UCChatClient.context, lastReceiver.getReceiverJid());
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 11: {
                boolean resultValue = ForwardMsg.forwardFileLocal(chatReceiverList, forwardedMessage);
                if (!resultValue) {
                    JOptionPane.showMessageDialog(actionService.getParentPanel(), I18NUtil.getString("media_upload_failed_general"), I18NUtil.getString("common_title_error"), 0);
                }
                if (chatReceiverList.size() <= 0) break;
                ChatReceiver lastReceiver = (ChatReceiver)chatReceiverList.get(chatReceiverList.size() - 1);
                AppUtils.startChat(UCChatClient.context, lastReceiver.getReceiverJid());
                break;
            }
        }
    }

    public static boolean forwardFileLocal(List<ChatReceiver> chatReceiverList, Message msg) {
        try {
            String fileName = msg.getFileNameForDisp();
            String fileContent = msg.getContent();
            String fileDownloadURL = msg.getFileDownloadURL();
            long fileSize = msg.getFileSizeToCal();
            String fileMimeType = msg.getMimeType();
            String fileExtraInfo = msg.getExtraMsgInfo();
            ChatSendFileTask task = new ChatSendFileTask(null, chatReceiverList, fileName, fileSize, fileContent, msg.getMsgType());
            if (StringUtils.isNotBlank((CharSequence)fileMimeType)) {
                task.setMimeType(fileMimeType);
            }
            task.setFileExtraInfo(fileExtraInfo);
            task.setFileDownloadUrl(fileDownloadURL);
            task.setDuration(msg.getDuration());
            WebAgent.getInstance().sendChatFile(task);
            return true;
        }
        catch (Exception e) {
            Log.e(FileUtil.class.getSimpleName(), e.getLocalizedMessage(), e);
            return false;
        }
    }
}

