/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.action;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.chat.ActionService;
import com.blisscloud.ezuc.client.chat.DownloadFileTask;
import com.blisscloud.ezuc.client.chat.ElementAttrMap;
import com.blisscloud.ezuc.client.chat.MessageArea;
import com.blisscloud.ezuc.client.chat.action.ActionBase;
import com.blisscloud.ezuc.client.chat.action.MyVoicemailDownloadForwardTaskCallBack;
import com.blisscloud.ezuc.client.chat.dom.FileProgressBarRenderer;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.main.SelectChatroomDialog;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.ChatActionUtil;
import com.blisscloud.mobile.ezuc.agent.ChatReceiver;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.bean.VoiceItem;
import com.blisscloud.mobile.ezuc.manager.VoicemailManager;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;

public class ForwardVoicePersonalFile
extends ActionBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handle(ActionService actionService, ElementAttrMap targetMap) {
        ActionService actionService2 = actionService;
        synchronized (actionService2) {
            String packetId = targetMap.get("packetId");
            if (actionService.hasDownloadTask(packetId)) {
                return;
            }
            String fileInfoStorageId = targetMap.get("fileInfoStorageId");
            Message forwardedMessage = actionService.getMessageByPacketId(packetId);
            SelectChatroomDialog scd = new SelectChatroomDialog(UCChatClient.getInstance());
            scd.setLocationRelativeTo(UCChatClient.getInstance().getMainPanel());
            SelectChatroomDialog.SelectChatroomResult result = scd.showDialog();
            if (result == null) {
                return;
            }
            List<String> selectedJids = result.getChatroomJids();
            if (selectedJids == null || selectedJids.size() == 0) {
                return;
            }
            VoiceItem item = VoicemailManager.getVoiceItemByMessage(UCChatClient.context, forwardedMessage);
            if (item == null) {
                Log.i(MessageArea.class.getSimpleName(), "VoiceItem null:" + forwardedMessage.getContent());
                ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
                return;
            }
            ArrayList<ChatReceiver> receiverList = new ArrayList<ChatReceiver>();
            for (String receiverJid : selectedJids) {
                receiverList.add(new ChatReceiver(receiverJid));
            }
            File localRecFile = VoicemailManager.getLocalVoiceItemFile(item);
            if (localRecFile != null) {
                if (localRecFile.exists()) {
                    ChatActionUtil.uploadFile(receiverList, localRecFile, false, null, actionService.getParentPanel());
                }
            } else {
                File cacheFile = VoicemailManager.getVoiceItemCacheFile(item);
                if (cacheFile == null) {
                    return;
                }
                if (cacheFile.exists()) {
                    ChatActionUtil.uploadFile(receiverList, cacheFile, false, null, actionService.getParentPanel());
                } else {
                    ForwardVoicePersonalFile.downloadAndForwardVoiceRecording(actionService, packetId, fileInfoStorageId, cacheFile, item, ForwardVoicePersonalFile.isLeft(targetMap), selectedJids);
                }
            }
        }
    }

    private static void downloadAndForwardVoiceRecording(final ActionService actionService, final String packetId, final String fileInfoStorageId, File cacheFile, VoiceItem item, final boolean isLeft, List<String> selectedJids) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    FileProgressBarRenderer.render(actionService, packetId, fileInfoStorageId, isLeft);
                }
                catch (UCThreadException e) {
                    Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                }
            }
        });
        String fileDownloadURL = item.getUrl();
        if (actionService.hasDownloadUrl(item.getUrl())) {
            return;
        }
        String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL.substring(fileDownloadURL.indexOf("/ucrm"));
        newURL = PreferencesUtil.isInOffice(UCChatClient.context) ? newURL + "&inOffice=true" : newURL + "&inOffice=false";
        DownloadFileTask task = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, item.getFileSize(), new MyVoicemailDownloadForwardTaskCallBack(actionService, packetId, cacheFile, item, selectedJids));
        actionService.registerDownloadMap(packetId, task);
        actionService.registerDownloadUrlMap(packetId, fileDownloadURL);
        task.start();
    }
}

