/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.action;

import com.blisscloud.ezuc.client.chat.ActionService;
import com.blisscloud.ezuc.client.chat.DownloadFileTaskCallBack;
import com.blisscloud.ezuc.client.chat.SelectFileHandler;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.mobile.ezuc.util.FaxSelectionCallback;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JOptionPane;

class MyDownloadFaxCallBack
implements DownloadFileTaskCallBack {
    String mPackId;
    File mFile;
    ActionService mActionService;
    FaxSelectionCallback faxSelectionCallback;

    public MyDownloadFaxCallBack(ActionService actionService, String packetId, File toFile, FaxSelectionCallback faxSelectionCallback) {
        this.mActionService = actionService;
        this.mPackId = packetId;
        this.mFile = toFile;
        this.faxSelectionCallback = faxSelectionCallback;
    }

    @Override
    public void onFileLengthGot(int length) {
    }

    @Override
    public void onProgressUpdated(int progress) {
        this.mActionService.updateFileDownloadProgress(this.mPackId, progress);
    }

    @Override
    public void onDownloadFileStarted() {
    }

    @Override
    public void onDownloadFileCompleted() {
        this.mActionService.updateFileDownloadCompleted(this.mPackId);
        long fileSize = this.mFile.length();
        if (fileSize > 0x1400000L) {
            JOptionPane.showMessageDialog(this.mActionService.getParentPanel(), String.format(I18NUtil.getString("chat_validation_doc_maxsize"), FileUtil.convertFileSizeDisplay(0x1400000L)), I18NUtil.getString("common_title_error"), 0);
            return;
        }
        ArrayList<File> fileList = new ArrayList<File>();
        fileList.add(this.mFile);
        SelectFileHandler.handleSelectedFileForFax(fileList, null, this.faxSelectionCallback);
        this.unlock();
    }

    @Override
    public void onDownloadFileCancelled() {
        this.mActionService.updateFileDownloadCancelled(this.mPackId);
        this.unlock();
    }

    @Override
    public void onDownloadFileFailed() {
        this.mActionService.updateFileDownloadFailed(this.mPackId);
        this.unlock();
        ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
    }

    private void unlock() {
        this.mActionService.unregisterDownloadMap(this.mPackId);
        this.mActionService.unregisterDownloadUrlMap(this.mPackId);
    }

    @Override
    public void onDownloadFileNotFound() {
        ToastUtil.showErrorLong(I18NUtil.getString("media_file_download_not_found"));
    }
}

