/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.action;

import com.blisscloud.ezuc.client.chat.ActionService;
import com.blisscloud.ezuc.client.chat.DownloadFileTaskCallBack;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

class MyDownloadSaveAsTaskCallBack
implements DownloadFileTaskCallBack {
    String mPackId;
    File mFile;
    File mSaveAsFile;
    ActionService mActionService;

    public MyDownloadSaveAsTaskCallBack(ActionService actionService, String packetId, File toFile, File saveAsFile) {
        this.mActionService = actionService;
        this.mPackId = packetId;
        this.mFile = toFile;
        this.mSaveAsFile = saveAsFile;
    }

    @Override
    public void onFileLengthGot(int length) {
    }

    @Override
    public void onProgressUpdated(int progress) {
        this.mActionService.updateFileDownloadProgress(this.mPackId, progress);
    }

    @Override
    public void onDownloadFileStarted() {
    }

    @Override
    public void onDownloadFileCompleted() {
        this.mActionService.updateFileDownloadCompleted(this.mPackId);
        try {
            Files.copy(this.mFile.toPath(), this.mSaveAsFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            ToastUtil.showShort(I18NUtil.getString("media_save_to_local_success"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.unlock();
    }

    @Override
    public void onDownloadFileCancelled() {
        this.mActionService.updateFileDownloadCancelled(this.mPackId);
        this.unlock();
    }

    @Override
    public void onDownloadFileFailed() {
        this.mActionService.updateFileDownloadFailed(this.mPackId);
        this.unlock();
        ToastUtil.showErrorLong(I18NUtil.getString("media_download_failed"));
    }

    private void unlock() {
        this.mActionService.unregisterDownloadMap(this.mPackId);
        this.mActionService.unregisterDownloadUrlMap(this.mPackId);
    }

    @Override
    public void onDownloadFileNotFound() {
        ToastUtil.showErrorLong(I18NUtil.getString("media_file_download_not_found"));
    }
}

