/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.action;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.chat.ActionService;
import com.blisscloud.ezuc.client.chat.DownloadFileTask;
import com.blisscloud.ezuc.client.chat.ElementAttrMap;
import com.blisscloud.ezuc.client.chat.MessageArea;
import com.blisscloud.ezuc.client.chat.action.ActionBase;
import com.blisscloud.ezuc.client.chat.action.MyDownloadSaveAsToDownloadTaskCallBack;
import com.blisscloud.ezuc.client.chat.dom.FileProgressBarRenderer;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javafx.application.Platform;

public class SaveFileToDownload
extends ActionBase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handle(final ActionService actionService, final ElementAttrMap targetMap) {
        ActionService actionService2 = actionService;
        synchronized (actionService2) {
            String packetId = targetMap.get("packetId");
            if (actionService.hasDownloadTask(packetId)) {
                return;
            }
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        SaveFileToDownload.doSaveFile(actionService, targetMap);
                    }
                    catch (UCThreadException e) {
                        Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                    }
                }
            });
        }
    }

    private static void doSaveFile(ActionService actionService, ElementAttrMap targetMap) throws UCThreadException {
        String packetId = targetMap.get("packetId");
        String fileInfoStorageId = targetMap.get("fileInfoStorageId");
        Message message = actionService.getMessageByPacketId(packetId);
        String fileName = message.getFileNameForDisp();
        String fileDownloadURL = message.getFileDownloadURL();
        String userHome = System.getProperty("user.home");
        File defaultDownloads = new File(userHome, "Downloads");
        if (!defaultDownloads.exists()) {
            return;
        }
        File saveAsFile = new File(defaultDownloads, fileName);
        if (saveAsFile != null) {
            File cacheFile = FileUtil.getDownloadCacheFile(fileDownloadURL);
            if (cacheFile.exists()) {
                try {
                    Files.copy(cacheFile.toPath(), saveAsFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ToastUtil.showShort(I18NUtil.getString("media_save_to_local_success"));
            } else {
                if (actionService.hasDownloadUrl(fileDownloadURL)) {
                    return;
                }
                FileProgressBarRenderer.render(actionService, packetId, fileInfoStorageId, SaveFileToDownload.isLeft(targetMap));
                String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + fileDownloadURL.substring(fileDownloadURL.indexOf("/ucrm"));
                DownloadFileTask task = new DownloadFileTask(UCChatClient.context, newURL, cacheFile, 0L, new MyDownloadSaveAsToDownloadTaskCallBack(actionService, packetId, cacheFile, saveAsFile));
                actionService.registerDownloadMap(packetId, task);
                actionService.registerDownloadUrlMap(packetId, fileDownloadURL);
                task.start();
            }
        }
    }
}

