/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.dom;

import com.blisscloud.ezuc.client.chat.DomService;
import com.blisscloud.ezuc.client.chat.MessageStatus;
import com.blisscloud.ezuc.client.chat.dom.DomUtil;
import com.blisscloud.ezuc.client.chat.dom.MyRendererBase;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.text.ChatTextWriter;
import com.blisscloud.ezuc.client.text.MsgTextConverter;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import java.awt.image.BufferedImage;
import javafx.application.Platform;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MyDocumentRenderer
extends MyRendererBase {
    public static void render(DomService domService, Node docNode, Message msg, String myJid, String myName, boolean isMultiRoom, String searchKey, String targetPacketId) throws UCThreadException {
        if (!Platform.isFxApplicationThread()) {
            throw new UCThreadException();
        }
        String imageBase64Content = msg.getContent();
        String fileName = msg.getFileNameForDisp();
        long fileSize = msg.getFileSizeToCal();
        String packetId = msg.getPacketId();
        String status = msg.getStatus();
        String extraInfo = msg.getExtraMsgInfo();
        MessageStatus msgStatus = DomUtil.convertMsgStatus(status);
        Element docElement = (Element)docNode;
        MyDocumentRenderer.fillMyCommonData(domService, docElement, myJid, myName, msg, msgStatus, isMultiRoom);
        String fileInfoStorageId = "myMessageInfo_" + packetId;
        if (StringUtils.isNotBlank((CharSequence)extraInfo)) {
            Element elem_myImageWithMsgText = domService.getElementById("myExtraText");
            elem_myImageWithMsgText.setAttribute("id", "myExtraText_" + packetId);
            elem_myImageWithMsgText.setAttribute("packetId", packetId);
            elem_myImageWithMsgText.setAttribute("command", "selectAll");
            domService.addEventListener(elem_myImageWithMsgText, "dblclick");
            ChatTextWriter writer = new ChatTextWriter(domService, elem_myImageWithMsgText, packetId, searchKey, targetPacketId);
            MsgTextConverter.convertAndAppendText(extraInfo, writer);
        }
        Element elem_docInfo = domService.getElementById("myMessageInfo");
        elem_docInfo.setAttribute("id", fileInfoStorageId);
        elem_docInfo.setAttribute("packetId", packetId);
        elem_docInfo.setAttribute("messageId", String.valueOf(msg.getId()));
        Element elem_docIcon = domService.getElementById("myMessageIcon");
        elem_docIcon.setAttribute("id", "myMessageIcon_" + packetId);
        elem_docIcon.setAttribute("packetId", packetId);
        BufferedImage bi = null;
        if (TextUtils.isNotBlank((CharSequence)imageBase64Content) && !"nodata".equalsIgnoreCase(imageBase64Content)) {
            bi = GraphicUtil.convertBase64StringToImage(imageBase64Content);
        }
        if (bi != null) {
            int imageWidth = bi.getWidth();
            int imageHeight = bi.getHeight();
            elem_docIcon.setAttribute("width", String.valueOf(imageWidth));
            elem_docIcon.setAttribute("height", String.valueOf(imageHeight));
            elem_docIcon.setAttribute("src", "data:image/png;base64," + imageBase64Content);
        } else {
            elem_docIcon.setAttribute("src", DomUtil.getDocumentIconURI(fileName));
            elem_docIcon.setAttribute("width", String.valueOf(80));
            elem_docIcon.setAttribute("height", String.valueOf(80));
        }
        elem_docIcon.setAttribute("fileInfoStorageId", fileInfoStorageId);
        elem_docIcon.setAttribute("command", "downloadDocument");
        elem_docIcon.setAttribute("isFromMe", "true");
        domService.addEventListener(elem_docIcon, "click");
        Element elem_docName = domService.getElementById("myDocumentName");
        elem_docName.setAttribute("id", "myDocumentName_" + packetId);
        boolean searchNow = false;
        if (targetPacketId != null && targetPacketId.equalsIgnoreCase(packetId)) {
            searchNow = true;
        }
        ChatTextWriter.writeTextMatchSearchKey(domService, elem_docName, fileName, searchKey, packetId, targetPacketId);
        Element elem_docSize = domService.getElementById("myDocumentSize");
        elem_docSize.setAttribute("id", "myDocumentSize_" + packetId);
        elem_docSize.appendChild(domService.createTextNode(FileUtil.getFileSizeText(fileSize)));
        if (msgStatus == MessageStatus.UPLOADING) {
            MyDocumentRenderer.appendFileUploadProgressBar(domService, packetId, fileInfoStorageId);
        }
    }
}

