/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.dom;

import com.blisscloud.ezuc.client.chat.DomService;
import com.blisscloud.ezuc.client.chat.MessageResource;
import com.blisscloud.ezuc.client.chat.MessageStatus;
import com.blisscloud.ezuc.client.chat.dom.DomUtil;
import com.blisscloud.ezuc.client.chat.dom.MyRendererBase;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.text.ChatTextWriter;
import com.blisscloud.ezuc.client.text.MsgTextConverter;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.mobile.ezuc.bean.Message;
import java.awt.image.BufferedImage;
import javafx.application.Platform;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MyImageRenderer
extends MyRendererBase {
    public static void render(DomService domService, Node imageNode, Message msg, String myJid, String myName, boolean isMultiRoom, String searchKey, String targetPacketId) throws UCThreadException {
        if (!Platform.isFxApplicationThread()) {
            throw new UCThreadException();
        }
        String imageBase64Content = msg.getContent();
        String packetId = msg.getPacketId();
        String status = msg.getStatus();
        String extraInfo = msg.getExtraMsgInfo();
        MessageStatus msgStatus = DomUtil.convertMsgStatus(status);
        Element imageElement = (Element)imageNode;
        MyImageRenderer.fillMyCommonData(domService, imageElement, myJid, myName, msg, msgStatus, isMultiRoom);
        String fileInfoStorageId = "myMessageInfo_" + packetId;
        if (StringUtils.isNotBlank((CharSequence)extraInfo)) {
            Element elem_myImageWithMsgText = domService.getElementById("myExtraText");
            elem_myImageWithMsgText.setAttribute("id", "myExtraText_" + packetId);
            elem_myImageWithMsgText.setAttribute("packetId", packetId);
            elem_myImageWithMsgText.setAttribute("command", "selectAll");
            domService.addEventListener(elem_myImageWithMsgText, "dblclick");
            ChatTextWriter writer = new ChatTextWriter(domService, elem_myImageWithMsgText, packetId, searchKey, targetPacketId);
            MsgTextConverter.convertAndAppendText(extraInfo, writer);
        }
        Element elem_imageInfo = domService.getElementById("myMessageInfo");
        elem_imageInfo.setAttribute("id", fileInfoStorageId);
        elem_imageInfo.setAttribute("packetId", packetId);
        elem_imageInfo.setAttribute("messageId", String.valueOf(msg.getId()));
        Element elem_imageIcon = domService.getElementById("myMessageIcon");
        elem_imageIcon.setAttribute("id", "myMessageIcon_" + packetId);
        elem_imageIcon.setAttribute("packetId", packetId);
        if (TextUtils.isNotBlank((CharSequence)imageBase64Content)) {
            BufferedImage bi = GraphicUtil.convertBase64StringToImage(imageBase64Content);
            if (bi != null) {
                int imageWidth = bi.getWidth();
                int imageHeight = bi.getHeight();
                elem_imageIcon.setAttribute("width", String.valueOf(imageWidth));
                elem_imageIcon.setAttribute("height", String.valueOf(imageHeight));
                elem_imageIcon.setAttribute("src", "data:image/png;base64," + imageBase64Content);
            } else {
                elem_imageIcon.setAttribute("width", String.valueOf(120));
                elem_imageIcon.setAttribute("height", String.valueOf(90));
                elem_imageIcon.setAttribute("src", MessageResource.fileMissingIconURI);
            }
        } else {
            elem_imageIcon.setAttribute("width", String.valueOf(120));
            elem_imageIcon.setAttribute("height", String.valueOf(90));
            elem_imageIcon.setAttribute("src", MessageResource.fileMissingIconURI);
        }
        elem_imageIcon.setAttribute("fileInfoStorageId", fileInfoStorageId);
        elem_imageIcon.setAttribute("isFromMe", "true");
        elem_imageIcon.setAttribute("command", "downloadImage");
        domService.addEventListener(elem_imageIcon, "click");
        if (msgStatus == MessageStatus.UPLOADING) {
            MyImageRenderer.appendFileUploadProgressBar(domService, packetId, fileInfoStorageId);
        }
    }
}

