/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.dom;

import com.blisscloud.ezuc.client.chat.DomService;
import com.blisscloud.ezuc.client.chat.MessageStatus;
import com.blisscloud.ezuc.client.chat.dom.DomUtil;
import com.blisscloud.ezuc.client.chat.dom.MyRendererBase;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.text.ChatTextWriter;
import com.blisscloud.ezuc.client.text.MsgTextConverter;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.mobile.ezuc.bean.Message;
import javafx.application.Platform;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MyLocationRenderer
extends MyRendererBase {
    public static void render(DomService domService, Node textNode, Message msg, String myJid, String myName, boolean isMultiRoom, String searchKey, String targetPacketId) throws UCThreadException {
        if (!Platform.isFxApplicationThread()) {
            throw new UCThreadException();
        }
        String packetId = msg.getPacketId();
        String address = msg.getContent();
        String status = msg.getStatus();
        String title = msg.getTitle();
        MessageStatus msgStatus = DomUtil.convertMsgStatus(status);
        Element textElement = (Element)textNode;
        MyLocationRenderer.fillMyCommonData(domService, textElement, myJid, myName, msg, msgStatus, isMultiRoom);
        if (TextUtils.isEmpty((CharSequence)address)) {
            address = I18NUtil.getString("chat_location_no_address_hint");
        }
        Element elem_myLocationAddrText = domService.getElementById("myLocationAddress");
        elem_myLocationAddrText.setAttribute("id", "myLocationAddress_" + packetId);
        elem_myLocationAddrText.setAttribute("packetId", packetId);
        elem_myLocationAddrText.setAttribute("style", "cursor:pointer;");
        elem_myLocationAddrText.setAttribute("command", "displayLocation");
        domService.addEventListener(elem_myLocationAddrText, "click");
        ChatTextWriter writer1 = new ChatTextWriter(domService, elem_myLocationAddrText, packetId, searchKey, targetPacketId);
        MsgTextConverter.convertAndAppendText(address, writer1);
        if (TextUtils.isEmpty((CharSequence)title)) {
            title = I18NUtil.getString("chat_msg_type_location_title");
        }
        Element elem_myLocationLabelText = domService.getElementById("myLocationLabel");
        elem_myLocationLabelText.setAttribute("id", "myLocationLabel_" + packetId);
        elem_myLocationLabelText.setAttribute("packetId", packetId);
        elem_myLocationLabelText.setAttribute("style", "cursor:pointer;");
        elem_myLocationLabelText.setAttribute("command", "displayLocation");
        domService.addEventListener(elem_myLocationLabelText, "click");
        ChatTextWriter writer2 = new ChatTextWriter(domService, elem_myLocationLabelText, packetId, searchKey, targetPacketId);
        MsgTextConverter.convertAndAppendText(title, writer2);
    }
}

