/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.dom;

import com.blisscloud.ezuc.client.chat.DomService;
import com.blisscloud.ezuc.client.chat.MessageResource;
import com.blisscloud.ezuc.client.chat.MessageStatus;
import com.blisscloud.ezuc.client.chat.dom.DomUtil;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.DateTimeUtil;
import com.blisscloud.ezuc.client.util.MsgUtil;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import org.w3c.dom.Element;

public class MyRendererBase {
    public static void fillMyCommonData(DomService domService, Element messageElement, String myJID, String myName, Message msg, MessageStatus msgStatus, boolean isMultiRoom) throws UCThreadException {
        Element elem_myMessageStatus;
        Element elem_myMessageReadStatus;
        String packetId = msg.getPacketId();
        messageElement.setAttribute("id", "msg_" + packetId);
        messageElement.setAttribute("packetId", packetId);
        messageElement.setAttribute("messageId", String.valueOf(msg.getId()));
        messageElement.setAttribute("mineFlag", String.valueOf(1));
        Object myPhotoURI = ContactManager.getContactPhotoURI(myJID);
        myPhotoURI = myPhotoURI == null ? MessageResource.noNamePhotoURI : (String)myPhotoURI + "?" + System.currentTimeMillis();
        Element elem_myPhoto = domService.getElementById("myPhoto");
        elem_myPhoto.setAttribute("id", "myPhoto_" + packetId);
        elem_myPhoto.setAttribute("packetId", packetId);
        elem_myPhoto.setAttribute("src", (String)myPhotoURI);
        domService.registerPhotoKey("myPhoto_" + packetId, myJID);
        Element elem_myMessageTime = domService.getElementById("myMessageTime");
        if (elem_myMessageTime != null) {
            elem_myMessageTime.setAttribute("id", "elem_myMessageTime_" + packetId);
            String serverTime = DateTimeUtil.getTimeStr(msg.getServerTime(), 2);
            elem_myMessageTime.appendChild(domService.createTextNode(serverTime));
        }
        if ((elem_myMessageReadStatus = domService.getElementById("myMessageReadStatus")) != null) {
            elem_myMessageReadStatus.setAttribute("id", "myMessageReadStatus_" + packetId);
            int readCount = MsgUtil.getReadCount(msg);
            if (readCount != 0) {
                if (isMultiRoom) {
                    elem_myMessageReadStatus.appendChild(domService.createTextNode(String.format(I18NUtil.getString("chat_title_msg_read_with_count"), readCount)));
                    elem_myMessageReadStatus.setAttribute("packetId", packetId);
                    elem_myMessageReadStatus.setAttribute("command", "showReadUnreadList");
                    elem_myMessageReadStatus.setAttribute("class", "functionButton");
                    domService.addEventListener(elem_myMessageReadStatus, "click");
                } else {
                    elem_myMessageReadStatus.appendChild(domService.createTextNode(I18NUtil.getString("chat_title_msg_read")));
                    elem_myMessageReadStatus.setAttribute("packetId", packetId);
                    elem_myMessageReadStatus.setAttribute("command", "showReadUnreadList");
                    elem_myMessageReadStatus.setAttribute("class", "functionButton");
                    domService.addEventListener(elem_myMessageReadStatus, "click");
                }
            }
        }
        if ((elem_myMessageStatus = domService.getElementById("myMessageStatus")) != null) {
            elem_myMessageStatus.setAttribute("id", "myMessageStatus_" + packetId);
            elem_myMessageStatus.setAttribute("packetId", packetId);
            elem_myMessageStatus.setAttribute("messageId", String.valueOf(msg.getId()));
            elem_myMessageStatus.setAttribute("src", DomUtil.getMessageStatusIcon(msgStatus));
            if (msgStatus == MessageStatus.NOT_PROCESSED) {
                elem_myMessageStatus.setAttribute("style", "cursor:pointer;");
                domService.addErrorEventListener(elem_myMessageStatus, "click");
            }
        }
    }

    public static void appendFileUploadProgressBar(DomService domService, String packetId, String progressBarParentId) throws UCThreadException {
        Element elem_progressBox = domService.getElementById("uploadProgressBox_" + packetId);
        if (elem_progressBox != null) {
            elem_progressBox.setAttribute("style", "display:;");
            return;
        }
        elem_progressBox = domService.createElement("div");
        elem_progressBox.setAttribute("id", "uploadProgressBox_" + packetId);
        elem_progressBox.setAttribute("align", "left");
        Element elem_progressBar = domService.createElement("div");
        elem_progressBar.setAttribute("id", "uploadProgressBar_" + packetId);
        elem_progressBar.setAttribute("class", "uploadProgressBar");
        Element elem_progressPercentBar = domService.createElement("div");
        elem_progressPercentBar.setAttribute("id", "uploadProgressPercentBar_" + packetId);
        elem_progressPercentBar.setAttribute("class", "uploadProgressPercentBar");
        elem_progressPercentBar.setAttribute("style", "width:0px;");
        Element elem_progressPercentText = domService.createElement("label");
        elem_progressPercentText.setAttribute("id", "uploadProgressPercentText_" + packetId);
        elem_progressPercentText.setAttribute("class", "uploadProgressPercentText");
        elem_progressPercentText.appendChild(domService.createTextNode("0%"));
        Element elem_cancelUpload = domService.createElement("img");
        elem_cancelUpload.setAttribute("id", "cancelUpload_" + packetId);
        elem_cancelUpload.setAttribute("packetId", packetId);
        elem_cancelUpload.setAttribute("class", "cancelUpload");
        elem_cancelUpload.setAttribute("src", MessageResource.cancelUploadIconURI);
        elem_cancelUpload.setAttribute("fileInfoStorageId", "myMessageInfo_" + packetId);
        elem_cancelUpload.setAttribute("command", "cancelUpload");
        domService.addEventListener(elem_cancelUpload, "click");
        elem_progressBox.appendChild(elem_cancelUpload);
        elem_progressBar.appendChild(elem_progressPercentBar);
        elem_progressBox.appendChild(elem_progressBar);
        elem_progressBox.appendChild(elem_progressPercentText);
        Element elem_progressBarParent = domService.getElementById(progressBarParentId);
        elem_progressBarParent.appendChild(elem_progressBox);
    }
}

