/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.dom;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.chat.DomService;
import com.blisscloud.ezuc.client.chat.MessageResource;
import com.blisscloud.ezuc.client.chat.MessageStatus;
import com.blisscloud.ezuc.client.chat.dom.DomUtil;
import com.blisscloud.ezuc.client.chat.dom.MyRendererBase;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.component.UCUploadFileChooser;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.text.ChatTextWriter;
import com.blisscloud.ezuc.client.text.MsgRefTextConverter;
import com.blisscloud.ezuc.client.text.MsgTextConverter;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.MsgUtil;
import com.blisscloud.ezuc.client.util.QuoteItem;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.bean.MessageChannel;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.db.UCDBMessageChannel;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.MessageChannelManager;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import java.awt.image.BufferedImage;
import javafx.application.Platform;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class MyTextRenderer
extends MyRendererBase {
    public static void render(DomService domService, Node textNode, Message msg, String myJid, String myName, boolean isMultiRoom, String searchKey, String targetPacketId) throws UCThreadException {
        if (!Platform.isFxApplicationThread()) {
            throw new UCThreadException();
        }
        Message refMsg = null;
        String refPacketId = null;
        if (msg.getProps() != null && msg.getProps().contains("refPacketId")) {
            try {
                JSONObject propObj = new JSONObject(msg.getProps());
                if (propObj.has("refPacketId")) {
                    refPacketId = propObj.getString("refPacketId");
                    refMsg = UCDBMessage.findMsgByPacketId(UCChatClient.context, refPacketId);
                }
            }
            catch (Exception e) {
                Log.e(MyTextRenderer.class.getSimpleName(), e.getMessage(), e);
            }
        }
        String packetId = msg.getPacketId();
        String text = msg.getContent();
        String status = msg.getStatus();
        MessageStatus msgStatus = DomUtil.convertMsgStatus(status);
        Element textElement = (Element)textNode;
        MyTextRenderer.fillMyCommonData(domService, textElement, myJid, myName, msg, msgStatus, isMultiRoom);
        String myMessageTextId = "myMessageText_" + packetId;
        boolean replyEnabled = StringUtils.isNotBlank((CharSequence)refPacketId);
        Element elem_myMessageText = domService.getElementById("myMessageText");
        elem_myMessageText.setAttribute("id", myMessageTextId);
        elem_myMessageText.setAttribute("packetId", packetId);
        Element textWriterElem = elem_myMessageText;
        if (replyEnabled) {
            if (refMsg != null && !refMsg.isRecalled()) {
                elem_ref_div = domService.createElement("div");
                elem_ref_div.setAttribute("id", "myMessageTextRef_" + packetId);
                domService.registerRefKey("myMessageTextRef_" + packetId, refMsg.getPacketId());
                elem_ref_div.setAttribute("style", "font-size:12px; padding:6px 6px 6px 6px; border-bottom:1px solid; border-bottom-color:#a8a8a8;cursor:pointer;");
                elem_ref_div.setAttribute("packetId", packetId);
                elem_ref_div.setAttribute("refPacketId", refMsg.getPacketId());
                elem_ref_div.setAttribute("command", "scrollToMsg");
                domService.addEventListener(elem_ref_div, "click");
                Element elem_table = domService.createElement("table");
                elem_table.setAttribute("cellpadding", "3");
                elem_table.setAttribute("cellspacing", "0");
                elem_table.setAttribute("border", "0");
                elem_table.setAttribute("width", "100%");
                elem_table.setAttribute("style", "pointer-events: none;");
                Element tr_1 = domService.createElement("tr");
                Element td_ref_photo = domService.createElement("td");
                td_ref_photo.setAttribute("rowspan", "2");
                td_ref_photo.setAttribute("width", "37");
                td_ref_photo.setAttribute("align", "center");
                tr_1.appendChild(td_ref_photo);
                tr_1.appendChild(td_ref_photo);
                Element td_name = domService.createElement("td");
                td_name.setAttribute("width", "100%");
                tr_1.appendChild(td_name);
                Element td_image = domService.createElement("td");
                td_image.setAttribute("rowspan", "2");
                tr_1.appendChild(td_image);
                elem_table.appendChild(tr_1);
                Element tr_2 = domService.createElement("tr");
                Element td_ref_content = domService.createElement("td");
                tr_2.appendChild(td_ref_content);
                elem_table.appendChild(tr_2);
                Object refPhotoURI = null;
                if (JidUtil.isAPIUserJid(refMsg.getFromJid())) {
                    MessageChannel channel = UCDBMessageChannel.getMessageChannelByJid(UCChatClient.context, refMsg.getFromJid());
                    refPhotoURI = MessageChannelManager.getChannelPhotoURI(channel.getId());
                } else {
                    refPhotoURI = ContactManager.getContactPhotoURI(refMsg.getFromJid());
                }
                refPhotoURI = refPhotoURI == null ? MessageResource.noNamePhotoURI : (String)refPhotoURI + "?" + System.currentTimeMillis();
                domService.registerPhotoKey("myMessageTextRefPhoto_" + packetId, refMsg.getFromJid());
                Element refPhoto = domService.createElement("img");
                refPhoto.setAttribute("id", "myMessageTextRefPhoto_" + packetId);
                refPhoto.setAttribute("src", (String)refPhotoURI);
                refPhoto.setAttribute("style", "border-radius: 5px;width:35px;height:35px;");
                td_ref_photo.appendChild(refPhoto);
                QuoteItem item = MsgUtil.getQuoteItem(UCChatClient.context, refMsg);
                Text prefixText2 = domService.createTextNode(item.getOwnerName() + I18NUtil.getString("comma2") + item.getTime());
                td_name.appendChild(prefixText2);
                Object dispContent = StringUtils.isNotBlank((CharSequence)item.getMsgContent()) ? item.getMsgContent().trim() : "";
                if (StringUtils.isNotBlank((CharSequence)item.getExtraInfo())) {
                    dispContent = (String)dispContent + " " + item.getExtraInfo().trim();
                }
                ChatTextWriter writer = new ChatTextWriter(domService, td_ref_content, packetId, 12, 50);
                MsgRefTextConverter.convertAndAppendText((String)dispContent, writer);
                int msgType = refMsg.getMsgType();
                if (msgType == 5) {
                    MyTextRenderer.handleImageIconForReply(domService, packetId, refMsg, td_image);
                } else if (msgType == 4) {
                    MyTextRenderer.handleVideoIconForReply(domService, packetId, refMsg, td_image);
                } else if (msgType == 11) {
                    MyTextRenderer.handleDocumentIconForReply(domService, packetId, refMsg, td_image);
                } else if (msgType == 2) {
                    String fileExt = refMsg.getFileExtension();
                    if (UCUploadFileChooser.IMAGE_TYPES.contains(fileExt)) {
                        MyTextRenderer.handleImageIconForReply(domService, packetId, refMsg, td_image);
                    } else if (UCUploadFileChooser.VIDEO_TYPES.contains(fileExt)) {
                        MyTextRenderer.handleVideoIconForReply(domService, packetId, refMsg, td_image);
                    } else if (UCUploadFileChooser.DOCUMENT_TYPES.contains(fileExt) || UCUploadFileChooser.AUDIO_TYPES.contains(fileExt)) {
                        MyTextRenderer.handleDocumentIconForReply(domService, packetId, refMsg, td_image);
                    }
                }
                elem_ref_div.appendChild(elem_table);
                elem_myMessageText.appendChild(elem_ref_div);
            } else {
                elem_ref_div = domService.createElement("div");
                MyTextRenderer.applyUnableToLoadReply(domService, elem_ref_div);
                elem_myMessageText.appendChild(elem_ref_div);
            }
            Element elem_main_div = domService.createElement("div");
            elem_main_div.setAttribute("id", "myMessageTextMain_" + packetId);
            elem_main_div.setAttribute("packetId", packetId);
            elem_main_div.setAttribute("mainTextId", "myMessageTextMain_" + packetId);
            elem_main_div.setAttribute("style", "padding:12px 12px 12px 12px;");
            elem_main_div.setAttribute("command", "selectAll");
            domService.addEventListener(elem_main_div, "dblclick");
            elem_myMessageText.appendChild(elem_main_div);
            textWriterElem = elem_main_div;
            elem_myMessageText.setAttribute("style", "padding:0px;");
        } else {
            elem_myMessageText.setAttribute("mainTextId", "myMessageText_" + packetId);
            elem_myMessageText.setAttribute("style", "padding:12px;");
            elem_myMessageText.setAttribute("command", "selectAll");
            domService.addEventListener(elem_myMessageText, "dblclick");
        }
        ChatTextWriter writer = new ChatTextWriter(domService, textWriterElem, packetId, searchKey, targetPacketId);
        boolean hasSticker = MsgTextConverter.convertAndAppendText(text, writer);
        if (!replyEnabled && hasSticker) {
            elem_myMessageText.setAttribute("class", "myMessageOnePic");
        }
    }

    public static void applyUnableToLoadReply(DomService domService, Element elem_ref_div) throws UCThreadException {
        elem_ref_div.setAttribute("style", "font-size:12px; padding:8px 12px 8px 12px; border-bottom:1px solid; border-bottom-color:#a8a8a8;");
        Element elem_table = domService.createElement("table");
        elem_table.setAttribute("cellpadding", "5");
        elem_table.setAttribute("cellspacing", "0");
        elem_table.setAttribute("border", "0");
        elem_table.setAttribute("width", "100%");
        elem_table.setAttribute("style", "pointer-events: none;");
        Element tr_2 = domService.createElement("tr");
        Element td_ref_content = domService.createElement("td");
        tr_2.appendChild(td_ref_content);
        elem_table.appendChild(tr_2);
        Text prefixText3 = domService.createTextNode(I18NUtil.getString("chat_unable_to_load_reply_msg"));
        td_ref_content.appendChild(prefixText3);
        elem_ref_div.appendChild(elem_table);
    }

    private static void handleImageIconForReply(DomService domService, String packetId, Message refMsg, Element td_image) throws UCThreadException {
        Element elem_imageIcon = domService.createElement("img");
        elem_imageIcon.setAttribute("id", "myMessageTextRefImg_" + packetId);
        elem_imageIcon.setAttribute("style", "background:white;margin:1px 1px 1px 5px;");
        int fixHeight = 35;
        if (TextUtils.isNotBlank((CharSequence)refMsg.getContent())) {
            BufferedImage bi = GraphicUtil.convertBase64StringToImage(refMsg.getContent());
            if (bi != null) {
                bi = GraphicUtil.crop(bi);
                elem_imageIcon.setAttribute("width", String.valueOf(fixHeight));
                elem_imageIcon.setAttribute("height", String.valueOf(fixHeight));
                elem_imageIcon.setAttribute("src", "data:image/png;base64," + GraphicUtil.convertImageToBase64String(bi));
            } else {
                elem_imageIcon.setAttribute("width", String.valueOf(fixHeight));
                elem_imageIcon.setAttribute("height", String.valueOf(fixHeight));
                elem_imageIcon.setAttribute("src", MessageResource.fileMissingSquareIconURI);
            }
        } else {
            elem_imageIcon.setAttribute("width", String.valueOf(fixHeight));
            elem_imageIcon.setAttribute("height", String.valueOf(fixHeight));
            elem_imageIcon.setAttribute("src", MessageResource.fileMissingSquareIconURI);
        }
        td_image.appendChild(elem_imageIcon);
        if (TextUtils.isBlank((CharSequence)refMsg.getContent())) {
            domService.registerRefPhotoKey("myMessageTextRefImg_" + packetId, refMsg.getPacketId());
        }
    }

    private static void handleVideoIconForReply(DomService domService, String packetId, Message refMsg, Element td_image) throws UCThreadException {
        Element elem_imageIcon = domService.createElement("img");
        elem_imageIcon.setAttribute("id", "myMessageTextRefImg_" + packetId);
        elem_imageIcon.setAttribute("style", "background:white;margin:1px 1px 1px 5px;");
        int fixHeight = 35;
        if (TextUtils.isNotBlank((CharSequence)refMsg.getContent())) {
            BufferedImage bi = GraphicUtil.convertBase64StringToImage(refMsg.getContent());
            if (bi != null) {
                bi = GraphicUtil.crop(bi);
                bi = GraphicUtil.convertVideoThumbnailImage(bi, 35, 17);
                int imageWidth = bi.getWidth();
                int imageHeight = bi.getHeight();
                elem_imageIcon.setAttribute("width", String.valueOf(fixHeight));
                elem_imageIcon.setAttribute("height", String.valueOf(fixHeight));
                elem_imageIcon.setAttribute("src", "data:image/png;base64," + GraphicUtil.convertImageToBase64String(bi));
            } else {
                elem_imageIcon.setAttribute("width", String.valueOf(fixHeight));
                elem_imageIcon.setAttribute("height", String.valueOf(fixHeight));
                elem_imageIcon.setAttribute("src", MessageResource.fileMissingSquareIconURI);
            }
        } else {
            elem_imageIcon.setAttribute("width", String.valueOf(fixHeight));
            elem_imageIcon.setAttribute("height", String.valueOf(fixHeight));
            elem_imageIcon.setAttribute("src", MessageResource.fileMissingSquareIconURI);
        }
        td_image.appendChild(elem_imageIcon);
        if (TextUtils.isBlank((CharSequence)refMsg.getContent())) {
            domService.registerRefPhotoKey("myMessageTextRefImg_" + packetId, refMsg.getPacketId());
        }
    }

    private static void handleDocumentIconForReply(DomService domService, String packetId, Message refMsg, Element td_image) throws UCThreadException {
        Element elem_imageIcon = domService.createElement("img");
        elem_imageIcon.setAttribute("id", "myMessageTextRefImg_" + packetId);
        elem_imageIcon.setAttribute("style", "background:white;margin:1px 1px 1px 5px;");
        int fixHeight = 35;
        String imageBase64Content = refMsg.getContent();
        String fileName = refMsg.getFileNameForDisp();
        BufferedImage bi = null;
        if (TextUtils.isNotBlank((CharSequence)imageBase64Content) && !"nodata".equalsIgnoreCase(imageBase64Content)) {
            bi = GraphicUtil.convertBase64StringToImage(imageBase64Content);
            bi = GraphicUtil.crop(bi);
        }
        if (bi != null) {
            elem_imageIcon.setAttribute("width", String.valueOf(fixHeight));
            elem_imageIcon.setAttribute("height", String.valueOf(fixHeight));
            elem_imageIcon.setAttribute("src", "data:image/png;base64," + GraphicUtil.convertImageToBase64String(bi));
        } else {
            elem_imageIcon.setAttribute("src", DomUtil.getDocumentIconURI(fileName));
            elem_imageIcon.setAttribute("width", String.valueOf(fixHeight));
            elem_imageIcon.setAttribute("height", String.valueOf(fixHeight));
        }
        td_image.appendChild(elem_imageIcon);
        if (TextUtils.isBlank((CharSequence)refMsg.getContent())) {
            domService.registerRefPhotoKey("myMessageTextRefImg_" + packetId, refMsg.getPacketId());
        }
    }
}

