/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.dom;

import com.blisscloud.ezuc.client.chat.DomService;
import com.blisscloud.ezuc.client.chat.dom.DomUtil;
import com.blisscloud.ezuc.client.chat.dom.OtherRendererBase;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.text.ChatTextWriter;
import com.blisscloud.ezuc.client.text.MsgTextConverter;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import java.awt.image.BufferedImage;
import javafx.application.Platform;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OtherDocumentRenderer
extends OtherRendererBase {
    public static void render(DomService domService, Node textNode, Message msg, String otherJid, String otherName, String searchKey, String targetPacketId) throws UCThreadException {
        if (!Platform.isFxApplicationThread()) {
            throw new UCThreadException();
        }
        String imageBase64Content = msg.getContent();
        String packetId = msg.getPacketId();
        String fileName = msg.getFileNameForDisp();
        long fileSize = msg.getFileSizeToCal();
        String extraInfo = msg.getExtraMsgInfo();
        Element textElement = (Element)textNode;
        OtherDocumentRenderer.fillOtherCommonData(domService, textElement, otherJid, otherName, msg);
        String fileInfoStorageId = "otherMessageInfo_" + packetId;
        if (StringUtils.isNotBlank((CharSequence)extraInfo)) {
            Element elem_otherVideoWithMsgText = domService.getElementById("otherExtraText");
            elem_otherVideoWithMsgText.setAttribute("id", "otherExtraText_" + packetId);
            elem_otherVideoWithMsgText.setAttribute("packetId", packetId);
            elem_otherVideoWithMsgText.setAttribute("command", "selectAll");
            domService.addEventListener(elem_otherVideoWithMsgText, "dblclick");
            ChatTextWriter writer = new ChatTextWriter(domService, elem_otherVideoWithMsgText, packetId, searchKey, targetPacketId);
            MsgTextConverter.convertAndAppendText(extraInfo, writer);
        }
        Element elem_docInfo = domService.getElementById("otherMessageInfo");
        elem_docInfo.setAttribute("id", fileInfoStorageId);
        elem_docInfo.setAttribute("packetId", packetId);
        elem_docInfo.setAttribute("messageId", String.valueOf(msg.getId()));
        Element elem_docIcon = domService.getElementById("otherMessageIcon");
        elem_docIcon.setAttribute("id", "otherMessageIcon_" + packetId);
        elem_docIcon.setAttribute("packetId", packetId);
        BufferedImage bi = null;
        if (TextUtils.isNotBlank((CharSequence)imageBase64Content) && !"nodata".equalsIgnoreCase(imageBase64Content)) {
            bi = GraphicUtil.convertBase64StringToImage(imageBase64Content);
        }
        if (bi != null) {
            int imageWidth = bi.getWidth();
            int imageHeight = bi.getHeight();
            elem_docIcon.setAttribute("width", String.valueOf(imageWidth));
            elem_docIcon.setAttribute("height", String.valueOf(imageHeight));
            elem_docIcon.setAttribute("src", "data:image/png;base64," + imageBase64Content);
        } else {
            elem_docIcon.setAttribute("src", DomUtil.getDocumentIconURI(fileName));
            elem_docIcon.setAttribute("width", String.valueOf(80));
            elem_docIcon.setAttribute("height", String.valueOf(80));
        }
        elem_docIcon.setAttribute("fileInfoStorageId", fileInfoStorageId);
        elem_docIcon.setAttribute("command", "downloadDocument");
        elem_docIcon.setAttribute("isFromMe", "false");
        domService.addEventListener(elem_docIcon, "click");
        Element elem_docName = domService.getElementById("otherDocumentName");
        elem_docName.setAttribute("id", "otherDocumentName_" + packetId);
        ChatTextWriter.writeTextMatchSearchKey(domService, elem_docName, fileName, searchKey, packetId, targetPacketId);
        Element elem_docSize = domService.getElementById("otherDocumentSize");
        elem_docSize.setAttribute("id", "otherDocumentSize_" + packetId);
        elem_docSize.appendChild(domService.createTextNode(FileUtil.getFileSizeText(fileSize)));
    }
}

