/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.dom;

import com.blisscloud.ezuc.client.chat.DomService;
import com.blisscloud.ezuc.client.chat.MessageResource;
import com.blisscloud.ezuc.client.chat.dom.OtherRendererBase;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.text.ChatTextWriter;
import com.blisscloud.ezuc.client.text.MsgTextConverter;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import java.awt.image.BufferedImage;
import javafx.application.Platform;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OtherVideoRenderer
extends OtherRendererBase {
    public static void render(DomService domService, Node textNode, Message msg, String otherJid, String otherName, String searchKey, String targetPacketId) throws UCThreadException {
        if (!Platform.isFxApplicationThread()) {
            throw new UCThreadException();
        }
        String packetId = msg.getPacketId();
        String imageBase64Content = msg.getContent();
        String extraInfo = msg.getExtraMsgInfo();
        long videoDuration = msg.getDuration();
        Element textElement = (Element)textNode;
        OtherVideoRenderer.fillOtherCommonData(domService, textElement, otherJid, otherName, msg);
        String fileInfoStorageId = "otherMessageInfo_" + packetId;
        if (StringUtils.isNotBlank((CharSequence)extraInfo)) {
            Element elem_otherVideoWithMsgText = domService.getElementById("otherExtraText");
            elem_otherVideoWithMsgText.setAttribute("id", "otherExtraText_" + packetId);
            elem_otherVideoWithMsgText.setAttribute("packetId", packetId);
            elem_otherVideoWithMsgText.setAttribute("command", "selectAll");
            domService.addEventListener(elem_otherVideoWithMsgText, "dblclick");
            ChatTextWriter writer = new ChatTextWriter(domService, elem_otherVideoWithMsgText, packetId, searchKey, targetPacketId);
            MsgTextConverter.convertAndAppendText(extraInfo, writer);
        }
        Element elem_videoInfo = domService.getElementById("otherMessageInfo");
        elem_videoInfo.setAttribute("id", fileInfoStorageId);
        elem_videoInfo.setAttribute("packetId", packetId);
        elem_videoInfo.setAttribute("messageId", String.valueOf(msg.getId()));
        Element elem_videoIcon = domService.getElementById("otherMessageIcon");
        elem_videoIcon.setAttribute("id", "otherMessageIcon_" + packetId);
        elem_videoIcon.setAttribute("packetId", packetId);
        if (TextUtils.isNotBlank((CharSequence)imageBase64Content)) {
            BufferedImage bi = GraphicUtil.convertBase64StringToImage(imageBase64Content);
            if (bi != null) {
                int imageWidth = bi.getWidth();
                int imageHeight = bi.getHeight();
                bi = GraphicUtil.convertVideoThumbnailImage(bi, 300, 50);
                imageWidth = bi.getWidth();
                imageHeight = bi.getHeight();
                elem_videoIcon.setAttribute("width", String.valueOf(imageWidth));
                elem_videoIcon.setAttribute("height", String.valueOf(imageHeight));
                elem_videoIcon.setAttribute("src", "data:image/png;base64," + GraphicUtil.convertImageToBase64String(bi));
            } else {
                elem_videoIcon.setAttribute("width", String.valueOf(120));
                elem_videoIcon.setAttribute("height", String.valueOf(90));
                elem_videoIcon.setAttribute("src", MessageResource.fileMissingIconURI);
            }
        } else {
            elem_videoIcon.setAttribute("width", String.valueOf(120));
            elem_videoIcon.setAttribute("height", String.valueOf(90));
            elem_videoIcon.setAttribute("src", MessageResource.fileMissingIconURI);
        }
        elem_videoIcon.setAttribute("fileInfoStorageId", fileInfoStorageId);
        elem_videoIcon.setAttribute("command", "downloadVideo");
        elem_videoIcon.setAttribute("isFromMe", "false");
        domService.addEventListener(elem_videoIcon, "click");
        Element elem_videoDuration = domService.getElementById("otherVideoDuration");
        elem_videoDuration.setAttribute("id", "otherVideoDuration_" + packetId);
        elem_videoDuration.appendChild(domService.createTextNode(CommonUtil.getDurationMilliSeconds(videoDuration)));
    }
}

