/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.popup;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.chat.popup.EmoticonButton;
import com.blisscloud.ezuc.client.chat.popup.EmoticonPanel;
import com.blisscloud.ezuc.client.chat.popup.IdiomButton;
import com.blisscloud.ezuc.client.chat.popup.IdiomPanel;
import com.blisscloud.ezuc.client.chat.popup.MediaContentInputListener;
import com.blisscloud.ezuc.client.chat.popup.SymbolButton;
import com.blisscloud.ezuc.client.chat.popup.SymbolPanel;
import com.blisscloud.ezuc.client.component.UCScrollPane;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import java.awt.Dimension;
import java.util.List;
import javax.swing.Box;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;

public class EmoticonPopupMenu
extends JPopupMenu {
    private static final int PREFERRED_HEIGHT = 350;
    private static final int PREFERRED_WIDTH = 360;
    private static EmoticonPopupMenu popupEmoticon;
    private MediaContentInputListener mMediaContentInputListener = null;
    private BtnClickListener mBtnClickListener = null;

    public static EmoticonPopupMenu getInstance() {
        if (popupEmoticon == null) {
            popupEmoticon = new EmoticonPopupMenu();
        }
        return popupEmoticon;
    }

    public EmoticonPopupMenu() {
        this.setPreferredSize(new Dimension(360, 350));
        this.mBtnClickListener = new BtnClickListener(){

            @Override
            public void onEmoticonClick(String emoticonKey, String iconPath) {
                EmoticonPopupMenu.this.mMediaContentInputListener.onEmoticonClick(emoticonKey, iconPath);
            }

            @Override
            public void onIdiomClick(String text) {
                EmoticonPopupMenu.this.mMediaContentInputListener.onIdiomClick(text);
            }

            @Override
            public void onSymbolClick(String text) {
                EmoticonPopupMenu.this.mMediaContentInputListener.onSymbolClick(text);
            }
        };
        EmoticonPanel panelEmoticon = new EmoticonPanel(360);
        List<String> emoticonKeys = ChatRoomManager.getEmoticonKeys();
        for (String emoticonKey : emoticonKeys) {
            String emottionPath = ChatRoomManager.getEmoticonSmallPath(emoticonKey);
            panelEmoticon.add(new EmoticonButton(emoticonKey, emottionPath, this.mBtnClickListener));
        }
        IdiomPanel panelIdiom = new IdiomPanel();
        List<String> idiomKeys = ChatRoomManager.getIdiomKeys();
        for (String idiomKey : idiomKeys) {
            String idiomI18NKey = ChatRoomManager.getIdiom(idiomKey);
            String idiomText = I18NUtil.getString(idiomI18NKey);
            panelIdiom.add(new IdiomButton(idiomKey, idiomText, this.mBtnClickListener));
            panelIdiom.add(Box.createVerticalStrut(5));
        }
        SymbolPanel panelSymbol = new SymbolPanel(360);
        List<String> symbolKeys = ChatRoomManager.getSymbolKeys();
        for (String symbolKey : symbolKeys) {
            String symbolText = ChatRoomManager.getSymbol(symbolKey);
            panelSymbol.add(new SymbolButton(symbolKey, symbolText, this.mBtnClickListener));
        }
        JTabbedPane tb = new JTabbedPane(3);
        tb.addTab(null, UIConstants.ICON_EMOTICON_TAB, new UCScrollPane(panelEmoticon, 20, 31, 20));
        tb.addTab(null, UIConstants.ICON_IDIOM_TAB, new UCScrollPane(panelIdiom, 20, 31, 20));
        tb.addTab(null, UIConstants.ICON_TEXT_EMOTICON_TAB, new UCScrollPane(panelSymbol, 20, 31, 20));
        this.add(tb);
    }

    public void setMediaContentInputListener(MediaContentInputListener mediaContentInputListener) {
        this.mMediaContentInputListener = mediaContentInputListener;
    }

    public static interface BtnClickListener {
        public void onEmoticonClick(String var1, String var2);

        public void onIdiomClick(String var1);

        public void onSymbolClick(String var1);
    }
}

