/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.popup;

import com.blisscloud.ezuc.client.chat.popup.MediaContentInputListener;
import com.blisscloud.ezuc.client.chat.popup.StickerButton;
import com.blisscloud.ezuc.client.chat.popup.StickerPanel;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JPopupMenu;

public class StickerPopupMenu
extends JPopupMenu {
    private static final int PREFERRED_HEIGHT = 270;
    private static final int PREFERRED_WIDTH = 400;
    private static StickerPopupMenu popupSticker;
    private MediaContentInputListener mMediaContentInputListener = null;
    private BtnClickListener mBtnClickListener = null;

    public static StickerPopupMenu getInstance() {
        if (popupSticker == null) {
            popupSticker = new StickerPopupMenu();
        }
        return popupSticker;
    }

    public StickerPopupMenu() {
        this.setPreferredSize(new Dimension(400, 270));
        this.mBtnClickListener = new BtnClickListener(){

            @Override
            public void onClick(String stickerKey) {
                if (StickerPopupMenu.this.mMediaContentInputListener != null) {
                    StickerPopupMenu.this.mMediaContentInputListener.onStickerClick(stickerKey);
                }
            }
        };
        StickerPanel panelSticker = new StickerPanel(400);
        List<String> stickerKeys = ChatRoomManager.getStickerKeys();
        for (String stickerKey : stickerKeys) {
            String stickerPath = ChatRoomManager.getStickerPath(stickerKey);
            panelSticker.add(new StickerButton(stickerKey, stickerPath, this.mBtnClickListener));
        }
        this.add(panelSticker);
    }

    public void setMediaContentInputListener(MediaContentInputListener mediaContentInputListener) {
        this.mMediaContentInputListener = mediaContentInputListener;
    }

    public static interface BtnClickListener {
        public void onClick(String var1);
    }
}

