/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.roomimpl;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoomAuthType;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoomType;
import com.blisscloud.ezuc.bean.web.LiteConferenceUserStatus;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.addressbook.AddressBookGroup;
import com.blisscloud.ezuc.client.bean.SelectContactResult;
import com.blisscloud.ezuc.client.chat.ChatRoomItem;
import com.blisscloud.ezuc.client.chat.ChatRoomMember;
import com.blisscloud.ezuc.client.chat.ChatroomType;
import com.blisscloud.ezuc.client.chat.IChatroom;
import com.blisscloud.ezuc.client.chat.IMultiUserChatroom;
import com.blisscloud.ezuc.client.chat.MessageArea;
import com.blisscloud.ezuc.client.chat.MessageDropperField;
import com.blisscloud.ezuc.client.chat.MessageInput;
import com.blisscloud.ezuc.client.chat.popup.EmoticonPopupMenu;
import com.blisscloud.ezuc.client.chat.popup.MediaContentInputListener;
import com.blisscloud.ezuc.client.chat.popup.StickerPopupMenu;
import com.blisscloud.ezuc.client.chat.roomimpl.BaseChatroom;
import com.blisscloud.ezuc.client.chat.roomimpl.ChangeConferenceroomNamePanel;
import com.blisscloud.ezuc.client.chat.roomimpl.Chatroom;
import com.blisscloud.ezuc.client.chat.roomimpl.ListenerCleaner;
import com.blisscloud.ezuc.client.chat.roomimpl.ReferenceOut;
import com.blisscloud.ezuc.client.chat.roomimpl.WidgetPanel;
import com.blisscloud.ezuc.client.component.GradientPanel;
import com.blisscloud.ezuc.client.component.ImageLabel;
import com.blisscloud.ezuc.client.component.RoundedCornerLabel;
import com.blisscloud.ezuc.client.component.UCScrollPane;
import com.blisscloud.ezuc.client.main.MainPanel;
import com.blisscloud.ezuc.client.main.SelectMeetmeItemResult;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.sorter.ChatRoomMemberListSorter;
import com.blisscloud.ezuc.client.util.ChatRoomUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Bundle;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.CallLine;
import com.blisscloud.mobile.ezuc.agent.ChatActionUtil;
import com.blisscloud.mobile.ezuc.agent.ChatReceiver;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBContact;
import com.blisscloud.mobile.ezuc.db.UCDBExternalContact;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.db.UserDatabase;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.ConferenceHelper;
import com.blisscloud.mobile.ezuc.manager.ConferenceUtil;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import com.blisscloud.mobile.ezuc.manager.PhoneMatcher;
import com.blisscloud.mobile.ezuc.manager.PhoneMatcherResult;
import com.blisscloud.mobile.ezuc.screen.CaptureUtil;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.apache.commons.lang3.StringUtils;

public class ConferenceChatroom
extends BaseChatroom
implements IMultiUserChatroom,
ConferenceHelper.VerifyResult,
MessageDropperField {
    private static final long serialVersionUID = -7897443211895936381L;
    public static final String ACTION_NONE = "[none]";
    public static final String ACTION_PLUS = "[plus]";
    public static final String ACTION_LOCK = "[lock]";
    public static final String ACTION_ALLMUTE = "[allmute]";
    public static final String ACTION_MUTE = "[mute]";
    public static final String ACTION_MINUS = "[minus]";
    public static final String UNJOINED_DISPLAY_MODE = "unjoined_display_mode";
    public static final String COMMAND_SHOW_MEMBER = "showMember";
    public static final String COMMAND_EXIT_MEETME = "exitMeetme";
    private boolean mMuteSelection = false;
    private boolean mMinusSelection = false;
    private String mCurrentAction = "[none]";
    private ConfRoomLayoutMode layoutMode = ConfRoomLayoutMode.MEMBER;
    private UnjoinedDisplayMode unjoinedDisplayMode = UnjoinedDisplayMode.CHAT_HISTORY;
    private ChatMode chatMode = null;
    private JLabel disableReasonLabel;
    private CardLayout thisLayout = new CardLayout();
    private JPanel panelJoin;
    private JLabel lblPhoto_;
    private JLabel lblSubject_;
    private JLabel lblProcessing_;
    private JPanel joinPanel;
    private RoundedCornerLabel btnJoin_;
    private JPanel panelChat;
    private JPanel panelHeader;
    private JLabel lblPhoto;
    private JPanel panelTitle;
    private JLabel lblSubject;
    private JLabel headerChairman;
    private JLabel nbChairman;
    private JLabel headerMember;
    private JLabel lblMemberCount;
    private ImageLabel btnLayout;
    private ImageLabel btnConfig;
    private JPopupMenu popupMenuConfig;
    private JPanel jPanel5;
    private WidgetPanel panelControl;
    private ImageLabel btnAddMember;
    private ImageLabel btnRemoveMember;
    private ImageLabel btnLock;
    private ImageLabel btnMute;
    private ImageLabel btnMuteAll;
    private JScrollPane spParticipant;
    private WidgetPanel panelParticipant;
    private JScrollPane spMessage;
    private JPanel jToolBar1;
    private JPanel jPanel100;
    private JPanel spMessageOut;
    private ReferenceOut referenceMsgOut;
    private JLabel lblPadding;
    private JSeparator jSeparator0;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator3;
    private JSeparator jSeparator4;
    private ImageLabel btnSendFile;
    private ImageLabel btnScreenCapture;
    private ImageLabel btnSendSticker;
    private ImageLabel btnSendEmoticon;
    private ImageLabel btnCall;
    private ImageLabel btnHangup;
    private ImageLabel btnMuteSelf;
    private ImageLabel btnShowCallPage;
    private JPanel jPanelCall1;
    private JPanel mMenuPanel;
    private ImageLabel btnCall2;
    private ImageLabel btnHangup2;
    private ImageLabel btnMuteSelf2;
    private JSplitPane jSplitPane1 = null;
    private JSplitPane jSplitPane2 = null;
    private JPanel sendBtnPanel = null;
    private ShowMeetmeMsgAction showMeetmeAction = new ShowMeetmeMsgAction(true);
    private ChangeConferenceroomNameAction changeConfNameAction = new ChangeConferenceroomNameAction(true);
    private ExitMeetmeAction exitMeetmeAction = new ExitMeetmeAction(true);
    private EndMeetmeAction endMeetmeAction = new EndMeetmeAction(true);
    private MuteAllAction muteAllAction = new MuteAllAction(false);
    private LockAction lockAction = new LockAction(false);
    private long roomId;
    private LiteConferenceRoom meetmeRoom;
    private HashSet<String> meetmeRoomManagerJidSet = new HashSet();
    private boolean mAllmute = false;
    private boolean mLock = false;
    private List<ChatRoomItem> mParticipantsDataList = Collections.synchronizedList(new ArrayList());
    boolean loginUserIsadminFlag = false;
    private BroadcastReceiver receiver = null;
    private IntentFilter filter = null;
    private boolean showMuteMsg = false;
    private JButton sendButton = null;
    private String mQuotePackageId;
    private boolean manualSelectedLayout = false;
    private ConferenceHelper mConferenceHelper = null;

    public ConferenceChatroom(String roomJid, JPanel parent) {
        super(roomJid, parent);
        this.mMessageArea = new MessageArea(roomJid, false, this);
        this.initGUI();
        this.initReceiver();
        this.meetmeRoom = MeetmeManager.getMeetme((Context)UCChatClient.context, this.mRoomJid);
        if (this.meetmeRoom == null) {
            Log.e(ConferenceChatroom.class.getSimpleName(), "\u627e\u4e0d\u5230\u6703\u8b70\u5ba4! " + this.mRoomJid);
            this.updateRoom();
            this.refreshParticipants("Constructor", true);
            this.updateFavoriteAction(ChatRoomManager.isInMyFavorite(this.mRoomJid));
            UserDatabase database = UserDatabase.getDB(UCChatClient.context);
            boolean isEnabled = !database.isDisableNotification(this.mRoomJid);
            this.updateNotificationAction(isEnabled);
            this.updateMeetmeShowAction(PreferencesUtil.isMeetmeShowEnabled(UCChatClient.context, this.mRoomJid));
        } else {
            Log.i(ConferenceChatroom.class.getSimpleName(), "\u5efa\u7acb\u6703\u8b70\u5ba4\u756b\u9762 " + this.meetmeRoom.getName() + "(" + this.mRoomJid + ")");
            this.roomId = this.meetmeRoom.getRoomId();
            this.mLock = this.meetmeRoom.isLocked();
            this.mAllmute = this.meetmeRoom.isAllMute();
            WebAgent.getInstance().queryMeetMeListUser(this.meetmeRoom.getRoomId());
            this.initMeetmeRoomManagerJidData();
            this.initConfigPopup();
            this.updateRoom();
            this.refreshParticipants("Constructor", true);
            this.updateFavoriteAction(ChatRoomManager.isInMyFavorite(this.mRoomJid));
            UserDatabase database = UserDatabase.getDB(UCChatClient.context);
            boolean isEnabled = !database.isDisableNotification(this.mRoomJid);
            this.updateNotificationAction(isEnabled);
            this.updateMeetmeShowAction(PreferencesUtil.isMeetmeShowEnabled(UCChatClient.context, this.mRoomJid));
            this.updateMuteAllAction();
            this.updateLockAction();
            this.updateRemoveMemberAction();
        }
        this.invalidate();
        this.repaint();
    }

    @Override
    public ChatroomType getChatroomType() {
        return ChatroomType.CONFERENCE;
    }

    @Override
    public void updateRoom() {
        this.meetmeRoom = MeetmeManager.getMeetme((Context)UCChatClient.context, this.mRoomJid);
        if (this.meetmeRoom == null) {
            this.setLayoutMode(ConfRoomLayoutMode.NO_MEMBER);
            this.setChatMode(ChatMode.DELETE);
            this.lblPhoto.setCursor(UIConstants.CURSOR_DEFAULT);
            this.lblPhoto.setIcon(GraphicUtil.scale(UIConstants.ICON_CONFERENCEROOM_IDLE_64, 64, 64));
            this.btnLayout.setEnabled(false);
            ChatRoomInfo roomInfo = ChatRoomManager.getChatRoom(UCChatClient.context, this.mRoomJid);
            this.mRoomDisplayName = ChatRoomUtil.getConfRoomTitle(UCChatClient.context, roomInfo, null, true, true);
            this.lblSubject.setText(this.mRoomDisplayName);
            this.lblSubject_.setText(this.mRoomDisplayName);
        } else {
            boolean roomJoined = UCDBChatRoom.hasParticipants(UCChatClient.context, this.mRoomJid);
            if (roomJoined) {
                this.setDisplayPage(DisplayPage.CHAT);
            } else {
                this.setDisplayPage(this.unjoinedDisplayMode == UnjoinedDisplayMode.JOIN ? DisplayPage.JOIN : DisplayPage.CHAT);
                this.joinPanel.setVisible(ConferenceUtil.isShowJoinBtn(this.meetmeRoom));
            }
            if (this.meetmeRoom.getType() == LiteConferenceRoomType.STATIC) {
                ChatRoomInfo roomInfo = ChatRoomManager.getChatRoom(UCChatClient.context, this.mRoomJid);
                this.mRoomDisplayName = ChatRoomUtil.getConfRoomTitle(UCChatClient.context, roomInfo, this.meetmeRoom, true, true);
                this.lblSubject.setText(this.mRoomDisplayName);
                this.lblSubject_.setText(this.mRoomDisplayName);
                this.btnJoin_.setVisible(true);
                this.lblProcessing_.setVisible(false);
                if (roomJoined) {
                    this.setLayoutMode(ConfRoomLayoutMode.MEMBER);
                    boolean hasChatPermission = PreferencesUtil.hasChatActionPermission(UCChatClient.context);
                    if (hasChatPermission) {
                        this.setChatMode(ChatMode.NORMAL);
                    } else {
                        this.setChatMode(ChatMode.ONLY_PHONE);
                    }
                    this.lblPhoto.setCursor(UIConstants.CURSOR_HAND);
                    this.lblPhoto.setIcon(GraphicUtil.scale(UIConstants.ICON_CONFERENCEROOM_USING_64, 64, 64));
                    this.btnLayout.setEnabled(true);
                } else {
                    this.setLayoutMode(ConfRoomLayoutMode.NO_MEMBER);
                    this.setChatMode(ChatMode.DISABLED);
                    this.lblPhoto.setCursor(UIConstants.CURSOR_DEFAULT);
                    this.lblPhoto.setIcon(GraphicUtil.scale(UIConstants.ICON_CONFERENCEROOM_IDLE_64, 64, 64));
                    this.btnLayout.setEnabled(false);
                }
            } else {
                ChatRoomInfo roomInfo = ChatRoomManager.getChatRoom(UCChatClient.context, this.mRoomJid);
                this.mRoomDisplayName = ChatRoomUtil.getChatRoomTitle(UCChatClient.context, roomInfo);
                this.lblSubject.setText(this.mRoomDisplayName);
                this.lblPhoto.setIcon(GraphicUtil.scale(UIConstants.ICON_CHATROOM_64, 64, 64));
                this.btnJoin_.setVisible(true);
                this.lblProcessing_.setVisible(false);
                if (roomJoined) {
                    boolean hasChatPermission = PreferencesUtil.hasChatActionPermission(UCChatClient.context);
                    if (hasChatPermission) {
                        this.setChatMode(ChatMode.NORMAL);
                    } else {
                        this.setChatMode(ChatMode.ONLY_PHONE);
                    }
                } else {
                    this.setChatMode(ChatMode.DISABLED);
                }
            }
        }
    }

    public String getRoomJID() {
        return this.mRoomJid;
    }

    public ChatMode getChatMode() {
        return this.chatMode;
    }

    private void setDisplayPage(DisplayPage page) {
        this.thisLayout.show(this, page.name());
        this.revalidate();
        this.repaint();
    }

    public void setChatMode(ChatMode mode) {
        if (this.chatMode == mode) {
            return;
        }
        this.chatMode = mode;
        switch (this.chatMode) {
            case NORMAL: {
                this.disableReasonLabel.setVisible(false);
                this.disableReasonLabel.setText("");
                this.btnConfig.setEnabled(true);
                this.btnSendFile.setEnabled(true);
                this.btnScreenCapture.setEnabled(true);
                this.btnSendSticker.setEnabled(true);
                this.btnSendEmoticon.setEnabled(true);
                if (!this.txtMessage.isEnabled()) {
                    this.txtMessage.setText("");
                }
                this.txtMessage.setEnabled(true);
                this.btnCall2.setEnabled(false);
                this.btnCall2.setVisible(false);
                this.btnHangup2.setEnabled(false);
                this.btnHangup2.setVisible(false);
                this.btnMuteSelf2.setEnabled(false);
                this.btnMuteSelf2.setVisible(false);
                if (!this.jPanel100.isVisible()) {
                    this.btnCall.setEnabled(true);
                    this.btnCall.setVisible(true);
                    this.jPanelCall1.setVisible(true);
                    this.btnLayout.setVisible(true);
                    this.btnConfig.setVisible(true);
                    this.jToolBar1.setVisible(true);
                    this.spMessage.setVisible(true);
                    this.jPanel100.setVisible(true);
                    this.sendBtnPanel.setVisible(true);
                    if (this.panelHeader.getHeight() >= 0) {
                        int panelHeight = PreferencesUtil.getChatInputAreaHeight(UCChatClient.context);
                        int loc = this.mPanrent.getHeight() - this.panelHeader.getHeight() - panelHeight;
                        if (loc > 200 && panelHeight > 200) {
                            this.jSplitPane1.setDividerLocation(loc);
                        } else {
                            this.jSplitPane1.setDividerLocation(0.7);
                        }
                    }
                }
                this.onPhoneStatusChanged();
                break;
            }
            case ONLY_PHONE: {
                this.disableReasonLabel.setVisible(false);
                this.disableReasonLabel.setText("");
                this.btnConfig.setEnabled(true);
                this.btnSendFile.setEnabled(false);
                this.btnScreenCapture.setEnabled(false);
                this.btnSendSticker.setEnabled(false);
                this.btnSendEmoticon.setEnabled(false);
                this.txtMessage.setEnabled(false);
                this.txtMessage.setText("");
                this.btnCall2.setEnabled(true);
                this.btnCall2.setVisible(true);
                this.btnHangup2.setEnabled(false);
                this.btnHangup2.setVisible(false);
                this.btnMuteSelf2.setEnabled(false);
                this.btnMuteSelf2.setVisible(false);
                this.btnCall.setEnabled(false);
                this.btnCall.setVisible(false);
                this.jPanelCall1.setVisible(false);
                this.btnLayout.setVisible(true);
                this.btnConfig.setVisible(true);
                this.jToolBar1.setVisible(false);
                this.spMessage.setVisible(false);
                this.jPanel100.setVisible(false);
                this.sendBtnPanel.setVisible(false);
                this.onReferenceRemoved(null);
                this.onPhoneStatusChanged();
                break;
            }
            case DISABLED: {
                this.disableReasonLabel.setVisible(true);
                this.disableReasonLabel.setText("[" + I18NUtil.getString("chat_leave_conf_room_you_self") + "]");
                this.btnConfig.setEnabled(false);
                this.btnSendFile.setEnabled(false);
                this.btnScreenCapture.setEnabled(false);
                this.btnSendSticker.setEnabled(false);
                this.btnSendEmoticon.setEnabled(false);
                this.txtMessage.setEnabled(false);
                this.txtMessage.setText("");
                this.btnCall2.setEnabled(false);
                this.btnCall2.setVisible(false);
                this.btnHangup2.setEnabled(false);
                this.btnHangup2.setVisible(false);
                this.btnMuteSelf2.setEnabled(false);
                this.btnMuteSelf2.setVisible(false);
                this.btnCall.setEnabled(false);
                this.btnCall.setVisible(false);
                this.jPanelCall1.setVisible(false);
                this.btnLayout.setVisible(false);
                this.btnConfig.setVisible(false);
                this.jToolBar1.setVisible(false);
                this.spMessage.setVisible(false);
                this.jPanel100.setVisible(false);
                this.sendBtnPanel.setVisible(false);
                this.onReferenceRemoved(null);
                break;
            }
            case DELETE: {
                this.disableReasonLabel.setVisible(false);
                this.disableReasonLabel.setText("");
                this.btnConfig.setEnabled(false);
                this.btnSendFile.setEnabled(false);
                this.btnScreenCapture.setEnabled(false);
                this.btnSendSticker.setEnabled(false);
                this.btnSendEmoticon.setEnabled(false);
                this.txtMessage.setEnabled(false);
                this.txtMessage.setText("");
                this.btnCall2.setEnabled(false);
                this.btnCall2.setVisible(false);
                this.btnHangup2.setEnabled(false);
                this.btnHangup2.setVisible(false);
                this.btnMuteSelf2.setEnabled(false);
                this.btnMuteSelf2.setVisible(false);
                this.btnCall.setEnabled(false);
                this.btnCall.setVisible(false);
                this.jPanelCall1.setVisible(false);
                this.btnLayout.setVisible(false);
                this.btnConfig.setVisible(false);
                this.jToolBar1.setVisible(false);
                this.spMessage.setVisible(false);
                this.jPanel100.setVisible(false);
                this.sendBtnPanel.setVisible(false);
                this.onReferenceRemoved(null);
            }
        }
    }

    private void refreshManagers(String from) {
        Log.i(ConferenceChatroom.class.getSimpleName(), "refreshManagers ..........................action: " + from);
        this.headerChairman.setText(I18NUtil.getString("conference_label_chairman"));
        this.nbChairman.setText(this.getMeetmeMemberName());
    }

    private String getMeetmeMemberName() {
        LiteContact managerContact;
        String comma = I18NUtil.getString("comma");
        StringBuffer summary2Buffer = new StringBuffer();
        if (this.meetmeRoom.getChairmanIds() != null && this.meetmeRoom.getChairmanIds().size() > 0) {
            for (int k = 0; k < this.meetmeRoom.getChairmanIds().size(); ++k) {
                Long chairmanId;
                LiteContact managerContact2;
                if (k != 0) {
                    summary2Buffer.append(comma);
                }
                if ((managerContact2 = UCDBContact.getContactByEmpId(UCChatClient.context, chairmanId = this.meetmeRoom.getChairmanIds().get(k))) == null) continue;
                summary2Buffer.append(ContactManager.getContactShortName((Context)UCChatClient.context, managerContact2));
            }
        } else if (this.meetmeRoom.getManagerId() != null && (managerContact = UCDBContact.getContactByEmpId(UCChatClient.context, this.meetmeRoom.getManagerId())) != null) {
            summary2Buffer.append(ContactManager.getContactShortName((Context)UCChatClient.context, managerContact));
        }
        return summary2Buffer.toString();
    }

    private synchronized void refreshParticipants(String from, boolean syncData) {
        Log.i(ConferenceChatroom.class.getSimpleName(), "refreshParticipants ..........................action: " + from);
        Activity ctx = UCChatClient.context;
        boolean showRemoveButton = false;
        boolean showMuteButton = false;
        this.loginUserIsadminFlag = false;
        ArrayList<ChatRoomMember> itemList = new ArrayList<ChatRoomMember>();
        ArrayList<String> chatParticipants = UCDBChatRoom.findChatRoomParticipants((Context)ctx, this.mRoomJid);
        HashSet<Long> idSet = new HashSet<Long>();
        boolean isWholeCompany = PreferencesUtil.isAddressBookScopeWholeCompany(UCChatClient.context);
        Set<Long> scopeEmpSet = PreferencesUtil.getAddressBookScopeEmpList(UCChatClient.context);
        Set<Long> extraEmpSet = PreferencesUtil.getAddressBookExtraEmpList(UCChatClient.context);
        if (this.meetmeRoom != null) {
            this.mLock = this.meetmeRoom.isLocked();
            String role = ConferenceUtil.getRole(this.meetmeRoom, ctx, PreferencesUtil.getUserId(ctx));
            if ("admin".equals(role)) {
                this.loginUserIsadminFlag = true;
            }
            List<LiteConferenceUserStatus> meetmeUsers = MeetmeManager.getMeetmeUserList(ctx, this.meetmeRoom.getRoomId());
            boolean allmuteTemp = true;
            if (meetmeUsers != null) {
                for (LiteConferenceUserStatus meetmeUser : meetmeUsers) {
                    ChatRoomMember m = new ChatRoomMember();
                    m.setMeetmeOn(true);
                    m.setMeetmeUserNo(meetmeUser.getUserNo());
                    m.setMeetmeIsMute(meetmeUser.isMuted());
                    m.setAdmin(this.isRoomAdmin(this.meetmeRoom, meetmeUser));
                    String callerType = meetmeUser.getCallerType();
                    if ("EMPLOYEE".equals(callerType)) {
                        LiteContact contact;
                        String callerDBId;
                        String string = callerDBId = meetmeUser.getCallerDbId() == null ? null : meetmeUser.getCallerDbId().trim();
                        if (TextUtils.isBlank((CharSequence)callerDBId)) continue;
                        Long empId = Long.parseLong(meetmeUser.getCallerDbId());
                        if (!(isWholeCompany || scopeEmpSet.contains(empId) || extraEmpSet.contains(empId))) {
                            idSet.add(empId);
                        }
                        if ((contact = ContactManager.getContact((Context)ctx, empId)) != null) {
                            m.setTitle(ContactManager.getContactShortName((Context)ctx, contact));
                            m.setJid(contact.getJid());
                            m.setContact(contact);
                            boolean isLoginUser = PreferencesUtil.getUserId(ctx) != null && PreferencesUtil.getUserId(ctx).longValue() == empId.longValue();
                            chatParticipants.remove(contact.getJid());
                            if (isLoginUser && m.isAdmin()) {
                                this.loginUserIsadminFlag = true;
                            }
                        } else {
                            m.setTitle(meetmeUser.getCallerIdNumber());
                            m.setJid(meetmeUser.getCallerIdNumber() + "@phonenumber");
                        }
                    } else if ("LOCATION".equals(callerType)) {
                        String locationJid = ContactManager.getJidByLocId(ctx, meetmeUser.getCallerIdNumberSite(), meetmeUser.getCallerIdNumber());
                        LiteContact locContact = null;
                        if (locationJid != null) {
                            locContact = ContactManager.getContact((Context)ctx, locationJid);
                        }
                        if (locContact != null) {
                            m.setTitle(ContactManager.getContactFullName((Context)ctx, locContact, locationJid));
                            m.setJid(locContact.getJid());
                            m.setContact(locContact);
                        } else {
                            m.setTitle(meetmeUser.getCallerIdNumber());
                            m.setJid(meetmeUser.getCallerIdNumber() + "@phonenumber");
                        }
                    } else {
                        PhoneMatcherResult result = PhoneMatcher.match(ctx, meetmeUser.getCallerIdNumber(), true);
                        if (result != null) {
                            if (result.getMatchType() == 0 || result.getMatchType() == 4) {
                                boolean isLoginUser;
                                contact = result.getContact();
                                m.setTitle(ContactManager.getContactShortName((Context)ctx, contact));
                                m.setJid(contact.getJid());
                                m.setContact(contact);
                                boolean bl = isLoginUser = PreferencesUtil.getUserJid(ctx) != null && PreferencesUtil.getUserJid(ctx).equals(result.getTargetJid());
                                if (isLoginUser && m.isAdmin()) {
                                    this.loginUserIsadminFlag = true;
                                }
                                chatParticipants.remove(result.getTargetJid());
                            } else if (result.getMatchType() == 1) {
                                contact = result.getContact();
                                m.setTitle(ContactManager.getContactFullName(contact));
                                m.setJid(contact.getJid());
                                m.setContact(contact);
                            } else if (result.getMatchType() == 5) {
                                m.setTitle(result.getTargetName());
                                m.setJid(result.getTargetJid());
                            } else {
                                m.setTitle(meetmeUser.getCallerIdNumber());
                                m.setJid(meetmeUser.getCallerIdNumber() + "@phonenumber");
                            }
                        } else {
                            m.setTitle(meetmeUser.getCallerIdNumber());
                            m.setJid(meetmeUser.getCallerIdNumber() + "@phonenumber");
                        }
                    }
                    itemList.add(m);
                    if (m.isAdmin()) continue;
                    if (!meetmeUser.isMuted()) {
                        allmuteTemp = false;
                    }
                    showMuteButton = true;
                    showRemoveButton = true;
                }
            }
            boolean bl = this.mAllmute = meetmeUsers != null && meetmeUsers.size() != 0 && allmuteTemp;
        }
        if (chatParticipants != null) {
            for (String jid : chatParticipants) {
                boolean isLoginUser;
                LiteContact contact = ContactManager.getContact((Context)ctx, jid);
                if (contact == null) continue;
                ChatRoomMember m = new ChatRoomMember();
                if (JidUtil.isEmployeeJid(contact.getJid())) {
                    long empId = contact.getId();
                    if (!(isWholeCompany || scopeEmpSet.contains(empId) || extraEmpSet.contains(empId))) {
                        idSet.add(empId);
                    }
                    m.setTitle(ContactManager.getContactShortName((Context)ctx, contact));
                    m.setJid(contact.getJid());
                    m.setContact(contact);
                    m.setMeetmeOn(false);
                    m.setAdmin(this.isRoomAdmin(jid, this.meetmeRoomManagerJidSet));
                } else {
                    m.setTitle(ContactManager.getContactFullName(contact));
                    m.setJid(contact.getJid());
                    m.setContact(contact);
                    m.setMeetmeOn(false);
                    m.setAdmin(this.isRoomAdmin(jid, this.meetmeRoomManagerJidSet));
                }
                itemList.add(m);
                boolean bl = isLoginUser = PreferencesUtil.getUserJid(ctx) != null && PreferencesUtil.getUserJid(ctx).equals(jid);
                if (isLoginUser && m.isAdmin()) {
                    this.loginUserIsadminFlag = true;
                }
                if (m.isAdmin()) continue;
                showRemoveButton = true;
            }
        }
        for (ChatRoomMember m : itemList) {
            if (this.mCurrentAction.equals(ACTION_MINUS) && this.mMinusSelection) {
                if (m.isAdmin()) {
                    m.setKickFlag(false);
                } else {
                    m.setKickFlag(true);
                    m.setActionResId(100);
                }
            }
            if (!this.mCurrentAction.equals(ACTION_MUTE) || !this.mMuteSelection) continue;
            if (m.isAdmin()) {
                m.setMuteFlag(false);
                continue;
            }
            if (!m.isMeetmeOn()) continue;
            if (m.isMeetmeIsMute()) {
                m.setActionResId(200);
                m.setMuteFlag(true);
                continue;
            }
            m.setActionResId(300);
            m.setMuteFlag(false);
        }
        if (this.meetmeRoom != null && this.meetmeRoom.getType() != LiteConferenceRoomType.STATIC) {
            this.loginUserIsadminFlag = false;
        }
        if (idSet.size() > 0) {
            long timestamp = UCDBChatRoom.getMemberTimestamp(ctx, this.mRoomJid);
            if (syncData || System.currentTimeMillis() - timestamp > 600000L) {
                WebAgent.getInstance().refreshChatRoomMemberListByIds(this.mRoomJid, timestamp, idSet);
            }
        }
        Collections.sort(itemList, new ChatRoomMemberListSorter());
        this.mParticipantsDataList.clear();
        this.mParticipantsDataList.addAll(itemList);
        final boolean _showRemoveButton = showRemoveButton;
        final boolean _showMuteButton = showMuteButton;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ConferenceChatroom.this.loginUserIsadminFlag) {
                    ConferenceChatroom.this.btnAddMember.setVisible(true);
                    ConferenceChatroom.this.btnRemoveMember.setVisible(_showRemoveButton);
                    ConferenceChatroom.this.btnMute.setVisible(_showMuteButton);
                    ConferenceChatroom.this.btnMuteAll.setVisible(_showMuteButton);
                    ConferenceChatroom.this.btnLock.setVisible(true);
                    ConferenceChatroom.this.panelControl.setVisible(true);
                } else {
                    ConferenceChatroom.this.btnAddMember.setVisible(!ConferenceChatroom.this.mLock);
                    ConferenceChatroom.this.btnRemoveMember.setVisible(false);
                    ConferenceChatroom.this.btnMute.setVisible(false);
                    ConferenceChatroom.this.btnMuteAll.setVisible(false);
                    ConferenceChatroom.this.btnLock.setVisible(false);
                    ConferenceChatroom.this.panelControl.setVisible(!ConferenceChatroom.this.mLock);
                }
                ConferenceChatroom.this.panelControl.revalidate();
                ConferenceChatroom.this.panelControl.repaint();
                ConferenceChatroom.this.cleanPanelParticipant();
                ConferenceChatroom.this.refreshSelectionList();
                for (ChatRoomItem item : ConferenceChatroom.this.mParticipantsDataList) {
                    if (!(item instanceof ChatRoomMember)) continue;
                    ConferenceChatroom.this.addParticipantItem((ChatRoomMember)item);
                }
                ConferenceChatroom.this.updateRemoveMemberAction();
                ConferenceChatroom.this.lblMemberCount.setText(String.format(I18NUtil.getString("chat_label_participant_count"), ConferenceChatroom.this.mParticipantsDataList.size()));
                boolean inChatroom = ConferenceChatroom.this.isInRoom(ConferenceChatroom.this.mParticipantsDataList, ConferenceChatroom.this.myJid);
                if (ConferenceChatroom.this.chatMode == ChatMode.DISABLED && inChatroom) {
                    boolean hasChatPermission = PreferencesUtil.hasChatActionPermission(UCChatClient.context);
                    if (hasChatPermission) {
                        ConferenceChatroom.this.setChatMode(ChatMode.NORMAL);
                    } else {
                        ConferenceChatroom.this.setChatMode(ChatMode.ONLY_PHONE);
                    }
                } else if (ConferenceChatroom.this.chatMode == ChatMode.NORMAL && !inChatroom) {
                    ConferenceChatroom.this.setChatMode(ChatMode.DISABLED);
                } else if (ConferenceChatroom.this.chatMode == ChatMode.ONLY_PHONE && !inChatroom) {
                    ConferenceChatroom.this.setChatMode(ChatMode.DISABLED);
                }
            }
        });
    }

    private boolean isInRoom(List<ChatRoomItem> itemList, String myJid) {
        for (ChatRoomItem x : itemList) {
            ChatRoomMember m;
            if (!(x instanceof ChatRoomMember) || !myJid.equalsIgnoreCase((m = (ChatRoomMember)x).getJid())) continue;
            return true;
        }
        return false;
    }

    private void updateRemoveMemberAction() {
        boolean hasParticipant = this.mParticipantsDataList.size() > 0;
        this.btnRemoveMember.setEnabled(hasParticipant);
    }

    @Override
    public void updateMyChatRoomAction(boolean isMyChatRoom) {
    }

    public void updateMeetmeShowAction(boolean meetmeShow) {
        if (this.showMeetmeAction == null) {
            return;
        }
        if (meetmeShow) {
            if (this.showMeetmeAction.showText) {
                this.showMeetmeAction.putValue("Name", I18NUtil.getString("conference_btn_hide_voice_action"));
            } else {
                this.showMeetmeAction.putValue("ShortDescription", I18NUtil.getString("conference_btn_hide_voice_action"));
            }
        } else if (this.showMeetmeAction.showText) {
            this.showMeetmeAction.putValue("Name", I18NUtil.getString("conference_btn_display_voice_action"));
        } else {
            this.showMeetmeAction.putValue("ShortDescription", I18NUtil.getString("conference_btn_display_voice_action"));
        }
    }

    private void updateMuteAllAction() {
        if (this.mAllmute) {
            this.btnMuteAll.setIcon(ICON_UNMUTE_ALL);
            this.btnMuteAll.setToolTipText(I18NUtil.getString("conference_action_label_allunmute"));
            if (this.muteAllAction.showText) {
                this.muteAllAction.putValue("Name", I18NUtil.getString("conference_action_label_allunmute"));
            } else {
                this.muteAllAction.putValue("ShortDescription", I18NUtil.getString("conference_action_label_allunmute"));
                this.muteAllAction.putValue("SmallIcon", ICON_UNMUTE_ALL);
            }
        } else {
            this.btnMuteAll.setIcon(ICON_MUTE_ALL);
            this.btnMuteAll.setToolTipText(I18NUtil.getString("conference_action_label_allmute"));
            if (this.muteAllAction.showText) {
                this.muteAllAction.putValue("Name", I18NUtil.getString("conference_action_label_allmute"));
            } else {
                this.muteAllAction.putValue("ShortDescription", I18NUtil.getString("conference_action_label_allmute"));
                this.muteAllAction.putValue("SmallIcon", ICON_MUTE_ALL);
            }
        }
    }

    private void updateLockAction() {
        if (this.mLock) {
            this.btnLock.setIcon(ICON_UNLOCK);
            this.btnLock.setToolTipText(I18NUtil.getString("conference_action_label_cancellock"));
            if (this.lockAction.showText) {
                this.lockAction.putValue("Name", I18NUtil.getString("conference_action_label_cancellock"));
            } else {
                this.lockAction.putValue("ShortDescription", I18NUtil.getString("conference_action_label_cancellock"));
                this.lockAction.putValue("SmallIcon", ICON_UNLOCK);
            }
        } else {
            this.btnLock.setIcon(ICON_LOCK);
            this.btnLock.setToolTipText(I18NUtil.getString("conference_action_label_lock"));
            if (this.lockAction.showText) {
                this.lockAction.putValue("Name", I18NUtil.getString("conference_action_label_lock"));
            } else {
                this.lockAction.putValue("ShortDescription", I18NUtil.getString("conference_action_label_lock"));
                this.lockAction.putValue("SmallIcon", ICON_LOCK);
            }
        }
    }

    private void initGUI() {
        try {
            this.setLayout(this.thisLayout);
            this.setPreferredSize(new Dimension(640, 480));
            this.setMinimumSize(new Dimension(520, 300));
            this.panelJoin = new JPanel();
            this.add((Component)this.panelJoin, DisplayPage.JOIN.name());
            GridBagLayout panelJoinLayout = new GridBagLayout();
            this.panelJoin.setLayout(panelJoinLayout);
            this.panelJoin.setBackground(UIConstants.COLOR_DIALOG_BACKGROUND);
            this.lblPhoto_ = new JLabel();
            this.panelJoin.add((Component)this.lblPhoto_, new GridBagConstraints(0, 1, 1, 2, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblPhoto_.setIcon(UIConstants.ICON_CONFERENCEROOM_IDLE_64);
            this.lblPhoto_.setPreferredSize(new Dimension(64, 64));
            this.lblPhoto_.setMinimumSize(new Dimension(64, 64));
            this.lblPhoto_.setMaximumSize(new Dimension(64, 64));
            this.lblSubject_ = new JLabel();
            this.panelJoin.add((Component)this.lblSubject_, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(8, 15, 0, 0), 0, 0));
            this.lblSubject_.setFont(UIConstants.FONT_14_PLAIN);
            this.lblSubject_.setText("Room Subject");
            this.joinPanel = new JPanel();
            BoxLayout jPanel4Layout = new BoxLayout(this.joinPanel, 0);
            this.joinPanel.setLayout(jPanel4Layout);
            this.panelJoin.add((Component)this.joinPanel, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.joinPanel.setOpaque(false);
            this.joinPanel.setBorder(BorderFactory.createEmptyBorder(60, 0, 0, 0));
            this.btnJoin_ = new RoundedCornerLabel(I18NUtil.getString("conference_btn_join"), null, UIConstants.BACKGROUND_UNJOINED_NORMAL, UIConstants.BACKGROUND_UNJOINED_OVER, UIConstants.BACKGROUND_UNJOINED_PRESSED);
            this.joinPanel.add(this.btnJoin_);
            this.btnJoin_.setArc(36);
            this.btnJoin_.setForeground(Color.WHITE);
            this.btnJoin_.setFont(UIConstants.FONT_14_BOLD);
            this.btnJoin_.setCursor(UIConstants.CURSOR_HAND);
            this.btnJoin_.setBorder(BorderFactory.createEmptyBorder(8, 20, 10, 20));
            this.btnJoin_.setAlignmentY(1.0f);
            this.btnJoin_.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    ConferenceChatroom.this.btnJoin_MouseClicked(evt);
                }
            });
            this.lblProcessing_ = new JLabel();
            this.joinPanel.add(this.lblProcessing_);
            this.lblProcessing_.setForeground(UIConstants.BACKGROUND_UNJOINED_NORMAL);
            this.lblProcessing_.setText(I18NUtil.getString("conference_notice_join_processing"));
            this.lblProcessing_.setIcon(UIConstants.ICON_LOADING24);
            this.lblProcessing_.setFont(UIConstants.FONT_14_BOLD);
            this.lblProcessing_.setAlignmentY(1.0f);
            this.lblProcessing_.setIconTextGap(20);
            this.lblProcessing_.setHorizontalTextPosition(0);
            this.lblProcessing_.setVerticalTextPosition(3);
            this.lblProcessing_.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            this.lblProcessing_.setVisible(false);
            this.panelChat = new JPanel();
            this.add((Component)this.panelChat, DisplayPage.CHAT.name());
            GridBagLayout panelChatLayout = new GridBagLayout();
            this.panelChat.setLayout(panelChatLayout);
            this.panelHeader = new GradientPanel(1, UIConstants.COLOR_HEADER_BACKGROUND_FROM, UIConstants.COLOR_HEADER_BACKGROUND_TO);
            this.panelChat.add((Component)this.panelHeader, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout jPanel1Layout = new GridBagLayout();
            this.panelHeader.setLayout(jPanel1Layout);
            this.panelHeader.setBorder(UIConstants.BORDER_HEADER);
            this.lblPhoto = new JLabel();
            this.panelHeader.add((Component)this.lblPhoto, new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblPhoto.setIcon(GraphicUtil.scale(UIConstants.ICON_CONFERENCEROOM_IDLE_64, 64, 64));
            this.lblPhoto.setPreferredSize(new Dimension(64, 64));
            this.lblPhoto.setMinimumSize(new Dimension(64, 64));
            this.lblPhoto.setMaximumSize(new Dimension(64, 64));
            this.lblPhoto.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    ConferenceChatroom.this.lblPhotoMousePressed(evt);
                }
            });
            this.panelTitle = new JPanel();
            this.panelHeader.add((Component)this.panelTitle, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 17, 2, new Insets(4, 12, 0, 0), 0, 0));
            BoxLayout panelTitleLayout = new BoxLayout(this.panelTitle, 0);
            this.panelTitle.setLayout(panelTitleLayout);
            this.panelTitle.setOpaque(false);
            this.lblSubject = new JLabel();
            this.panelTitle.add(this.lblSubject);
            this.lblSubject.setFont(UIConstants.FONT_14_BOLD);
            this.mRoomDisplayName = " ";
            this.lblSubject.setText(this.mRoomDisplayName);
            this.panelTitle.add(Box.createHorizontalStrut(5));
            this.headerChairman = new JLabel();
            this.panelHeader.add((Component)this.headerChairman, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 12, 0, 0), 0, 0));
            this.headerChairman.setText(I18NUtil.getString("conference_label_chairman"));
            this.headerChairman.setForeground(UIConstants.COLOR_LIGHT_GRAY);
            this.nbChairman = new JLabel();
            this.panelHeader.add((Component)this.nbChairman, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 1, new Insets(4, 8, 0, 0), 0, 0));
            this.headerMember = new JLabel();
            this.panelHeader.add((Component)this.headerMember, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 12, 0, 0), 0, 0));
            this.headerMember.setText(I18NUtil.getString("chatroom_label_participants") + " : ");
            this.headerMember.setForeground(UIConstants.COLOR_LIGHT_GRAY);
            this.lblMemberCount = new JLabel();
            this.panelHeader.add((Component)this.lblMemberCount, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(4, 8, 0, 0), 0, 0));
            this.lblMemberCount.setText(String.format(I18NUtil.getString("chat_label_participant_count"), 0));
            this.mMenuPanel = new JPanel();
            this.mMenuPanel.setOpaque(false);
            FlowLayout panelEndcallLayout = new FlowLayout();
            panelEndcallLayout.setAlignment(0);
            panelEndcallLayout.setVgap(0);
            panelEndcallLayout.setHgap(5);
            this.mMenuPanel.setLayout(panelEndcallLayout);
            this.panelHeader.add((Component)this.mMenuPanel, new GridBagConstraints(3, 0, 1, 3, 0.0, 0.0, 12, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.btnCall2 = new ImageLabel((Icon)UIConstants.ICON_VOICE_CALL_SMALL, I18NUtil.getString("abook_popup_btn_talk"));
            this.mMenuPanel.add(this.btnCall2);
            this.btnCall2.setPreferredSize(new Dimension(this.btnCall2.calculatePreferWidth(), 32));
            this.btnCall2.setHorizontalAlignment(0);
            this.btnCall2.setBorder(UIConstants.BORDER_CONFIG_BUTTON);
            this.btnCall2.setCursor(UIConstants.CURSOR_HAND);
            this.btnCall2.setArc(12);
            this.btnCall2.setVisible(false);
            this.btnCall2.setEnabled(false);
            this.btnCall2.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (ConferenceChatroom.this.btnCall2.isEnabled()) {
                        Log.i(Chatroom.class.getSimpleName(), "room start dial:" + ConferenceChatroom.this.mRoomJid);
                        ChatRoomManager.startDialOut(ConferenceChatroom.this.btnCall2, ConferenceChatroom.this.mRoomJid);
                    }
                }
            });
            this.btnHangup2 = new ImageLabel((Icon)UIConstants.ICON_VOICE_END_SMALL, I18NUtil.getString("call_btn_hangup"));
            this.mMenuPanel.add(this.btnHangup2);
            this.btnHangup2.setPreferredSize(new Dimension(this.btnHangup2.calculatePreferWidth(), 32));
            this.btnHangup2.setHorizontalAlignment(0);
            this.btnHangup2.setBorder(UIConstants.BORDER_CONFIG_BUTTON);
            this.btnHangup2.setCursor(UIConstants.CURSOR_HAND);
            this.btnHangup2.setArc(12);
            this.btnHangup2.setVisible(false);
            this.btnHangup2.setEnabled(false);
            this.btnHangup2.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (ConferenceChatroom.this.btnHangup2.isEnabled()) {
                        PhoneAgent.getInstance().hangupMeetme(ConferenceChatroom.this.mRoomJid);
                    }
                }
            });
            this.btnMuteSelf2 = new ImageLabel((Icon)UIConstants.ICON_CHAT_MIC_SMALL, I18NUtil.getString("call_btn_click_mute"));
            this.mMenuPanel.add(this.btnMuteSelf2);
            this.btnMuteSelf2.setPreferredSize(new Dimension(this.btnMuteSelf2.calculatePreferWidth(), 32));
            this.btnMuteSelf2.setHorizontalAlignment(0);
            this.btnMuteSelf2.setBorder(UIConstants.BORDER_CONFIG_BUTTON);
            this.btnMuteSelf2.setCursor(UIConstants.CURSOR_HAND);
            this.btnMuteSelf2.setArc(12);
            this.btnMuteSelf2.setVisible(false);
            this.btnMuteSelf2.setEnabled(false);
            this.btnMuteSelf2.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    ConferenceChatroom.this.onClickMuteButton();
                }
            });
            this.btnLayout = new ImageLabel(ConfRoomLayoutMode.NO_MEMBER.getIcon());
            this.mMenuPanel.add(this.btnLayout);
            this.btnLayout.setToolTipText(ConfRoomLayoutMode.MEMBER.getToolTip());
            this.btnLayout.setPreferredSize(new Dimension(40, 32));
            this.btnLayout.setMinimumSize(new Dimension(40, 32));
            this.btnLayout.setMaximumSize(new Dimension(40, 32));
            this.btnLayout.setHorizontalAlignment(0);
            this.btnLayout.setBorder(UIConstants.BORDER_CONFIG_BUTTON);
            this.btnLayout.setCursor(UIConstants.CURSOR_HAND);
            this.btnLayout.setArc(12);
            this.btnLayout.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    if (ConferenceChatroom.this.btnLayout.isEnabled()) {
                        ConferenceChatroom.this.switchLayout();
                    }
                }
            });
            this.btnConfig = new ImageLabel(UIConstants.ICON_MENU);
            this.mMenuPanel.add(this.btnConfig);
            this.btnConfig.setToolTipText(I18NUtil.getString("common_btn_config"));
            this.btnConfig.setPreferredSize(new Dimension(32, 32));
            this.btnConfig.setMinimumSize(new Dimension(32, 32));
            this.btnConfig.setMaximumSize(new Dimension(32, 32));
            this.btnConfig.setHorizontalAlignment(0);
            this.btnConfig.setBorder(UIConstants.BORDER_CONFIG_BUTTON);
            this.btnConfig.setCursor(UIConstants.CURSOR_HAND);
            this.btnConfig.setArc(12);
            this.popupMenuConfig = new JPopupMenu();
            this.setComponentPopupMenu(this.btnConfig, this.popupMenuConfig);
            this.disableReasonLabel = new JLabel();
            this.disableReasonLabel.setFont(UIConstants.FONT_16_PLAIN);
            this.disableReasonLabel.setText("");
            this.disableReasonLabel.setVisible(false);
            this.panelHeader.add((Component)this.disableReasonLabel, new GridBagConstraints(0, 3, 4, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panelHeader.add((Component)this.getSearchControlPanel(), new GridBagConstraints(0, 4, 4, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jSplitPane2 = new JSplitPane(1);
            this.jSplitPane2.setResizeWeight(1.0);
            this.jSplitPane2.setBorder(BorderFactory.createEmptyBorder());
            this.panelChat.add((Component)this.jSplitPane2, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jSplitPane1 = new JSplitPane(0);
            this.jSplitPane1.setResizeWeight(1.0);
            this.jSplitPane1.setBorder(BorderFactory.createEmptyBorder());
            this.jSplitPane2.add((Component)this.jSplitPane1, "left");
            this.jSplitPane1.add((Component)this.getMessageLayerPanel(), "top");
            this.jPanel100 = new JPanel();
            BorderLayout jPanel100Layout = new BorderLayout();
            this.jPanel100.setLayout(jPanel100Layout);
            this.jSplitPane1.add((Component)this.jPanel100, "bottom");
            this.spMessageOut = new JPanel();
            this.spMessageOut.setLayout(new BorderLayout());
            this.jPanel100.add((Component)this.spMessageOut, "Center");
            this.jToolBar1 = new JPanel();
            this.jPanel100.add((Component)this.jToolBar1, "North");
            GridBagLayout jToolBar1Layout = new GridBagLayout();
            this.jToolBar1.setLayout(jToolBar1Layout);
            this.jToolBar1.setBorder(UIConstants.BORDER_MESSAGE_TOOLBAR);
            int x = 0;
            boolean hasFilePermission = PreferencesUtil.hasChatFileActionPermission(UCChatClient.context);
            boolean hasPhotoPermission = PreferencesUtil.hasChatPhotoActionPermission(UCChatClient.context);
            this.btnSendFile = new ImageLabel((Icon)UIConstants.ICON_FILE, I18NUtil.getString("chat_btn_send_file"));
            this.jToolBar1.add((Component)this.btnSendFile, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.btnSendFile.setFont(UIConstants.FONT_14_PLAIN);
            this.btnSendFile.setBorder(Chatroom.BORDER_BTN_MESSAGE);
            this.btnSendFile.setNormalBorderColor(null);
            this.btnSendFile.setCursor(UIConstants.CURSOR_HAND);
            this.btnSendFile.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (ConferenceChatroom.this.btnSendFile.isEnabled()) {
                        ConferenceChatroom.this.btnSendFileMouseClicked(evt);
                    }
                }
            });
            this.btnSendFile.setVisible(hasFilePermission);
            this.jSeparator0 = new JSeparator();
            this.jToolBar1.add((Component)this.jSeparator0, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.jSeparator0.setPreferredSize(new Dimension(2, 20));
            this.jSeparator0.setOrientation(1);
            this.jSeparator0.setVisible(hasFilePermission);
            this.btnScreenCapture = new ImageLabel((Icon)UIConstants.ICON_SCREEN_CAPTURE, I18NUtil.getString("chat_btn_screen_capture"));
            this.jToolBar1.add((Component)this.btnScreenCapture, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.btnScreenCapture.setFont(UIConstants.FONT_14_PLAIN);
            this.btnScreenCapture.setBorder(Chatroom.BORDER_BTN_MESSAGE);
            this.btnScreenCapture.setNormalBorderColor(null);
            this.btnScreenCapture.setCursor(UIConstants.CURSOR_HAND);
            this.btnScreenCapture.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (ConferenceChatroom.this.btnScreenCapture.isEnabled()) {
                        ConferenceChatroom.this.btnScreenCaptureMouseClicked(evt);
                    }
                }
            });
            this.btnScreenCapture.setVisible(hasPhotoPermission);
            this.jSeparator1 = new JSeparator();
            this.jToolBar1.add((Component)this.jSeparator1, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.jSeparator1.setPreferredSize(new Dimension(2, 20));
            this.jSeparator1.setOrientation(1);
            this.jSeparator1.setVisible(hasPhotoPermission);
            this.btnSendSticker = new ImageLabel((Icon)UIConstants.ICON_STICKER, I18NUtil.getString("chat_msg_type_sticker"));
            this.jToolBar1.add((Component)this.btnSendSticker, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnSendSticker.setFont(UIConstants.FONT_14_PLAIN);
            this.btnSendSticker.setBorder(Chatroom.BORDER_BTN_MESSAGE);
            this.btnSendSticker.setNormalBorderColor(null);
            this.btnSendSticker.setCursor(UIConstants.CURSOR_HAND);
            this.btnSendSticker.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (ConferenceChatroom.this.btnSendSticker.isEnabled()) {
                        ConferenceChatroom.this.btnSendStickerMouseClicked(evt);
                    }
                }
            });
            this.jSeparator2 = new JSeparator();
            this.jToolBar1.add((Component)this.jSeparator2, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.jSeparator2.setPreferredSize(new Dimension(2, 20));
            this.jSeparator2.setOrientation(1);
            this.btnSendEmoticon = new ImageLabel((Icon)UIConstants.ICON_EMOTICON, I18NUtil.getString("chat_msg_type_emoticon"));
            this.jToolBar1.add((Component)this.btnSendEmoticon, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnSendEmoticon.setFont(UIConstants.FONT_14_PLAIN);
            this.btnSendEmoticon.setBorder(Chatroom.BORDER_BTN_MESSAGE);
            this.btnSendEmoticon.setNormalBorderColor(null);
            this.btnSendEmoticon.setCursor(UIConstants.CURSOR_HAND);
            this.btnSendEmoticon.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (ConferenceChatroom.this.btnSendEmoticon.isEnabled()) {
                        ConferenceChatroom.this.btnSendEmoticonMouseClicked(evt);
                    }
                }
            });
            this.lblPadding = new JLabel();
            this.jToolBar1.add((Component)this.lblPadding, new GridBagConstraints(x++, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.btnCall = new ImageLabel((Icon)UIConstants.ICON_VOICE_CHAT, I18NUtil.getString("abook_popup_btn_talk"));
            this.jToolBar1.add((Component)this.btnCall, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnCall.setFont(UIConstants.FONT_14_PLAIN);
            this.btnCall.setBorder(Chatroom.BORDER_BTN_MESSAGE);
            this.btnCall.setNormalBorderColor(null);
            this.btnCall.setCursor(UIConstants.CURSOR_HAND);
            this.btnCall.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (ConferenceChatroom.this.btnCall.isEnabled()) {
                        Log.i(ConferenceChatroom.class.getSimpleName(), "conf start dial:" + ConferenceChatroom.this.mRoomJid);
                        ChatRoomManager.startDialOut(ConferenceChatroom.this.btnCall, ConferenceChatroom.this.mRoomJid);
                    }
                }
            });
            this.jPanelCall1 = new JPanel();
            FlowLayout panelEndcallLayout2 = new FlowLayout();
            panelEndcallLayout2.setAlignment(0);
            panelEndcallLayout2.setVgap(0);
            this.jPanelCall1.setLayout(panelEndcallLayout2);
            this.jToolBar1.add((Component)this.jPanelCall1, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnHangup = new ImageLabel(UIConstants.ICON_VOICE_END);
            this.jPanelCall1.add(this.btnHangup);
            this.btnHangup.setToolTipText(I18NUtil.getString("call_btn_hangup"));
            this.btnHangup.setFont(UIConstants.FONT_14_PLAIN);
            this.btnHangup.setBorder(Chatroom.BORDER_BTN_MESSAGE);
            this.btnHangup.setNormalBorderColor(null);
            this.btnHangup.setCursor(UIConstants.CURSOR_HAND);
            this.btnHangup.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    int result;
                    if (ConferenceChatroom.this.btnHangup.isEnabled() && (result = JOptionPane.showConfirmDialog(ConferenceChatroom.this, I18NUtil.getString("call_title_meetme_hangup_confirm"), I18NUtil.getString("common_title_warning"), 2, 2)) == 0) {
                        PhoneAgent.getInstance().hangupMeetme(ConferenceChatroom.this.mRoomJid);
                    }
                }
            });
            this.jSeparator3 = new JSeparator();
            this.jPanelCall1.add(this.jSeparator3);
            this.jSeparator3.setPreferredSize(new Dimension(2, 20));
            this.jSeparator3.setOrientation(1);
            this.btnMuteSelf = new ImageLabel(UIConstants.ICON_CHAT_MIC);
            this.jPanelCall1.add(this.btnMuteSelf);
            this.btnMuteSelf.setToolTipText(I18NUtil.getString("call_btn_click_mute"));
            this.btnMuteSelf.setFont(UIConstants.FONT_14_PLAIN);
            this.btnMuteSelf.setBorder(Chatroom.BORDER_BTN_MESSAGE);
            this.btnMuteSelf.setNormalBorderColor(null);
            this.btnMuteSelf.setCursor(UIConstants.CURSOR_HAND);
            this.btnMuteSelf.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    ConferenceChatroom.this.onClickMuteButton();
                }
            });
            this.jSeparator4 = new JSeparator();
            this.jPanelCall1.add(this.jSeparator4);
            this.jSeparator4.setPreferredSize(new Dimension(2, 20));
            this.jSeparator4.setOrientation(1);
            this.btnShowCallPage = new ImageLabel(UIConstants.ICON_SHOW_CALL_PAGE);
            this.jPanelCall1.add(this.btnShowCallPage);
            this.btnShowCallPage.setToolTipText(I18NUtil.getString("chatroom_btn_switch_to_call_view"));
            this.btnShowCallPage.setFont(UIConstants.FONT_14_PLAIN);
            this.btnShowCallPage.setBorder(Chatroom.BORDER_BTN_MESSAGE);
            this.btnShowCallPage.setNormalBorderColor(null);
            this.btnShowCallPage.setCursor(UIConstants.CURSOR_HAND);
            this.btnShowCallPage.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (ConferenceChatroom.this.btnShowCallPage.isEnabled()) {
                        UCChatClient.getInstance().getMainPanel().getViewContainer().showPhonePanel(ConferenceChatroom.this.mRoomJid);
                    }
                }
            });
            this.spMessage = new UCScrollPane();
            this.spMessageOut.add((Component)this.spMessage, "Center");
            this.spMessage.setPreferredSize(new Dimension(300, 130));
            this.txtMessage = new MessageInput(new MessageInput.MessageInputCallback(){

                @Override
                public void onSendMessage(String text) {
                    if (TextUtils.isNotBlank((CharSequence)text)) {
                        ArrayList<ChatReceiver> chatReceiverList = new ArrayList<ChatReceiver>();
                        chatReceiverList.add(new ChatReceiver(ConferenceChatroom.this.mRoomJid));
                        if (ChatActionUtil.sendMessage(ConferenceChatroom.this.mQuotePackageId, chatReceiverList, text)) {
                            ConferenceChatroom.this.txtMessage.setText("");
                            ConferenceChatroom.this.onReferenceRemoved(ConferenceChatroom.this.mQuotePackageId);
                            UserDatabase database = UserDatabase.getDB(UCChatClient.context);
                            database.deletePendingMessage(ConferenceChatroom.this.mRoomJid);
                        }
                        ConferenceChatroom.this.txtMessage.requestFocus();
                    }
                }

                @Override
                public List<LiteContact> pickContact() {
                    return ConferenceChatroom.this._pickContacts();
                }

                @Override
                public void focusLost() {
                    ConferenceChatroom.this.saveDraft();
                }
            }, this.fileSelectionCallback, this);
            UserDatabase database = UserDatabase.getDB(UCChatClient.context);
            String pendingMsg = database.getPendingMessage(this.getChatroomID());
            this.txtMessage.setPendingText(pendingMsg);
            this.spMessage.setViewportView(this.txtMessage);
            this.sendBtnPanel = new JPanel();
            this.sendBtnPanel.setBorder(BorderFactory.createEmptyBorder(15, 10, 15, 15));
            this.sendBtnPanel.setLayout(new BorderLayout());
            this.sendBtnPanel.setBackground(Color.WHITE);
            this.spMessageOut.add((Component)this.sendBtnPanel, "East");
            this.sendButton = new JButton();
            this.sendBtnPanel.add((Component)this.sendButton, "South");
            this.sendButton.setText(I18NUtil.getString("chat_btn_send") + " (S)");
            this.sendButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String docText = ConferenceChatroom.this.txtMessage.getMessageTextWithIconKey();
                    if (TextUtils.isNotBlank((CharSequence)docText)) {
                        ArrayList<ChatReceiver> chatReceiverList = new ArrayList<ChatReceiver>();
                        chatReceiverList.add(new ChatReceiver(ConferenceChatroom.this.mRoomJid));
                        if (ChatActionUtil.sendMessage(ConferenceChatroom.this.mQuotePackageId, chatReceiverList, docText)) {
                            ConferenceChatroom.this.txtMessage.setText("");
                            ConferenceChatroom.this.onReferenceRemoved(ConferenceChatroom.this.mQuotePackageId);
                            UserDatabase database = UserDatabase.getDB(UCChatClient.context);
                            database.deletePendingMessage(ConferenceChatroom.this.mRoomJid);
                        }
                        ConferenceChatroom.this.txtMessage.requestFocus();
                    }
                }
            });
            this.jPanel5 = new JPanel();
            this.jSplitPane2.add((Component)this.jPanel5, "right");
            BorderLayout jPanel4Layout2 = new BorderLayout();
            this.jPanel5.setLayout(jPanel4Layout2);
            this.panelControl = new WidgetPanel(new Color(247, 247, 247));
            this.jPanel5.add((Component)this.panelControl, "North");
            this.panelControl.add(this.getBtnAddMember());
            this.panelControl.add(this.getBtnRemoveMember());
            this.panelControl.add(this.getBtnMute());
            this.panelControl.add(this.getBtnMuteAll());
            this.panelControl.add(this.getBtnLock());
            this.spParticipant = new UCScrollPane(82);
            this.spParticipant.setHorizontalScrollBarPolicy(31);
            this.jPanel5.add((Component)this.spParticipant, "Center");
            this.panelParticipant = new WidgetPanel();
            this.panelParticipant.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
            this.spParticipant.setViewportView(this.panelParticipant);
            this.panelHeader.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (ConferenceChatroom.this.panelHeader.getHeight() >= 0) {
                        int panelHeight = PreferencesUtil.getChatInputAreaHeight(UCChatClient.context);
                        int loc = ConferenceChatroom.this.mPanrent.getHeight() - ConferenceChatroom.this.panelHeader.getHeight() - panelHeight;
                        if (loc > 200 && panelHeight > 200) {
                            ConferenceChatroom.this.jSplitPane1.setDividerLocation(loc);
                        } else {
                            ConferenceChatroom.this.jSplitPane1.setDividerLocation(0.7);
                        }
                    }
                }
            });
            this.jPanel100.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    Dimension d = ConferenceChatroom.this.jPanel100.getSize();
                    if (d.getHeight() >= 0.0) {
                        PreferencesUtil.setChatInputAreaHeight(UCChatClient.context, (int)d.getHeight());
                    }
                    if (ConferenceChatroom.this.mMessageArea != null) {
                        ConferenceChatroom.this.mMessageArea.refreshScrollBar();
                    }
                }
            });
            int panelWidth = PreferencesUtil.getMangPanelWidth(UCChatClient.context);
            if (panelWidth > 100) {
                this.jSplitPane2.setDividerLocation(this.mPanrent.getWidth() - panelWidth);
            } else if (this.spParticipant.getVerticalScrollBar().isVisible()) {
                this.jSplitPane2.setDividerLocation(this.mPanrent.getWidth() - 155);
            } else {
                this.jSplitPane2.setDividerLocation(this.mPanrent.getWidth() - 135);
            }
            this.jPanel5.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    Dimension d = ConferenceChatroom.this.jPanel5.getSize();
                    if (d.getWidth() >= 0.0) {
                        PreferencesUtil.setMangPanelWidth(UCChatClient.context, (int)d.getWidth());
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onClickMuteButton() {
        try {
            Log.i(ConferenceChatroom.class.getSimpleName(), "PhoneActivity onClickMuteButton");
            int lineIndex = PhoneAgent.getInstance().isInCall(this.mRoomJid);
            if (lineIndex != -1) {
                if (PhoneAgent.getInstance().toggleMute(lineIndex)) {
                    this.showMuteMsg = true;
                } else {
                    CallLine callLine = PhoneAgent.getInstance().getCallLine(lineIndex);
                    if (callLine.isMute()) {
                        ToastUtil.show(UCChatClient.context, I18NUtil.getString("call_notice_call_muted"), 10);
                        this.btnMuteSelf.setIcon(UIConstants.ICON_CHAT_MUTE);
                        this.btnMuteSelf.setToolTipText(I18NUtil.getString("call_btn_click_unmute"));
                    } else {
                        ToastUtil.show(UCChatClient.context, I18NUtil.getString("call_notice_call_unmuted"), 10);
                        this.btnMuteSelf.setIcon(UIConstants.ICON_CHAT_MIC);
                        this.btnMuteSelf.setToolTipText(I18NUtil.getString("call_btn_click_mute"));
                    }
                }
            }
        }
        catch (Throwable t) {
            Log.e(ConferenceChatroom.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
        }
    }

    @Override
    public void onReferenceSelected(String packetId) {
        if (StringUtils.isBlank((CharSequence)packetId)) {
            return;
        }
        this.onReferenceRemoved(null);
        this.mQuotePackageId = packetId;
        this.referenceMsgOut = new ReferenceOut(new ReferenceOut.ReferenceClose(){

            @Override
            public void onReferenceCancel() {
                ConferenceChatroom.this.onReferenceRemoved(null);
            }

            @Override
            public void onMouseClicked() {
                ConferenceChatroom.this.mMessageArea.scrollToPacketId(ConferenceChatroom.this.mQuotePackageId);
            }
        });
        this.referenceMsgOut.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ConferenceChatroom.this.mMessageArea.scrollToPacketId(ConferenceChatroom.this.mQuotePackageId);
            }
        });
        this.referenceMsgOut.setCursor(new Cursor(12));
        Message quoteMsg = UCDBMessage.findMsgByPacketId(UCChatClient.context, this.mQuotePackageId);
        this.referenceMsgOut.setMsg(quoteMsg, false);
        this.spMessageOut.add((Component)this.referenceMsgOut, "North");
        this.jPanel100.validate();
    }

    @Override
    public void onReferenceRemoved(String packetId) {
        if (StringUtils.isNotBlank((CharSequence)packetId) && (StringUtils.isBlank((CharSequence)this.mQuotePackageId) || !this.mQuotePackageId.equalsIgnoreCase(packetId))) {
            return;
        }
        if (this.referenceMsgOut != null) {
            this.spMessageOut.remove(this.referenceMsgOut);
            this.referenceMsgOut = null;
            this.mQuotePackageId = null;
            this.jPanel100.validate();
        }
    }

    private void initConfigPopup() {
        boolean isAdmin = this.isRoomAdmin(PreferencesUtil.getUserJid(UCChatClient.context));
        this.popupMenuConfig.add(this.favoriteAction);
        if (isAdmin) {
            this.popupMenuConfig.add(this.changeConfNameAction);
        }
        this.popupMenuConfig.add(this.notificationAction);
        this.popupMenuConfig.add(this.showMeetmeAction);
        this.popupMenuConfig.addSeparator();
        this.popupMenuConfig.add(this.exitMeetmeAction);
        if (isAdmin) {
            this.popupMenuConfig.add(this.endMeetmeAction);
        }
    }

    private void cleanConfigPopup() {
        this.popupMenuConfig.removeAll();
        ListenerCleaner.cleanPropertyChangeListener(this.notificationAction);
        ListenerCleaner.cleanPropertyChangeListener(this.favoriteAction);
        ListenerCleaner.cleanPropertyChangeListener(this.changeConfNameAction);
        ListenerCleaner.cleanPropertyChangeListener(this.showMeetmeAction);
        ListenerCleaner.cleanPropertyChangeListener(this.exitMeetmeAction);
        ListenerCleaner.cleanPropertyChangeListener(this.endMeetmeAction);
    }

    private void initReceiver() {
        this.receiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                try {
                    final String action = intent.getAction();
                    Long roomId = intent.getLongExtra("roomId", -1L);
                    if ("ezphone.intent.action.event.PHONE_MUTE_CHANGED".equals(action)) {
                        Bundle bundle = intent.getExtras();
                        if (bundle == null) {
                            return;
                        }
                        int line = bundle.getInt("line");
                        int lineIndex = PhoneAgent.getInstance().isInCall(ConferenceChatroom.this.mRoomJid);
                        if (lineIndex != -1) {
                            if (lineIndex != line) {
                                return;
                            }
                            CallLine callLine = PhoneAgent.getInstance().getCallLine(lineIndex);
                            if (callLine.isMute()) {
                                if (ConferenceChatroom.this.showMuteMsg) {
                                    ToastUtil.show(UCChatClient.context, I18NUtil.getString("call_notice_call_muted"), 10);
                                }
                                ConferenceChatroom.this.btnMuteSelf.setIcon(UIConstants.ICON_CHAT_MUTE);
                                ConferenceChatroom.this.btnMuteSelf.setToolTipText(I18NUtil.getString("call_btn_click_unmute"));
                                ConferenceChatroom.this.btnMuteSelf2.setIcon(UIConstants.ICON_CHAT_MUTE_SMALL);
                                ConferenceChatroom.this.btnMuteSelf2.setText(I18NUtil.getString("call_btn_click_unmute"));
                                ConferenceChatroom.this.btnMuteSelf2.setPreferredSize(new Dimension(ConferenceChatroom.this.btnMuteSelf2.calculatePreferWidth(), 32));
                            } else {
                                if (ConferenceChatroom.this.showMuteMsg) {
                                    ToastUtil.show(UCChatClient.context, I18NUtil.getString("call_notice_call_unmuted"), 10);
                                }
                                ConferenceChatroom.this.btnMuteSelf.setIcon(UIConstants.ICON_CHAT_MIC);
                                ConferenceChatroom.this.btnMuteSelf.setToolTipText(I18NUtil.getString("call_btn_click_mute"));
                                ConferenceChatroom.this.btnMuteSelf2.setIcon(UIConstants.ICON_CHAT_MIC_SMALL);
                                ConferenceChatroom.this.btnMuteSelf2.setText(I18NUtil.getString("call_btn_click_mute"));
                                ConferenceChatroom.this.btnMuteSelf2.setPreferredSize(new Dimension(ConferenceChatroom.this.btnMuteSelf2.calculatePreferWidth(), 32));
                            }
                        }
                        ConferenceChatroom.this.showMuteMsg = false;
                    }
                    if (ConferenceChatroom.this.meetmeRoom != null && roomId != null && ConferenceChatroom.this.meetmeRoom.getRoomId().longValue() == roomId.longValue()) {
                        if (action.equals("ezphone.intent.action.event.MEETME_CHANGED")) {
                            ConferenceChatroom.this.meetmeRoom = MeetmeManager.getMeetme((Context)UCChatClient.context, roomId);
                            if (ConferenceChatroom.this.meetmeRoom == null) {
                                Log.w(ConferenceChatroom.class.getSimpleName(), "meetMe has removed!");
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ConferenceChatroom.this.refreshParticipants(action, false);
                                        ConferenceChatroom.this.updateRoom();
                                    }
                                });
                            } else {
                                Log.i(ConferenceChatroom.class.getSimpleName(), "MEETME_CHANGED_ACTION==> " + roomId + " vs " + ConferenceChatroom.this.meetmeRoom.getRoomId());
                                if (ConferenceChatroom.this.meetmeRoom.getType() == LiteConferenceRoomType.STATIC) {
                                    ConferenceChatroom.this.initMeetmeRoomManagerJidData();
                                    ConferenceChatroom.this.cleanConfigPopup();
                                    ConferenceChatroom.this.initConfigPopup();
                                }
                                SwingUtilities.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        ConferenceChatroom.this.refreshParticipants(action, false);
                                        ConferenceChatroom.this.updateRoom();
                                    }
                                });
                            }
                        } else if ("ezphone.intent.action.event.MEETME_USER_LIST_CHANGED".equals(action)) {
                            Log.d(ConferenceChatroom.class.getSimpleName(), ConferenceChatroom.this.meetmeRoom.getName() + "(" + roomId + ") \u6703\u8b70\u4eba\u54e1\u5217\u8868\u8b8a\u52d5");
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ConferenceChatroom.this.refreshParticipants(action, false);
                                }
                            });
                        } else if (action.equals("ezphone.intent.action.event.MEET_ME_LOCK")) {
                            ConferenceChatroom.this.meetmeRoom = MeetmeManager.getMeetme((Context)UCChatClient.context, ConferenceChatroom.this.mRoomJid);
                            ConferenceChatroom.this.mLock = true;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ConferenceChatroom.this.updateRoom();
                                    ConferenceChatroom.this.updateLockAction();
                                }
                            });
                        } else if (action.equals("ezphone.intent.action.event.MEET_ME_UNLOCK")) {
                            ConferenceChatroom.this.meetmeRoom = MeetmeManager.getMeetme((Context)UCChatClient.context, ConferenceChatroom.this.mRoomJid);
                            ConferenceChatroom.this.mLock = false;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ConferenceChatroom.this.updateRoom();
                                    ConferenceChatroom.this.updateLockAction();
                                }
                            });
                        } else if (action.equals("ezphone.intent.action.event.MEET_ME_MUTE")) {
                            ConferenceChatroom.this.meetmeRoom = MeetmeManager.getMeetme((Context)UCChatClient.context, ConferenceChatroom.this.mRoomJid);
                            ConferenceChatroom.this.mAllmute = true;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ConferenceChatroom.this.updateRoom();
                                    ConferenceChatroom.this.updateMuteAllAction();
                                    ConferenceChatroom.this.refreshParticipants("WEB_MEET_ME_MUTE_EVENT", false);
                                }
                            });
                        } else if (action.equals("ezphone.intent.action.event.MEET_ME_UNMUTE ")) {
                            ConferenceChatroom.this.meetmeRoom = MeetmeManager.getMeetme((Context)UCChatClient.context, ConferenceChatroom.this.mRoomJid);
                            ConferenceChatroom.this.mAllmute = false;
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    ConferenceChatroom.this.updateRoom();
                                    ConferenceChatroom.this.updateMuteAllAction();
                                    ConferenceChatroom.this.refreshParticipants("WEB_MEET_ME_UNMUTE_EVENT", false);
                                }
                            });
                        }
                    }
                    if ("ezphone.intent.action.event.CONTACT_PHOTO_CHANGED".equals(action) || "ezphone.intent.action.event.CONTACT_LIST_CHANGED".equals(action)) {
                        if (ConferenceChatroom.this.mMessageArea != null) {
                            ConferenceChatroom.this.mMessageArea.reloadPage();
                            ConferenceChatroom.this.mMessageArea.reloadSystemInfo();
                        }
                        ConferenceChatroom.this.refreshParticipants(action, false);
                    } else if ("ezphone.intent.action.event.CHAT_PARTICIPANT_CHANGED".equals(action)) {
                        ConferenceChatroom.this.chat_participantChanged(intent);
                    } else if ("ezphone.intent.action.event.GROUP_LIST_CHANGED".equals(action)) {
                        ConferenceChatroom.this.group_listChanged();
                    } else if ("ezphone.intent.action.event.MEETME_PHONE_PREFIX_CHANGED".equals(action)) {
                        ConferenceChatroom.this.updateRoom();
                    } else if ("ezphone.intent.action.event.PHONE_TWO_STEP_TRANSFER".equals(action)) {
                        ConferenceChatroom.this.onPhoneStatusChanged();
                    } else if ("ezphone.intent.action.event.PHONE_CALL_BRIDGED".equals(action)) {
                        ConferenceChatroom.this.onPhoneStatusChanged();
                    } else if ("ezphone.intent.action.event.PERSONAL_INFO_CHANGED".equals(action)) {
                        ConferenceChatroom.this.updateRoom();
                        boolean hasFilePermission = PreferencesUtil.hasChatFileActionPermission(UCChatClient.context);
                        boolean hasPhotoPermission = PreferencesUtil.hasChatPhotoActionPermission(UCChatClient.context);
                        ConferenceChatroom.this.btnSendFile.setVisible(hasFilePermission);
                        ConferenceChatroom.this.jSeparator0.setVisible(hasFilePermission);
                        ConferenceChatroom.this.btnScreenCapture.setVisible(hasPhotoPermission);
                        ConferenceChatroom.this.jSeparator1.setVisible(hasPhotoPermission);
                    }
                }
                catch (Throwable t) {
                    Log.e(ConferenceChatroom.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                }
            }
        };
        this.filter = new IntentFilter();
        this.filter.addAction("ezphone.intent.action.event.CONTACT_PHOTO_CHANGED");
        this.filter.addAction("ezphone.intent.action.event.CONTACT_LIST_CHANGED");
        this.filter.addAction("ezphone.intent.action.event.MEETME_CHANGED");
        this.filter.addAction("ezphone.intent.action.event.MEETME_USER_LIST_CHANGED");
        this.filter.addAction("ezphone.intent.action.event.MEET_ME_LOCK");
        this.filter.addAction("ezphone.intent.action.event.MEET_ME_UNLOCK");
        this.filter.addAction("ezphone.intent.action.event.MEET_ME_MUTE");
        this.filter.addAction("ezphone.intent.action.event.MEET_ME_UNMUTE ");
        this.filter.addAction("ezphone.intent.action.event.MEETME_PHONE_PREFIX_CHANGED");
        this.filter.addAction("ezphone.intent.action.event.CHAT_PARTICIPANT_CHANGED");
        this.filter.addAction("ezphone.intent.action.event.GROUP_LIST_CHANGED");
        this.filter.addAction("ezphone.intent.action.event.PHONE_MUTE_CHANGED");
        this.filter.addAction("ezphone.intent.action.event.PHONE_CALL_BRIDGED");
        this.filter.addAction("ezphone.intent.action.event.PHONE_TWO_STEP_TRANSFER");
        this.filter.addAction("ezphone.intent.action.event.PERSONAL_INFO_CHANGED");
        UCChatClient.context.registerReceiver(this.receiver, this.filter);
    }

    private void initMeetmeRoomManagerJidData() {
        this.meetmeRoomManagerJidSet = this.getMeetmeRoomManagerJidSet(this.meetmeRoom);
        this.refreshManagers("initMeetmeRoomManagerJidData");
    }

    private HashSet<String> getMeetmeRoomManagerJidSet(LiteConferenceRoom _meetmeRoom) {
        HashSet<String> meetmeRoomManagerJidSet = new HashSet<String>();
        if (_meetmeRoom != null) {
            long myUserId;
            String role;
            HashSet<Long> empSet = new HashSet<Long>();
            if (_meetmeRoom.getManagerId() != null) {
                empSet.add(_meetmeRoom.getManagerId());
            }
            if (_meetmeRoom.getChairmanIds() != null) {
                for (int i = 0; i < _meetmeRoom.getChairmanIds().size(); ++i) {
                    empSet.add(_meetmeRoom.getChairmanIds().get(i));
                }
            }
            if ("admin".equals(role = ConferenceUtil.getRole(_meetmeRoom, UCChatClient.context, myUserId = PreferencesUtil.getUserId(UCChatClient.context).longValue()))) {
                empSet.add((long)PreferencesUtil.getUserId(UCChatClient.context));
            }
            Map<Long, LiteContact> map = UCDBContact.findAllContactsByEmpIdsWithoutNumber(UCChatClient.context, empSet);
            for (LiteContact contact : map.values()) {
                meetmeRoomManagerJidSet.add(contact.getJid());
            }
        }
        return meetmeRoomManagerJidSet;
    }

    @Override
    public void execute(String command) {
        if (command.equals(COMMAND_SHOW_MEMBER)) {
            this.setLayoutMode(ConfRoomLayoutMode.MEMBER);
        } else if (command.equals(COMMAND_EXIT_MEETME)) {
            ConferenceChatroom.doExitMeetmeAction(this.mRoomJid);
        }
    }

    private boolean isRoomAdmin(String jid) {
        if (jid == null || this.meetmeRoomManagerJidSet == null) {
            return false;
        }
        return this.meetmeRoomManagerJidSet.contains(jid.trim());
    }

    private boolean isRoomAdmin(String jid, HashSet<String> meetmeRoomManagerJidSet) {
        if (jid == null || meetmeRoomManagerJidSet == null) {
            return false;
        }
        return meetmeRoomManagerJidSet.contains(jid.trim());
    }

    private boolean isRoomAdmin(LiteConferenceRoom meetmeRoom, LiteConferenceUserStatus meetmeUser) {
        if (meetmeRoom != null && meetmeRoom.getType() != LiteConferenceRoomType.STATIC) {
            return false;
        }
        if (meetmeUser != null && meetmeUser.isAdmin()) {
            return true;
        }
        if (meetmeRoom != null && meetmeRoom.getManagerId() != null && meetmeUser != null && meetmeRoom.getManagerId() == Long.parseLong(meetmeUser.getCallerDbId())) {
            return true;
        }
        if (meetmeRoom != null && meetmeRoom.getChairmanIds() != null) {
            for (int i = 0; i < meetmeRoom.getChairmanIds().size(); ++i) {
                Long chairdbid = meetmeRoom.getChairmanIds().get(i);
                if (chairdbid != Long.parseLong(meetmeUser.getCallerDbId())) continue;
                return true;
            }
        }
        return false;
    }

    private synchronized List<LiteContact> _pickContacts() {
        String caption;
        ArrayList<LiteContact> candidateContacts = new ArrayList<LiteContact>();
        LiteContact allContact = new LiteContact();
        allContact.setId(-10000L);
        candidateContacts.add(allContact);
        for (ChatRoomItem item : this.mParticipantsDataList) {
            ChatRoomMember m;
            if (!(item instanceof ChatRoomMember) || !JidUtil.isEmployeeJid((m = (ChatRoomMember)item).getJid()) || this.myJid.equals(m.getJid())) continue;
            candidateContacts.add(m.getContact());
        }
        MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
        SelectContactResult result = mainPanel.showSelectContactDialog(caption = I18NUtil.getString("abook_title_select_participant_to_reply"), candidateContacts, true);
        if (result != null) {
            return result.getParticipants();
        }
        return null;
    }

    private void btnSendFileMouseClicked(MouseEvent evt) {
        FileUtil.sendFile(this.fileSelectionCallback);
    }

    private void btnScreenCaptureMouseClicked(MouseEvent evt) {
        CaptureUtil.captureImage(this, this.fileSelectionCallback);
    }

    private void btnSendStickerMouseClicked(MouseEvent evt) {
        final StickerPopupMenu menu = StickerPopupMenu.getInstance();
        menu.setMediaContentInputListener(new MediaContentInputListener(){

            @Override
            public void onStickerClick(String stickerKey) {
                ArrayList<ChatReceiver> chatReceiverList = new ArrayList<ChatReceiver>();
                chatReceiverList.add(new ChatReceiver(ConferenceChatroom.this.mRoomJid));
                ChatActionUtil.sendMessage(ConferenceChatroom.this.mQuotePackageId, chatReceiverList, stickerKey);
                ConferenceChatroom.this.onReferenceRemoved(ConferenceChatroom.this.mQuotePackageId);
                menu.setVisible(false);
                ConferenceChatroom.this.txtMessage.requestFocus();
            }

            @Override
            public void onEmoticonClick(String emoticonKey, String iconPath) {
            }

            @Override
            public void onIdiomClick(String text) {
            }

            @Override
            public void onSymbolClick(String text) {
            }
        });
        menu.show(this.btnSendSticker, 0, -menu.getPreferredSize().height);
    }

    private void btnSendEmoticonMouseClicked(MouseEvent evt) {
        final EmoticonPopupMenu menu = EmoticonPopupMenu.getInstance();
        menu.setMediaContentInputListener(new MediaContentInputListener(){

            @Override
            public void onStickerClick(String stickerKey) {
            }

            @Override
            public void onEmoticonClick(String emoticonKey, String iconPath) {
                ImageIcon eIcon = GraphicUtil.getScaledIcon(iconPath, 16, 16);
                eIcon.setDescription(emoticonKey);
                ConferenceChatroom.this.txtMessage.insertIcon(eIcon);
                menu.setVisible(false);
                ConferenceChatroom.this.txtMessage.requestFocus();
            }

            @Override
            public void onIdiomClick(String text) {
                try {
                    ConferenceChatroom.this.txtMessage.replaceSelection("");
                    ConferenceChatroom.this.txtMessage.getDocument().insertString(ConferenceChatroom.this.txtMessage.getCaretPosition(), text, null);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
                menu.setVisible(false);
                ConferenceChatroom.this.txtMessage.requestFocus();
            }

            @Override
            public void onSymbolClick(String text) {
                try {
                    ConferenceChatroom.this.txtMessage.replaceSelection("");
                    ConferenceChatroom.this.txtMessage.getDocument().insertString(ConferenceChatroom.this.txtMessage.getCaretPosition(), text, null);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
                menu.setVisible(false);
                ConferenceChatroom.this.txtMessage.requestFocus();
            }
        });
        menu.show(this.btnSendEmoticon, 0, -menu.getPreferredSize().height);
    }

    private void setComponentPopupMenu(final Component parent, final JPopupMenu menu) {
        parent.addMouseListener(new MouseAdapter(this){

            @Override
            public void mousePressed(MouseEvent e) {
                if (parent.isEnabled()) {
                    menu.show(parent, 0, parent.getHeight());
                }
            }
        });
    }

    private void lblPhotoMousePressed(MouseEvent evt) {
        boolean roomJoined = UCDBChatRoom.hasParticipants(UCChatClient.context, this.mRoomJid);
        if (roomJoined) {
            this.switchLayout();
        }
    }

    public void setLayoutMode(ConfRoomLayoutMode mode) {
        if (!this.manualSelectedLayout) {
            this.layoutMode = mode;
            this.updateConfRoomLayoutModeUI();
        } else if (this.layoutMode == ConfRoomLayoutMode.MEMBER && mode == ConfRoomLayoutMode.NO_MEMBER) {
            this.layoutMode = ConfRoomLayoutMode.NO_MEMBER;
            this.updateConfRoomLayoutModeUI();
        }
    }

    private void switchLayout() {
        int newIndex = (this.layoutMode.ordinal() + 1) % ConfRoomLayoutMode.values().length;
        this.layoutMode = ConfRoomLayoutMode.values()[newIndex];
        this.updateConfRoomLayoutModeUI();
        this.manualSelectedLayout = true;
    }

    private void updateConfRoomLayoutModeUI() {
        this.btnLayout.setIcon(this.layoutMode.getIcon());
        this.btnLayout.setToolTipText(this.layoutMode.getToolTip());
        switch (this.layoutMode) {
            case NO_MEMBER: {
                PreferencesUtil.setMangPrevPanelWidth(UCChatClient.context, (int)this.jPanel5.getSize().getWidth());
                this.jPanel5.setVisible(false);
                this.panelChat.revalidate();
                this.panelChat.repaint();
                break;
            }
            case MEMBER: {
                this.jPanel5.setVisible(true);
                int panelWidth = PreferencesUtil.getMangPrevPanelWidth(UCChatClient.context);
                if (panelWidth > 100) {
                    this.jSplitPane2.setDividerLocation(this.mPanrent.getWidth() - panelWidth);
                } else if (this.spParticipant.getVerticalScrollBar().isVisible()) {
                    this.jSplitPane2.setDividerLocation(this.mPanrent.getWidth() - 155);
                } else {
                    this.jSplitPane2.setDividerLocation(this.mPanrent.getWidth() - 135);
                }
                this.panelChat.revalidate();
                this.panelChat.repaint();
            }
        }
    }

    @Override
    public void onShow(Intent intent) {
        boolean roomJoined;
        Log.i(ConferenceChatroom.class.getSimpleName(), "chatroom onShow: " + this.mRoomJid);
        super.onShow(intent);
        if (intent != null && intent.getExtras().containsKey(UNJOINED_DISPLAY_MODE)) {
            this.unjoinedDisplayMode = (UnjoinedDisplayMode)((Object)intent.getExtras().get(UNJOINED_DISPLAY_MODE));
        }
        if (roomJoined = UCDBChatRoom.hasParticipants(UCChatClient.context, this.mRoomJid)) {
            this.setDisplayPage(DisplayPage.CHAT);
        } else {
            this.setDisplayPage(this.unjoinedDisplayMode == UnjoinedDisplayMode.JOIN ? DisplayPage.JOIN : DisplayPage.CHAT);
        }
    }

    @Override
    public void onClose() {
        this.saveDraft();
        if (this.mMessageArea != null) {
            this.mMessageArea.onClose();
        }
        if (this.receiver != null) {
            UCChatClient.context.unregisterReceiver(this.receiver);
        }
        ListenerCleaner.cleanMouseListner(this.btnJoin_);
        ListenerCleaner.cleanMouseListner(this.lblPhoto);
        ListenerCleaner.cleanMouseListner(this.btnLayout);
        ListenerCleaner.cleanMouseListner(this.btnSendFile);
        ListenerCleaner.cleanMouseListner(this.btnScreenCapture);
        ListenerCleaner.cleanMouseListner(this.btnSendSticker);
        ListenerCleaner.cleanMouseListner(this.btnSendEmoticon);
        ListenerCleaner.cleanMouseListner(this.btnCall);
        ListenerCleaner.cleanMouseListner(this.btnHangup);
        ListenerCleaner.cleanMouseListner(this.btnMuteSelf);
        ListenerCleaner.cleanMouseListner(this.btnShowCallPage);
        ListenerCleaner.cleanMouseListner(this.btnCall2);
        ListenerCleaner.cleanMouseListner(this.btnHangup2);
        ListenerCleaner.cleanMouseListner(this.btnMuteSelf2);
        ListenerCleaner.cleanMouseListner(this.btnConfig);
        ListenerCleaner.cleanMouseListner(this.btnAddMember);
        ListenerCleaner.cleanMouseListner(this.btnRemoveMember);
        ListenerCleaner.cleanMouseListner(this.btnMute);
        ListenerCleaner.cleanMouseListner(this.btnMuteAll);
        ListenerCleaner.cleanMouseListner(this.btnLock);
        ListenerCleaner.cleanActionListner(this.sendButton);
        ListenerCleaner.cleanComponentListner(this.panelHeader);
        ListenerCleaner.cleanComponentListner(this.jPanel100);
        ListenerCleaner.cleanComponentListner(this.jPanel5);
        this.cleanPanelParticipant();
        this.cleanConfigPopup();
        this.txtMessage.onClose();
        this.jSplitPane1.removeAll();
        this.mMessageArea = null;
        StickerPopupMenu menu = StickerPopupMenu.getInstance();
        menu.setMediaContentInputListener(null);
    }

    private void saveDraft() {
        if (this.txtMessage == null) {
            return;
        }
        if (this.txtMessage.isEnabled()) {
            UserDatabase database = UserDatabase.getDB(UCChatClient.context);
            String roomJid = this.getChatroomID();
            String existedDraftMsg = database.getPendingMessage(roomJid);
            String docText = this.txtMessage.getMessageTextWithIconKey();
            if (!TextUtils.isBlank((CharSequence)docText)) {
                database.savePendingMessage(roomJid, docText);
                BroadcastUtil.sendContactHistoryChangedEvent(UCChatClient.context);
            } else if (TextUtils.isNotBlank((CharSequence)existedDraftMsg)) {
                database.deletePendingMessage(roomJid);
                BroadcastUtil.sendContactHistoryChangedEvent(UCChatClient.context);
            }
        }
    }

    private void addParticipantItem(final ChatRoomMember m) {
        JLabel lblParticipant = new JLabel();
        lblParticipant.setText(m.getTitle());
        lblParticipant.setToolTipText(m.getTitle());
        Image image = null;
        image = JidUtil.isEmployeeJid(m.getJid()) ? this.getEmpParticipantImage(m) : (JidUtil.isLocationJid(m.getJid()) ? this.getLocationParticipantImage(m) : (JidUtil.isMyContactJid(m.getJid()) ? this.getMyContactParticipantImage(m) : this.getNomanParticipantImage(m)));
        lblParticipant.setIcon(image == null ? UIConstants.ICON_PERSON48 : new ImageIcon(image));
        lblParticipant.setIconTextGap(4);
        lblParticipant.setHorizontalTextPosition(0);
        lblParticipant.setVerticalTextPosition(3);
        lblParticipant.setForeground(new Color(224, 224, 224));
        lblParticipant.setPreferredSize(new Dimension(48, 70));
        lblParticipant.setMaximumSize(new Dimension(48, 70));
        lblParticipant.setMinimumSize(new Dimension(48, 70));
        String myJid = PreferencesUtil.getUserJid(UCChatClient.context);
        if (!m.getJid().equals(myJid)) {
            lblParticipant.setCursor(new Cursor(12));
            lblParticipant.addMouseListener(new MouseAdapter(this){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    UCChatClient.getInstance().getMainPanel().showChatroom(m.getJid());
                }
            });
        }
        this.panelParticipant.add(lblParticipant);
        this.panelParticipant.revalidate();
        this.panelParticipant.repaint();
    }

    private void cleanPanelParticipant() {
        if (this.panelParticipant != null) {
            for (Component comp : this.panelParticipant.getComponents()) {
                ListenerCleaner.cleanMouseListner(comp);
            }
        }
        this.panelParticipant.removeAll();
    }

    private Image getEmpParticipantImage(ChatRoomMember crm) {
        LiteContact contact = ContactManager.getContact((Context)UCChatClient.context, crm.getJid());
        Image image = ContactManager.getContactImage(contact, 48, false, true);
        return this.mix(crm, image);
    }

    private Image getLocationParticipantImage(ChatRoomMember crm) {
        Image participantImage = UIConstants.ICON_PHONE_PUBLIC_PHONE48.getImage();
        return this.mix(crm, participantImage);
    }

    private Image getMyContactParticipantImage(ChatRoomMember crm) {
        long myContactId = JidUtil.trimExternalContactId(crm.getJid());
        LiteMyContact myContact = UCDBExternalContact.getExternalContactById(UCChatClient.context, myContactId);
        Image participantImage = ContactManager.getExternalContactImage(myContact, 48, false, true);
        return this.mix(crm, participantImage);
    }

    private Image getNomanParticipantImage(ChatRoomMember crm) {
        Image participantImage = UIConstants.ICON_PERSON48.getImage();
        return this.mix(crm, participantImage);
    }

    private Image mix(ChatRoomMember crm, Image participantImage) {
        Image muteImage = null;
        if (crm.isMeetmeOn()) {
            boolean muted = crm.isMeetmeIsMute();
            muteImage = muted ? ICON_VOICE_OFF.getImage() : ICON_VOICE_ON.getImage();
        }
        participantImage = crm.isAdmin() ? GraphicUtil.getPresencedPersonalPhoto(48, 48, participantImage, null, true, Color.YELLOW, Color.ORANGE, muteImage) : GraphicUtil.getPresencedPersonalPhoto(48, 48, participantImage, null, true, null, null, muteImage);
        return participantImage;
    }

    @Override
    public void onPhoneStatusChanged() {
        if (PhoneAgent.isRegistered != PhoneAgent.STAT_REGISTERED) {
            this.btnCall.setEnabled(false);
            this.btnCall.setVisible(false);
            this.btnCall.setToolTipText(I18NUtil.getString("phone_notice_not_connected"));
            this.jPanelCall1.setVisible(false);
            this.btnCall2.setEnabled(false);
            this.btnCall2.setVisible(false);
            this.btnCall2.setToolTipText(I18NUtil.getString("phone_notice_not_connected"));
            this.btnHangup2.setEnabled(false);
            this.btnHangup2.setVisible(false);
            this.btnMuteSelf2.setEnabled(false);
            this.btnMuteSelf2.setVisible(false);
            return;
        }
        this.btnCall.setToolTipText(null);
        this.btnCall2.setToolTipText(null);
        if (this.chatMode == ChatMode.NORMAL) {
            this.btnCall2.setEnabled(false);
            this.btnCall2.setVisible(false);
            this.btnHangup2.setEnabled(false);
            this.btnHangup2.setVisible(false);
            this.btnMuteSelf2.setEnabled(false);
            this.btnMuteSelf2.setVisible(false);
            this.handleNormalPhone();
        } else if (this.chatMode == ChatMode.ONLY_PHONE) {
            this.btnCall.setEnabled(false);
            this.btnCall.setVisible(false);
            this.jPanelCall1.setVisible(false);
            this.handleOnlyPhone();
        } else {
            this.btnCall2.setEnabled(false);
            this.btnCall2.setVisible(false);
            this.btnHangup2.setEnabled(false);
            this.btnHangup2.setVisible(false);
            this.btnMuteSelf2.setEnabled(false);
            this.btnMuteSelf2.setVisible(false);
            this.btnCall.setEnabled(false);
            this.btnCall.setVisible(false);
            this.jPanelCall1.setVisible(false);
        }
    }

    private void handleNormalPhone() {
        int lineIndex = PhoneAgent.getInstance().isInCall(this.mRoomJid);
        if (lineIndex != -1) {
            CallLine callLine = PhoneAgent.getInstance().getCallLine(lineIndex);
            if (callLine.isMute()) {
                this.btnMuteSelf.setIcon(UIConstants.ICON_CHAT_MUTE);
                this.btnMuteSelf.setToolTipText(I18NUtil.getString("call_btn_click_unmute"));
            } else {
                this.btnMuteSelf.setIcon(UIConstants.ICON_CHAT_MIC);
                this.btnMuteSelf.setToolTipText(I18NUtil.getString("call_btn_click_mute"));
            }
            this.btnCall.setEnabled(false);
            this.btnCall.setVisible(false);
            this.jPanelCall1.setVisible(true);
            return;
        }
        PhoneAgent.LineAvailableType isAvailableToCall = PhoneAgent.getInstance().isAvailableToCall();
        this.handleCallBtnText(isAvailableToCall != PhoneAgent.LineAvailableType.NONE, isAvailableToCall);
        this.revalidate();
        this.repaint();
    }

    private void handleCallBtnText(boolean btnEnable, PhoneAgent.LineAvailableType ableToCall) {
        if (btnEnable) {
            this.btnCall.setEnabled(true);
            this.btnCall.setVisible(true);
            this.jPanelCall1.setVisible(false);
        } else {
            this.btnCall.setEnabled(false);
            this.btnCall.setVisible(false);
            this.jPanelCall1.setVisible(false);
        }
        if (!btnEnable) {
            this.btnCall.setText(I18NUtil.getString("abook_popup_btn_talk"));
        } else if (ableToCall == PhoneAgent.LineAvailableType.LINE_ONE) {
            this.btnCall.setText(I18NUtil.getString("call_btn_callout_line1_full"));
        } else if (ableToCall == PhoneAgent.LineAvailableType.LINE_TWO) {
            this.btnCall.setText(I18NUtil.getString("call_btn_callout_line2_full"));
        } else {
            this.btnCall.setText(I18NUtil.getString("abook_popup_btn_talk"));
        }
    }

    private void handleOnlyPhone() {
        int lineIndex = PhoneAgent.getInstance().isInCall(this.mRoomJid);
        if (lineIndex != -1) {
            CallLine callLine = PhoneAgent.getInstance().getCallLine(lineIndex);
            boolean isMuted = callLine.isMute();
            if (isMuted) {
                this.btnMuteSelf2.setIcon(UIConstants.ICON_CHAT_MUTE_SMALL);
                this.btnMuteSelf2.setText(I18NUtil.getString("call_btn_click_unmute"));
            } else {
                this.btnMuteSelf2.setIcon(UIConstants.ICON_CHAT_MIC_SMALL);
                this.btnMuteSelf2.setText(I18NUtil.getString("call_btn_click_mute"));
            }
            this.btnMuteSelf2.setPreferredSize(new Dimension(this.btnMuteSelf2.calculatePreferWidth(), 32));
            this.btnCall2.setVisible(false);
            this.btnHangup2.setEnabled(true);
            this.btnHangup2.setVisible(true);
            this.btnMuteSelf2.setEnabled(true);
            this.btnMuteSelf2.setVisible(true);
            return;
        }
        PhoneAgent.LineAvailableType isAvailableToCall = PhoneAgent.getInstance().isAvailableToCall();
        this.handleCallBtn2Text(isAvailableToCall != PhoneAgent.LineAvailableType.NONE, isAvailableToCall);
        this.revalidate();
        this.repaint();
    }

    private void handleCallBtn2Text(boolean btnEnable, PhoneAgent.LineAvailableType ableToCall) {
        if (btnEnable) {
            this.btnCall2.setEnabled(true);
            this.btnCall2.setVisible(true);
            this.btnHangup2.setEnabled(false);
            this.btnHangup2.setVisible(false);
            this.btnMuteSelf2.setEnabled(false);
            this.btnMuteSelf2.setVisible(false);
        } else {
            this.btnCall2.setEnabled(false);
            this.btnCall2.setVisible(false);
            this.btnHangup2.setEnabled(false);
            this.btnHangup2.setVisible(false);
            this.btnMuteSelf2.setEnabled(false);
            this.btnMuteSelf2.setVisible(false);
        }
        if (!btnEnable) {
            this.btnCall2.setText(I18NUtil.getString("abook_popup_btn_talk"));
        } else if (ableToCall == PhoneAgent.LineAvailableType.LINE_ONE) {
            this.btnCall2.setText(I18NUtil.getString("call_btn_callout_line1_full"));
        } else if (ableToCall == PhoneAgent.LineAvailableType.LINE_TWO) {
            this.btnCall2.setText(I18NUtil.getString("call_btn_callout_line2_full"));
        } else {
            this.btnCall2.setText(I18NUtil.getString("abook_popup_btn_talk"));
        }
        this.btnCall2.setPreferredSize(new Dimension(this.btnCall2.calculatePreferWidth(), 32));
    }

    private void group_listChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConferenceChatroom.this.updateFavoriteAction(ChatRoomManager.isInMyFavorite(ConferenceChatroom.this.mRoomJid));
            }
        });
    }

    private void chat_participantChanged(final Intent intent) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean update = false;
                String chatIdTemp = intent.getStringExtra("chatId");
                if (chatIdTemp != null && chatIdTemp != null && ConferenceChatroom.this.mRoomJid != null && chatIdTemp.equals(ConferenceChatroom.this.mRoomJid)) {
                    update = true;
                }
                if (update) {
                    ConferenceChatroom.this.refreshParticipants("CHAT_PARTICIPANT_CHANGED_ACTION", false);
                }
            }
        });
    }

    private void btnJoin_MouseClicked(MouseEvent evt) {
        boolean roomJoined;
        if (this.btnJoin_.isEnabled() && evt.getButton() == 1 && !(roomJoined = UCDBChatRoom.hasParticipants(UCChatClient.context, this.mRoomJid))) {
            LiteConferenceRoomAuthType type = this.meetmeRoom.getAuthType();
            if (!type.equals((Object)LiteConferenceRoomAuthType.PIN_CODE)) {
                this.btnJoin_.setVisible(false);
                this.lblProcessing_.setVisible(true);
            }
            if (this.mConferenceHelper != null) {
                this.mConferenceHelper.release();
            }
            this.mConferenceHelper = new ConferenceHelper(UCChatClient.context, this.roomId, this);
            this.mConferenceHelper.doVerify();
        }
    }

    @Override
    public void verifyOK() {
        if (this.mConferenceHelper != null) {
            this.mConferenceHelper.release();
            this.mConferenceHelper = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                UCChatClient.getInstance().getMainPanel().showChatroom(ConferenceChatroom.this.mRoomJid);
            }
        });
    }

    @Override
    public void verifyFailed(int returnCode, String msg) {
        if (this.mConferenceHelper != null) {
            this.mConferenceHelper.release();
            this.mConferenceHelper = null;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConferenceChatroom.this.btnJoin_.setVisible(true);
                ConferenceChatroom.this.lblProcessing_.setVisible(false);
            }
        });
    }

    public static void doExitMeetmeAction(String roomJid) {
        WebAgent.getInstance().exitRoom(roomJid);
        PhoneAgent.getInstance().hangupMeetme(roomJid);
        LiteConferenceRoom liteRoom = MeetmeManager.getMeetme((Context)UCChatClient.context, roomJid);
        if (liteRoom != null) {
            UserDatabase database = UserDatabase.getDB(UCChatClient.context);
            database.deleteConferenceRoleInfo(liteRoom.getRoomId());
            WebAgent.getInstance().leaveConference(liteRoom.getRoomId());
        }
    }

    private synchronized void _addMember() {
        String string;
        this.mCurrentAction = ACTION_PLUS;
        HashSet<String> exculsiveJIDs = new HashSet<String>();
        for (ChatRoomItem item : this.mParticipantsDataList) {
            if (!(item instanceof ChatRoomMember)) continue;
            ChatRoomMember m = (ChatRoomMember)item;
            if (JidUtil.isEmployeeJid(m.getJid())) {
                exculsiveJIDs.add(m.getJid());
                continue;
            }
            if (!JidUtil.isLocationJid(m.getJid())) continue;
            exculsiveJIDs.add(m.getJid());
        }
        List itemList = UCDBContact.getContactsOrderByName(UCChatClient.context, null, 0, exculsiveJIDs);
        ArrayList<LiteContact> candidateContacts = new ArrayList<LiteContact>();
        for (AddressBookGroup addressBookGroup : itemList) {
            for (LiteContact c : addressBookGroup.getDataList()) {
                if (!JidUtil.isEmployeeJid(c.getJid())) continue;
                candidateContacts.add(c);
            }
        }
        MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
        SelectContactResult result = mainPanel.showSelectContactDialog(string = I18NUtil.getString("conference_select_members_to_invite"), candidateContacts);
        if (result != null) {
            List<LiteContact> participants = result.getParticipants();
            ArrayList<String> participantJIDs = new ArrayList<String>();
            for (LiteContact participant : participants) {
                participantJIDs.add(participant.getJid());
            }
            ToastUtil.showShort(String.format(I18NUtil.getString("chatroom_notice_invite_processing"), this.getContactDispTitle(participants)));
            WebAgent.getInstance().inviteRoomParticipants(this.mRoomJid, participantJIDs);
        }
    }

    private void refreshSelectionList() {
        ArrayList<ChatRoomItem> kickCandidateContacts = new ArrayList<ChatRoomItem>();
        for (ChatRoomItem item : this.mParticipantsDataList) {
            ChatRoomMember m;
            if (!(item instanceof ChatRoomMember) || (m = (ChatRoomMember)item).isAdmin()) continue;
            kickCandidateContacts.add(m);
        }
        MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
        mainPanel.updateKickSelectMeetmeItemDialog(kickCandidateContacts);
        ArrayList<ChatRoomItem> muteCandidateContacts = new ArrayList<ChatRoomItem>();
        String selfJid = PreferencesUtil.getUserJid(UCChatClient.context);
        for (ChatRoomItem item : this.mParticipantsDataList) {
            boolean meetmeOn;
            ChatRoomMember m;
            if (!(item instanceof ChatRoomMember) || selfJid.equals((m = (ChatRoomMember)item).getJid()) || m.isAdmin() || !(meetmeOn = m.isMeetmeOn())) continue;
            muteCandidateContacts.add(m);
        }
        mainPanel.updateMuteSelectMeetmeItemDialog(muteCandidateContacts);
    }

    private void _removeMember() {
        String caption;
        this.mCurrentAction = ACTION_MINUS;
        if (this.meetmeRoom != null) {
            this.mMinusSelection = !this.mMinusSelection;
        }
        this.mMuteSelection = false;
        ArrayList<ChatRoomItem> candidateContacts = new ArrayList<ChatRoomItem>();
        for (ChatRoomItem item : this.mParticipantsDataList) {
            ChatRoomMember m;
            if (!(item instanceof ChatRoomMember) || (m = (ChatRoomMember)item).isAdmin()) continue;
            candidateContacts.add(m);
        }
        MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
        SelectMeetmeItemResult result = mainPanel.showKickSelectMeetmeItemDialog(caption = I18NUtil.getString("conference_select_members_to_kick"), candidateContacts);
        if (result != null) {
            List<ChatRoomItem> participants = result.getParticipants();
            ToastUtil.showShort(String.format(I18NUtil.getString("chatroom_notice_kick_processing"), this.getDispTitle(participants)));
            ArrayList<ChatRoomMember> toRemoveList = new ArrayList<ChatRoomMember>();
            ArrayList<String> removeMemberJidList = new ArrayList<String>();
            for (ChatRoomItem m : participants) {
                if (!(m instanceof ChatRoomMember)) continue;
                ChatRoomMember crm = (ChatRoomMember)m;
                toRemoveList.add(crm);
            }
            for (ChatRoomMember crm : toRemoveList) {
                LiteContact empContact = null;
                if (JidUtil.isEmployeeJid(crm.getJid())) {
                    empContact = ContactManager.getContact((Context)UCChatClient.context, crm.getJid());
                    removeMemberJidList.add(crm.getJid());
                }
                if (this.meetmeRoom == null || this.meetmeRoom.getRoomId() == null) continue;
                if (empContact != null) {
                    WebAgent.getInstance().kickUser(this.meetmeRoom.getRoomId(), crm.getMeetmeUserNo(), empContact.getId());
                    continue;
                }
                WebAgent.getInstance().kickUser(this.meetmeRoom.getRoomId(), crm.getMeetmeUserNo());
            }
            WebAgent.getInstance().removeRoomMembers(this.mRoomJid, removeMemberJidList);
        }
    }

    private synchronized void _mute() {
        String caption;
        this.mCurrentAction = ACTION_MUTE;
        if (this.meetmeRoom != null) {
            this.mMuteSelection = !this.mMuteSelection;
        }
        this.mMinusSelection = false;
        ArrayList<ChatRoomItem> candidateContacts = new ArrayList<ChatRoomItem>();
        ArrayList<ChatRoomItem> mutedContacts = new ArrayList<ChatRoomItem>();
        String selfJid = PreferencesUtil.getUserJid(UCChatClient.context);
        for (ChatRoomItem item : this.mParticipantsDataList) {
            boolean meetmeOn;
            ChatRoomMember m;
            if (!(item instanceof ChatRoomMember) || selfJid.equals((m = (ChatRoomMember)item).getJid()) || m.isAdmin() || !(meetmeOn = m.isMeetmeOn())) continue;
            candidateContacts.add(m);
            boolean isMuted = m.isMeetmeIsMute();
            if (!isMuted) continue;
            mutedContacts.add(m);
        }
        MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
        SelectMeetmeItemResult result = mainPanel.showMuteSelectMeetmeItemDialog(caption = I18NUtil.getString("conference_select_members_to_mute"), candidateContacts, mutedContacts, true);
        if (result != null) {
            String userNo;
            ChatRoomMember crm;
            ArrayList<ChatRoomItem> originalMutedContacts = new ArrayList<ChatRoomItem>(mutedContacts);
            List<ChatRoomItem> newMutedParticipants = result.getParticipants();
            originalMutedContacts.retainAll(newMutedParticipants);
            newMutedParticipants.removeAll(originalMutedContacts);
            mutedContacts.removeAll(originalMutedContacts);
            if (newMutedParticipants.size() != 0 && mutedContacts.size() != 0) {
                ToastUtil.showLong(String.format(I18NUtil.getString("conference_mute_process"), this.getDispTitle(newMutedParticipants), this.getDispTitle(mutedContacts)));
            } else if (newMutedParticipants.size() != 0) {
                ToastUtil.showLong(String.format(I18NUtil.getString("conference_mute_process_muteonly"), this.getDispTitle(newMutedParticipants)));
            } else if (mutedContacts.size() != 0) {
                ToastUtil.showLong(String.format(I18NUtil.getString("conference_mute_process_unmuteonly"), this.getDispTitle(mutedContacts)));
            }
            for (ChatRoomItem m : newMutedParticipants) {
                if (!(m instanceof ChatRoomMember)) continue;
                crm = (ChatRoomMember)m;
                userNo = crm.getMeetmeUserNo();
                WebAgent.getInstance().muteUser(this.meetmeRoom.getRoomId(), userNo);
            }
            for (ChatRoomItem m : mutedContacts) {
                if (!(m instanceof ChatRoomMember)) continue;
                crm = (ChatRoomMember)m;
                userNo = crm.getMeetmeUserNo();
                WebAgent.getInstance().unMuteUser(this.meetmeRoom.getRoomId(), userNo);
            }
        }
    }

    private void _muteAll() {
        this.mCurrentAction = ACTION_ALLMUTE;
        if (this.meetmeRoom != null) {
            if (this.mAllmute) {
                ToastUtil.showShort(I18NUtil.getString("conference_allunmute_processing"));
                WebAgent.getInstance().unMuteAll(this.meetmeRoom.getRoomId());
            } else {
                ToastUtil.showShort(I18NUtil.getString("conference_allmute_processing"));
                WebAgent.getInstance().muteAll(this.meetmeRoom.getRoomId());
            }
        }
    }

    private void _lock() {
        this.mCurrentAction = ACTION_LOCK;
        if (this.meetmeRoom != null) {
            if (this.mLock) {
                ToastUtil.showShort(I18NUtil.getString("conference_unlock_processing"));
                WebAgent.getInstance().unLock(this.meetmeRoom.getRoomId());
            } else {
                ToastUtil.showShort(I18NUtil.getString("conference_lock_process"));
                WebAgent.getInstance().lock(this.meetmeRoom.getRoomId());
            }
        }
    }

    private void doEndMeetme() {
        int result = JOptionPane.showConfirmDialog(this, I18NUtil.getString("conference_title_end_confirm"), I18NUtil.getString("common_title_warning"), 2, 2);
        if (result == 0) {
            if (this.meetmeRoom != null) {
                WebAgent.getInstance().kickAll(this.meetmeRoom.getRoomId());
            }
            if (this.mRoomJid != null) {
                String selfJid = PreferencesUtil.getUserJid(UCChatClient.context);
                ArrayList<String> participants = UCDBChatRoom.findChatRoomParticipants((Context)UCChatClient.context, this.mRoomJid);
                if (participants != null) {
                    participants.remove(selfJid);
                    if (!participants.isEmpty()) {
                        WebAgent.getInstance().removeRoomMembers(this.mRoomJid, participants);
                    }
                }
                ArrayList<String> selfJids = new ArrayList<String>(1);
                selfJids.add(selfJid);
                WebAgent.getInstance().removeRoomMembers(this.mRoomJid, selfJids);
                UCChatClient.getInstance().getMainPanel().closeChatroom(this.mRoomJid);
            }
        }
    }

    private ImageLabel getBtnAddMember() {
        if (this.btnAddMember == null) {
            this.btnAddMember = new ImageLabel(ICON_ADD_MEMBER);
            this.btnAddMember.setFlatMode(true);
            this.btnAddMember.setNormalBorderColor(null);
            this.btnAddMember.setCursor(UIConstants.CURSOR_HAND);
            this.btnAddMember.setToolTipText(I18NUtil.getString("conference_label_invite_participants"));
            this.btnAddMember.setPreferredSize(new Dimension(48, 48));
            this.btnAddMember.setMaximumSize(new Dimension(48, 48));
            this.btnAddMember.setMinimumSize(new Dimension(48, 48));
            this.btnAddMember.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    ConferenceChatroom.this._addMember();
                }
            });
        }
        return this.btnAddMember;
    }

    private ImageLabel getBtnRemoveMember() {
        if (this.btnRemoveMember == null) {
            this.btnRemoveMember = new ImageLabel(ICON_REMOVE_MEMBER);
            this.btnRemoveMember.setFlatMode(true);
            this.btnRemoveMember.setCursor(UIConstants.CURSOR_HAND);
            this.btnRemoveMember.setNormalBorderColor(null);
            this.btnRemoveMember.setToolTipText(I18NUtil.getString("conference_btn_kick"));
            this.btnRemoveMember.setPreferredSize(new Dimension(48, 48));
            this.btnRemoveMember.setMaximumSize(new Dimension(48, 48));
            this.btnRemoveMember.setMinimumSize(new Dimension(48, 48));
            this.btnRemoveMember.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    ConferenceChatroom.this._removeMember();
                }
            });
        }
        return this.btnRemoveMember;
    }

    private ImageLabel getBtnMute() {
        if (this.btnMute == null) {
            this.btnMute = new ImageLabel(ICON_MUTE);
            this.btnMute.setFlatMode(true);
            this.btnMute.setNormalBorderColor(null);
            this.btnMute.setCursor(UIConstants.CURSOR_HAND);
            this.btnMute.setToolTipText(I18NUtil.getString("conference_action_label_mute"));
            this.btnMute.setPreferredSize(new Dimension(48, 48));
            this.btnMute.setMaximumSize(new Dimension(48, 48));
            this.btnMute.setMinimumSize(new Dimension(48, 48));
            this.btnMute.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    ConferenceChatroom.this._mute();
                }
            });
        }
        return this.btnMute;
    }

    private ImageLabel getBtnMuteAll() {
        if (this.btnMuteAll == null) {
            this.btnMuteAll = new ImageLabel(ICON_MUTE_ALL);
            this.btnMuteAll.setFlatMode(true);
            this.btnMuteAll.setNormalBorderColor(null);
            this.btnMuteAll.setCursor(UIConstants.CURSOR_HAND);
            this.btnMuteAll.setToolTipText(I18NUtil.getString("conference_action_label_allmute"));
            this.btnMuteAll.setPreferredSize(new Dimension(48, 48));
            this.btnMuteAll.setMaximumSize(new Dimension(48, 48));
            this.btnMuteAll.setMinimumSize(new Dimension(48, 48));
            this.btnMuteAll.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    ConferenceChatroom.this._muteAll();
                }
            });
        }
        return this.btnMuteAll;
    }

    private ImageLabel getBtnLock() {
        if (this.btnLock == null) {
            this.btnLock = new ImageLabel(ICON_LOCK);
            this.btnLock.setFlatMode(true);
            this.btnLock.setNormalBorderColor(null);
            this.btnLock.setCursor(UIConstants.CURSOR_HAND);
            this.btnLock.setToolTipText(I18NUtil.getString("conference_action_label_lock"));
            this.btnLock.setPreferredSize(new Dimension(48, 48));
            this.btnLock.setMaximumSize(new Dimension(48, 48));
            this.btnLock.setMinimumSize(new Dimension(48, 48));
            this.btnLock.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    ConferenceChatroom.this._lock();
                }
            });
        }
        return this.btnLock;
    }

    public static enum ConfRoomLayoutMode {
        NO_MEMBER(IChatroom.ICON_LAYOUT_MEMBER, I18NUtil.getString("chatroom_btn_show_participant_list")),
        MEMBER(IChatroom.ICON_LAYOUT_NOMEMBER, I18NUtil.getString("chatroom_btn_hide_participant_list"));

        Icon icon;
        String toolTip;

        private ConfRoomLayoutMode(Icon icon, String toolTip) {
            this.icon = icon;
            this.toolTip = toolTip;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String getToolTip() {
            return this.toolTip;
        }
    }

    public static enum UnjoinedDisplayMode {
        CHAT_HISTORY,
        JOIN;

    }

    public static enum ChatMode {
        NORMAL,
        DISABLED,
        ONLY_PHONE,
        DELETE;

    }

    class ShowMeetmeMsgAction
    extends AbstractAction {
        boolean showText;

        public ShowMeetmeMsgAction(boolean showText) {
            this.showText = showText;
            if (showText) {
                this.putValue("Name", I18NUtil.getString("conference_btn_display_voice_action"));
            } else {
                this.putValue("ShortDescription", I18NUtil.getString("conference_btn_display_voice_action"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean isShow = PreferencesUtil.isMeetmeShowEnabled(UCChatClient.context, ConferenceChatroom.this.mRoomJid);
            if (isShow) {
                PreferencesUtil.removeFromMeetmeShowList(UCChatClient.context, ConferenceChatroom.this.mRoomJid);
                ConferenceChatroom.this.updateMeetmeShowAction(false);
            } else {
                PreferencesUtil.addToMeetmeShowList(UCChatClient.context, ConferenceChatroom.this.mRoomJid);
                ConferenceChatroom.this.updateMeetmeShowAction(true);
            }
            ToastUtil.show(UCChatClient.context, I18NUtil.getString("common_notice_update_success"), 10);
            BroadcastUtil.sendMsgChangedEvent(UCChatClient.context, ConferenceChatroom.this.mRoomJid);
            ConferenceChatroom.this.loadLast();
        }
    }

    class ChangeConferenceroomNameAction
    extends AbstractAction {
        boolean showText;

        public ChangeConferenceroomNameAction(boolean showText) {
            this.showText = showText;
            if (showText) {
                this.putValue("Name", I18NUtil.getString("conference_fun_update_name"));
            } else {
                this.putValue("ShortDescription", I18NUtil.getString("conference_fun_update_name"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ChatRoomInfo roomInfo = ChatRoomManager.getChatRoom(UCChatClient.context, ConferenceChatroom.this.mRoomJid);
                    String roomTitle = ChatRoomUtil.getConfRoomTitle(UCChatClient.context, roomInfo, ConferenceChatroom.this.meetmeRoom, false, false);
                    ChangeConferenceroomNamePanel ccnp = new ChangeConferenceroomNamePanel(ConferenceChatroom.this.mRoomJid, roomTitle);
                    UCChatClient.getInstance().showGlassPanel(ccnp, true);
                    ccnp.focusTextField();
                }
            });
        }
    }

    class ExitMeetmeAction
    extends AbstractAction {
        public ExitMeetmeAction(boolean showText) {
            if (showText) {
                this.putValue("Name", I18NUtil.getString("conference_btn_exit"));
            } else {
                this.putValue("ShortDescription", I18NUtil.getString("conference_btn_exit"));
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConferenceChatroom.doExitMeetmeAction(ConferenceChatroom.this.mRoomJid);
        }
    }

    class EndMeetmeAction
    extends AbstractAction {
        public EndMeetmeAction(boolean showText) {
            if (showText) {
                this.putValue("Name", I18NUtil.getString("conference_title_end"));
            } else {
                this.putValue("ShortDescription", I18NUtil.getString("conference_title_end"));
                this.putValue("SmallIcon", IChatroom.ICON_END);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConferenceChatroom.this.doEndMeetme();
        }
    }

    class MuteAllAction
    extends AbstractAction {
        boolean showText;

        public MuteAllAction(boolean showText) {
            this.showText = showText;
            if (showText) {
                this.putValue("Name", I18NUtil.getString("conference_action_label_allmute"));
            } else {
                this.putValue("ShortDescription", I18NUtil.getString("conference_action_label_allmute"));
                this.putValue("SmallIcon", IChatroom.ICON_MUTE_ALL);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConferenceChatroom.this._muteAll();
        }
    }

    class LockAction
    extends AbstractAction {
        boolean showText;

        public LockAction(boolean showText) {
            this.showText = showText;
            if (showText) {
                this.putValue("Name", I18NUtil.getString("conference_action_label_lock"));
            } else {
                this.putValue("ShortDescription", I18NUtil.getString("conference_action_label_lock"));
                this.putValue("SmallIcon", IChatroom.ICON_LOCK);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConferenceChatroom.this._lock();
        }
    }

    public static enum DisplayPage {
        JOIN,
        CHAT;

    }

    class MuteAction
    extends AbstractAction {
        public MuteAction(boolean showText) {
            if (showText) {
                this.putValue("Name", I18NUtil.getString("conference_action_label_mute"));
            } else {
                this.putValue("ShortDescription", I18NUtil.getString("conference_action_label_mute"));
                this.putValue("SmallIcon", IChatroom.ICON_MUTE);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ConferenceChatroom.this._mute();
        }
    }
}

