/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.roomimpl;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.chat.ChatroomType;
import com.blisscloud.ezuc.client.chat.DeleteService;
import com.blisscloud.ezuc.client.chat.IChatroom;
import com.blisscloud.ezuc.client.chat.action.DeleteFile;
import com.blisscloud.ezuc.client.chat.roomimpl.PageSizeItem;
import com.blisscloud.ezuc.client.chat.roomimpl.PhoneHistoryEntryPanel;
import com.blisscloud.ezuc.client.chat.roomimpl.PhoneHistoryEntryParameter;
import com.blisscloud.ezuc.client.chat.roomimpl.TimeType;
import com.blisscloud.ezuc.client.chat.roomimpl.TimeTypeSelectionRenderer;
import com.blisscloud.ezuc.client.component.GradientPanel;
import com.blisscloud.ezuc.client.component.HintTextField;
import com.blisscloud.ezuc.client.component.PersonalPhoto;
import com.blisscloud.ezuc.client.component.UCScrollPane;
import com.blisscloud.ezuc.client.inboundfilter.AddNumToInboundBlackListConfirmDialog;
import com.blisscloud.ezuc.client.outboundfilter.AddNumToOutboundBlackListConfirmDialog;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.DateTimeUtil;
import com.blisscloud.ezuc.client.util.QueryThread;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.ExternalCallMessage;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.db.UserDatabase;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.task.MarkPhoneRemoteReadTask;
import com.blisscloud.mobile.ezuc.manager.task.TaskController;
import com.blisscloud.mobile.ezuc.util.ApiVersion;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.toedter.calendar.JCalendar;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.apache.commons.lang3.StringUtils;

public class PhoneHistoryRoom
extends JPanel
implements IChatroom {
    private static final long serialVersionUID = -3678614081445217832L;
    private static final int TIME_TYPE_TIME_RANGE = 4;
    private static final int TIME_TYPE_WEEK = 3;
    private static final int TIME_TYPE_YESTERDAY = 2;
    private static final int TIME_TYPE_TODAY = 1;
    private static final int TIME_TYPE_NONE = 0;
    private String mJid;
    private long mTimestamp = System.currentTimeMillis();
    private JPanel panelHeader;
    private PersonalPhoto lblPhoto;
    private JLabel lblDisplayName;
    private JPanel panelDataTypeSelection;
    private JLabel labelDataType;
    private JCheckBox cbOutboundAnswered;
    private JCheckBox cbInboundAnswered;
    private JCheckBox cbOutboundCanceled;
    private JCheckBox cbInboundMissed;
    private JCheckBox cbRecording;
    private JCheckBox cbVoicemail;
    private JPanel panelNumberSearch;
    private JLabel labelNumber;
    private JTextField fieldNumber;
    private JPanel panelReportKeySearch;
    private JLabel labelReportKey;
    private JTextField fieldReportKey;
    private JPanel panelTimeSearch;
    private JLabel labelTime;
    private JComboBox<TimeType> cbTimeType;
    private DefaultComboBoxModel<TimeType> cbModelTimeType;
    private JPanel panelSearchOption;
    private JLabel labelSearchType;
    private JRadioButton optionKeySearchRadioBtn;
    private JRadioButton optionCondSearchRadioBtn;
    private ButtonGroup searchOptionGroup = new ButtonGroup();
    private JLabel startL;
    private JTextField startTimeField;
    private JComboBox<String> cbStartTime;
    private JLabel sep;
    private JLabel endL;
    private JTextField endTimeField;
    private JComboBox<String> cbEndTime;
    protected JCalendar jcalendar;
    protected JPopupMenu popup;
    protected boolean dateSelected;
    private ChangeListener changeListener;
    int calendarMode = 0;
    private Date mStartDate;
    private Date mEndDate;
    private boolean isNoContent = false;
    private JPanel panelContent;
    private JPanel noContentPanel;
    private JScrollPane spContentEntries;
    private JPanel panelBottom;
    private JLabel lblDataCount;
    private JComboBox<PageSizeItem> cbPageSize;
    private JLabel lblPageCount;
    private JLabel gotoPrev;
    private JLabel gotoNext;
    private JLabel gotoFirst;
    private JLabel gotoLast;
    private JPanel pageDisplay;
    private int currentPageIndex = 1;
    private boolean currentContactReportKeyDisp;
    private EntryPanelMouseListener epml = new EntryPanelMouseListener();
    private PhoneHistoryEntryPanel selectedEntryPanel;
    private PhoneHistoryEntryPanel menuDisplayedEntryPanel;
    private MyPopupMenuListener myPopupMenuListener = new MyPopupMenuListener();
    private HashSet<Long> newMsgIdSet = new HashSet();
    private String[] items = new String[]{"00:00", "00:30", "01:00", "01:30", "02:00", "02:30", "03:00", "03:30", "04:00", "04:30", "05:00", "05:30", "06:00", "06:30", "07:00", "07:30", "08:00", "08:30", "09:00", "09:30", "10:00", "10:30", "11:00", "11:30", "12:00", "12:30", "13:00", "13:30", "14:00", "14:30", "15:00", "15:30", "16:00", "16:30", "17:00", "17:30", "18:00", "18:30", "19:00", "19:30", "20:00", "20:30", "21:00", "21:30", "22:00", "22:30", "23:00", "23:30", "24:00"};
    private QueryThread queryThread = null;

    public PhoneHistoryRoom(String jid) {
        this.mJid = jid;
        this.queryThread = new QueryThread(UCChatClient.context, "PhoneHistoryRoom", new QueryThread.QueryListener(){

            @Override
            public void performAction() {
                try {
                    PhoneHistoryRoom.this.doSearch();
                }
                catch (Throwable t) {
                    Log.i(PhoneHistoryRoom.class.getName(), t.getMessage(), t);
                }
            }
        });
        this.queryThread.start();
        this.currentContactReportKeyDisp = PreferencesUtil.isContactReportKeyDisp(UCChatClient.context);
        this.initGUI();
        this.initData();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.setLayout(thisLayout);
            this.panelHeader = new GradientPanel(1, UIConstants.COLOR_HEADER_BACKGROUND_FROM, UIConstants.COLOR_HEADER_BACKGROUND_TO);
            this.add((Component)this.panelHeader, "North");
            GridBagLayout jPanel1Layout = new GridBagLayout();
            this.panelHeader.setLayout(jPanel1Layout);
            this.panelHeader.setBorder(UIConstants.BORDER_HEADER);
            this.lblPhoto = new PersonalPhoto();
            this.lblPhoto.setImage(UIConstants.ICON_EXTERNAL_CALL.getImage());
            this.panelHeader.add((Component)this.lblPhoto, new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblPhoto.setPreferredSize(new Dimension(64, 64));
            this.lblPhoto.setMinimumSize(new Dimension(64, 64));
            this.lblPhoto.setMaximumSize(new Dimension(64, 64));
            int gridSize = 8;
            this.lblDisplayName = new JLabel();
            this.panelHeader.add((Component)this.lblDisplayName, new GridBagConstraints(1, 0, gridSize, 1, 1.0, 0.0, 17, 0, new Insets(8, 15, 5, 0), 0, 0));
            this.lblDisplayName.setText(I18NUtil.getString("phone_history_label_external"));
            this.lblDisplayName.setFont(UIConstants.FONT_16_BOLD);
            int y = 1;
            this.labelSearchType = new JLabel();
            this.panelHeader.add((Component)this.labelSearchType, new GridBagConstraints(1, y, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 20, 0, 0), 0, 0));
            this.labelSearchType.setText(I18NUtil.getString("phone_history_label_search_type"));
            this.labelSearchType.setFont(UIConstants.FONT_12_BOLD);
            this.labelSearchType.setVisible(this.currentContactReportKeyDisp);
            this.panelSearchOption = new JPanel();
            this.panelSearchOption.setOpaque(false);
            this.panelSearchOption.setLayout(new FlowLayout(0));
            this.panelHeader.add((Component)this.panelSearchOption, new GridBagConstraints(2, y, gridSize, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 0), 0, 0));
            this.panelSearchOption.setVisible(this.currentContactReportKeyDisp);
            this.optionKeySearchRadioBtn = new JRadioButton();
            this.panelSearchOption.add(this.optionKeySearchRadioBtn);
            this.optionKeySearchRadioBtn.setText(String.format(I18NUtil.getString("phone_history_label_report_key_search"), I18NUtil.getAppName()));
            this.optionKeySearchRadioBtn.setOpaque(false);
            this.optionKeySearchRadioBtn.setSelected(false);
            this.optionKeySearchRadioBtn.setFont(UIConstants.FONT_12_PLAIN);
            this.searchOptionGroup.add(this.optionKeySearchRadioBtn);
            this.optionKeySearchRadioBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PhoneHistoryRoom.this.labelReportKey.setVisible(true);
                    PhoneHistoryRoom.this.panelReportKeySearch.setVisible(true);
                    PhoneHistoryRoom.this.labelDataType.setVisible(false);
                    PhoneHistoryRoom.this.panelDataTypeSelection.setVisible(false);
                    PhoneHistoryRoom.this.panelNumberSearch.setVisible(false);
                    PhoneHistoryRoom.this.labelNumber.setVisible(false);
                    PhoneHistoryRoom.this.panelTimeSearch.setVisible(false);
                    PhoneHistoryRoom.this.labelTime.setVisible(false);
                    PhoneHistoryRoom.this.researchData();
                }
            });
            this.optionCondSearchRadioBtn = new JRadioButton();
            this.panelSearchOption.add(this.optionCondSearchRadioBtn);
            this.optionCondSearchRadioBtn.setText(String.format(I18NUtil.getString("phone_history_label_cond_search"), I18NUtil.getAppName()));
            this.optionCondSearchRadioBtn.setOpaque(false);
            this.optionCondSearchRadioBtn.setSelected(true);
            this.optionCondSearchRadioBtn.setFont(UIConstants.FONT_12_PLAIN);
            this.searchOptionGroup.add(this.optionCondSearchRadioBtn);
            this.optionCondSearchRadioBtn.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PhoneHistoryRoom.this.labelReportKey.setVisible(false);
                    PhoneHistoryRoom.this.panelReportKeySearch.setVisible(false);
                    PhoneHistoryRoom.this.fieldReportKey.setText("");
                    PhoneHistoryRoom.this.labelDataType.setVisible(true);
                    PhoneHistoryRoom.this.panelDataTypeSelection.setVisible(true);
                    PhoneHistoryRoom.this.panelNumberSearch.setVisible(true);
                    PhoneHistoryRoom.this.labelNumber.setVisible(true);
                    PhoneHistoryRoom.this.panelTimeSearch.setVisible(true);
                    PhoneHistoryRoom.this.labelTime.setVisible(true);
                    PhoneHistoryRoom.this.researchData();
                }
            });
            this.labelDataType = new JLabel();
            this.labelDataType.setBackground(Color.GREEN);
            this.panelHeader.add((Component)this.labelDataType, new GridBagConstraints(1, ++y, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 20, 0, 0), 0, 0));
            this.labelDataType.setText(I18NUtil.getString("phone_history_label_datatype"));
            this.labelDataType.setFont(UIConstants.FONT_12_BOLD);
            this.panelDataTypeSelection = new JPanel();
            this.panelDataTypeSelection.setOpaque(false);
            this.panelDataTypeSelection.setLayout(new FlowLayout(0));
            this.panelHeader.add((Component)this.panelDataTypeSelection, new GridBagConstraints(2, y, gridSize, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 0), 0, 0));
            this.cbOutboundAnswered = new JCheckBox();
            this.panelDataTypeSelection.add(this.cbOutboundAnswered);
            this.cbOutboundAnswered.setText(String.format(I18NUtil.getString("phone_history_lable_datatype_outbound_answered"), I18NUtil.getAppName()));
            this.cbOutboundAnswered.setOpaque(false);
            this.cbOutboundAnswered.setFont(UIConstants.FONT_12_PLAIN);
            this.cbOutboundAnswered.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserDatabase database = UserDatabase.getDB(UCChatClient.context);
                    database.setDisplayPhoneHistoryOutboundAnsweredOn(PhoneHistoryRoom.this.cbOutboundAnswered.isSelected());
                    PhoneHistoryRoom.this.researchData();
                }
            });
            this.cbInboundAnswered = new JCheckBox();
            this.panelDataTypeSelection.add(this.cbInboundAnswered);
            this.cbInboundAnswered.setText(String.format(I18NUtil.getString("phone_history_lable_datatype_inbound_answered"), I18NUtil.getAppName()));
            this.cbInboundAnswered.setOpaque(false);
            this.cbInboundAnswered.setFont(UIConstants.FONT_12_PLAIN);
            this.cbInboundAnswered.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserDatabase database = UserDatabase.getDB(UCChatClient.context);
                    database.setDisplayPhoneHistoryInboundAnsweredOn(PhoneHistoryRoom.this.cbInboundAnswered.isSelected());
                    PhoneHistoryRoom.this.researchData();
                }
            });
            this.cbOutboundCanceled = new JCheckBox();
            this.panelDataTypeSelection.add(this.cbOutboundCanceled);
            this.cbOutboundCanceled.setText(String.format(I18NUtil.getString("phone_history_lable_datatype_outbound_canceled"), I18NUtil.getAppName()));
            this.cbOutboundCanceled.setOpaque(false);
            this.cbOutboundCanceled.setFont(UIConstants.FONT_12_PLAIN);
            this.cbOutboundCanceled.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserDatabase database = UserDatabase.getDB(UCChatClient.context);
                    database.setDisplayPhoneHistoryOutboundCanceledOn(PhoneHistoryRoom.this.cbOutboundCanceled.isSelected());
                    PhoneHistoryRoom.this.researchData();
                }
            });
            this.cbInboundMissed = new JCheckBox();
            this.panelDataTypeSelection.add(this.cbInboundMissed);
            this.cbInboundMissed.setText(String.format(I18NUtil.getString("phone_history_lable_datatype_inbound_missed"), I18NUtil.getAppName()));
            this.cbInboundMissed.setOpaque(false);
            this.cbInboundMissed.setFont(UIConstants.FONT_12_PLAIN);
            this.cbInboundMissed.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserDatabase database = UserDatabase.getDB(UCChatClient.context);
                    database.setDisplayPhoneHistoryInboundMissedOn(PhoneHistoryRoom.this.cbInboundMissed.isSelected());
                    PhoneHistoryRoom.this.researchData();
                }
            });
            this.cbRecording = new JCheckBox();
            this.panelDataTypeSelection.add(this.cbRecording);
            this.cbRecording.setText(String.format(I18NUtil.getString("phone_history_lable_datatype_recording"), I18NUtil.getAppName()));
            this.cbRecording.setOpaque(false);
            this.cbRecording.setFont(UIConstants.FONT_12_PLAIN);
            this.cbRecording.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserDatabase database = UserDatabase.getDB(UCChatClient.context);
                    database.setDisplayPhoneHistoryRecordingOn(PhoneHistoryRoom.this.cbRecording.isSelected());
                    PhoneHistoryRoom.this.researchData();
                }
            });
            this.cbVoicemail = new JCheckBox();
            this.panelDataTypeSelection.add(this.cbVoicemail);
            this.cbVoicemail.setText(String.format(I18NUtil.getString("phone_history_lable_datatype_voicemail"), I18NUtil.getAppName()));
            this.cbVoicemail.setOpaque(false);
            this.cbVoicemail.setFont(UIConstants.FONT_12_PLAIN);
            this.cbVoicemail.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    UserDatabase database = UserDatabase.getDB(UCChatClient.context);
                    database.setDisplayPhoneHistoryVoicemailOn(PhoneHistoryRoom.this.cbVoicemail.isSelected());
                    PhoneHistoryRoom.this.researchData();
                }
            });
            this.labelReportKey = new JLabel();
            this.panelHeader.add((Component)this.labelReportKey, new GridBagConstraints(1, ++y, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 20, 0, 0), 0, 0));
            this.labelReportKey.setText(I18NUtil.getString("phone_history_label_report_key"));
            this.labelReportKey.setFont(UIConstants.FONT_12_BOLD);
            this.labelReportKey.setVisible(this.currentContactReportKeyDisp && this.optionKeySearchRadioBtn.isSelected());
            this.panelReportKeySearch = new JPanel();
            this.panelReportKeySearch.setOpaque(false);
            this.panelReportKeySearch.setLayout(new FlowLayout(0));
            this.panelHeader.add((Component)this.panelReportKeySearch, new GridBagConstraints(2, y, gridSize, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 0), 0, 0));
            this.panelReportKeySearch.setVisible(this.currentContactReportKeyDisp && this.optionKeySearchRadioBtn.isSelected());
            this.fieldReportKey = new JTextField(12);
            this.panelReportKeySearch.add(this.fieldReportKey);
            this.labelTime = new JLabel();
            this.panelHeader.add((Component)this.labelTime, new GridBagConstraints(1, ++y, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 20, 0, 0), 0, 0));
            this.labelTime.setText(I18NUtil.getString("phone_history_label_time"));
            this.labelTime.setFont(UIConstants.FONT_12_BOLD);
            this.labelTime.setVisible(this.optionCondSearchRadioBtn.isSelected());
            this.panelTimeSearch = new JPanel();
            this.panelTimeSearch.setOpaque(false);
            this.panelTimeSearch.setLayout(new FlowLayout(0));
            this.panelHeader.add((Component)this.panelTimeSearch, new GridBagConstraints(2, y, gridSize, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 0), 0, 0));
            this.panelTimeSearch.setVisible(this.optionCondSearchRadioBtn.isSelected());
            this.cbModelTimeType = new DefaultComboBoxModel();
            this.cbModelTimeType.addElement(new TimeType(0, " "));
            this.cbModelTimeType.addElement(new TimeType(1, I18NUtil.getString("phone_history_label_time_type_today")));
            this.cbModelTimeType.addElement(new TimeType(2, I18NUtil.getString("phone_history_label_time_type_yesterday")));
            this.cbModelTimeType.addElement(new TimeType(3, I18NUtil.getString("phone_history_label_time_type_this_week")));
            this.cbModelTimeType.addElement(new TimeType(4, I18NUtil.getString("phone_history_label_time_type_time_range")));
            this.cbTimeType = new JComboBox();
            this.panelTimeSearch.add(this.cbTimeType);
            this.cbTimeType.setFont(UIConstants.FONT_12_PLAIN);
            this.cbTimeType.setModel(this.cbModelTimeType);
            this.cbTimeType.setRenderer(new TimeTypeSelectionRenderer());
            this.startL = new JLabel();
            this.startL.setVisible(false);
            this.startL.setText(I18NUtil.getString("phone_history_label_start_time"));
            this.panelTimeSearch.add(this.startL);
            this.startTimeField = new JTextField(7);
            this.startTimeField.setVisible(false);
            this.startTimeField.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (PhoneHistoryRoom.this.cbTimeType.getSelectedIndex() == 4) {
                        PhoneHistoryRoom.this.startTimeFieldMouseClicked(evt);
                    }
                }
            });
            this.panelTimeSearch.add(this.startTimeField);
            this.cbStartTime = new JComboBox<String>(this.items);
            this.cbStartTime.setVisible(false);
            this.cbStartTime.setFont(UIConstants.FONT_12_PLAIN);
            this.panelTimeSearch.add(this.cbStartTime);
            this.cbStartTime.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PhoneHistoryRoom.this.researchData();
                }
            });
            this.sep = new JLabel();
            this.sep.setVisible(false);
            this.sep.setText("~");
            this.panelTimeSearch.add(this.sep);
            this.endL = new JLabel();
            this.endL.setVisible(false);
            this.endL.setText(I18NUtil.getString("phone_history_label_end_time"));
            this.panelTimeSearch.add(this.endL);
            this.endTimeField = new JTextField(7);
            this.endTimeField.setVisible(false);
            this.endTimeField.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    if (PhoneHistoryRoom.this.cbTimeType.getSelectedIndex() == 4) {
                        PhoneHistoryRoom.this.endTimeFieldMouseClicked(evt);
                    }
                }
            });
            this.panelTimeSearch.add(this.endTimeField);
            this.cbEndTime = new JComboBox<String>(this.items);
            this.cbEndTime.setVisible(false);
            this.cbEndTime.setFont(UIConstants.FONT_12_PLAIN);
            this.panelTimeSearch.add(this.cbEndTime);
            this.cbEndTime.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PhoneHistoryRoom.this.researchData();
                }
            });
            this.labelNumber = new JLabel();
            this.panelHeader.add((Component)this.labelNumber, new GridBagConstraints(1, ++y, 1, 1, 0.0, 0.0, 13, 0, new Insets(2, 20, 0, 0), 0, 0));
            this.labelNumber.setText(I18NUtil.getString("phone_history_label_number"));
            this.labelNumber.setFont(UIConstants.FONT_12_BOLD);
            this.labelNumber.setVisible(this.optionCondSearchRadioBtn.isSelected());
            this.panelNumberSearch = new JPanel();
            this.panelNumberSearch.setOpaque(false);
            this.panelNumberSearch.setLayout(new FlowLayout(0));
            this.panelHeader.add((Component)this.panelNumberSearch, new GridBagConstraints(2, y, 1, 1, 1.0, 0.0, 17, 2, new Insets(2, 5, 0, 0), 0, 0));
            this.panelNumberSearch.setVisible(this.optionCondSearchRadioBtn.isSelected());
            this.fieldNumber = new JTextField(12);
            this.panelNumberSearch.add(this.fieldNumber);
            this.spContentEntries = new UCScrollPane(60);
            this.add((Component)this.spContentEntries, "Center");
            this.panelContent = new JPanel();
            BoxLayout panelContentEntriesLayout = new BoxLayout(this.panelContent, 1);
            this.panelContent.setLayout(panelContentEntriesLayout);
            this.panelContent.setBackground(Color.WHITE);
            this.spContentEntries.setViewportView(this.panelContent);
            this.noContentPanel = new JPanel();
            BorderLayout bLayout2 = new BorderLayout();
            this.noContentPanel.setLayout(bLayout2);
            this.noContentPanel.setOpaque(true);
            this.noContentPanel.setBackground(Color.WHITE);
            this.noContentPanel.setMinimumSize(new Dimension(100, 100));
            this.noContentPanel.setPreferredSize(new Dimension(100, 100));
            JLabel noContentLabel = new JLabel();
            noContentLabel.setOpaque(true);
            noContentLabel.setBackground(Color.WHITE);
            noContentLabel.setHorizontalAlignment(0);
            noContentLabel.setText(I18NUtil.getString("common_no_item_all"));
            noContentLabel.setForeground(Color.LIGHT_GRAY);
            noContentLabel.setFont(UIConstants.FONT_16_BOLD);
            this.noContentPanel.add((Component)noContentLabel, "Center");
            this.panelBottom = new GradientPanel(1, UIConstants.COLOR_HEADER_BACKGROUND_TO, UIConstants.COLOR_HEADER_BACKGROUND_FROM);
            this.add((Component)this.panelBottom, "South");
            this.panelBottom.setLayout(new BorderLayout());
            this.panelBottom.setBorder(UIConstants.BORDER_HEADER);
            this.lblDataCount = new JLabel();
            this.panelBottom.add((Component)this.lblDataCount, "West");
            this.lblDataCount.setText(String.format(I18NUtil.getString("phone_history_label_count"), String.valueOf(0)));
            this.lblDataCount.setFont(UIConstants.FONT_12_PLAIN);
            JPanel panel = new JPanel();
            panel.setLayout(new FlowLayout(1));
            panel.setOpaque(false);
            this.panelBottom.add((Component)panel, "Center");
            this.gotoFirst = new JLabel();
            this.gotoFirst.setEnabled(false);
            this.gotoFirst.setCursor(UIConstants.CURSOR_HAND);
            this.gotoFirst.setIcon(UIConstants.ICON_GOTO_FIRST);
            panel.add(this.gotoFirst);
            this.gotoFirst.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    PhoneHistoryRoom.this.currentPageIndex = 1;
                    PhoneHistoryRoom.this.researchData();
                }
            });
            this.gotoPrev = new JLabel();
            this.gotoPrev.setEnabled(false);
            this.gotoPrev.setCursor(UIConstants.CURSOR_HAND);
            this.gotoPrev.setIcon(UIConstants.ICON_GOTO_PREV);
            panel.add(this.gotoPrev);
            this.gotoPrev.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    --PhoneHistoryRoom.this.currentPageIndex;
                    PhoneHistoryRoom.this.researchData();
                }
            });
            this.pageDisplay = new JPanel();
            this.pageDisplay.setOpaque(false);
            this.pageDisplay.setLayout(new FlowLayout(1));
            panel.add(this.pageDisplay);
            this.gotoNext = new JLabel();
            this.gotoNext.setEnabled(false);
            this.gotoNext.setCursor(UIConstants.CURSOR_HAND);
            this.gotoNext.setIcon(UIConstants.ICON_GOTO_NEXT);
            panel.add(this.gotoNext);
            this.gotoNext.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    ++PhoneHistoryRoom.this.currentPageIndex;
                    PhoneHistoryRoom.this.researchData();
                }
            });
            this.gotoLast = new JLabel();
            this.gotoLast.setEnabled(false);
            this.gotoLast.setCursor(UIConstants.CURSOR_HAND);
            this.gotoLast.setIcon(UIConstants.ICON_GOTO_LAST);
            panel.add(this.gotoLast);
            this.gotoLast.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    PhoneHistoryRoom.this.currentPageIndex = -100;
                    PhoneHistoryRoom.this.researchData();
                }
            });
            ArrayList<PageSizeItem> pageItemList = new ArrayList<PageSizeItem>();
            pageItemList.add(new PageSizeItem(15, String.format(I18NUtil.getString("phone_history_label_page_size"), "15")));
            pageItemList.add(new PageSizeItem(30, String.format(I18NUtil.getString("phone_history_label_page_size"), "30")));
            pageItemList.add(new PageSizeItem(50, String.format(I18NUtil.getString("phone_history_label_page_size"), "50")));
            this.cbPageSize = new JComboBox<PageSizeItem>(pageItemList.toArray(new PageSizeItem[pageItemList.size()]));
            this.cbPageSize.setVisible(false);
            panel.add(this.cbPageSize);
            this.cbPageSize.setFont(UIConstants.FONT_12_PLAIN);
            this.lblPageCount = new JLabel();
            this.lblPageCount.setVisible(false);
            panel.add(this.lblPageCount);
            this.lblPageCount.setText(String.format(I18NUtil.getString("phone_history_label_total_page"), String.valueOf(0)));
            this.lblPageCount.setFont(UIConstants.FONT_12_PLAIN);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void researchData() {
        if (this.queryThread != null) {
            this.queryThread.requestRefreshFast();
        }
    }

    private void initData() {
        UserDatabase database = UserDatabase.getDB(UCChatClient.context);
        this.cbOutboundAnswered.setSelected(database.isDisplayPhoneHistoryOutboundAnsweredOn());
        this.cbInboundAnswered.setSelected(database.isDisplayPhoneHistoryInboundAnsweredOn());
        this.cbOutboundCanceled.setSelected(database.isDisplayPhoneHistoryOutboundCanceledOn());
        this.cbInboundMissed.setSelected(database.isDisplayPhoneHistoryInboundMissedOn());
        this.cbRecording.setSelected(database.isDisplayPhoneHistoryRecordingOn());
        this.cbVoicemail.setSelected(database.isDisplayPhoneHistoryVoicemailOn());
        int dateType = database.getDisplayPhoneHistoryTimeType();
        this.handleTimeTypeSelection(dateType);
        this.cbTimeType.setSelectedIndex(dateType);
        this.cbTimeType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PhoneHistoryRoom.this.popup != null && PhoneHistoryRoom.this.popup.isVisible()) {
                    PhoneHistoryRoom.this.popup.setVisible(false);
                }
                int selectedIndex = PhoneHistoryRoom.this.cbTimeType.getSelectedIndex();
                UserDatabase database = UserDatabase.getDB(UCChatClient.context);
                database.setDisplayPhoneHistoryTimeType(selectedIndex);
                PhoneHistoryRoom.this.handleTimeTypeSelection(selectedIndex);
                PhoneHistoryRoom.this.researchData();
            }
        });
        this.fieldReportKey.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PhoneHistoryRoom.this.researchData();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PhoneHistoryRoom.this.researchData();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.fieldNumber.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                PhoneHistoryRoom.this.researchData();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                PhoneHistoryRoom.this.researchData();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
        int cbPageSizeIndex = database.getDisplayPhoneHistoryPageSize();
        this.cbPageSize.setSelectedIndex(cbPageSizeIndex);
        this.cbPageSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int selectedIndex = PhoneHistoryRoom.this.cbPageSize.getSelectedIndex();
                UserDatabase database = UserDatabase.getDB(UCChatClient.context);
                database.setDisplayPhoneHistoryPageSize(selectedIndex);
                PhoneHistoryRoom.this.currentPageIndex = 1;
                PhoneHistoryRoom.this.researchData();
            }
        });
    }

    private void handleTimeTypeSelection(int selectedIndex) {
        boolean showDateRangeBar = true;
        boolean enableDateRangeBar = false;
        switch (selectedIndex) {
            case 0: {
                showDateRangeBar = false;
                this.setStartDate(null);
                this.setEndDate(null);
                break;
            }
            case 1: {
                Calendar cal = this.getToday();
                this.setStartDate(cal.getTime());
                this.setEndDate(cal.getTime());
                this.cbStartTime.setSelectedItem("00:00");
                this.cbEndTime.setSelectedItem("24:00");
                break;
            }
            case 2: {
                Calendar cal = this.getToday();
                cal.add(5, -1);
                this.setStartDate(cal.getTime());
                this.setEndDate(cal.getTime());
                this.cbStartTime.setSelectedItem("00:00");
                this.cbEndTime.setSelectedItem("24:00");
                break;
            }
            case 3: {
                Calendar cal = this.getToday();
                this.setEndDate(cal.getTime());
                cal.add(5, -7);
                this.setStartDate(cal.getTime());
                this.cbStartTime.setSelectedItem("00:00");
                this.cbEndTime.setSelectedItem("24:00");
                break;
            }
            case 4: {
                enableDateRangeBar = true;
                Calendar cal = this.getToday();
                this.setEndDate(cal.getTime());
                cal.add(5, -3);
                this.setStartDate(cal.getTime());
                this.cbStartTime.setSelectedItem("00:00");
                this.cbEndTime.setSelectedItem("24:00");
                break;
            }
        }
        if (this.startL != null) {
            this.startL.setVisible(showDateRangeBar);
        }
        if (this.startTimeField != null) {
            this.startTimeField.setVisible(showDateRangeBar);
            this.startTimeField.setEnabled(enableDateRangeBar);
        }
        if (this.cbStartTime != null) {
            this.cbStartTime.setVisible(showDateRangeBar);
            this.cbStartTime.setEnabled(enableDateRangeBar);
        }
        if (this.sep != null) {
            this.sep.setVisible(showDateRangeBar);
        }
        if (this.endL != null) {
            this.endL.setVisible(showDateRangeBar);
        }
        if (this.endTimeField != null) {
            this.endTimeField.setVisible(showDateRangeBar);
            this.endTimeField.setEnabled(enableDateRangeBar);
        }
        if (this.cbEndTime != null) {
            this.cbEndTime.setVisible(showDateRangeBar);
            this.cbEndTime.setEnabled(enableDateRangeBar);
        }
    }

    private void doSearch() {
        String myJid = PreferencesUtil.getUserJid(UCChatClient.context);
        List<Long[]> msgIdList = ChatRoomManager.findUnreadPhoneMsgIds(UCChatClient.context, myJid);
        for (int i = 0; msgIdList != null && i < msgIdList.size(); ++i) {
            Long[] id = msgIdList.get(i);
            this.newMsgIdSet.add(id[0]);
        }
        this.remarkAllUnreadMsg();
        ArrayList<Integer> callTypeList = new ArrayList<Integer>();
        if (this.cbOutboundAnswered.isSelected()) {
            callTypeList.add(221);
        }
        if (this.cbOutboundCanceled.isSelected()) {
            callTypeList.add(222);
        }
        if (this.cbInboundAnswered.isSelected()) {
            callTypeList.add(223);
        }
        if (this.cbInboundMissed.isSelected()) {
            callTypeList.add(225);
        }
        if (this.cbRecording.isSelected()) {
            callTypeList.add(1006);
            callTypeList.add(13);
        }
        if (this.cbVoicemail.isSelected()) {
            callTypeList.add(1005);
            callTypeList.add(12);
        }
        int pageSize = this.cbPageSize != null ? ((PageSizeItem)this.cbPageSize.getSelectedItem()).getSize() : 15;
        int count = 0;
        int totalPageCont = 0;
        long targetNo = -1L;
        String number = null;
        Date qStartTime = null;
        Date qEndTime = null;
        if (this.currentContactReportKeyDisp && this.optionKeySearchRadioBtn.isSelected()) {
            String key = this.fieldReportKey.getText();
            if (StringUtils.isNotBlank((CharSequence)key)) {
                try {
                    targetNo = Long.parseLong(key);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            count = targetNo > 0L ? UCDBMessage.countExternalCallMsgList(UCChatClient.context, targetNo) : 0;
            totalPageCont = count / pageSize + (count % pageSize > 0 ? 1 : 0);
        } else {
            SimpleDateFormat timeformatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            if (this.startTimeField.getText() != null && !TextUtils.isEmpty((CharSequence)this.startTimeField.getText().trim())) {
                try {
                    qStartTime = timeformatter.parse(this.startTimeField.getText().trim() + " " + String.valueOf(this.cbStartTime.getSelectedItem()));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    this.startTimeField.setText("");
                }
            }
            if (this.endTimeField.getText() != null && !TextUtils.isEmpty((CharSequence)this.endTimeField.getText().trim())) {
                try {
                    qEndTime = timeformatter.parse(this.endTimeField.getText().trim() + " " + String.valueOf(this.cbEndTime.getSelectedItem()));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                    this.endTimeField.setText("");
                }
            }
            number = this.fieldNumber.getText();
            count = UCDBMessage.countExternalCallMsgList(UCChatClient.context, callTypeList, number, qStartTime, qEndTime);
            totalPageCont = count / pageSize + (count % pageSize > 0 ? 1 : 0);
        }
        final int[] pageRange = PhoneHistoryRoom.getPageRange(this.currentPageIndex, totalPageCont);
        if (this.currentPageIndex == -100) {
            this.currentPageIndex = totalPageCont;
        } else if (this.currentPageIndex <= 0) {
            this.currentPageIndex = 1;
        } else if (this.currentPageIndex > totalPageCont) {
            this.currentPageIndex = totalPageCont;
        }
        this.lblDataCount.setText(String.format(I18NUtil.getString("phone_history_label_count"), String.valueOf(count)));
        this.lblPageCount.setText(String.format(I18NUtil.getString("phone_history_label_total_page"), String.valueOf(totalPageCont)));
        this.lblPageCount.setVisible(count > 0);
        this.cbPageSize.setVisible(count > 0);
        if (count > 0) {
            if (this.currentPageIndex != 1) {
                this.gotoFirst.setEnabled(true);
                this.gotoPrev.setEnabled(true);
            } else {
                this.gotoFirst.setEnabled(false);
                this.gotoPrev.setEnabled(false);
            }
            if (this.currentPageIndex != totalPageCont) {
                this.gotoLast.setEnabled(true);
                this.gotoNext.setEnabled(true);
            } else {
                this.gotoLast.setEnabled(false);
                this.gotoNext.setEnabled(false);
            }
            this.pageDisplay.setVisible(true);
            this.gotoFirst.setVisible(true);
            this.gotoPrev.setVisible(true);
            this.gotoLast.setVisible(true);
            this.gotoNext.setVisible(true);
        } else {
            this.pageDisplay.setVisible(false);
            this.gotoFirst.setVisible(false);
            this.gotoPrev.setVisible(false);
            this.gotoLast.setVisible(false);
            this.gotoNext.setVisible(false);
        }
        final List<ExternalCallMessage> msgList = this.currentContactReportKeyDisp && this.optionKeySearchRadioBtn.isSelected() ? (count > 0 ? UCDBMessage.findExternalCallMsgList(UCChatClient.context, targetNo, this.currentPageIndex, pageSize) : null) : (count > 0 ? UCDBMessage.findExternalCallMsgList(UCChatClient.context, callTypeList, number, qStartTime, qEndTime, this.currentPageIndex, pageSize) : null);
        if (count == 0) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (!PhoneHistoryRoom.this.isNoContent) {
                        PhoneHistoryRoom.this.showNoContent();
                    }
                    PhoneHistoryRoom.this.cleanPhoneHistory();
                }
            });
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PhoneHistoryRoom.this.pageDisplay.removeAll();
                    for (int i = pageRange[0]; i <= pageRange[1]; ++i) {
                        JLabel sp = new JLabel();
                        sp.setText("|");
                        PhoneHistoryRoom.this.pageDisplay.add(sp);
                        if (PhoneHistoryRoom.this.currentPageIndex == i) {
                            JLabel sp2 = new JLabel();
                            sp2.setText("<HTML><FONT color=\"red\">" + String.valueOf(i) + "</FONT></HTML>");
                            PhoneHistoryRoom.this.pageDisplay.add(sp2);
                            sp2.setFont(UIConstants.FONT_14_BOLD);
                            continue;
                        }
                        JButton b = new JButton();
                        b.setBorderPainted(false);
                        b.setContentAreaFilled(false);
                        b.setOpaque(false);
                        b.setName(String.valueOf(i));
                        b.setText("<HTML><FONT color=\"black\"><U>" + String.valueOf(i) + "</U></FONT></HTML>");
                        b.setFocusPainted(false);
                        b.setCursor(UIConstants.CURSOR_HAND);
                        b.setBorder(new EmptyBorder(0, 0, 0, 0));
                        b.addActionListener(new ActionListener(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                JButton cb = (JButton)e.getSource();
                                PhoneHistoryRoom.this.currentPageIndex = Integer.valueOf(cb.getName());
                                PhoneHistoryRoom.this.researchData();
                            }
                        });
                        PhoneHistoryRoom.this.pageDisplay.add(b);
                    }
                    JLabel sp = new JLabel();
                    sp.setText("|");
                    PhoneHistoryRoom.this.pageDisplay.add(sp);
                    PhoneHistoryRoom.this.pageDisplay.revalidate();
                    PhoneHistoryRoom.this.pageDisplay.getParent().repaint();
                    if (PhoneHistoryRoom.this.isNoContent) {
                        PhoneHistoryRoom.this.hideNoContent();
                    }
                    if (msgList != null) {
                        ExternalCallMessage msg;
                        int i;
                        Set<Long> oldHistoryIDs = PhoneHistoryRoom.this.getPhoneHistoryIDs();
                        HashSet<Long> unchangedHistoryIDs = new HashSet<Long>(oldHistoryIDs);
                        Set<Long> newHistoryIDs = PhoneHistoryRoom.this.getPhoneHistoryIDs(msgList);
                        unchangedHistoryIDs.retainAll(newHistoryIDs);
                        newHistoryIDs.removeAll(unchangedHistoryIDs);
                        oldHistoryIDs.removeAll(unchangedHistoryIDs);
                        for (Long oldHistoryID : oldHistoryIDs) {
                            PhoneHistoryRoom.this.removePhoneHistory(oldHistoryID);
                        }
                        PhoneHistoryEntryParameter phoneHistoryEntryParameter = new PhoneHistoryEntryParameter();
                        for (i = 0; msgList != null && i < msgList.size(); ++i) {
                            msg = (ExternalCallMessage)msgList.get(i);
                            FontMetrics metrics = new FontMetrics(UIConstants.FONT_14_PLAIN){};
                            Object reportKey = "";
                            if (msg.getContactRecordId() != null && msg.getContactRecordId() > 0L) {
                                reportKey = "" + msg.getContactRecordId();
                            }
                            String statusText = msg.getTargetSuffix();
                            String phoneNum = msg.getTargetPhoneNumber();
                            String durationText = msg.getTargetDuration();
                            String errorText = "";
                            String timeDisp = DateTimeUtil.getTimeStr(msg.getTargetStartTime(), true);
                            Rectangle2D timeBounds = metrics.getStringBounds(timeDisp, null);
                            int timeWidthInPixels = (int)timeBounds.getWidth();
                            phoneHistoryEntryParameter.setMaxTimeLength(Math.max(phoneHistoryEntryParameter.getMaxTimeLength(), timeWidthInPixels));
                            Rectangle2D reportKeyBounds = metrics.getStringBounds((String)reportKey, null);
                            int reportKeyWidthInPixels = (int)reportKeyBounds.getWidth();
                            phoneHistoryEntryParameter.setMaxReportKeyLength(Math.max(phoneHistoryEntryParameter.getMaxReportKeyLength(), reportKeyWidthInPixels));
                            Rectangle2D statusBounds = metrics.getStringBounds(statusText, null);
                            int statusWidthInPixels = (int)statusBounds.getWidth();
                            phoneHistoryEntryParameter.setMaxStatusLength(Math.max(phoneHistoryEntryParameter.getMaxStatusLength(), statusWidthInPixels));
                            Rectangle2D phoneNumBounds = metrics.getStringBounds(phoneNum, null);
                            int phoneNumWidthInPixels = (int)phoneNumBounds.getWidth();
                            phoneHistoryEntryParameter.setMaxPhoneNumberLength(Math.max(phoneHistoryEntryParameter.getMaxPhoneNumberLength(), phoneNumWidthInPixels));
                            Rectangle2D errorBounds = metrics.getStringBounds(errorText, null);
                            int errorWidthInPixels = (int)errorBounds.getWidth();
                            phoneHistoryEntryParameter.setMaxErrorLength(Math.max(phoneHistoryEntryParameter.getMaxErrorLength(), errorWidthInPixels));
                            Rectangle2D durationBounds = metrics.getStringBounds(durationText, null);
                            int durationWidthInPixels = (int)durationBounds.getWidth();
                            phoneHistoryEntryParameter.setMaxDurationLength(Math.max(phoneHistoryEntryParameter.getMaxDurationLength(), durationWidthInPixels));
                        }
                        for (i = 0; msgList != null && i < msgList.size(); ++i) {
                            msg = (ExternalCallMessage)msgList.get(i);
                            Long id = msg.getId();
                            if (unchangedHistoryIDs.contains(id)) {
                                PhoneHistoryRoom.this.movePhoneHistory(msg, phoneHistoryEntryParameter, i);
                                continue;
                            }
                            if (!newHistoryIDs.contains(id)) continue;
                            PhoneHistoryRoom.this.insertPhoneHistory(msg, phoneHistoryEntryParameter, i);
                        }
                        PhoneHistoryRoom.this.panelContent.revalidate();
                        PhoneHistoryRoom.this.panelContent.repaint();
                    }
                }
            });
        }
        if (this.selectedEntryPanel != null && this.selectedEntryPanel.getParent() == null) {
            this.selectedEntryPanel = null;
        }
        if (this.menuDisplayedEntryPanel != null && this.menuDisplayedEntryPanel.getParent() == null) {
            this.menuDisplayedEntryPanel = null;
        }
    }

    private void remarkAllUnreadMsg() {
        Activity ctx = UCChatClient.context;
        MarkPhoneRemoteReadTask t = new MarkPhoneRemoteReadTask(ctx);
        TaskController.getInstance().addTask(t);
        t.start();
    }

    private void insertPhoneHistory(ExternalCallMessage msg, PhoneHistoryEntryParameter phoneHistoryEntryParameter, int index) {
        PhoneHistoryEntryPanel chep = new PhoneHistoryEntryPanel(msg, this.newMsgIdSet.contains(msg.getId()), phoneHistoryEntryParameter);
        chep.setAlignmentX(0.0f);
        chep.setSelected(false);
        chep.addMouseListener(this.epml);
        this.panelContent.add((Component)chep, index);
        if (this.panelContent.getComponentCount() != 0) {
            this.hideNoContent();
        }
    }

    private void movePhoneHistory(ExternalCallMessage msg, PhoneHistoryEntryParameter phoneHistoryEntryParameter, int index) {
        PhoneHistoryEntryPanel chep = this.getPhoneHistoryEntryPanel(msg.getId());
        if (chep != null) {
            chep.updatePhoneHistory(msg, this.newMsgIdSet.contains(msg.getId()), phoneHistoryEntryParameter);
            boolean selected = chep.isSelected();
            this.panelContent.remove(chep);
            this.panelContent.add((Component)chep, index);
            chep.setSelected(selected);
        }
    }

    private void removePhoneHistory(Long id) {
        PhoneHistoryEntryPanel chep = this.getPhoneHistoryEntryPanel(id);
        if (chep != null) {
            if (this.selectedEntryPanel == chep) {
                this.selectedEntryPanel = null;
            }
            if (this.menuDisplayedEntryPanel == chep) {
                this.menuDisplayedEntryPanel = null;
            }
            this.panelContent.remove(chep);
            if (this.panelContent.getComponentCount() == 0) {
                this.showNoContent();
            }
            chep.removeMouseListener(this.epml);
        }
    }

    private Set<Long> getPhoneHistoryIDs() {
        Component[] comps;
        HashSet<Long> ids = new HashSet<Long>();
        for (Component comp : comps = this.panelContent.getComponents()) {
            if (!(comp instanceof PhoneHistoryEntryPanel)) continue;
            PhoneHistoryEntryPanel chep = (PhoneHistoryEntryPanel)comp;
            ids.add(chep.getId());
        }
        return ids;
    }

    private Set<Long> getPhoneHistoryIDs(List<ExternalCallMessage> phoneHistoryList) {
        HashSet<Long> ret = new HashSet<Long>();
        for (Message message : phoneHistoryList) {
            ret.add(message.getId());
        }
        return ret;
    }

    private void cleanPhoneHistory() {
        Component[] comps;
        this.menuDisplayedEntryPanel = null;
        this.selectedEntryPanel = null;
        for (Component comp : comps = this.panelContent.getComponents()) {
            if (!(comp instanceof PhoneHistoryEntryPanel)) continue;
            PhoneHistoryEntryPanel chep = (PhoneHistoryEntryPanel)comp;
            chep.removeMouseListener(this.epml);
        }
        this.panelContent.removeAll();
        this.panelContent.revalidate();
        this.panelContent.repaint();
    }

    private void showNoContent() {
        this.isNoContent = true;
        this.remove(this.spContentEntries);
        this.add((Component)this.noContentPanel, "Center");
        this.revalidate();
        this.repaint();
    }

    private void hideNoContent() {
        this.isNoContent = false;
        this.remove(this.noContentPanel);
        this.add((Component)this.spContentEntries, "Center");
        this.revalidate();
        this.repaint();
    }

    private static int[] getPageRange(int currentIndex, int totalPage) {
        int fromPageIndex = 1;
        int toPageIndex = 1;
        int displaySize = 10;
        int preSize = 4;
        if (totalPage <= displaySize) {
            fromPageIndex = 1;
            toPageIndex = totalPage;
        } else {
            fromPageIndex = currentIndex - preSize > 0 ? currentIndex - preSize : 1;
            if (fromPageIndex + displaySize - 1 < totalPage) {
                toPageIndex = fromPageIndex + displaySize - 1;
            } else {
                toPageIndex = totalPage;
                fromPageIndex = toPageIndex - displaySize + 1;
            }
        }
        return new int[]{fromPageIndex, toPageIndex};
    }

    private Calendar getToday() {
        Calendar cal = Calendar.getInstance();
        cal.set(10, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal;
    }

    private void startTimeFieldMouseClicked(MouseEvent evt) {
        if (this.jcalendar == null) {
            this.initJCalendar();
        }
        int x = 0;
        int y = this.startTimeField.getHeight();
        this.calendarMode = 0;
        Calendar calendar = Calendar.getInstance();
        if (this.mStartDate != null) {
            calendar.setTime(this.mStartDate);
        }
        this.jcalendar.setCalendar(calendar);
        this.popup.show(this.startTimeField, x, y);
        this.dateSelected = false;
    }

    private void endTimeFieldMouseClicked(MouseEvent evt) {
        if (this.jcalendar == null) {
            this.initJCalendar();
        }
        int x = 0;
        int y = this.endTimeField.getHeight();
        this.calendarMode = 1;
        Calendar calendar = Calendar.getInstance();
        if (this.mEndDate != null) {
            calendar.setTime(this.mEndDate);
        }
        this.jcalendar.setCalendar(calendar);
        this.popup.show(this.endTimeField, x, y);
        this.dateSelected = false;
    }

    private void setDate(Date date) {
        if (this.calendarMode == 0) {
            this.setStartDate(date);
        } else {
            this.setEndDate(date);
        }
        this.researchData();
    }

    private void setStartDate(Date date) {
        this.mStartDate = date;
        if (this.mStartDate == null) {
            this.startTimeField.setForeground(HintTextField.HINT_COLOR);
            this.startTimeField.setText("");
        } else {
            this.startTimeField.setForeground(UIManager.getColor("Label.foreground"));
            this.startTimeField.setText(DateTimeUtil.getBirthdayTimeStr(this.mStartDate));
        }
    }

    private void setEndDate(Date date) {
        this.mEndDate = date;
        if (this.mEndDate == null) {
            this.endTimeField.setForeground(HintTextField.HINT_COLOR);
            this.endTimeField.setText("");
        } else {
            this.endTimeField.setForeground(UIManager.getColor("Label.foreground"));
            this.endTimeField.setText(DateTimeUtil.getBirthdayTimeStr(this.mEndDate));
        }
    }

    private void initJCalendar() {
        this.jcalendar = new JCalendar();
        this.jcalendar.getDayChooser().addPropertyChangeListener("day", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("day") && PhoneHistoryRoom.this.popup.isVisible()) {
                    PhoneHistoryRoom.this.dateSelected = true;
                    PhoneHistoryRoom.this.popup.setVisible(false);
                    if ((Integer)evt.getNewValue() > 0) {
                        PhoneHistoryRoom.this.setDate(PhoneHistoryRoom.this.jcalendar.getCalendar().getTime());
                    } else {
                        PhoneHistoryRoom.this.setDate(null);
                    }
                }
            }
        });
        this.jcalendar.getDayChooser().setAlwaysFireDayProperty(true);
        this.jcalendar.setMaxSelectableDate(new Date());
        this.popup = new JPopupMenu(){

            @Override
            public void setVisible(boolean b) {
                int selectedIndex = PhoneHistoryRoom.this.cbTimeType.getSelectedIndex();
                Boolean isCanceled = (Boolean)this.getClientProperty("JPopupMenu.firePopupMenuCanceled");
                if (b || !b && selectedIndex != 4 || !b && PhoneHistoryRoom.this.dateSelected || isCanceled != null && !b && isCanceled.booleanValue()) {
                    super.setVisible(b);
                }
            }
        };
        this.popup.setLightWeightPopupEnabled(true);
        this.popup.add((Component)this.jcalendar);
        this.changeListener = new ChangeListener(){
            boolean hasListened = false;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (this.hasListened) {
                    this.hasListened = false;
                    return;
                }
                if (PhoneHistoryRoom.this.popup.isVisible() && PhoneHistoryRoom.this.jcalendar.getMonthChooser().getComboBox().hasFocus()) {
                    MenuElement[] me = MenuSelectionManager.defaultManager().getSelectedPath();
                    MenuElement[] newMe = new MenuElement[me.length + 1];
                    newMe[0] = PhoneHistoryRoom.this.popup;
                    for (int i = 0; i < me.length; ++i) {
                        newMe[i + 1] = me[i];
                    }
                    this.hasListened = true;
                    MenuSelectionManager.defaultManager().setSelectedPath(newMe);
                }
            }
        };
        MenuSelectionManager.defaultManager().addChangeListener(this.changeListener);
    }

    @Override
    public String getViewId() {
        return this.mJid;
    }

    @Override
    public void onShow(Intent intent) {
        this.researchData();
    }

    @Override
    public void onHide() {
        Component[] comps;
        this.newMsgIdSet.clear();
        for (Component comp : comps = this.panelContent.getComponents()) {
            if (!(comp instanceof PhoneHistoryEntryPanel)) continue;
            PhoneHistoryEntryPanel chep = (PhoneHistoryEntryPanel)comp;
            chep.updateNewMsgFlag(this.newMsgIdSet.contains(chep.getMsg().getId()));
        }
        this.panelContent.revalidate();
        this.panelContent.repaint();
    }

    @Override
    public void onClose() {
        this.newMsgIdSet.clear();
        if (this.queryThread != null) {
            this.queryThread.terminate();
        }
        this.selectedEntryPanel = null;
        this.menuDisplayedEntryPanel = null;
    }

    @Override
    public String getChatroomID() {
        return this.mJid;
    }

    @Override
    public ChatroomType getChatroomType() {
        return ChatroomType.EXTERNAL;
    }

    @Override
    public void onPhoneStatusChanged() {
    }

    @Override
    public void updateMessageStatus(Intent intent) {
        boolean isContactReportKeyDisp = PreferencesUtil.isContactReportKeyDisp(UCChatClient.context);
        boolean doChange = false;
        if (this.currentContactReportKeyDisp != isContactReportKeyDisp) {
            doChange = true;
        }
        this.currentContactReportKeyDisp = isContactReportKeyDisp;
        if (doChange) {
            this.cleanPhoneHistory();
            if (this.currentContactReportKeyDisp) {
                if (this.panelSearchOption != null) {
                    this.panelSearchOption.setVisible(true);
                }
                if (this.labelSearchType != null) {
                    this.labelSearchType.setVisible(true);
                }
            } else {
                if (this.panelSearchOption != null) {
                    this.panelSearchOption.setVisible(false);
                }
                if (this.labelSearchType != null) {
                    this.labelSearchType.setVisible(false);
                }
                if (this.labelReportKey != null) {
                    this.labelReportKey.setVisible(false);
                }
                if (this.panelReportKeySearch != null) {
                    this.panelReportKeySearch.setVisible(false);
                    this.fieldReportKey.setText("");
                }
                if (this.labelDataType != null) {
                    this.labelDataType.setVisible(true);
                }
                if (this.panelDataTypeSelection != null) {
                    this.panelDataTypeSelection.setVisible(true);
                }
                if (this.panelNumberSearch != null) {
                    this.panelNumberSearch.setVisible(true);
                }
                if (this.labelNumber != null) {
                    this.labelNumber.setVisible(true);
                }
                if (this.panelTimeSearch != null) {
                    this.panelTimeSearch.setVisible(true);
                }
                if (this.labelTime != null) {
                    this.labelTime.setVisible(true);
                }
            }
            if (this.optionCondSearchRadioBtn != null) {
                this.optionCondSearchRadioBtn.setSelected(true);
            }
        }
        this.researchData();
    }

    @Override
    public void updateMessageContent(Intent intent) {
        this.researchData();
    }

    @Override
    public void updateFileUploadProgress(Intent intent) {
    }

    @Override
    public void updateFavoriteAction(boolean favorite) {
    }

    @Override
    public void updateNotificationAction(boolean enable) {
    }

    @Override
    public void updateMyChatRoomAction(boolean isMyChatRoom) {
    }

    @Override
    public void loadNewMessage(boolean selfSendOut) {
        this.researchData();
    }

    @Override
    public void execute(String command) {
    }

    @Override
    public void setTimestamp(long timestamp) {
        this.mTimestamp = timestamp;
    }

    @Override
    public long getTimestamp() {
        return this.mTimestamp;
    }

    @Override
    public void playMessage(String packetId) {
    }

    @Override
    public void checkAllDate() {
    }

    @Override
    public void checkAllPhoneData() {
        this.researchData();
    }

    @Override
    public void recallMessage(String packetId) {
    }

    @Override
    public void deleteMessage(String packetId) {
        this.researchData();
    }

    @Override
    public void readedByMessage(String packetId) {
    }

    @Override
    public void updateActionMap() {
    }

    private PhoneHistoryEntryPanel getPhoneHistoryEntryPanel(long msgId) {
        Component[] comps;
        for (Component comp : comps = this.panelContent.getComponents()) {
            PhoneHistoryEntryPanel chep;
            if (!(comp instanceof PhoneHistoryEntryPanel) || (chep = (PhoneHistoryEntryPanel)comp).getId() != msgId) continue;
            return chep;
        }
        return null;
    }

    public void setSelectedPhoneHistory(long msgId, boolean showViewer) {
        PhoneHistoryEntryPanel chep = this.getPhoneHistoryEntryPanel(msgId);
        if (this.selectedEntryPanel != null) {
            if (this.selectedEntryPanel == chep) {
                this.selectedEntryPanel.setSelected(true);
                return;
            }
            this.selectedEntryPanel.setSelected(false);
            this.selectedEntryPanel = null;
        }
        if (chep == null) {
            return;
        }
        this.selectedEntryPanel = chep;
        this.selectedEntryPanel.setSelected(true);
    }

    class EntryPanelMouseListener
    extends MouseAdapter {
        EntryPanelMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            if (evt.getButton() == 1) {
                PhoneHistoryEntryPanel panel = (PhoneHistoryEntryPanel)evt.getComponent();
                PhoneHistoryRoom.this.setSelectedPhoneHistory(panel.getId(), true);
            }
            this.checkPopup(evt);
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            this.checkPopup(evt);
        }

        private void checkPopup(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                PhoneHistoryEntryPanel chep;
                PhoneHistoryRoom.this.menuDisplayedEntryPanel = chep = (PhoneHistoryEntryPanel)evt.getComponent();
                JPopupMenu popupHistoryMenu = new JPopupMenu();
                popupHistoryMenu.addPopupMenuListener(PhoneHistoryRoom.this.myPopupMenuListener);
                ExternalCallMessage msg = chep.getMsg();
                int msgType = msg.getMsgType();
                boolean isFuzzy = false;
                if (PreferencesUtil.isFuzzyOutboundNumber(UCChatClient.context)) {
                    isFuzzy = true;
                }
                boolean showNumber = true;
                if (isFuzzy) {
                    if (msgType == 221 || msgType == 222) {
                        showNumber = false;
                    } else if ((msgType == 13 || msgType == 1006) && msg.isOutboundRecording(UCChatClient.context)) {
                        showNumber = false;
                    }
                }
                if (showNumber) {
                    popupHistoryMenu.add(new CopyNumberAction());
                    popupHistoryMenu.add(new SearchNumberAction());
                    popupHistoryMenu.addSeparator();
                }
                if (chep.canPlaySystemRecording() || chep.canPlayVoicePersonal()) {
                    popupHistoryMenu.add(new SaveAudioAction());
                    popupHistoryMenu.add(new ForwardAudioAction());
                    popupHistoryMenu.addSeparator();
                }
                boolean hasBlacklistMenu = false;
                if (PreferencesUtil.isRemoteCheckOutboundNumber(UCChatClient.context)) {
                    popupHistoryMenu.add(new AddToOutboundBlackListAction());
                    hasBlacklistMenu = true;
                }
                if (ApiVersion.isApi25Later() && PreferencesUtil.hasAddToInboundBlacklistPermission(UCChatClient.context)) {
                    popupHistoryMenu.add(new AddToInboundBlackListAction());
                    hasBlacklistMenu = true;
                }
                if (hasBlacklistMenu) {
                    popupHistoryMenu.addSeparator();
                }
                popupHistoryMenu.add(new DeleteContactHistoryAction());
                popupHistoryMenu.show(chep, evt.getX(), evt.getY());
                PhoneHistoryRoom.this.menuDisplayedEntryPanel.setMenuDisplayed(true);
            }
        }
    }

    class MyPopupMenuListener
    implements PopupMenuListener {
        MyPopupMenuListener() {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            if (PhoneHistoryRoom.this.menuDisplayedEntryPanel != null && PhoneHistoryRoom.this.menuDisplayedEntryPanel != PhoneHistoryRoom.this.selectedEntryPanel) {
                PhoneHistoryRoom.this.menuDisplayedEntryPanel.setMenuDisplayed(false);
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }
    }

    class AddToInboundBlackListAction
    extends AbstractAction
    implements ClipboardOwner {
        private static final long serialVersionUID = 121831855018705174L;

        public AddToInboundBlackListAction() {
            this.putValue("Name", I18NUtil.getString("phone_history_btn_add_to_inbound_black_list"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String phoneNumber = PhoneHistoryRoom.this.menuDisplayedEntryPanel.getNumberToDial();
            AddNumToInboundBlackListConfirmDialog dialog = new AddNumToInboundBlackListConfirmDialog(UCChatClient.getInstance(), phoneNumber);
            dialog.setLocationRelativeTo(UCChatClient.getInstance().getMainPanel());
            ToastUtil.hide();
            boolean result = dialog.showDialog();
            if (result) {
                String phoneNum = dialog.getPhoneNumber();
                String reason = dialog.getReason();
                WebAgent.getInstance().addPhoneNumToInboundBlackList(phoneNum, reason);
            }
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }

    class AddToOutboundBlackListAction
    extends AbstractAction
    implements ClipboardOwner {
        private static final long serialVersionUID = 7454411791688515573L;

        public AddToOutboundBlackListAction() {
            this.putValue("Name", I18NUtil.getString("phone_history_btn_add_to_outbound_black_list"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String phoneNumber = PhoneHistoryRoom.this.menuDisplayedEntryPanel.getNumberToDial();
            AddNumToOutboundBlackListConfirmDialog dialog = new AddNumToOutboundBlackListConfirmDialog(UCChatClient.getInstance(), phoneNumber);
            dialog.setLocationRelativeTo(UCChatClient.getInstance().getMainPanel());
            ToastUtil.hide();
            boolean result = dialog.showDialog();
            if (result) {
                String phoneNum = dialog.getPhoneNumber();
                String reason = dialog.getReason();
                WebAgent.getInstance().addPhoneNumToOutboundBlackList(phoneNum, reason);
            }
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }

    class SearchNumberAction
    extends AbstractAction
    implements ClipboardOwner {
        private static final long serialVersionUID = 4555391465541839742L;

        public SearchNumberAction() {
            String phoneNumber = PhoneHistoryRoom.this.menuDisplayedEntryPanel.getNumberToDial();
            this.putValue("Name", String.format(I18NUtil.getString("fax_btn_search_number"), phoneNumber));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String phoneNumber = PhoneHistoryRoom.this.menuDisplayedEntryPanel.getNumberToDial();
            PhoneHistoryRoom.this.fieldNumber.setText(phoneNumber);
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }

    class CopyNumberAction
    extends AbstractAction
    implements ClipboardOwner {
        private static final long serialVersionUID = -9130093279598964063L;

        public CopyNumberAction() {
            String phoneNumber = PhoneHistoryRoom.this.menuDisplayedEntryPanel.getNumberToDial();
            this.putValue("Name", String.format(I18NUtil.getString("fax_btn_copy_number"), phoneNumber));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String phoneNumber = PhoneHistoryRoom.this.menuDisplayedEntryPanel.getNumberToDial();
            Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringSelection contents = new StringSelection(phoneNumber);
            clipboard.setContents(contents, this);
        }

        @Override
        public void lostOwnership(Clipboard clipboard, Transferable contents) {
        }
    }

    class DeleteContactHistoryAction
    extends AbstractAction {
        private static final long serialVersionUID = 7091708083808489636L;

        public DeleteContactHistoryAction() {
            this.putValue("Name", I18NUtil.getString("common_btn_delete"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            final PhoneHistoryEntryPanel chep = PhoneHistoryRoom.this.menuDisplayedEntryPanel;
            DeleteFile.handle(new DeleteService(){

                @Override
                public Component getParentPanel() {
                    return PhoneHistoryRoom.this;
                }

                @Override
                public void cleanMsgUI(String packetId) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PhoneHistoryRoom.this.removePhoneHistory(chep.getId());
                            PhoneHistoryRoom.this.panelContent.revalidate();
                            PhoneHistoryRoom.this.panelContent.repaint();
                            BroadcastUtil.sendContactHistoryChangedEvent(UCChatClient.context);
                            BroadcastUtil.sendMsgChangedEvent(UCChatClient.context);
                        }
                    });
                }

                @Override
                public Message getMessageByPacketId(String packetId) {
                    return UCDBMessage.findMsgByPacketId(UCChatClient.context, packetId);
                }
            }, chep.getMsg().getPacketId());
        }
    }

    class ForwardAudioAction
    extends AbstractAction {
        private static final long serialVersionUID = -5355369617046677850L;

        public ForwardAudioAction() {
            this.putValue("Name", I18NUtil.getString("common_btn_forward"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PhoneHistoryEntryPanel chep = PhoneHistoryRoom.this.menuDisplayedEntryPanel;
            chep.handleFoward();
        }
    }

    class SaveAudioAction
    extends AbstractAction {
        private static final long serialVersionUID = 6203434566787397537L;

        public SaveAudioAction() {
            this.putValue("Name", I18NUtil.getString("common_btn_save_as"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PhoneHistoryEntryPanel chep = PhoneHistoryRoom.this.menuDisplayedEntryPanel;
            chep.handleSaveToFile();
        }
    }
}

