/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.roomimpl;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.text.HistoryTextWriter;
import com.blisscloud.ezuc.client.text.MsgTextConverter;
import com.blisscloud.ezuc.client.util.MsgUtil;
import com.blisscloud.ezuc.client.util.QuoteItem;
import com.blisscloud.mobile.ezuc.bean.Message;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.text.DefaultCaret;

public class ReferenceOut
extends JPanel {
    private JTextPane mMsgPane;
    private ReferenceClose mCloseListener;

    public ReferenceOut(ReferenceClose closeListener) {
        this.mCloseListener = closeListener;
        this.init();
    }

    public void init() {
        GridBagLayout thisLayout = new GridBagLayout();
        this.setLayout(thisLayout);
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setBackground(Color.WHITE);
        RoundedCornerPanel referenceMsg = new RoundedCornerPanel();
        referenceMsg.setLayout(new GridBagLayout());
        this.add((Component)referenceMsg, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(3, 3, 3, 100), 10, 10));
        JLabel title = new JLabel();
        title.setIcon(UIConstants.ICON_REPLY);
        title.setFont(UIConstants.FONT_12_BOLD);
        title.setBorder(BorderFactory.createEmptyBorder(5, 10, 5, 0));
        referenceMsg.add((Component)title, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
        this.mMsgPane = new JTextPane();
        this.mMsgPane.setFont(UIConstants.FONT_12_PLAIN);
        this.mMsgPane.setForeground(UIConstants.COLOR_LIGHT_GRAY);
        this.mMsgPane.setOpaque(false);
        this.mMsgPane.setEnabled(true);
        this.mMsgPane.setEditable(false);
        this.mMsgPane.setCaret(new MyCaret());
        this.mMsgPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.mMsgPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                ReferenceOut.this.mCloseListener.onMouseClicked();
            }
        });
        referenceMsg.add((Component)this.mMsgPane, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        final JLabel lblClose = new JLabel();
        lblClose.setCursor(UIConstants.CURSOR_HAND);
        lblClose.setIcon(UIConstants.ICON_CLOSE);
        lblClose.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 10));
        lblClose.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (ReferenceOut.this.mCloseListener != null) {
                    ReferenceOut.this.mCloseListener.onReferenceCancel();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                lblClose.setIcon(UIConstants.ICON_CLOSE_OVER);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                lblClose.setIcon(UIConstants.ICON_CLOSE);
            }
        });
        referenceMsg.add((Component)lblClose, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
    }

    public void setMsg(Message quoteMsg, boolean confRoom) {
        QuoteItem item = MsgUtil.getQuoteItem(UCChatClient.context, quoteMsg);
        if (item != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(item.getOwnerName());
            builder.append(" ");
            builder.append(item.getTime());
            builder.append(" ");
            builder.append(item.getMsgContent());
            String msgContent = builder.toString().replace("\n", " ");
            HistoryTextWriter writer = new HistoryTextWriter(this.mMsgPane, 12, 80);
            try {
                MsgTextConverter.convertAndAppendText(msgContent, writer);
            }
            catch (UCThreadException uCThreadException) {
                // empty catch block
            }
        }
    }

    public static interface ReferenceClose {
        public void onReferenceCancel();

        public void onMouseClicked();
    }

    class MyCaret
    extends DefaultCaret {
        MyCaret() {
        }

        @Override
        protected void adjustVisibility(Rectangle nloc) {
        }
    }
}

