/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.chat.roomimpl;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteCustomer;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.chat.ChatroomType;
import com.blisscloud.ezuc.client.chat.IChatroom;
import com.blisscloud.ezuc.client.chat.MessageArea;
import com.blisscloud.ezuc.client.chat.MessageDropperField;
import com.blisscloud.ezuc.client.chat.MessageInput;
import com.blisscloud.ezuc.client.chat.dom.UCThreadException;
import com.blisscloud.ezuc.client.chat.popup.EmoticonPopupMenu;
import com.blisscloud.ezuc.client.chat.popup.MediaContentInputListener;
import com.blisscloud.ezuc.client.chat.popup.StickerPopupMenu;
import com.blisscloud.ezuc.client.chat.roomimpl.BaseChatroom;
import com.blisscloud.ezuc.client.chat.roomimpl.Chatroom;
import com.blisscloud.ezuc.client.chat.roomimpl.ListenerCleaner;
import com.blisscloud.ezuc.client.chat.roomimpl.ReferenceOut;
import com.blisscloud.ezuc.client.component.GradientPanel;
import com.blisscloud.ezuc.client.component.ImageLabel;
import com.blisscloud.ezuc.client.component.PersonalPhoto;
import com.blisscloud.ezuc.client.component.UCScrollPane;
import com.blisscloud.ezuc.client.component.UCUploadFileChooser;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.CustomerUtils;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.MsgUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.Utils;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.ezuc.client.wechat.WechatCloseDialog;
import com.blisscloud.ezuc.client.wechat.WechatLevelPopup;
import com.blisscloud.ezuc.client.wechat.WechatLevelPopupCallback;
import com.blisscloud.ezuc.client.wechat.WechatTransferDialog;
import com.blisscloud.mobile.ezuc.agent.ChatActionUtil;
import com.blisscloud.mobile.ezuc.agent.ChatReceiver;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.db.UserDatabase;
import com.blisscloud.mobile.ezuc.manager.ChatEventManager;
import com.blisscloud.mobile.ezuc.manager.ChatRoomManager;
import com.blisscloud.mobile.ezuc.manager.CustomerManager;
import com.blisscloud.mobile.ezuc.screen.CaptureUtil;
import com.blisscloud.mobile.ezuc.util.BroadcastUtil;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javafx.application.Platform;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import org.apache.commons.lang3.StringUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WechatChatroom
extends BaseChatroom
implements IChatroom,
WechatLevelPopupCallback,
MessageDropperField {
    private static final long serialVersionUID = 3219452717812736249L;
    private ChatMode chatMode = null;
    private JLabel disableReasonLabel;
    private JPanel panelHeader;
    private PersonalPhoto lblPhoto;
    private ImageLabel btnConfig;
    private MessageArea tpHistoryArea;
    private JScrollPane spMessage;
    private JPanel jToolBar1;
    private JPanel jPanel100;
    private JPanel spMessageOut;
    private ReferenceOut referenceMsgOut;
    private JLabel lblPadding;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private ImageLabel btnSendFile;
    private ImageLabel btnScreenCapture;
    private ImageLabel btnSendEmoticon;
    private JLabel lblDisplayName;
    private JPanel panelInfo;
    private JPanel panelLevel;
    private JLabel lblServname;
    private JLabel jLabel1;
    private JLabel lblLevel;
    private JLabel lblCountdown;
    private ImageLabel btnHistory;
    private ImageLabel btnClose;
    private ImageLabel btnTransfer;
    private JSplitPane jSplitPane1 = null;
    private JPopupMenu popupMenuConfig;
    private WechatLevelPopup wechatLevelPopup;
    private WechatTransferDialog wad;
    private WechatCloseDialog wcd;
    private LiteCustomer liteCustomer;
    private BroadcastReceiver receiver = null;
    private IntentFilter filter = null;
    private JPanel sendBtnPanel = null;
    private boolean wechatViewHistoryShow = false;
    private String wechatSessionId = null;
    private ArrayList<Message> customerHistoryList;
    private JButton sendButton = null;
    private String mQuotePackageId;

    public WechatChatroom(String roomJid, JPanel parent) {
        super(roomJid, parent);
        this.mMessageArea = new MessageArea(roomJid, false, this);
        this.initGUI();
        this.initConfigPopup();
        this.initReceiver();
        Log.i(WechatChatroom.class.getSimpleName(), "\u5efa\u7acbWechat\u804a\u5929\u5ba4\u756b\u9762 " + this.mRoomJid);
        ChatRoomManager.checkAndGenerateChatRoomData(UCChatClient.context, this.mRoomJid, null, false, false);
        ChatRoomInfo info = ChatRoomManager.getChatRoom(UCChatClient.context, this.mRoomJid);
        if (info == null) {
            throw new IllegalArgumentException("invalid chatroom jid " + this.mRoomJid);
        }
        this.updateCustomer();
        this.updateFavoriteAction(ChatRoomManager.isInMyFavorite(this.mRoomJid));
        UserDatabase database = UserDatabase.getDB(UCChatClient.context);
        boolean isEnabled = !database.isDisableNotification(this.mRoomJid);
        this.updateNotificationAction(isEnabled);
    }

    @Override
    public ChatroomType getChatroomType() {
        return ChatroomType.WECHAT;
    }

    @Override
    public void execute(String command) {
    }

    @Override
    public void loadNewMessage(boolean selfSendOut) {
        Log.i(WechatChatroom.class.getSimpleName(), "loadNewMessage...selfSendOut:" + selfSendOut);
        super.loadNewMessage(selfSendOut);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WechatChatroom.this.updateCustomer();
            }
        });
    }

    public ChatMode getChatMode() {
        return this.chatMode;
    }

    public void setChatMode(ChatMode mode, String disabledText) {
        this.chatMode = mode;
        switch (mode) {
            case ONLY_CHAT: {
                this.disableReasonLabel.setVisible(false);
                this.disableReasonLabel.setText("");
                this.btnClose.setEnabled(true);
                this.btnTransfer.setEnabled(true);
                this.btnSendFile.setEnabled(true);
                this.btnScreenCapture.setEnabled(true);
                this.btnSendEmoticon.setEnabled(true);
                if (!this.txtMessage.isEnabled()) {
                    this.txtMessage.setText("");
                }
                this.txtMessage.setEnabled(true);
                if (this.jPanel100.isVisible()) break;
                this.btnConfig.setVisible(false);
                this.btnClose.setVisible(true);
                this.btnTransfer.setVisible(true);
                this.jToolBar1.setVisible(true);
                this.spMessage.setVisible(true);
                this.jPanel100.setVisible(true);
                this.sendBtnPanel.setVisible(true);
                if (this.panelHeader.getHeight() < 0) break;
                int panelHeight = PreferencesUtil.getChatInputAreaHeight(UCChatClient.context);
                int loc = this.mPanrent.getHeight() - this.panelHeader.getHeight() - panelHeight;
                if (loc > 200 && panelHeight > 200) {
                    this.jSplitPane1.setDividerLocation(loc);
                    break;
                }
                this.jSplitPane1.setDividerLocation(0.7);
                break;
            }
            case DISABLED: {
                if (StringUtils.isNotEmpty((CharSequence)disabledText)) {
                    this.disableReasonLabel.setVisible(true);
                    this.disableReasonLabel.setText("[" + disabledText + "]");
                } else {
                    this.disableReasonLabel.setVisible(false);
                    this.disableReasonLabel.setText("");
                }
                this.btnClose.setEnabled(false);
                this.btnTransfer.setEnabled(false);
                this.btnSendFile.setEnabled(false);
                this.btnScreenCapture.setEnabled(false);
                this.btnSendEmoticon.setEnabled(false);
                this.txtMessage.setEnabled(false);
                this.txtMessage.setText("");
                this.btnConfig.setVisible(false);
                this.btnClose.setVisible(false);
                this.btnTransfer.setVisible(false);
                this.jToolBar1.setVisible(false);
                this.spMessage.setVisible(false);
                this.jPanel100.setVisible(false);
                this.sendBtnPanel.setVisible(false);
                this.onReferenceRemoved(null);
            }
        }
    }

    public void updateParticipantPhoto() {
        Log.i(WechatChatroom.class.getSimpleName(), "updateParticipantPhoto:" + this.mRoomJid);
        LiteCustomer customer = CustomerManager.getCustomerInfo(UCChatClient.context, Utils.convertKey(this.mRoomJid));
        Image image = CustomerManager.getContactImage(customer, 64, false);
        this.lblPhoto.setImage(image);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCustomerHistory(Intent intent) {
        JSONArray historyLogTempData;
        String sessionId = intent.getStringExtra("SESSION_ID");
        if (this.wechatSessionId == null || sessionId == null || !this.wechatSessionId.equals(sessionId)) {
            return;
        }
        ToastUtil.hide();
        if (this.customerHistoryList == null) {
            this.customerHistoryList = new ArrayList();
        }
        if ((historyLogTempData = intent.getJSONArrayExtra("DATA")) != null) {
            try {
                this.customerHistoryList.clear();
                for (int i = 0; i < historyLogTempData.length(); ++i) {
                    JSONObject item = historyLogTempData.getJSONObject(i);
                    int type = item.getInt("type");
                    if (type == 4) continue;
                    String sender = item.optString("sender", "");
                    String msgContent = item.getString("content");
                    String fileName = item.optString("fileName", null);
                    long fileSize = item.optLong("fileSize", -1L);
                    String downloadURL = item.optString("downloadURL", null);
                    long id = item.getLong("id");
                    long duration = item.optLong("duration", -1L);
                    String mimeType = item.optString("mimeType", null);
                    if (type == 0) {
                        msgContent = ChatEventManager.trimQuote(msgContent);
                    }
                    long msgTime = item.getLong("time");
                    Message msg = new Message();
                    msg.setId(id);
                    msg.setServerTime(msgTime);
                    msg.setMainType(1);
                    msg.setStatus("S");
                    msg.setContent(msgContent);
                    msg.setRead(true);
                    msg.setPlayed(true);
                    if (JidUtil.isCustomerJid(sender)) {
                        msg.setFromJid(sender + "@social.blisscloud.com");
                    } else {
                        msg.setFromJid(sender + "@blisscloud.com");
                    }
                    msg.setDuration(duration);
                    msg.setPacketId("SOCIALHISTORY-" + CommonUtil.randomString(15));
                    switch (type) {
                        case 0: {
                            msg.setContentType(Message.ContentType.TEXT);
                            msg.setMsgType(0);
                            break;
                        }
                        case 1: {
                            msg.setContentType(Message.ContentType.FILE);
                            msg.setMsgType(5);
                            msg.setFileName("image/" + fileName);
                            msg.setFileDownloadURL(downloadURL);
                            break;
                        }
                        case 2: {
                            msg.setContentType(Message.ContentType.TEXT);
                            msg.setMsgType(6);
                            break;
                        }
                        case 12: {
                            msg.setContentType(Message.ContentType.TEXT);
                            msg.setMsgType(1);
                            break;
                        }
                        case 3: {
                            msg.setContentType(Message.ContentType.FILE);
                            msg.setMsgType(4);
                            msg.setFileName("video/" + fileName);
                            msg.setFileDownloadURL(downloadURL);
                            break;
                        }
                        case 5: {
                            double latitude = 0.0;
                            double longitude = 0.0;
                            if (item.has("latitude")) {
                                String latitudeStr = item.getString("latitude");
                                try {
                                    latitude = Double.parseDouble(latitudeStr);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            if (item.has("longitude")) {
                                String longitudeStr = item.getString("longitude");
                                try {
                                    longitude = Double.parseDouble(longitudeStr);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            msg.setContentType(Message.ContentType.TEXT);
                            msg.setMsgType(8);
                            JSONObject obj = new JSONObject();
                            obj.put("latitude", latitude);
                            obj.put("longitude", longitude);
                            msg.setProps(obj.toString());
                            break;
                        }
                        case 6: 
                        case 99: {
                            msg.setContentType(Message.ContentType.FILE);
                            msg.setMsgType(11);
                            msg.setFileName(fileName);
                            msg.setFileDownloadURL(downloadURL);
                            msg.setFileSize(fileSize);
                            msg.setMimeType(mimeType);
                            break;
                        }
                        case 30: {
                            msg.setContentType(Message.ContentType.TEXT);
                            msg.setMsgType(99);
                        }
                    }
                    this.customerHistoryList.add(msg);
                }
            }
            catch (JSONException e) {
                Log.e(WechatChatroom.class.getSimpleName(), e.getLocalizedMessage());
            }
        }
        this.setChatMode(ChatMode.DISABLED, "");
        this.wechatViewHistoryShow = true;
        this.btnHistory.setText(I18NUtil.getString("wechat_present_chats"));
        if (this.tpHistoryArea != null) {
            this.tpHistoryArea.onClose();
        }
        this.tpHistoryArea = new MessageArea(this.mRoomJid, new MessageHistoryCallback());
        Object object = this.msgLock;
        synchronized (object) {
            for (Message msg : this.customerHistoryList) {
                String fileExt;
                String senderJID = msg.getFromJid();
                int msgType = msg.getMsgType();
                Message.ContentType contentType = msg.getContentType();
                boolean appendToBottom = true;
                boolean scrollBottom = true;
                if (MsgUtil.isSystemMsg(msgType)) {
                    this.tpHistoryArea.addSystemMessage(msg.getPacketId(), msg.getContent(), appendToBottom, scrollBottom);
                    continue;
                }
                if (msgType == 99) {
                    this.tpHistoryArea.addNoticeMessage(msg, appendToBottom, scrollBottom, null, null);
                    continue;
                }
                if (!JidUtil.isCustomerJid(senderJID)) {
                    switch (contentType) {
                        case TEXT: {
                            if (msgType == 1 || msgType == 6) {
                                this.tpHistoryArea.addMyAudio(senderJID, this.myDisplayName, msg, appendToBottom, scrollBottom);
                                break;
                            }
                            if (msgType == 0 || msgType == 221 || msgType == 222) {
                                this.tpHistoryArea.addMyMessage(senderJID, this.myDisplayName, msg, appendToBottom, scrollBottom, null, null);
                                break;
                            }
                            if (msgType == 8) {
                                this.tpHistoryArea.addMyLocation(senderJID, this.myDisplayName, msg, appendToBottom, scrollBottom, null, null);
                                break;
                            }
                            if (msgType != 9) break;
                            this.tpHistoryArea.addMyPunchCard(senderJID, this.myDisplayName, msg, appendToBottom, scrollBottom, null, null);
                            break;
                        }
                        case FILE: {
                            if (msgType == 5) {
                                this.tpHistoryArea.addMyImage(senderJID, this.myDisplayName, msg, appendToBottom, scrollBottom, null, null);
                                break;
                            }
                            if (msgType == 4) {
                                this.tpHistoryArea.addMyVideo(senderJID, this.myDisplayName, msg, appendToBottom, scrollBottom, null, null);
                                break;
                            }
                            if (msgType == 11) {
                                this.tpHistoryArea.addMyDocument(senderJID, this.myDisplayName, msg, appendToBottom, scrollBottom, null, null);
                                break;
                            }
                            if (msgType != 2) break;
                            fileExt = FileUtil.getFileExtension(msg.getFileNameForDisp());
                            if (UCUploadFileChooser.IMAGE_TYPES.contains(fileExt)) {
                                this.tpHistoryArea.addMyImage(senderJID, this.myDisplayName, msg, appendToBottom, scrollBottom, null, null);
                                break;
                            }
                            if (UCUploadFileChooser.VIDEO_TYPES.contains(fileExt)) {
                                this.tpHistoryArea.addMyVideo(senderJID, this.myDisplayName, msg, appendToBottom, scrollBottom, null, null);
                                break;
                            }
                            if (!UCUploadFileChooser.DOCUMENT_TYPES.contains(fileExt) && !UCUploadFileChooser.AUDIO_TYPES.contains(fileExt)) break;
                            this.tpHistoryArea.addMyDocument(senderJID, this.myDisplayName, msg, appendToBottom, scrollBottom, null, null);
                        }
                    }
                    continue;
                }
                switch (contentType) {
                    case TEXT: {
                        if (msgType == 1 || msgType == 6) {
                            this.tpHistoryArea.addOtherAudio(this.mRoomJid, this.mRoomDisplayName, msg, appendToBottom, scrollBottom);
                            break;
                        }
                        if (msgType == 0 || msgType == 223 || msgType == 225) {
                            this.tpHistoryArea.addOtherMessage(this.mRoomJid, this.mRoomDisplayName, msg, appendToBottom, scrollBottom, null, null);
                            break;
                        }
                        if (msgType == 8) {
                            this.tpHistoryArea.addOtherLocation(this.mRoomJid, this.mRoomDisplayName, msg, appendToBottom, scrollBottom, null, null);
                            break;
                        }
                        if (msgType != 9) break;
                        this.tpHistoryArea.addOtherPunchCard(this.mRoomJid, this.mRoomDisplayName, msg, appendToBottom, scrollBottom, null, null);
                        break;
                    }
                    case FILE: {
                        if (msgType == 5) {
                            this.tpHistoryArea.addOtherImage(this.mRoomJid, this.mRoomDisplayName, msg, appendToBottom, scrollBottom, null, null);
                            break;
                        }
                        if (msgType == 4) {
                            this.tpHistoryArea.addOtherVideo(this.mRoomJid, this.mRoomDisplayName, msg, appendToBottom, scrollBottom, null, null);
                            break;
                        }
                        if (msgType == 11) {
                            this.tpHistoryArea.addOtherDocument(this.mRoomJid, this.mRoomDisplayName, msg, appendToBottom, scrollBottom, null, null);
                            break;
                        }
                        if (msgType != 2) break;
                        fileExt = msg.getFileExtension();
                        if (UCUploadFileChooser.IMAGE_TYPES.contains(fileExt)) {
                            this.tpHistoryArea.addOtherImage(this.mRoomJid, this.mRoomDisplayName, msg, appendToBottom, scrollBottom, null, null);
                            break;
                        }
                        if (UCUploadFileChooser.VIDEO_TYPES.contains(fileExt)) {
                            this.tpHistoryArea.addOtherVideo(this.mRoomJid, this.mRoomDisplayName, msg, appendToBottom, scrollBottom, null, null);
                            break;
                        }
                        if (!UCUploadFileChooser.DOCUMENT_TYPES.contains(fileExt) && !UCUploadFileChooser.AUDIO_TYPES.contains(fileExt)) break;
                        this.tpHistoryArea.addOtherDocument(this.mRoomJid, this.mRoomDisplayName, msg, appendToBottom, scrollBottom, null, null);
                    }
                }
            }
        }
        this.jSplitPane1.add((Component)((Object)this.tpHistoryArea), "top");
    }

    private void updateCustomer() {
        Activity ctx = UCChatClient.context;
        this.liteCustomer = CustomerManager.getCustomerInfo(ctx, Utils.convertKey(this.mRoomJid));
        if (this.liteCustomer == null) {
            this.lblPhoto.setImage(UIConstants.ICON_PERSON64.getImage());
            this.mRoomDisplayName = "";
            this.lblDisplayName.setText(this.mRoomDisplayName);
            this.lblServname.setText("");
            this.lblLevel.setText("");
            this.mRoomDisplayName = null;
        } else {
            if (this.liteCustomer.getType() == 0) {
                this.lblServname.setIcon(UIConstants.ICON_WECHAT_GREEN);
            } else if (this.liteCustomer.getType() == 1) {
                this.lblServname.setIcon(UIConstants.ICON_LINE_GREEN);
            } else if (this.liteCustomer.getType() == 2) {
                this.lblServname.setIcon(UIConstants.ICON_WEBCHAT_BLUE);
            }
            Image image = CustomerManager.getContactImage(this.liteCustomer, 64, false);
            this.lblPhoto.setImage(image);
            this.mRoomDisplayName = this.liteCustomer.getNickname() + "@" + this.liteCustomer.getServName();
            this.lblDisplayName.setText(this.mRoomDisplayName);
            this.lblServname.setText(this.liteCustomer.getServName());
            this.lblLevel.setText(I18NUtil.getString("wechat_level") + this.liteCustomer.getLevel());
            this.mRoomDisplayName = this.liteCustomer.getNickname();
        }
        this.updateExpireTime();
        if (this.liteCustomer != null && CustomerManager.isValid(UCChatClient.context, this.liteCustomer)) {
            if (this.liteCustomer.isTransferred()) {
                this.btnHistory.setVisible(true);
                if (this.wechatViewHistoryShow) {
                    this.btnHistory.setText(I18NUtil.getString("wechat_present_chats"));
                } else {
                    this.btnHistory.setText(I18NUtil.getString("wechat_history_log"));
                }
                this.wechatSessionId = this.liteCustomer.getSessionId();
            }
        } else {
            this.btnHistory.setVisible(false);
            this.btnHistory.setText(I18NUtil.getString("wechat_history_log"));
        }
    }

    public void updateExpireTime() {
        if (this.wechatViewHistoryShow) {
            this.setChatMode(ChatMode.DISABLED, "");
            if (this.liteCustomer == null) {
                this.lblCountdown.setText("");
            } else if (!CustomerManager.isValid(UCChatClient.context, this.liteCustomer)) {
                this.lblCountdown.setText("");
            } else {
                long t = this.liteCustomer.getExpireTime() - System.currentTimeMillis();
                this.lblCountdown.setText(CustomerUtils.getExpireTime(t));
            }
        } else if (this.liteCustomer == null) {
            this.setChatMode(ChatMode.DISABLED, "");
            this.lblCountdown.setText("");
        } else if (!CustomerManager.isValid(UCChatClient.context, this.liteCustomer)) {
            this.setChatMode(ChatMode.DISABLED, I18NUtil.getString("wechat_service_is_closed"));
            this.lblCountdown.setText("");
        } else {
            boolean hasChatPermission = PreferencesUtil.hasChatActionPermission(UCChatClient.context);
            if (hasChatPermission) {
                this.setChatMode(ChatMode.ONLY_CHAT, "");
            } else {
                this.setChatMode(ChatMode.DISABLED, "");
            }
            long t = this.liteCustomer.getExpireTime() - System.currentTimeMillis();
            this.lblCountdown.setText(CustomerUtils.getExpireTime(t));
        }
    }

    @Override
    public void updateMyChatRoomAction(boolean isMyChatRoom) {
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            this.setLayout(thisLayout);
            this.setPreferredSize(new Dimension(640, 480));
            this.setMinimumSize(new Dimension(520, 300));
            this.panelHeader = new GradientPanel(1, UIConstants.COLOR_HEADER_BACKGROUND_FROM, UIConstants.COLOR_HEADER_BACKGROUND_TO);
            this.add((Component)this.panelHeader, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            GridBagLayout jPanel1Layout = new GridBagLayout();
            this.panelHeader.setLayout(jPanel1Layout);
            this.panelHeader.setBorder(UIConstants.BORDER_HEADER);
            this.lblPhoto = new PersonalPhoto();
            this.panelHeader.add((Component)this.lblPhoto, new GridBagConstraints(0, 0, 1, 3, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.lblPhoto.setPreferredSize(new Dimension(64, 64));
            this.lblPhoto.setMinimumSize(new Dimension(64, 64));
            this.lblPhoto.setMaximumSize(new Dimension(64, 64));
            this.lblDisplayName = new JLabel();
            this.panelHeader.add((Component)this.lblDisplayName, new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(4, 12, 0, 0), 0, 0));
            this.mRoomDisplayName = "<Display Name>";
            this.lblDisplayName.setText(this.mRoomDisplayName);
            this.lblDisplayName.setFont(UIConstants.FONT_14_BOLD);
            this.panelInfo = new JPanel();
            this.panelHeader.add((Component)this.panelInfo, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(4, 12, 0, 0), 0, 0));
            FlowLayout panelInfoLayout = new FlowLayout();
            panelInfoLayout.setHgap(0);
            panelInfoLayout.setVgap(0);
            panelInfoLayout.setAlignment(0);
            this.panelInfo.setLayout(panelInfoLayout);
            this.panelInfo.setOpaque(false);
            this.lblServname = new JLabel();
            this.panelInfo.add(this.lblServname);
            this.panelLevel = new JPanel();
            this.panelInfo.add(this.panelLevel);
            FlowLayout panelLevelLayout = new FlowLayout();
            panelLevelLayout.setVgap(0);
            panelLevelLayout.setAlignment(0);
            this.panelLevel.setLayout(panelLevelLayout);
            this.panelLevel.setOpaque(false);
            this.panelLevel.setCursor(UIConstants.CURSOR_HAND);
            this.panelLevel.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 0));
            this.panelLevel.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent evt) {
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    if (evt.getButton() == 1) {
                        WechatChatroom.this.showWechatLevelPopup(evt);
                    }
                }
            });
            this.jLabel1 = new JLabel();
            this.panelLevel.add(this.jLabel1);
            this.jLabel1.setIcon(UIConstants.ICON_WECHAT_LEVEL);
            this.lblLevel = new JLabel();
            this.panelLevel.add(this.lblLevel);
            this.lblLevel.setText(I18NUtil.getString("wechat_level"));
            this.lblLevel.setForeground(Color.GRAY);
            this.lblLevel.setIcon(UIConstants.ICON_ARROW_DOWN);
            this.lblLevel.setHorizontalTextPosition(10);
            this.lblCountdown = new JLabel();
            this.panelInfo.add(this.lblCountdown);
            this.lblCountdown.setText("");
            this.lblCountdown.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 0));
            JLabel lblCountdownx = new JLabel();
            this.panelInfo.add(lblCountdownx);
            lblCountdownx.setText("");
            lblCountdownx.setBorder(BorderFactory.createEmptyBorder(0, 30, 0, 0));
            this.btnHistory = new ImageLabel(null, I18NUtil.getString("wechat_history_log"));
            this.btnHistory.setVisible(false);
            this.panelInfo.add(this.btnHistory);
            this.btnHistory.setHorizontalAlignment(0);
            this.btnHistory.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.btnHistory.setCursor(UIConstants.CURSOR_HAND);
            this.btnHistory.setArc(12);
            this.btnHistory.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (WechatChatroom.this.btnHistory.isEnabled()) {
                        WechatChatroom.this.switchChatHistory();
                    }
                }
            });
            this.btnClose = new ImageLabel((Icon)UIConstants.ICON_WECHAT_CLOSE, I18NUtil.getString("wechat_close"));
            this.panelHeader.add((Component)this.btnClose, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.btnClose.setPreferredSize(new Dimension(75, 30));
            this.btnClose.setMinimumSize(new Dimension(75, 30));
            this.btnClose.setMaximumSize(new Dimension(75, 30));
            this.btnClose.setHorizontalAlignment(0);
            this.btnClose.setBorder(UIConstants.BORDER_CONFIG_BUTTON);
            this.btnClose.setCursor(UIConstants.CURSOR_HAND);
            this.btnClose.setArc(12);
            this.btnClose.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (WechatChatroom.this.btnClose.isEnabled()) {
                        WechatChatroom.this.closeWechat();
                    }
                }
            });
            this.btnTransfer = new ImageLabel((Icon)UIConstants.ICON_WECHAT_TRANSFER, I18NUtil.getString("wechat_reassign"));
            this.panelHeader.add((Component)this.btnTransfer, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 14, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.btnTransfer.setPreferredSize(new Dimension(75, 30));
            this.btnTransfer.setMinimumSize(new Dimension(75, 30));
            this.btnTransfer.setMaximumSize(new Dimension(75, 30));
            this.btnTransfer.setHorizontalAlignment(0);
            this.btnTransfer.setBorder(UIConstants.BORDER_CONFIG_BUTTON);
            this.btnTransfer.setCursor(UIConstants.CURSOR_HAND);
            this.btnTransfer.setArc(12);
            this.btnTransfer.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (WechatChatroom.this.btnTransfer.isEnabled()) {
                        WechatChatroom.this.reassignWechat();
                    }
                }
            });
            this.btnConfig = new ImageLabel(UIConstants.ICON_MENU);
            this.panelHeader.add((Component)this.btnConfig, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 12, 0, new Insets(5, 5, 0, 0), 0, 0));
            this.btnConfig.setToolTipText(I18NUtil.getString("common_btn_config"));
            this.btnConfig.setPreferredSize(new Dimension(32, 32));
            this.btnConfig.setMinimumSize(new Dimension(32, 32));
            this.btnConfig.setMaximumSize(new Dimension(32, 32));
            this.btnConfig.setHorizontalAlignment(0);
            this.btnConfig.setBorder(UIConstants.BORDER_CONFIG_BUTTON);
            this.btnConfig.setCursor(UIConstants.CURSOR_HAND);
            this.btnConfig.setArc(12);
            this.popupMenuConfig = new JPopupMenu();
            this.setComponentPopupMenu(this.btnConfig, this.popupMenuConfig);
            this.btnConfig.setVisible(false);
            this.disableReasonLabel = new JLabel();
            this.disableReasonLabel.setFont(UIConstants.FONT_16_PLAIN);
            this.disableReasonLabel.setText("");
            this.disableReasonLabel.setVisible(false);
            this.panelHeader.add((Component)this.disableReasonLabel, new GridBagConstraints(0, 3, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.panelHeader.add((Component)this.getSearchControlPanel(), new GridBagConstraints(0, 4, 3, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.jSplitPane1 = new JSplitPane(0);
            this.add((Component)this.jSplitPane1, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.jSplitPane1.setBorder(BorderFactory.createEmptyBorder());
            this.jSplitPane1.add((Component)this.getMessageLayerPanel(), "top");
            this.jPanel100 = new JPanel();
            BorderLayout jPanel100Layout = new BorderLayout();
            this.jPanel100.setLayout(jPanel100Layout);
            this.jSplitPane1.add((Component)this.jPanel100, "bottom");
            this.spMessageOut = new JPanel();
            this.spMessageOut.setLayout(new BorderLayout());
            this.jPanel100.add((Component)this.spMessageOut, "Center");
            this.jToolBar1 = new JPanel();
            this.jPanel100.add((Component)this.jToolBar1, "North");
            GridBagLayout jToolBar1Layout = new GridBagLayout();
            this.jToolBar1.setLayout(jToolBar1Layout);
            this.jToolBar1.setBorder(UIConstants.BORDER_MESSAGE_TOOLBAR);
            int x = 0;
            boolean hasFilePermission = PreferencesUtil.hasChatFileActionPermission(UCChatClient.context);
            boolean hasPhotoPermission = PreferencesUtil.hasChatPhotoActionPermission(UCChatClient.context);
            this.btnSendFile = new ImageLabel((Icon)UIConstants.ICON_FILE, I18NUtil.getString("chat_btn_send_file"));
            this.jToolBar1.add((Component)this.btnSendFile, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.btnSendFile.setFont(UIConstants.FONT_14_PLAIN);
            this.btnSendFile.setBorder(Chatroom.BORDER_BTN_MESSAGE);
            this.btnSendFile.setNormalBorderColor(null);
            this.btnSendFile.setCursor(UIConstants.CURSOR_HAND);
            this.btnSendFile.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (WechatChatroom.this.btnSendFile.isEnabled()) {
                        WechatChatroom.this.btnSendFileMouseClicked(evt);
                    }
                }
            });
            this.btnSendFile.setVisible(hasFilePermission);
            this.jSeparator1 = new JSeparator();
            this.jToolBar1.add((Component)this.jSeparator1, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.jSeparator1.setPreferredSize(new Dimension(2, 20));
            this.jSeparator1.setOrientation(1);
            this.jSeparator1.setVisible(hasFilePermission);
            this.btnScreenCapture = new ImageLabel((Icon)UIConstants.ICON_SCREEN_CAPTURE, I18NUtil.getString("chat_btn_screen_capture"));
            this.jToolBar1.add((Component)this.btnScreenCapture, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 0, 0), 0, 0));
            this.btnScreenCapture.setFont(UIConstants.FONT_14_PLAIN);
            this.btnScreenCapture.setBorder(Chatroom.BORDER_BTN_MESSAGE);
            this.btnScreenCapture.setNormalBorderColor(null);
            this.btnScreenCapture.setCursor(UIConstants.CURSOR_HAND);
            this.btnScreenCapture.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (WechatChatroom.this.btnScreenCapture.isEnabled()) {
                        WechatChatroom.this.btnScreenCaptureMouseClicked(evt);
                    }
                }
            });
            this.btnScreenCapture.setVisible(hasPhotoPermission);
            this.jSeparator2 = new JSeparator();
            this.jToolBar1.add((Component)this.jSeparator2, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 5, 0, 5), 0, 0));
            this.jSeparator2.setPreferredSize(new Dimension(2, 20));
            this.jSeparator2.setOrientation(1);
            this.jSeparator2.setVisible(hasPhotoPermission);
            this.btnSendEmoticon = new ImageLabel((Icon)UIConstants.ICON_EMOTICON, I18NUtil.getString("chat_msg_type_emoticon"));
            this.jToolBar1.add((Component)this.btnSendEmoticon, new GridBagConstraints(x++, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
            this.btnSendEmoticon.setFont(UIConstants.FONT_14_PLAIN);
            this.btnSendEmoticon.setBorder(Chatroom.BORDER_BTN_MESSAGE);
            this.btnSendEmoticon.setNormalBorderColor(null);
            this.btnSendEmoticon.setCursor(UIConstants.CURSOR_HAND);
            this.btnSendEmoticon.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (WechatChatroom.this.btnSendEmoticon.isEnabled()) {
                        WechatChatroom.this.btnSendEmoticonMouseClicked(evt);
                    }
                }
            });
            this.lblPadding = new JLabel();
            this.jToolBar1.add((Component)this.lblPadding, new GridBagConstraints(x++, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.spMessage = new UCScrollPane();
            this.spMessageOut.add((Component)this.spMessage, "Center");
            this.spMessage.setPreferredSize(new Dimension(300, 130));
            this.txtMessage = new MessageInput(new MessageInput.MessageInputCallback(){

                @Override
                public void onSendMessage(String text) {
                    if (TextUtils.isNotBlank((CharSequence)text)) {
                        ArrayList<ChatReceiver> chatReceiverList = new ArrayList<ChatReceiver>();
                        chatReceiverList.add(new ChatReceiver(WechatChatroom.this.mRoomJid));
                        if (ChatActionUtil.sendMessage(WechatChatroom.this.mQuotePackageId, chatReceiverList, text)) {
                            WechatChatroom.this.txtMessage.setText("");
                            WechatChatroom.this.onReferenceRemoved(WechatChatroom.this.mQuotePackageId);
                            UserDatabase database = UserDatabase.getDB(UCChatClient.context);
                            database.deletePendingMessage(WechatChatroom.this.mRoomJid);
                        }
                        WechatChatroom.this.txtMessage.requestFocus();
                    }
                }

                @Override
                public List<LiteContact> pickContact() {
                    return null;
                }

                @Override
                public void focusLost() {
                    WechatChatroom.this.saveDraft();
                }
            }, this.fileSelectionCallback, this);
            UserDatabase database = UserDatabase.getDB(UCChatClient.context);
            String pendingMsg = database.getPendingMessage(this.getChatroomID());
            this.txtMessage.setPendingText(pendingMsg);
            this.spMessage.setViewportView(this.txtMessage);
            this.sendBtnPanel = new JPanel();
            this.sendBtnPanel.setBorder(BorderFactory.createEmptyBorder(15, 10, 15, 15));
            this.sendBtnPanel.setLayout(new BorderLayout());
            this.sendBtnPanel.setBackground(Color.WHITE);
            this.spMessageOut.add((Component)this.sendBtnPanel, "East");
            this.sendButton = new JButton();
            this.sendBtnPanel.add((Component)this.sendButton, "South");
            this.sendButton.setText(I18NUtil.getString("chat_btn_send") + " (S)");
            this.sendButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    String docText = WechatChatroom.this.txtMessage.getMessageTextWithIconKey();
                    if (TextUtils.isNotBlank((CharSequence)docText)) {
                        ArrayList<ChatReceiver> chatReceiverList = new ArrayList<ChatReceiver>();
                        chatReceiverList.add(new ChatReceiver(WechatChatroom.this.mRoomJid));
                        if (ChatActionUtil.sendMessage(WechatChatroom.this.mQuotePackageId, chatReceiverList, docText)) {
                            WechatChatroom.this.txtMessage.setText("");
                            WechatChatroom.this.onReferenceRemoved(WechatChatroom.this.mQuotePackageId);
                            UserDatabase database = UserDatabase.getDB(UCChatClient.context);
                            database.deletePendingMessage(WechatChatroom.this.mRoomJid);
                        }
                        WechatChatroom.this.txtMessage.requestFocus();
                    }
                }
            });
            this.panelHeader.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    if (WechatChatroom.this.panelHeader.getHeight() >= 0) {
                        int panelHeight = PreferencesUtil.getChatInputAreaHeight(UCChatClient.context);
                        int loc = WechatChatroom.this.mPanrent.getHeight() - WechatChatroom.this.panelHeader.getHeight() - panelHeight;
                        if (loc > 200 && panelHeight > 200) {
                            WechatChatroom.this.jSplitPane1.setDividerLocation(loc);
                        } else {
                            WechatChatroom.this.jSplitPane1.setDividerLocation(0.7);
                        }
                    }
                }
            });
            this.jPanel100.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    Dimension d = WechatChatroom.this.jPanel100.getSize();
                    if (d.getHeight() >= 0.0) {
                        PreferencesUtil.setChatInputAreaHeight(UCChatClient.context, (int)d.getHeight());
                    }
                    if (WechatChatroom.this.mMessageArea != null) {
                        WechatChatroom.this.mMessageArea.refreshScrollBar();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onReferenceSelected(String packetId) {
        if (StringUtils.isBlank((CharSequence)packetId)) {
            return;
        }
        this.onReferenceRemoved(null);
        this.mQuotePackageId = packetId;
        this.referenceMsgOut = new ReferenceOut(new ReferenceOut.ReferenceClose(){

            @Override
            public void onReferenceCancel() {
                WechatChatroom.this.onReferenceRemoved(null);
            }

            @Override
            public void onMouseClicked() {
                WechatChatroom.this.mMessageArea.scrollToPacketId(WechatChatroom.this.mQuotePackageId);
            }
        });
        this.referenceMsgOut.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                WechatChatroom.this.mMessageArea.scrollToPacketId(WechatChatroom.this.mQuotePackageId);
            }
        });
        this.referenceMsgOut.setCursor(new Cursor(12));
        Message quoteMsg = UCDBMessage.findMsgByPacketId(UCChatClient.context, this.mQuotePackageId);
        this.referenceMsgOut.setMsg(quoteMsg, false);
        this.spMessageOut.add((Component)this.referenceMsgOut, "North");
        this.jPanel100.validate();
    }

    @Override
    public void onReferenceRemoved(String packetId) {
        if (StringUtils.isNotBlank((CharSequence)packetId) && (StringUtils.isBlank((CharSequence)this.mQuotePackageId) || !this.mQuotePackageId.equalsIgnoreCase(packetId))) {
            return;
        }
        if (this.referenceMsgOut != null) {
            this.spMessageOut.remove(this.referenceMsgOut);
            this.referenceMsgOut = null;
            this.mQuotePackageId = null;
            this.jPanel100.validate();
        }
    }

    private void initConfigPopup() {
        this.popupMenuConfig.add(this.favoriteAction);
        this.popupMenuConfig.add(this.notificationAction);
    }

    private void cleanConfigPopup() {
        this.popupMenuConfig.removeAll();
        ListenerCleaner.cleanPropertyChangeListener(this.notificationAction);
        ListenerCleaner.cleanPropertyChangeListener(this.favoriteAction);
    }

    private void initReceiver() {
        this.receiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                try {
                    String action = intent.getAction();
                    if (action.equals("ezphone.intent.action.event.GROUP_LIST_CHANGED")) {
                        WechatChatroom.this.group_listChanged();
                    } else if (action.equals("ezphone.intent.action.event.EXE_CUSTOMER_LEVEL_UPDATE_FAILED")) {
                        WechatChatroom.this.exe_customerLevelUpdateFailed(intent);
                    } else if (action.equals("ezphone.intent.action.event.CUSTOMER_STATUS_CHANGED")) {
                        WechatChatroom.this.updateCustomer();
                    } else if (action.equals("ezphone.intent.action.event.FETCH_CUSTOMER_HISTORY_LOG")) {
                        WechatChatroom.this.updateCustomerHistory(intent);
                    } else if ("ezphone.intent.action.event.PERSONAL_INFO_CHANGED".equals(action)) {
                        WechatChatroom.this.updateCustomer();
                        boolean hasFilePermission = PreferencesUtil.hasChatFileActionPermission(UCChatClient.context);
                        boolean hasPhotoPermission = PreferencesUtil.hasChatPhotoActionPermission(UCChatClient.context);
                        WechatChatroom.this.btnSendFile.setVisible(hasFilePermission);
                        WechatChatroom.this.jSeparator1.setVisible(hasFilePermission);
                        WechatChatroom.this.btnScreenCapture.setVisible(hasPhotoPermission);
                        WechatChatroom.this.jSeparator2.setVisible(hasPhotoPermission);
                    }
                }
                catch (Throwable t) {
                    Log.e(WechatChatroom.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                }
            }
        };
        this.filter = new IntentFilter();
        this.filter.addAction("ezphone.intent.action.event.GROUP_LIST_CHANGED");
        this.filter.addAction("ezphone.intent.action.event.EXE_CUSTOMER_LEVEL_UPDATE_FAILED");
        this.filter.addAction("ezphone.intent.action.event.CUSTOMER_STATUS_CHANGED");
        this.filter.addAction("ezphone.intent.action.event.FETCH_CUSTOMER_HISTORY_LOG");
        this.filter.addAction("ezphone.intent.action.event.PERSONAL_INFO_CHANGED");
        UCChatClient.context.registerReceiver(this.receiver, this.filter);
    }

    private void switchChatHistory() {
        if (!this.wechatViewHistoryShow) {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        WechatChatroom.this.mMessageArea.stopAudioFile();
                    }
                    catch (UCThreadException e) {
                        Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                    }
                }
            });
            if (this.wechatSessionId != null) {
                WebAgent.getInstance().getCustomerHistoryLog(JidUtil.convertKey(this.mRoomJid), this.wechatSessionId);
                ToastUtil.show(UCChatClient.context, I18NUtil.getString("common_notice_downloading"), 10);
            }
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        if (WechatChatroom.this.tpHistoryArea != null) {
                            WechatChatroom.this.tpHistoryArea.stopAudioFile();
                        }
                    }
                    catch (UCThreadException e) {
                        Log.e(MessageArea.class.getSimpleName(), e.getLocalizedMessage(), e);
                    }
                }
            });
            this.wechatViewHistoryShow = false;
            this.btnHistory.setText(I18NUtil.getString("wechat_history_log"));
            this.jSplitPane1.add((Component)((Object)this.mMessageArea), "top");
            boolean hasChatPermission = PreferencesUtil.hasChatActionPermission(UCChatClient.context);
            if (hasChatPermission) {
                this.setChatMode(ChatMode.ONLY_CHAT, "");
            } else {
                this.setChatMode(ChatMode.DISABLED, "");
            }
            this.tpHistoryArea = null;
        }
    }

    private void showWechatLevelPopup(MouseEvent e) {
        if (this.wechatLevelPopup == null) {
            this.wechatLevelPopup = new WechatLevelPopup(UCChatClient.getInstance(), this);
        }
        Component comp = e.getComponent();
        this.wechatLevelPopup.setLevel(this.liteCustomer.getLevel());
        this.wechatLevelPopup.show(comp, 0, 3 + comp.getHeight());
    }

    public void changeLevel(int level) {
        Log.i(WechatChatroom.class.getSimpleName(), "change level to " + level);
        this.lblLevel.setText(I18NUtil.getString("wechat_level") + level);
        WebAgent.getInstance().updateCustomerLevel(this.liteCustomer.getAccount(), level);
    }

    private void btnSendFileMouseClicked(MouseEvent evt) {
        FileUtil.sendFile(this.fileSelectionCallback);
    }

    private void btnScreenCaptureMouseClicked(MouseEvent evt) {
        CaptureUtil.captureImage(this, this.fileSelectionCallback);
    }

    private void btnSendEmoticonMouseClicked(MouseEvent evt) {
        final EmoticonPopupMenu menu = EmoticonPopupMenu.getInstance();
        menu.setMediaContentInputListener(new MediaContentInputListener(){

            @Override
            public void onStickerClick(String stickerKey) {
            }

            @Override
            public void onEmoticonClick(String emoticonKey, String iconPath) {
                ImageIcon eIcon = GraphicUtil.getScaledIcon(iconPath, 16, 16);
                eIcon.setDescription(emoticonKey);
                WechatChatroom.this.txtMessage.insertIcon(eIcon);
                menu.setVisible(false);
                WechatChatroom.this.txtMessage.requestFocus();
            }

            @Override
            public void onIdiomClick(String text) {
                try {
                    WechatChatroom.this.txtMessage.replaceSelection("");
                    WechatChatroom.this.txtMessage.getDocument().insertString(WechatChatroom.this.txtMessage.getCaretPosition(), text, null);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
                menu.setVisible(false);
                WechatChatroom.this.txtMessage.requestFocus();
            }

            @Override
            public void onSymbolClick(String text) {
                try {
                    WechatChatroom.this.txtMessage.replaceSelection("");
                    WechatChatroom.this.txtMessage.getDocument().insertString(WechatChatroom.this.txtMessage.getCaretPosition(), text, null);
                }
                catch (BadLocationException e1) {
                    e1.printStackTrace();
                }
                menu.setVisible(false);
                WechatChatroom.this.txtMessage.requestFocus();
            }
        });
        menu.show(this.btnSendEmoticon, 0, -menu.getPreferredSize().height);
    }

    private void setComponentPopupMenu(final Component parent, final JPopupMenu menu) {
        parent.addMouseListener(new MouseAdapter(this){

            @Override
            public void mousePressed(MouseEvent e) {
                if (parent.isEnabled()) {
                    menu.show(parent, 0, parent.getHeight());
                }
            }
        });
    }

    @Override
    public void onClose() {
        this.saveDraft();
        if (this.mMessageArea != null) {
            this.mMessageArea.onClose();
        }
        if (this.tpHistoryArea != null) {
            this.tpHistoryArea.onClose();
        }
        if (this.receiver != null) {
            UCChatClient.context.unregisterReceiver(this.receiver);
        }
        ListenerCleaner.cleanMouseListner(this.lblPhoto);
        ListenerCleaner.cleanMouseListner(this.btnSendFile);
        ListenerCleaner.cleanMouseListner(this.btnScreenCapture);
        ListenerCleaner.cleanMouseListner(this.btnSendEmoticon);
        ListenerCleaner.cleanMouseListner(this.btnConfig);
        ListenerCleaner.cleanMouseListner(this.panelLevel);
        ListenerCleaner.cleanMouseListner(this.btnHistory);
        ListenerCleaner.cleanMouseListner(this.btnClose);
        ListenerCleaner.cleanMouseListner(this.btnTransfer);
        ListenerCleaner.cleanActionListner(this.sendButton);
        ListenerCleaner.cleanComponentListner(this.panelHeader);
        ListenerCleaner.cleanComponentListner(this.jPanel100);
        this.cleanConfigPopup();
        this.txtMessage.onClose();
        this.jSplitPane1.removeAll();
        this.mMessageArea = null;
        StickerPopupMenu menu = StickerPopupMenu.getInstance();
        menu.setMediaContentInputListener(null);
    }

    private void saveDraft() {
        if (this.txtMessage == null) {
            return;
        }
        if (this.txtMessage.isEnabled()) {
            UserDatabase database = UserDatabase.getDB(UCChatClient.context);
            String roomJid = this.getChatroomID();
            String existedDraftMsg = database.getPendingMessage(roomJid);
            String docText = this.txtMessage.getMessageTextWithIconKey();
            if (!TextUtils.isBlank((CharSequence)docText)) {
                database.savePendingMessage(roomJid, docText);
                BroadcastUtil.sendContactHistoryChangedEvent(UCChatClient.context);
            } else if (TextUtils.isNotBlank((CharSequence)existedDraftMsg)) {
                database.deletePendingMessage(roomJid);
                BroadcastUtil.sendContactHistoryChangedEvent(UCChatClient.context);
            }
        }
    }

    @Override
    public void onPhoneStatusChanged() {
    }

    private void group_listChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                WechatChatroom.this.updateFavoriteAction(ChatRoomManager.isInMyFavorite(WechatChatroom.this.mRoomJid));
            }
        });
    }

    private void exe_customerLevelUpdateFailed(Intent intent) {
        ToastUtil.showErrorShort(I18NUtil.getString("common_notice_update_failed"));
    }

    private void closeWechat() {
        if (this.wcd == null) {
            this.wcd = new WechatCloseDialog(UCChatClient.getInstance(), this.mRoomJid);
        }
        this.wcd.setLocationRelativeTo(this);
        this.wcd.setVisible(true);
    }

    private void reassignWechat() {
        if (this.wad == null) {
            this.wad = new WechatTransferDialog(UCChatClient.getInstance(), this.mRoomJid);
        }
        this.wad.setLocationRelativeTo(this);
        this.wad.setVisible(true);
    }

    @Override
    public void wechatLevelSelected(int level) {
        this.lblLevel.setText(I18NUtil.getString("wechat_level") + level);
        WebAgent.getInstance().updateCustomerLevel(this.liteCustomer.getAccount(), level);
    }

    @Override
    public boolean isChatModeEnabled() {
        return false;
    }

    public static enum ChatMode {
        DISABLED,
        ONLY_CHAT;

    }

    class MessageHistoryCallback
    implements MessageArea.MessageAreaCallback {
        MessageHistoryCallback() {
        }

        @Override
        public void onScrollTop() {
        }

        @Override
        public void onScrollBottom() {
        }

        @Override
        public void onScrollNotBottom() {
        }

        @Override
        public void dumpToPacketId(String packetId) {
        }

        @Override
        public void resendMsg(Message message) {
        }

        @Override
        public void attachFromName(String name) {
        }

        @Override
        public Message getMessageByPacketId(String packetId) {
            for (Message msg : WechatChatroom.this.customerHistoryList) {
                if (!packetId.equals(msg.getPacketId())) continue;
                return msg;
            }
            return null;
        }

        @Override
        public void onQuoteSelected(String packageId) {
        }

        @Override
        public boolean isChatModeEnabled() {
            return false;
        }

        @Override
        public void onDelete(String packetId) {
        }

        @Override
        public void onRecall(String packetId) {
        }
    }
}

