/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class BubblePanel
extends JPanel {
    private int arc = 12;
    private int thickness = 2;
    private int pointerWidth = 20;
    private int pointerHeight = 12;
    private Color borderColor = Color.BLACK;
    private BasicStroke stroke = null;
    private int strokePad;
    private int pointerPad = 0;
    private Color shadowFromColor = new Color(90, 90, 90);
    private Color shadowToColor = new Color(16, 16, 16);
    private Color bgFromColor = new Color(120, 120, 120);
    private Color bgToColor = new Color(24, 24, 24);

    public BubblePanel() {
        this.stroke = new BasicStroke(this.thickness);
        this.strokePad = this.thickness / 2;
        this.setBorder(BorderFactory.createEmptyBorder(this.pointerHeight + this.thickness, this.thickness, this.thickness, this.thickness));
        this.setOpaque(false);
    }

    @Override
    protected void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        Graphics2D g2d = (Graphics2D)g;
        Paint oldPaint = g2d.getPaint();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int shadow = 2;
        int bubbleHeight = height - this.thickness - this.pointerHeight - shadow;
        RoundRectangle2D.Double bubbleShadow = new RoundRectangle2D.Double(0 + this.strokePad, shadow + this.strokePad + this.pointerHeight, width - this.thickness, bubbleHeight, this.arc, this.arc);
        GradientPaint paintShadow = new GradientPaint(0.0f, 0.0f, this.shadowFromColor, 0.0f, height, this.shadowToColor, true);
        g2d.setPaint(paintShadow);
        g2d.fill(bubbleShadow);
        RoundRectangle2D.Double bubbleBG = new RoundRectangle2D.Double(shadow + this.strokePad, 0 + this.strokePad + this.pointerHeight, width - this.thickness - shadow * 2, bubbleHeight, this.arc, this.arc);
        Polygon pointer = new Polygon();
        pointer.addPoint(this.strokePad + this.arc + this.pointerPad, this.strokePad + this.thickness + this.pointerHeight);
        pointer.addPoint(this.strokePad + this.arc + this.pointerPad + this.pointerWidth, this.strokePad + this.thickness + this.pointerHeight);
        pointer.addPoint(this.strokePad + this.arc + this.pointerPad + this.pointerWidth / 2, this.strokePad);
        Area areaBG = new Area(bubbleBG);
        areaBG.add(new Area(pointer));
        GradientPaint paintBG = new GradientPaint(0.0f, 0.0f, this.bgFromColor, 0.0f, height, this.bgToColor, true);
        g2d.setPaint(paintBG);
        g2d.fill(areaBG);
        g2d.setPaint(oldPaint);
    }
}

