/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.PersonalPhoto;
import com.blisscloud.ezuc.client.util.PhoneStatusUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;

public class ContactCellRendererForDropDown
extends JPanel
implements ListCellRenderer<Object> {
    private PersonalPhoto lblHeadIcon;
    private JLabel lblName;
    private JLabel lblStatus;

    public ContactCellRendererForDropDown() {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
        this.lblHeadIcon = new PersonalPhoto();
        this.lblHeadIcon.setPreferredSize(new Dimension(32, 32));
        this.add((Component)this.lblHeadIcon, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
        this.lblName = new JLabel();
        this.add((Component)this.lblName, new GridBagConstraints(1, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
        this.lblName.setFont(UIConstants.FONT_14_PLAIN);
        this.lblStatus = new JLabel();
        this.add((Component)this.lblStatus, new GridBagConstraints(4, 0, 1, 2, 0.0, 0.0, 13, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.lblStatus.setFont(UIConstants.FONT_12_PLAIN);
        this.lblStatus.setForeground(UIConstants.COLOR_LIGHT_GRAY);
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (value != null) {
            LiteContact contact = (LiteContact)value;
            String contactJID = contact.getJid();
            String contactName = ContactManager.getContactFullName(contact);
            Image contactImage = ContactManager.getContactImage(contact, 32, false, true);
            this.lblHeadIcon.setImage(contactImage);
            this.lblName.setText(contactName == null ? contactJID : contactName);
            String status = "";
            if (JidUtil.isEmployeeJid(contact.getJid())) {
                status = ContactManager.getPhoneEmpStatus("" + contact.getId());
            } else if (JidUtil.isLocationJid(contact.getJid())) {
                status = ContactManager.getPhoneLocStatus(contact.getJid());
            }
            this.updateStatusText(this.lblStatus, status, isSelected);
        }
        return this;
    }

    private void updateStatusText(JLabel lblStatus, String status, boolean isSelected) {
        String statusText = PhoneStatusUtil.getPhoneStatusText(status);
        Color statusColor = PhoneStatusUtil.getPhoneStatusColor(status);
        StringBuilder sb = new StringBuilder();
        sb.append("<html><table cellspacing=\"1\" cellpadding=\"1\">");
        if (TextUtils.isNotBlank((CharSequence)statusText)) {
            if (statusColor == null) {
                statusColor = Color.BLACK;
            }
            String colorHex = String.format("#%02x%02x%02x", statusColor.getRed(), statusColor.getGreen(), statusColor.getBlue());
            sb.append("<rd><td nowrap align=\"right\"><font color=\"").append(colorHex).append("\">").append(statusText).append("</font></td></tr>");
        }
        sb.append("</table></html>");
        lblStatus.setText(sb.toString());
    }
}

