/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.bean.DataImportBean;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;

public class DataImportCellRenderer
extends DefaultListCellRenderer {
    @Override
    public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
        if (value != null) {
            DataImportBean bean = (DataImportBean)value;
            String dispName = "";
            if (bean.getDays() == -1L) {
                dispName = I18NUtil.getString("init_data_option_noimport");
            } else if (bean.getDays() == 14L) {
                dispName = I18NUtil.getString("init_data_option_two_weeks");
            } else if (bean.getDays() == 30L) {
                dispName = I18NUtil.getString("init_data_option_one_month");
            } else if (bean.getDays() == 90L) {
                dispName = I18NUtil.getString("init_data_option_three_month");
            } else if (bean.getDays() == 365L) {
                dispName = I18NUtil.getString("init_data_option_one_year");
            } else if (bean.getDays() == bean.getTotalDays()) {
                if (bean.getTotalDays() == 0L) {
                    dispName = I18NUtil.getString("init_data_option_all_less_one_day");
                } else {
                    long years = bean.getTotalDays() / 365L;
                    long rdays = bean.getTotalDays() % 365L;
                    dispName = years == 0L ? String.format(I18NUtil.getString("init_data_option_all"), bean.getTotalDays()) : String.format(I18NUtil.getString("init_data_option_all_with_year"), years, rdays);
                }
            } else if (bean.getDays() == -2L) {
                dispName = I18NUtil.getString("init_data_option_days_specific");
            }
            this.setText(dispName);
        }
        this.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 10));
        this.setFont(UIConstants.FONT_16_PLAIN);
        return this;
    }
}

