/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import com.blisscloud.ezuc.client.UIConstants;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.RoundRectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JToggleButton;

public class HighlightToggleButton
extends JToggleButton {
    private int arc = 0;
    private float borderThick = 1.0f;
    private boolean entered = false;
    private Color enteredBorderColor = Color.LIGHT_GRAY;
    private Color selectedBorderColor = Color.LIGHT_GRAY;
    private Color enteredBackgroundFrom = new Color(0xE0E0E0);
    private Color enteredBackgroundTo = new Color(0xE0E0E0);
    private Color selectedBackgroundFrom = new Color(10, 126, 217);
    private Color selectedBackgroundTo = new Color(159, 210, 251);
    private BasicStroke borderStroke;

    public HighlightToggleButton() {
        this.init();
    }

    public HighlightToggleButton(String text) {
        this.setText(text);
        this.init();
    }

    public HighlightToggleButton(String text, Color selectedBackgroundFrom, Color selectedBackgroundTo) {
        this.setText(text);
        this.selectedBackgroundFrom = selectedBackgroundFrom;
        this.selectedBackgroundTo = selectedBackgroundTo;
        this.init();
    }

    public HighlightToggleButton(String text, Color enteredBackgroundFrom, Color enteredBackgroundTo, Color selectedBackgroundFrom, Color selectedBackgroundTo) {
        this.setText(text);
        this.enteredBackgroundFrom = enteredBackgroundFrom;
        this.enteredBackgroundTo = enteredBackgroundTo;
        this.selectedBackgroundFrom = selectedBackgroundFrom;
        this.selectedBackgroundTo = selectedBackgroundTo;
        this.init();
    }

    public HighlightToggleButton(Color enteredBackgroundFrom, Color enteredBackgroundTo, Color selectedBackgroundFrom, Color selectedBackgroundTo) {
        this.enteredBackgroundFrom = enteredBackgroundFrom;
        this.enteredBackgroundTo = enteredBackgroundTo;
        this.selectedBackgroundFrom = selectedBackgroundFrom;
        this.selectedBackgroundTo = selectedBackgroundTo;
        this.init();
    }

    private void init() {
        this.setBorderPainted(false);
        this.setFocusPainted(false);
        this.setContentAreaFilled(false);
        this.setFont(UIConstants.FONT_12_PLAIN);
        this.setBorder(BorderFactory.createEmptyBorder(6, this.arc / 2, 6, this.arc / 2));
        this.setOpaque(false);
        this.borderStroke = new BasicStroke(this.borderThick);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent evt) {
                if (HighlightToggleButton.this.isEnabled()) {
                    HighlightToggleButton.this.entered = false;
                    HighlightToggleButton.this.repaint();
                }
            }

            @Override
            public void mouseEntered(MouseEvent evt) {
                if (HighlightToggleButton.this.isEnabled()) {
                    HighlightToggleButton.this.entered = true;
                    HighlightToggleButton.this.repaint();
                }
            }
        });
    }

    public int getArc() {
        return this.arc;
    }

    public void setArc(int arc) {
        this.arc = arc;
        this.setBorder(BorderFactory.createEmptyBorder(6, arc / 2, 6, arc / 2));
        this.repaint();
    }

    public Color getEnteredBorderColor() {
        return this.enteredBorderColor;
    }

    public void setEnteredBorderColor(Color enteredBorderColor) {
        this.enteredBorderColor = enteredBorderColor;
    }

    public Color getSelectedBorderColor() {
        return this.selectedBorderColor;
    }

    public void setSelectedBorderColor(Color selectedBorderColor) {
        this.selectedBorderColor = selectedBorderColor;
    }

    public Color getEnteredBackgroundFrom() {
        return this.enteredBackgroundFrom;
    }

    public void setEnteredBackgroundFrom(Color enteredBackgroundFrom) {
        this.enteredBackgroundFrom = enteredBackgroundFrom;
    }

    public Color getEnteredBackgroundTo() {
        return this.enteredBackgroundTo;
    }

    public void setEnteredBackgroundTo(Color enteredBackgroundTo) {
        this.enteredBackgroundTo = enteredBackgroundTo;
    }

    public Color getSelectedBackgroundFrom() {
        return this.selectedBackgroundFrom;
    }

    public void setSelectedBackgroundFrom(Color selectedBackgroundFrom) {
        this.selectedBackgroundFrom = selectedBackgroundFrom;
    }

    public Color getSelectedBackgroundTo() {
        return this.selectedBackgroundTo;
    }

    public void setSelectedBackgroundTo(Color selectedBackgroundTo) {
        this.selectedBackgroundTo = selectedBackgroundTo;
    }

    @Override
    public void paintComponent(Graphics g) {
        int width = this.getWidth();
        int height = this.getHeight();
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        RoundRectangle2D.Double rectBG = new RoundRectangle2D.Double(0.0, 0.0, width, height, this.arc, this.arc);
        RoundRectangle2D.Double rectBorder = new RoundRectangle2D.Double(0.0, 0.0, width - 1, height - 1, this.arc, this.arc);
        if (this.isSelected()) {
            if (this.entered) {
                oldPaint = g2d.getPaint();
                paint = new GradientPaint(width / 2, 0.0f, this.selectedBackgroundFrom, width / 2, height, this.selectedBackgroundTo, true);
                g2d.setPaint(paint);
                g2d.fill(rectBG);
                g2d.setPaint(oldPaint);
            } else {
                oldPaint = g2d.getPaint();
                paint = new GradientPaint(width / 2, 0.0f, this.selectedBackgroundFrom, width / 2, height, this.selectedBackgroundTo, true);
                g2d.setPaint(paint);
                g2d.fill(rectBG);
                g2d.setPaint(oldPaint);
            }
        } else if (this.entered) {
            oldPaint = g2d.getPaint();
            paint = new GradientPaint(width / 2, 0.0f, this.enteredBackgroundFrom, width / 2, height, this.enteredBackgroundTo, true);
            g2d.setPaint(paint);
            g2d.fill(rectBG);
            g2d.setPaint(oldPaint);
        }
        if (this.isBorderPainted()) {
            if (this.isSelected()) {
                if (this.entered) {
                    oldColor = g2d.getColor();
                    oldStroke = g2d.getStroke();
                    g2d.setColor(this.selectedBorderColor);
                    g2d.setStroke(this.borderStroke);
                    g2d.draw(rectBorder);
                    g2d.setColor(oldColor);
                    g2d.setStroke(oldStroke);
                }
            } else if (this.entered) {
                oldColor = g2d.getColor();
                oldStroke = g2d.getStroke();
                g2d.setColor(this.enteredBorderColor);
                g2d.setStroke(this.borderStroke);
                g2d.draw(rectBorder);
                g2d.setColor(oldColor);
                g2d.setStroke(oldStroke);
            }
        }
        super.paintComponent(g2d);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().setLayout(new FlowLayout());
        frame.getContentPane().add(new HighlightToggleButton("label"));
        frame.getContentPane().add(new HighlightToggleButton("label", Color.LIGHT_GRAY, Color.DARK_GRAY));
        frame.getContentPane().add(new HighlightToggleButton("\u6587\u5b57", Color.LIGHT_GRAY, Color.DARK_GRAY, Color.pink, Color.red));
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public boolean isEntered() {
        return this.entered;
    }

    public void setEntered(boolean entered) {
        this.entered = entered;
    }
}

