/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;

public class HintTextField
extends JTextField
implements FocusListener {
    public static final Color HINT_COLOR = Color.GRAY;
    String hintText;
    Font hintFont;

    public HintTextField(String hintText) {
        this.hintText = hintText;
        this.addFocusListener(this);
    }

    public HintTextField(String hintText, Font hintFont) {
        this.hintText = hintText;
        this.hintFont = hintFont;
        this.addFocusListener(this);
    }

    public void setHintText(String hintText) {
        this.hintText = hintText;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        Font font;
        super.paintComponent(g);
        Font font2 = font = this.hintFont == null ? new Font("Microsoft JhengHei", 0, this.getFont().getSize()) : this.hintFont;
        if (!(!this.getText().equals("") || this.isEditable() && this.isFocusOwner())) {
            int width = this.getWidth();
            int height = this.getHeight();
            Font prevFont = g.getFont();
            Color prevColor = g.getColor();
            g.setFont(font);
            g.setColor(HINT_COLOR);
            int h = g.getFontMetrics().getHeight();
            int textBottom = (height - h) / 2 + h - 4;
            int x = this.getInsets().left;
            Graphics2D g2d = (Graphics2D)g;
            RenderingHints hints = g2d.getRenderingHints();
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.drawString(this.hintText, x, textBottom);
            g2d.setRenderingHints(hints);
            g.setFont(prevFont);
            g.setColor(prevColor);
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.repaint();
    }
}

