/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextPane;
import javax.swing.UIManager;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class HintTextPane
extends JTextPane
implements FocusListener {
    String hintText;
    Font hintFont;

    public HintTextPane(String hintText) {
        this.hintText = hintText;
        this.setEditorKit(new WarpEditorKit());
        this.addFocusListener(this);
    }

    public HintTextPane(String hintText, Font hintFont) {
        this.hintText = hintText;
        this.hintFont = hintFont;
        this.setEditorKit(new WarpEditorKit());
        this.addFocusListener(this);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Font font;
        super.paintComponent(g);
        Font font2 = font = this.hintFont == null ? new Font("Microsoft JhengHei", 0, this.getFont().getSize()) : this.hintFont;
        if (this.getText().equals("") && !this.isFocusOwner()) {
            Font prevFont = g.getFont();
            Color prevColor = g.getColor();
            g.setFont(font);
            g.setColor(UIManager.getColor("textInactiveText"));
            int h = g.getFontMetrics().getHeight();
            int x = this.getInsets().left;
            Graphics2D g2d = (Graphics2D)g;
            RenderingHints hints = g2d.getRenderingHints();
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.drawString(this.hintText, x, h);
            g2d.setRenderingHints(hints);
            g.setFont(prevFont);
            g.setColor(prevColor);
        }
    }

    @Override
    public void focusGained(FocusEvent arg0) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent arg0) {
        this.repaint();
    }

    private class WarpEditorKit
    extends StyledEditorKit {
        private ViewFactory defaultFactory;

        private WarpEditorKit() {
            this.defaultFactory = new WarpColumnFactory();
        }

        @Override
        public ViewFactory getViewFactory() {
            return this.defaultFactory;
        }
    }

    private class WarpLabelView
    extends LabelView {
        public WarpLabelView(HintTextPane hintTextPane, Element elem) {
            super(elem);
        }

        @Override
        public float getMinimumSpan(int axis) {
            switch (axis) {
                case 0: {
                    return 0.0f;
                }
                case 1: {
                    return super.getMinimumSpan(axis);
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }
    }

    private class WarpColumnFactory
    implements ViewFactory {
        private WarpColumnFactory() {
        }

        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new WarpLabelView(HintTextPane.this, elem);
                }
                if (kind.equals("paragraph")) {
                    return new ParagraphView(elem);
                }
                if (kind.equals("section")) {
                    return new BoxView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new LabelView(elem);
        }
    }
}

