/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.chat.DownloadFileTask;
import com.blisscloud.ezuc.client.chat.DownloadFileTaskCallBack;
import com.blisscloud.ezuc.client.component.CopyImages;
import com.blisscloud.ezuc.client.component.ImageDispPanel;
import com.blisscloud.ezuc.client.component.LoadImageMsgPanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.ToastUtil;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.util.CommonUtil;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javafx.application.Platform;
import javafx.stage.FileChooser;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import org.apache.commons.lang3.StringUtils;

public class LoadImagePanel
extends JPanel
implements ImageObserver {
    private static final double MIN_RATIO = 1.0;
    private static final double MAX_RATIO = 3.0;
    private DownloadFileTask mDownloadTask;
    private JScrollPane photoScroll;
    private JLabel copyToClipboard;
    private JLabel lblMax;
    private JLabel lblUp;
    private JLabel lblDown;
    private JLabel lblMin;
    private JLabel lblOther;
    private JLabel lblDownload;
    private JLabel lblLeft;
    private JLabel lblRight;
    private JPanel functionPanel;
    private JPanel mViewPort;
    private File cacheFile = null;
    private String imageName = null;
    private String thumbnailBase64 = null;
    private double gap = 0.12;
    private LoadImageMsgPanel loadImageMsgPanel;
    private Message currentMsg;
    private Message prevMsg;
    private Message nextMsg;
    private static final String LEFT = "left";
    private static final String RIGHT = "right";
    double mainRatio = 1.0;
    MouseAdapter ma = new MouseAdapter(){
        private Point origin;

        @Override
        public void mouseClicked(MouseEvent evt) {
            LoadImagePanel.this.setVisible(false);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.origin = new Point(e.getPoint());
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            JViewport viewPort;
            if (this.origin != null && (viewPort = (JViewport)SwingUtilities.getAncestorOfClass(JViewport.class, LoadImagePanel.this.mViewPort)) != null) {
                int deltaX = this.origin.x - e.getX();
                int deltaY = this.origin.y - e.getY();
                Rectangle view = viewPort.getViewRect();
                view.x += deltaX;
                view.y += deltaY;
                LoadImagePanel.this.mViewPort.scrollRectToVisible(view);
            }
        }
    };

    public LoadImagePanel() {
        this.initGUI();
    }

    private void initGUI() {
        try {
            ActionMap actionMap = this.getActionMap();
            int condition = 2;
            InputMap inputMap = this.getInputMap(condition);
            inputMap.put(KeyStroke.getKeyStroke(37, 0), LEFT);
            actionMap.put(LEFT, new LeftAction());
            inputMap.put(KeyStroke.getKeyStroke(39, 0), RIGHT);
            actionMap.put(RIGHT, new RightAction());
            this.setOpaque(false);
            ToolTipManager.sharedInstance().setLightWeightPopupEnabled(false);
            this.setLayout(new BorderLayout(15, 15));
            this.loadImageMsgPanel = new LoadImageMsgPanel();
            this.loadImageMsgPanel.setVisible(false);
            this.add(this.loadImageMsgPanel);
            this.functionPanel = new JPanel();
            this.functionPanel.setVisible(false);
            this.functionPanel.setOpaque(false);
            this.add((Component)this.functionPanel, "South");
            FlowLayout jPanel3Layout = new FlowLayout();
            jPanel3Layout.setVgap(0);
            jPanel3Layout.setHgap(20);
            this.functionPanel.setLayout(jPanel3Layout);
            this.functionPanel.addMouseListener(new MouseAdapter(this){

                @Override
                public void mouseClicked(MouseEvent evt) {
                }
            });
            this.copyToClipboard = new JLabel();
            this.copyToClipboard.setIcon(UIConstants.ICON_PHOTO_COPY_2_CLIPBOARD);
            this.copyToClipboard.setForeground(Color.WHITE);
            this.copyToClipboard.setCursor(new Cursor(12));
            this.copyToClipboard.setToolTipText(I18NUtil.getString("photo_diplay_btn_copy_to_clipboard"));
            this.functionPanel.add(this.copyToClipboard);
            this.copyToClipboard.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    LoadImagePanel.this.copyToClipboard();
                }
            });
            this.lblDownload = new JLabel();
            this.lblDownload.setIcon(UIConstants.ICON_PHOTO_DOWNLOAD);
            this.lblDownload.setForeground(Color.WHITE);
            this.lblDownload.setCursor(new Cursor(12));
            this.lblDownload.setToolTipText(I18NUtil.getString("photo_diplay_btn_download"));
            this.functionPanel.add(this.lblDownload);
            this.lblDownload.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    LoadImagePanel.this.download();
                }
            });
            this.lblOther = new JLabel();
            this.lblOther.setIcon(UIConstants.ICON_PHOTO_OTHER);
            this.lblOther.setForeground(Color.WHITE);
            this.lblOther.setCursor(new Cursor(12));
            this.lblOther.setToolTipText(I18NUtil.getString("photo_diplay_btn_other"));
            this.functionPanel.add(this.lblOther);
            this.lblOther.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    LoadImagePanel.this.openOther();
                }
            });
            this.lblLeft = new JLabel();
            this.lblLeft.setIcon(UIConstants.ICON_PHOTO_LEFT);
            this.lblLeft.setForeground(Color.WHITE);
            this.lblLeft.setCursor(new Cursor(12));
            this.lblLeft.setToolTipText(I18NUtil.getString("photo_diplay_btn_left"));
            this.functionPanel.add(this.lblLeft);
            this.lblLeft.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    LoadImagePanel.this.findPrev();
                }
            });
            this.lblRight = new JLabel();
            this.lblRight.setIcon(UIConstants.ICON_PHOTO_RIGHT);
            this.lblRight.setForeground(Color.WHITE);
            this.lblRight.setCursor(new Cursor(12));
            this.lblRight.setToolTipText(I18NUtil.getString("photo_diplay_btn_right"));
            this.functionPanel.add(this.lblRight);
            this.lblRight.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    LoadImagePanel.this.findNext();
                }
            });
            this.lblMax = new JLabel();
            this.lblMax.setIcon(UIConstants.ICON_PHOTO_MAX);
            this.lblMax.setForeground(Color.WHITE);
            this.lblMax.setCursor(new Cursor(12));
            this.lblMax.setToolTipText(I18NUtil.getString("photo_diplay_btn_zoomMax"));
            this.functionPanel.add(this.lblMax);
            this.lblMax.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    LoadImagePanel.this.zoomMax();
                }
            });
            this.lblUp = new JLabel();
            this.lblUp.setIcon(UIConstants.ICON_PHOTO_ZOOM_IN);
            this.lblUp.setForeground(Color.WHITE);
            this.lblUp.setCursor(new Cursor(12));
            this.lblUp.setToolTipText(I18NUtil.getString("photo_diplay_btn_zoomIn"));
            this.functionPanel.add(this.lblUp);
            this.lblUp.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    LoadImagePanel.this.zoomIn();
                }
            });
            this.lblDown = new JLabel();
            this.lblDown.setIcon(UIConstants.ICON_PHOTO_ZOOM_OUT);
            this.lblDown.setForeground(Color.WHITE);
            this.lblDown.setCursor(new Cursor(12));
            this.lblDown.setToolTipText(I18NUtil.getString("photo_diplay_btn_zoomOut"));
            this.functionPanel.add(this.lblDown);
            this.lblDown.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    LoadImagePanel.this.zoomOut();
                }
            });
            this.lblMin = new JLabel();
            this.lblMin.setIcon(UIConstants.ICON_PHOTO_MIN);
            this.lblMin.setForeground(Color.WHITE);
            this.lblMin.setCursor(new Cursor(12));
            this.lblMin.setToolTipText(I18NUtil.getString("photo_diplay_btn_zoomMin"));
            this.functionPanel.add(this.lblMin);
            this.lblMin.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    LoadImagePanel.this.zoomMin();
                }
            });
            JLabel lblClose = new JLabel();
            lblClose.setIcon(UIConstants.ICON_PHOTO_CLOSE);
            lblClose.setForeground(Color.WHITE);
            lblClose.setCursor(UIConstants.CURSOR_HAND);
            lblClose.setToolTipText(I18NUtil.getString("photo_diplay_btn_close"));
            this.functionPanel.add(lblClose);
            lblClose.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    LoadImagePanel.this.setVisible(false);
                }
            });
            this.photoScroll = new JScrollPane();
            this.photoScroll.getVerticalScrollBar().setUnitIncrement(20);
            this.photoScroll.getHorizontalScrollBar().setUnitIncrement(20);
            this.photoScroll.setHorizontalScrollBarPolicy(31);
            this.photoScroll.setVerticalScrollBarPolicy(21);
            this.photoScroll.setOpaque(false);
            this.photoScroll.setBorder(BorderFactory.createEmptyBorder());
            this.photoScroll.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    LoadImagePanel.this.setVisible(false);
                }
            });
            this.photoScroll.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    if (e.isControlDown()) {
                        if (e.getWheelRotation() < 0) {
                            LoadImagePanel.this.zoomIn();
                        } else {
                            LoadImagePanel.this.zoomOut();
                        }
                    } else {
                        LoadImagePanel.this.photoScroll.getVerticalScrollBar().setValue(LoadImagePanel.this.photoScroll.getVerticalScrollBar().getValue() + e.getUnitsToScroll() * LoadImagePanel.this.photoScroll.getVerticalScrollBar().getUnitIncrement());
                    }
                }
            });
            this.mViewPort = new JPanel();
            this.mViewPort.setOpaque(false);
            this.mViewPort.setLayout(new GridBagLayout());
            this.mViewPort.setAutoscrolls(true);
            this.mViewPort.addMouseListener(this.ma);
            this.mViewPort.addMouseMotionListener(this.ma);
            this.photoScroll.setViewportView(this.mViewPort);
            this.photoScroll.getViewport().setOpaque(false);
            this.add((Component)this.photoScroll, "Center");
            UCChatClient mainFrame = UCChatClient.getInstance();
            this.setPreferredSize(mainFrame.getSize());
            this.setMaximumSize(mainFrame.getSize());
            this.revalidate();
            this.repaint();
            if (this.getParent() != null) {
                this.getParent().revalidate();
                this.getParent().repaint();
            }
            this.checkBtn();
            this.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    UCChatClient mainFrame = UCChatClient.getInstance();
                    LoadImagePanel.this.setPreferredSize(mainFrame.getSize());
                    LoadImagePanel.this.setMaximumSize(mainFrame.getSize());
                    LoadImagePanel.this.setMaximumSize(mainFrame.getSize());
                    LoadImagePanel.this.setMinimumSize(mainFrame.getSize());
                    LoadImagePanel.this.showImagePanel();
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void zoomMax() {
        if (!this.lblMax.isEnabled()) {
            return;
        }
        Log.d(LoadImagePanel.class.getSimpleName(), "zoomMax");
        this.mainRatio = 3.0;
        this.showImagePanel();
        this.checkBtn();
    }

    private void zoomIn() {
        if (!this.lblUp.isEnabled()) {
            return;
        }
        Log.d(LoadImagePanel.class.getSimpleName(), "zoomIn");
        this.mainRatio = Math.min(3.0, this.mainRatio + this.gap);
        this.showImagePanel();
        this.checkBtn();
    }

    private void zoomOut() {
        if (!this.lblDown.isEnabled()) {
            return;
        }
        Log.d(LoadImagePanel.class.getSimpleName(), "zoomOut");
        this.mainRatio = Math.max(1.0, this.mainRatio - this.gap);
        this.showImagePanel();
        this.checkBtn();
    }

    private void zoomMin() {
        if (!this.lblMin.isEnabled()) {
            return;
        }
        Log.d(LoadImagePanel.class.getSimpleName(), "zoomMin");
        this.mainRatio = 1.0;
        this.showImagePanel();
        this.checkBtn();
    }

    private void checkBtn() {
        if (this.mainRatio >= 3.0) {
            this.lblMax.setEnabled(false);
            this.lblUp.setEnabled(false);
        } else {
            this.lblMax.setEnabled(true);
            this.lblUp.setEnabled(true);
        }
        if (this.mainRatio <= 1.0) {
            this.lblDown.setEnabled(false);
            this.lblMin.setEnabled(false);
        } else {
            this.lblDown.setEnabled(true);
            this.lblMin.setEnabled(true);
        }
    }

    private void openOther() {
        try {
            Desktop.getDesktop().browse(this.cacheFile.toURI());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.setVisible(false);
    }

    private void copyToClipboard() {
        BufferedImage bi = FileUtil.readFileHandleExif(this.cacheFile);
        CopyImages im = new CopyImages(bi);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(im, null);
        this.showToastPanel(I18NUtil.getString("media_save_to_clipboard_success"), 1500);
    }

    private void download() {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                File selectedFile;
                FileChooser fc = new FileChooser();
                fc.setInitialFileName(LoadImagePanel.this.imageName);
                String exten = null;
                if (LoadImagePanel.this.imageName.contains(".")) {
                    String[] xx = LoadImagePanel.this.imageName.split("\\.");
                    exten = xx[1];
                }
                fc.getExtensionFilters().clear();
                if (StringUtils.isNotBlank(exten)) {
                    fc.getExtensionFilters().addAll(new FileChooser.ExtensionFilter(exten.toUpperCase(), new String[]{"*." + exten.toLowerCase()}));
                }
                if ((selectedFile = fc.showSaveDialog(null)) != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                Files.copy(LoadImagePanel.this.cacheFile.toPath(), selectedFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                            LoadImagePanel.this.showToastPanel(I18NUtil.getString("media_save_to_local_success"), 1500);
                            PreferencesUtil.setChatLastSaveDir(UCChatClient.context, selectedFile.getParentFile().getAbsolutePath());
                        }
                    });
                }
            }
        });
    }

    public void dispImage(Message msg) {
        this.currentMsg = msg;
        String fileName = msg.getFileNameForDisp();
        String fileDownloadURL = msg.getFileDownloadURL();
        long targetFleSize = msg.getFileSize();
        if (TextUtils.isBlank((CharSequence)fileDownloadURL)) {
            return;
        }
        int index = fileDownloadURL.indexOf("/ucrm");
        if (index == -1) {
            ToastUtil.show(UCChatClient.context, I18NUtil.getString("media_filepath_is_corrupted"), 10);
            return;
        }
        this.downloadImage(msg.getContent(), fileName, fileDownloadURL, targetFleSize);
        this.prevMsg = UCDBMessage.findPrevToPlayImageMsg(UCChatClient.context, this.currentMsg.getChatRoomJid(), this.currentMsg.getServerTime(), this.currentMsg.getId());
        if (this.prevMsg != null) {
            this.lblLeft.setEnabled(true);
        } else {
            this.lblLeft.setEnabled(false);
        }
        this.nextMsg = UCDBMessage.findNextToPlayImageMsg(UCChatClient.context, this.currentMsg.getChatRoomJid(), this.currentMsg.getServerTime(), this.currentMsg.getId());
        if (this.nextMsg != null) {
            this.lblRight.setEnabled(true);
        } else {
            this.lblRight.setEnabled(false);
        }
    }

    public void findNext() {
        if (this.nextMsg != null) {
            this.dispImage(this.nextMsg);
        }
    }

    public void findPrev() {
        if (this.prevMsg != null) {
            this.dispImage(this.prevMsg);
        }
    }

    public void downloadImage(String thumbnailBase64, String imageName, String downloadURL, long targetFleSize) {
        try {
            this.thumbnailBase64 = thumbnailBase64;
            this.imageName = imageName;
            this.cacheFile = FileUtil.getDownloadCacheFile(downloadURL);
            if (this.cacheFile.exists() && this.cacheFile.length() == targetFleSize) {
                this.showImagePanel();
            } else {
                String newURL = "https://" + CommonUtil.getHttpsIpPort(UCChatClient.context) + downloadURL.substring(downloadURL.indexOf("/ucrm"));
                DownloadFileTask task = new DownloadFileTask(UCChatClient.context, newURL, this.cacheFile, 0L, new MyDownloadFileTaskCallback());
                task.start();
            }
        }
        catch (Exception e) {
            Log.e(LoadImagePanel.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
    }

    public void cancelDownloadIfNotCompleted() {
        if (this.mDownloadTask != null && this.mDownloadTask.isAlive()) {
            this.mDownloadTask.cancel();
        }
    }

    public void showToastPanel(String message, int duration) {
        this.loadImageMsgPanel.showMessage(message, duration);
    }

    private synchronized void showImagePanel() {
        try {
            UCChatClient mainFrame = UCChatClient.getInstance();
            Dimension dimToDisplay = new Dimension(mainFrame.getWidth() - 80, mainFrame.getHeight() - 120 - 40);
            try {
                BufferedImage bi = null;
                if (this.cacheFile.exists() && this.cacheFile.length() != 0L) {
                    bi = FileUtil.readFileHandleExif(this.cacheFile);
                }
                if (bi == null) {
                    bi = GraphicUtil.convertBase64StringToImage(this.thumbnailBase64);
                }
                this.mViewPort.removeAll();
                this.mViewPort.add(new ImageDispPanel(this.mainRatio, dimToDisplay, bi));
            }
            catch (Exception e) {
                Log.e(LoadImagePanel.class.getSimpleName(), e.getLocalizedMessage(), e);
                BufferedImage bi = GraphicUtil.convertBase64StringToImage(this.thumbnailBase64);
                this.mViewPort.removeAll();
                this.mViewPort.add(new ImageDispPanel(this.mainRatio, dimToDisplay, bi));
            }
        }
        catch (Exception e) {
            Log.e(LoadImagePanel.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoadImagePanel.this.loadImageMsgPanel.setVisible(false);
                LoadImagePanel.this.functionPanel.setVisible(true);
                LoadImagePanel.this.revalidate();
                LoadImagePanel.this.repaint();
            }
        });
    }

    class LeftAction
    extends AbstractAction {
        LeftAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            LoadImagePanel.this.findPrev();
        }
    }

    class RightAction
    extends AbstractAction {
        RightAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            LoadImagePanel.this.findNext();
        }
    }

    class MyDownloadFileTaskCallback
    implements DownloadFileTaskCallBack {
        @Override
        public void onFileLengthGot(int size) {
        }

        @Override
        public void onProgressUpdated(int progress) {
        }

        @Override
        public void onDownloadFileStarted() {
        }

        @Override
        public void onDownloadFileCompleted() {
            LoadImagePanel.this.showImagePanel();
        }

        @Override
        public void onDownloadFileCancelled() {
            Log.i(LoadImagePanel.class.getSimpleName(), "onDownloadFileCancelled");
            LoadImagePanel.this.showToastPanel(I18NUtil.getString("media_file_download_aborted"), 1500);
        }

        @Override
        public void onDownloadFileFailed() {
            Log.i(LoadImagePanel.class.getSimpleName(), "onDownloadFileCancelled");
            LoadImagePanel.this.showToastPanel(I18NUtil.getString("media_download_failed"), 1500);
        }

        @Override
        public void onDownloadFileNotFound() {
            Log.i(LoadImagePanel.class.getSimpleName(), "onDownloadFileCancelled");
            LoadImagePanel.this.showToastPanel(I18NUtil.getString("media_file_download_not_found"), 1500);
        }
    }
}

