/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.component;

import com.blisscloud.ezuc.client.resource.I18NUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

public class PersonalPhoto
extends JComponent {
    private Image image;
    private boolean mHasEditLabel = false;

    public PersonalPhoto() {
        this.mHasEditLabel = false;
    }

    public PersonalPhoto(boolean hasEditLabel) {
        this.mHasEditLabel = hasEditLabel;
    }

    public void setImage(Image image) {
        this.image = image;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int width = this.getWidth();
        int height = this.getHeight();
        Graphics2D g2d = (Graphics2D)g;
        g2d.drawImage(this.image, 0, 0, width, height, null);
        if (this.mHasEditLabel) {
            String label = I18NUtil.getString("common_btn_edit");
            Rectangle2D rect = g2d.getFontMetrics().getStringBounds(label, g2d);
            int stringWidth = (int)rect.getWidth();
            g2d.setColor(Color.WHITE);
            int start = width / 2 - stringWidth / 2;
            g2d.drawString(label, start, height - 5);
        }
    }

    public void setHasEditLabel(boolean hashEditLabel) {
        this.mHasEditLabel = hashEditLabel;
    }
}

