/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.emoticons;

import com.blisscloud.ezuc.client.emoticons.Emoticon;
import com.blisscloud.ezuc.client.util.URLFileSystem;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.ImageIcon;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.xml.sax.SAXException;

public class EmoticonManager {
    private static EmoticonManager singleton;
    private static final Object LOCK;
    private Map<String, Collection<Emoticon>> emoticonMap = new HashMap<String, Collection<Emoticon>>();
    private Map<String, ImageIcon> imageMap = new HashMap<String, ImageIcon>();
    public static File EMOTICON_DIRECTORY;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EmoticonManager getInstance() {
        Object object = LOCK;
        synchronized (object) {
            if (null == singleton) {
                EmoticonManager controller;
                singleton = controller = new EmoticonManager();
                return controller;
            }
        }
        return singleton;
    }

    private EmoticonManager() {
        EMOTICON_DIRECTORY = new File(FileUtil.getAppRootDir(), "xtra/emoticons").getAbsoluteFile();
        File[] files = null;
        files = EMOTICON_DIRECTORY.listFiles();
        if (files != null) {
            this.copyFiles();
        }
    }

    private void copyFiles() {
        File[] files;
        File newEmoticonDir = new File(FileUtil.getAppRootDir().getParentFile(), "xtra/emoticons").getAbsoluteFile();
        newEmoticonDir.mkdirs();
        for (File file : files = EMOTICON_DIRECTORY.listFiles()) {
            if (!file.isFile()) continue;
            try {
                String unzipURL;
                File unzipFile;
                int endIndex;
                File newFile = new File(newEmoticonDir, file.getName());
                long installerFile = file.lastModified();
                long copiedFile = newFile.lastModified();
                if (installerFile <= copiedFile || (endIndex = file.getName().indexOf(".zip")) <= 0 || (unzipFile = new File(newEmoticonDir, unzipURL = file.getName().substring(0, endIndex))).exists()) continue;
                URLFileSystem.copy(file.toURI().toURL(), newFile);
                this.expandNewPack(newFile, newEmoticonDir);
            }
            catch (IOException e) {
                Log.e(EmoticonManager.class.getSimpleName(), e.getLocalizedMessage(), e);
            }
        }
        EMOTICON_DIRECTORY = newEmoticonDir;
    }

    public Collection<Emoticon> getActiveEmoticonSet() {
        return Collections.emptyList();
    }

    public String getActiveEmoticonSetName() {
        return "unknown";
    }

    public void setActivePack(String pack) {
    }

    public String installPack(File pack) {
        if (!this.containsEmoticonPList(pack)) {
            return null;
        }
        String name = null;
        try {
            URLFileSystem.copy(pack.toURI().toURL(), new File(EMOTICON_DIRECTORY, pack.getName()));
            File rootDirectory = this.unzipPack(pack, EMOTICON_DIRECTORY);
            name = URLFileSystem.getName(rootDirectory.toURI().toURL());
            this.addEmoticonPack(name);
        }
        catch (IOException e) {
            Log.e(EmoticonManager.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
        return name;
    }

    public void addEmoticonPack(String packName) {
        Document emoticonFile;
        File emoticonSet = new File(EMOTICON_DIRECTORY, packName + ".adiumemoticonset");
        if (!emoticonSet.exists()) {
            emoticonSet = new File(EMOTICON_DIRECTORY, packName + ".AdiumEmoticonset");
        }
        if (!emoticonSet.exists()) {
            emoticonSet = new File(EMOTICON_DIRECTORY, "Default.adiumemoticonset");
            packName = "Default";
            this.setActivePack("Default");
        }
        ArrayList<Emoticon> emoticons = new ArrayList<Emoticon>();
        File plist = new File(emoticonSet, "Emoticons.plist");
        SAXReader saxParser = new SAXReader();
        saxParser.setValidation(false);
        try {
            saxParser.setFeature("http://xml.org/sax/features/validation", false);
            saxParser.setFeature("http://xml.org/sax/features/namespaces", false);
            saxParser.setFeature("http://apache.org/xml/features/validation/schema", false);
            saxParser.setFeature("http://apache.org/xml/features/validation/schema-full-checking", false);
            saxParser.setFeature("http://apache.org/xml/features/validation/dynamic", false);
            saxParser.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
            saxParser.setFeature("http://apache.org/xml/features/continue-after-fatal-error", true);
            saxParser.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            saxParser.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        try {
            emoticonFile = saxParser.read(plist);
        }
        catch (DocumentException e) {
            Log.e(EmoticonManager.class.getSimpleName(), e.getLocalizedMessage(), e);
            return;
        }
        Node root = emoticonFile.selectSingleNode("/plist/dict/dict");
        List keyList = root.selectNodes("key");
        List dictonaryList = root.selectNodes("dict");
        Iterator keys = keyList.iterator();
        Iterator dicts = dictonaryList.iterator();
        while (keys.hasNext()) {
            Element keyEntry = (Element)keys.next();
            String key = keyEntry.getText();
            Element dict = (Element)dicts.next();
            String name = dict.selectSingleNode("string").getText();
            ArrayList<String> equivs = new ArrayList<String>();
            List equivilants = dict.selectNodes("array/string");
            for (Object equivilant1 : equivilants) {
                Element equivilant = (Element)equivilant1;
                String equivilantString = equivilant.getText();
                equivs.add(equivilantString);
            }
            Emoticon emoticon = new Emoticon(key, name, equivs, emoticonSet);
            emoticons.add(emoticon);
        }
        this.emoticonMap.put(packName, emoticons);
    }

    public URL getEmoticonURL(Emoticon emoticon) {
        String imageName = emoticon.getImageName();
        File file = new File(emoticon.getEmoticonDirectory(), imageName);
        try {
            return file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public Emoticon getEmoticon(String packName, String key) {
        Collection<Emoticon> emoticons = this.emoticonMap.get(packName);
        if (emoticons == null) {
            return null;
        }
        for (Emoticon emoticon : emoticons) {
            for (String string : emoticon.getEquivalants()) {
                if (!key.equals(string)) continue;
                return emoticon;
            }
        }
        return null;
    }

    public Emoticon getEmoticon(String key) {
        Collection<Emoticon> emoticons = this.emoticonMap.get(this.getActiveEmoticonSetName());
        if (emoticons != null) {
            for (Emoticon emoticon : emoticons) {
                for (String string : emoticon.getEquivalants()) {
                    if (!key.toLowerCase().equals(string.toLowerCase())) continue;
                    return emoticon;
                }
            }
        }
        return null;
    }

    public ImageIcon getEmoticonImage(String key) {
        Emoticon emoticon = this.getEmoticon(key);
        if (emoticon != null) {
            ImageIcon icon = this.imageMap.get(key);
            if (icon == null) {
                URL url = this.getEmoticonURL(emoticon);
                icon = new ImageIcon(url);
                this.imageMap.put(key, icon);
            }
            return this.imageMap.get(key);
        }
        return null;
    }

    public Collection<String> getEmoticonPacks() {
        ArrayList<String> emoticonList = new ArrayList<String>();
        File[] dirs = EMOTICON_DIRECTORY.listFiles();
        if (dirs == null) {
            return null;
        }
        for (File file : dirs) {
            if (!file.isDirectory() || !file.getName().toLowerCase().endsWith("adiumemoticonset")) continue;
            try {
                String name = URLFileSystem.getName(file.toURI().toURL());
                name = name.replaceAll("adiumemoticonset", "");
                name = name.replaceAll("AdiumEmoticonset", "");
                emoticonList.add(name);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return emoticonList;
    }

    private void expandNewPack(File file, File dist) {
        URL url = null;
        try {
            url = file.toURI().toURL();
        }
        catch (MalformedURLException e) {
            Log.e(EmoticonManager.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
        String name = URLFileSystem.getName(url);
        File directory = new File(dist, name);
        this.unzipPack(file, directory.getParentFile());
    }

    private boolean containsEmoticonPList(File zip) {
        try {
            JarFile zipFile = new JarFile(zip);
            Enumeration<? extends ZipEntry> e = ((ZipFile)zipFile).entries();
            while (e.hasMoreElements()) {
                JarEntry entry = (JarEntry)e.nextElement();
                if (!entry.getName().contains("Emoticons.plist")) continue;
                return true;
            }
        }
        catch (IOException e) {
            Log.e(EmoticonManager.class.getSimpleName(), e.getLocalizedMessage(), e);
        }
        return false;
    }

    private File unzipPack(File zip, File dir) {
        File rootDirectory = null;
        try {
            JarFile zipFile = new JarFile(zip);
            dir.mkdir();
            Enumeration<? extends ZipEntry> e = ((ZipFile)zipFile).entries();
            while (e.hasMoreElements()) {
                int len;
                JarEntry entry = (JarEntry)e.nextElement();
                File entryFile = new File(dir, entry.getName());
                if (entry.getName().toLowerCase().endsWith("manifest.mf")) continue;
                if (entry.isDirectory() && rootDirectory == null) {
                    rootDirectory = entryFile;
                }
                if (entry.isDirectory()) continue;
                entryFile.getParentFile().mkdirs();
                FileOutputStream out = new FileOutputStream(entryFile);
                InputStream zin = ((ZipFile)zipFile).getInputStream(entry);
                byte[] b = new byte[512];
                while ((len = zin.read(b)) != -1) {
                    out.write(b, 0, len);
                }
                out.flush();
                out.close();
                zin.close();
            }
            zipFile.close();
        }
        catch (Exception e) {
            Log.e(EmoticonManager.class.getSimpleName(), "Error unzipping emoticon pack", e);
        }
        return rootDirectory;
    }

    static {
        LOCK = new Object();
    }
}

