/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.emoticons;

import com.blisscloud.ezuc.client.emoticons.Emoticon;
import com.blisscloud.ezuc.client.emoticons.EmoticonManager;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.Collection;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;

public class EmoticonUI
extends JPanel {
    private EmoticonPickListener listener;

    public EmoticonUI() {
        this.setBackground(Color.white);
        EmoticonManager manager = EmoticonManager.getInstance();
        Collection<Emoticon> emoticons = manager.getActiveEmoticonSet();
        if (emoticons != null) {
            int no = emoticons.size();
            int rows = no / 5;
            this.setLayout(new GridLayout(rows, 5));
            for (Emoticon emoticon : emoticons) {
                final String text = emoticon.getEquivalants().get(0);
                String name = manager.getActiveEmoticonSetName();
                Emoticon smileEmoticon = manager.getEmoticon(name, text);
                URL smileURL = manager.getEmoticonURL(smileEmoticon);
                ImageIcon icon = new ImageIcon(smileURL);
                JButton emotButton = new JButton();
                emotButton.setIcon(icon);
                emotButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        EmoticonUI.this.listener.emoticonPicked(text);
                    }
                });
                this.add(emotButton);
            }
        }
    }

    public void setEmoticonPickListener(EmoticonPickListener listener) {
        this.listener = listener;
    }

    public static interface EmoticonPickListener {
        public void emoticonPicked(String var1);
    }
}

