/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.emoticons;

import com.blisscloud.ezuc.client.chat.roomimpl.Chatroom;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class EmoticonUtils {
    private static final String PHONE_TALKING = "PHONE_TALKING";
    private static final String PHONE_CANCEL = "PHONE_CANCEL";
    private static final String PHONE_CANCEL_IN = "PHONE_CANCEL_IN";
    private static final String PHONE_CANCEL_OUT = "PHONE_CANCEL_OUT";
    public static final String STICKERPOSTFIX = ".";
    public static final String STICKERPREFIX = "sticker";
    public static final String STICKERPREFIX_S = "sticker_s_";
    public static final String STICKERPREFIXSP = ":";

    public static boolean isStickerContent(String str) {
        String key;
        if (TextUtils.isBlank((CharSequence)str)) {
            return false;
        }
        Matcher m = Chatroom.PATTERN_EMOTICON.matcher(str);
        return m.find() && m.groupCount() == 1 && (key = m.group()).startsWith("[sticker:");
    }

    public static boolean isEmoticonV1File(String name) {
        String sub;
        if (StringUtils.isNotBlank((CharSequence)name) && name.startsWith("emoticon_") && TextUtils.isDigitsOnly(sub = name.substring("emoticon_".length()))) {
            int value = Integer.parseInt(sub);
            return value > 0 && value <= 57;
        }
        return false;
    }

    public static boolean isEmoticonV2File(String name) {
        String sub;
        if (StringUtils.isNotBlank((CharSequence)name) && name.startsWith("emo") && TextUtils.isDigitsOnly(sub = name.substring("emo".length()))) {
            int value = Integer.parseInt(sub);
            return value > 0 && value <= 130;
        }
        return false;
    }

    public static boolean isPhoneFile(String tag) {
        return PHONE_TALKING.equals(tag) || PHONE_CANCEL.equals(tag) || PHONE_CANCEL_IN.equals(tag) || PHONE_CANCEL_OUT.equals(tag);
    }

    public static boolean isChatModeType(String name) {
        return "[mode_noticeoff]".equals(name) || "[mode_handset]".equals(name) || "[mode_headset]".equals(name) || "[mode_bluetooth]".equals(name) || "[mute_s]".equals(name) || "[video_mute_s]".equals(name) || "[speaker_s]".equals(name);
    }

    public static String getEmotionsTextOnly(String str) {
        if (StringUtils.isBlank((CharSequence)str) || !str.contains("[") || !str.contains("]")) {
            return str;
        }
        Pattern p = Pattern.compile("\\[([^(\\[|\\])]*)]");
        Matcher m = p.matcher(str);
        while (m.find()) {
            String key = m.group(1);
            String keyTag = "[" + key + "]";
            if (EmoticonUtils.isEmoticonV1File(key)) {
                str = str.replace(keyTag, "[" + I18NUtil.getString("chat_msg_type_emoticon") + "]");
                continue;
            }
            if (EmoticonUtils.isEmoticonV2File(key)) {
                str = str.replace(keyTag, "[" + I18NUtil.getString("chat_msg_type_emoticon") + "]");
                continue;
            }
            if (EmoticonUtils.isPhoneFile(key)) {
                str = str.replace(keyTag, "");
                continue;
            }
            if (!EmoticonUtils.isChatModeType(keyTag)) continue;
            str = str.replace(keyTag, "");
        }
        return str;
    }
}

