/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.http;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.main.MainPanel;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.CallLine;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.bean.Device;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.manager.DeviceManager;
import com.blisscloud.mobile.ezuc.manager.DialoutManager;
import com.blisscloud.mobile.ezuc.phone.CallState;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;

public class DesktopHttpServer {
    private HttpServer server = null;

    public DesktopHttpServer() throws IOException {
        int port = PreferencesUtil.getApiHttpServerPort();
        InetSocketAddress addr = new InetSocketAddress(port);
        this.server = HttpServer.create(addr, 0);
        this.server.createContext("/", new MyHttpHandler(this));
        this.server.setExecutor(Executors.newCachedThreadPool());
        this.server.start();
        Log.i(DesktopHttpServer.class.getSimpleName(), "Http Server is listening on port " + port);
    }

    public void stopServer() {
        if (this.server != null) {
            this.server.stop(0);
        }
        Log.i(DesktopHttpServer.class.getSimpleName(), "Http Server stoped!");
    }

    class MyHttpHandler
    implements HttpHandler {
        MyHttpHandler(DesktopHttpServer this$0) {
        }

        @Override
        public void handle(HttpExchange exchange) throws IOException {
            URI uri = exchange.getRequestURI();
            Log.i(DesktopHttpServer.class.getSimpleName(), "handle request " + uri.toString());
            String path = uri.getPath();
            String query = uri.getQuery();
            Map<String, String> queryMap = this.getQueryMap(query);
            if (path.equals("/dialout")) {
                String number = queryMap.get("number");
                String linkId = queryMap.get("linkId");
                String hardphoneOnly = queryMap.get("hardphoneOnly");
                long mySiteId = PreferencesUtil.getSipUsePbxSite(UCChatClient.context);
                Map<Long, List<Device>> deviceMapt = DeviceManager.getDeviceInfos(UCChatClient.context);
                ArrayList<String> deviceIdList = new ArrayList<String>();
                List<Device> deviceList = deviceMapt.get(mySiteId);
                if (deviceList != null) {
                    for (Device d : deviceList) {
                        if (d.getDeviceType() != 0) continue;
                        deviceIdList.add(d.getDeviceId());
                    }
                }
                if (this.isHardPhoneOnly(hardphoneOnly)) {
                    if (!PreferencesUtil.hasPhoneCallLicense(UCChatClient.context)) {
                        this.sendResponse(403, "failed, no voice license", exchange);
                    } else if (!WebAgent.getInstance().isConnected()) {
                        this.sendResponse(503, "failed, phone not available", exchange);
                    } else if (mySiteId == -1L) {
                        this.sendResponse(503, "failed, site info not available", exchange);
                    } else if (TextUtils.isBlank((CharSequence)number)) {
                        this.sendResponse(400, "failed, number param is missing", exchange);
                    } else if (deviceIdList.size() == 0) {
                        this.sendResponse(503, "failed, hard phone not available", exchange);
                    } else {
                        Log.i(DesktopHttpServer.class.getSimpleName(), "dialout:" + number + " linkId:" + linkId + " hardphoneOnly:" + hardphoneOnly);
                        WebAgent.getInstance().makeCallUsingHardhone(mySiteId, number, mySiteId, deviceIdList);
                        this.sendResponse(200, "ok", exchange);
                    }
                } else {
                    CallLine callLine0 = PhoneAgent.getInstance().getCallLine(0);
                    if (!PreferencesUtil.hasPhoneCallLicense(UCChatClient.context)) {
                        this.sendResponse(403, "failed, no voice license", exchange);
                    } else if (PhoneAgent.isRegistered != PhoneAgent.STAT_REGISTERED) {
                        this.sendResponse(503, "failed, phone not available", exchange);
                    } else if (callLine0.getState() != CallState.IDLE) {
                        this.sendResponse(503, "failed, line is busy", exchange);
                    } else if (TextUtils.isBlank((CharSequence)number)) {
                        this.sendResponse(400, "failed, number param is missing", exchange);
                    } else {
                        Log.i(DesktopHttpServer.class.getSimpleName(), "dialout:" + number + " linkId:" + linkId);
                        DialoutManager.directDialNumberForPad(UCChatClient.context, number, linkId);
                        this.sendResponse(200, "ok", exchange);
                    }
                }
            } else if (path.equals("/hangup")) {
                String hardphoneOnly = queryMap.get("hardphoneOnly");
                long mySiteId = PreferencesUtil.getSipUsePbxSite(UCChatClient.context);
                if (this.isHardPhoneOnly(hardphoneOnly)) {
                    if (!PreferencesUtil.hasPhoneCallLicense(UCChatClient.context)) {
                        this.sendResponse(403, "failed, no voice license", exchange);
                    } else if (!WebAgent.getInstance().isConnected()) {
                        this.sendResponse(503, "failed, phone not available", exchange);
                    } else if (mySiteId == -1L) {
                        this.sendResponse(503, "failed, site info not available", exchange);
                    } else if (StringUtils.isBlank((CharSequence)WebAgent.refCallId)) {
                        this.sendResponse(503, "failed, ref call id not available", exchange);
                    } else {
                        Log.i(DesktopHttpServer.class.getSimpleName(), "hangupCall hardphoneOnly:" + hardphoneOnly);
                        WebAgent.getInstance().hangupCall(mySiteId);
                        this.sendResponse(200, "ok", exchange);
                    }
                } else if (!PreferencesUtil.hasPhoneCallLicense(UCChatClient.context)) {
                    this.sendResponse(403, "failed, no voice license", exchange);
                } else if (PhoneAgent.isRegistered != PhoneAgent.STAT_REGISTERED) {
                    this.sendResponse(503, "failed, phone not available", exchange);
                } else {
                    CallLine[] callLineAry;
                    Log.i(DesktopHttpServer.class.getSimpleName(), "hangup");
                    HashSet<String> hangupLineSet = new HashSet<String>();
                    for (CallLine callline : callLineAry = PhoneAgent.getInstance().getCallLineAry()) {
                        if (callline.getState() == CallState.IDLE) continue;
                        PhoneAgent.getInstance().hangupLine(callline.getLineId());
                        hangupLineSet.add(String.valueOf(callline.getLineId() + 1));
                    }
                    if (hangupLineSet.size() > 0) {
                        this.sendResponse(200, "ok, hangup line " + String.join((CharSequence)",", hangupLineSet), exchange);
                    } else {
                        this.sendResponse(200, "failed, no line is busy", exchange);
                    }
                }
            } else if (path.equals("/popupRoom")) {
                String name = queryMap.get("name");
                List<ChatRoomInfo> roomInfoList = UCDBChatRoom.getChatRoomByName(UCChatClient.context, name.trim());
                if (roomInfoList != null && roomInfoList.size() > 0) {
                    MainPanel mainPanel = UCChatClient.getInstance().getMainPanel();
                    ChatRoomInfo info = roomInfoList.get(0);
                    mainPanel.showChatroom(info.getChatRoomId());
                    this.sendResponse(200, "ok", exchange);
                } else {
                    this.sendResponse(200, "failed, room not found!", exchange);
                }
            } else {
                this.sendResponse(404, "failed, unsupported function", exchange);
            }
        }

        private boolean isHardPhoneOnly(String hardPhoneOnly) {
            return StringUtils.isNotBlank((CharSequence)hardPhoneOnly) && ("true".equalsIgnoreCase(hardPhoneOnly.trim()) || "1".equals(hardPhoneOnly.trim()) || "yes".equals(hardPhoneOnly.trim()) || "y".equals(hardPhoneOnly.trim()));
        }

        private void sendResponse(int code, String response, HttpExchange exchange) throws IOException {
            Headers responseHeaders = exchange.getResponseHeaders();
            responseHeaders.set("Content-Type", "text/plain");
            responseHeaders.set("Access-Control-Allow-Origin", "*");
            responseHeaders.set("Access-Control-Allow-Methods", "GET,PUT,POST,DELETE");
            exchange.sendResponseHeaders(code, response.length());
            exchange.getResponseBody().write(response.getBytes());
            exchange.close();
        }

        private Map<String, String> getQueryMap(String query) {
            HashMap<String, String> map = new HashMap<String, String>();
            if (TextUtils.isNotBlank((CharSequence)query)) {
                String[] params;
                for (String param : params = query.split("&")) {
                    String[] terms = param.split("=");
                    String name = terms[0];
                    String value = terms.length == 2 ? terms[1] : null;
                    map.put(name, value);
                }
            }
            return map;
        }
    }
}

