/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.login;

import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.component.GreenButton;
import com.blisscloud.ezuc.client.login.IPValidator;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.AsyncTask;
import com.blisscloud.mobile.ezuc.manager.task.CheckAuthOptionTask;
import com.blisscloud.mobile.ezuc.manager.task.TaskComplete;
import com.blisscloud.mobile.ezuc.manager.task.VerifyEnterpriseIpTask;
import com.blisscloud.mobile.ezuc.manager.task.VerifyEnterpriseNoTask;
import com.blisscloud.mobile.ezuc.util.ICheckCompleteListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class EnterpriseNoDialog
extends GenericDialog
implements ICheckCompleteListener {
    private static final long serialVersionUID = -9711597253952481L;
    private JLabel lblIcon;
    private JLabel lblTitle;
    private JLabel lbChangeWarning;
    private JPanel panelContent;
    private JButton btnCancel;
    private JButton btnConfirm;
    private JTextField txtEnterpriseNo;
    private JLabel lblMessage;
    private String currentEterpriseNo;
    private AsyncTask<Void, Void, Integer> mQueryTask;
    private boolean checkCompleted = false;

    public EnterpriseNoDialog(JFrame frame, String enterpriseNo) {
        super(frame);
        this.currentEterpriseNo = enterpriseNo;
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.panelContent = new JPanel();
            GridBagLayout panelContentLayout = new GridBagLayout();
            this.panelContent.setLayout(panelContentLayout);
            this.getContentPane().add((Component)this.panelContent, "Center");
            this.panelContent.setBorder(BorderFactory.createEmptyBorder(35, 30, 35, 30));
            this.panelContent.setBackground(UIConstants.BACKGROUND_LOGIN);
            this.lblIcon = new JLabel();
            this.panelContent.add((Component)this.lblIcon, new GridBagConstraints(0, 0, 1, 7, 0.0, 0.0, 11, 0, new Insets(20, 0, 0, 20), 0, 0));
            this.lblIcon.setIcon(new ImageIcon(this.getClass().getClassLoader().getResource("images/earthicon.png")));
            this.lblTitle = new JLabel();
            this.panelContent.add((Component)this.lblTitle, new GridBagConstraints(1, 0, 2, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.lblTitle.setText(I18NUtil.getString("login_label_fill_enterprise_no"));
            this.lblTitle.setFont(UIConstants.FONT_14_PLAIN);
            this.lblTitle.setForeground(Color.DARK_GRAY);
            this.lbChangeWarning = new JLabel();
            this.panelContent.add((Component)this.lbChangeWarning, new GridBagConstraints(1, 1, 2, 1, 0.0, 0.0, 18, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.lbChangeWarning.setText("<html><body style='width: 160px'>" + I18NUtil.getString("login_confirm_update_enterprise_no"));
            this.lbChangeWarning.setIcon(UIConstants.ICON_WARNING);
            this.lbChangeWarning.setFont(UIConstants.FONT_12_PLAIN);
            this.lbChangeWarning.setForeground(Color.DARK_GRAY);
            if (TextUtils.isNotBlank((CharSequence)this.currentEterpriseNo)) {
                this.lbChangeWarning.setVisible(true);
            } else {
                this.lbChangeWarning.setVisible(false);
            }
            this.txtEnterpriseNo = new JTextField();
            this.txtEnterpriseNo.enableInputMethods(false);
            this.panelContent.add((Component)this.txtEnterpriseNo, new GridBagConstraints(1, 2, 2, 1, 1.0, 0.0, 18, 2, new Insets(10, 0, 0, 0), 0, 0));
            this.txtEnterpriseNo.setText(this.currentEterpriseNo);
            this.txtEnterpriseNo.setFont(UIConstants.FONT_12_PLAIN);
            this.txtEnterpriseNo.setPreferredSize(new Dimension(200, 28));
            this.txtEnterpriseNo.setMinimumSize(new Dimension(200, 28));
            ((AbstractDocument)this.txtEnterpriseNo.getDocument()).setDocumentFilter(new LowercaseDocumentFilter(this));
            this.txtEnterpriseNo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EnterpriseNoDialog.this.txtEnterpriseNoActionPerformed(evt);
                }
            });
            this.lblMessage = new JLabel();
            this.panelContent.add((Component)this.lblMessage, new GridBagConstraints(1, 3, 2, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.lblMessage.setFont(UIConstants.FONT_14_PLAIN);
            this.lblMessage.setPreferredSize(new Dimension(200, 28));
            this.lblMessage.setMinimumSize(new Dimension(200, 28));
            this.lblMessage.setVisible(false);
            this.btnConfirm = new GreenButton();
            this.panelContent.add((Component)this.btnConfirm, new GridBagConstraints(1, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 0, 0, 0), 0, 0));
            this.btnConfirm.setText(I18NUtil.getString("common_btn_ok"));
            this.btnConfirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EnterpriseNoDialog.this.btnConfirmActionPerformed(evt);
                }
            });
            this.btnCancel = new GreenButton();
            this.panelContent.add((Component)this.btnCancel, new GridBagConstraints(2, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 15, 0, 0), 0, 0));
            this.btnCancel.setText(I18NUtil.getString("common_btn_cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    EnterpriseNoDialog.this.btnCancelActionPerformed(evt);
                }
            });
            this.setDialogSize();
            this.setModal(true);
            this.setResizable(false);
            this.setTitle(I18NUtil.getAppName());
            this.setIconImages(UIConstants.APP_ICONS);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setDialogSize() {
        if (TextUtils.isNotBlank((CharSequence)this.currentEterpriseNo) && this.lblMessage.isVisible()) {
            this.setSize(380, 260);
        } else if (TextUtils.isNotBlank((CharSequence)this.currentEterpriseNo) && !this.lblMessage.isVisible()) {
            this.setSize(380, 230);
        } else if (TextUtils.isBlank((CharSequence)this.currentEterpriseNo) && this.lblMessage.isVisible()) {
            this.setSize(380, 230);
        } else if (TextUtils.isBlank((CharSequence)this.currentEterpriseNo) && !this.lblMessage.isVisible()) {
            this.setSize(380, 200);
        }
        this.invalidate();
    }

    public boolean isCheckCompleted() {
        return this.checkCompleted;
    }

    public String getEnterpriseNo() {
        return this.txtEnterpriseNo.getText();
    }

    private void txtEnterpriseNoActionPerformed(ActionEvent evt) {
        this.checkEnterpriseNo();
    }

    private void btnConfirmActionPerformed(ActionEvent evt) {
        this.checkEnterpriseNo();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.checkCancelled();
    }

    @Override
    protected void onESCPressed() {
        this.checkCancelled();
    }

    private void checkCompleted() {
        this.checkCompleted = true;
        this.setVisible(false);
    }

    private void checkCancelled() {
        this.checkCompleted = false;
        this.lblMessage.setVisible(false);
        this.setDialogSize();
        this.setVisible(false);
    }

    private void checkEnterpriseNo() {
        String newEnterprise = this.txtEnterpriseNo.getText();
        if (newEnterprise != null) {
            newEnterprise = newEnterprise.replace(" ", "");
            newEnterprise = newEnterprise.trim();
            this.txtEnterpriseNo.setText(newEnterprise);
        }
        if (TextUtils.isBlank((CharSequence)newEnterprise)) {
            this.updateState(true, true, I18NUtil.getString("login_validation_enterprise_no_empty"), null);
            this.txtEnterpriseNo.requestFocus();
        } else if (!newEnterprise.equalsIgnoreCase(this.currentEterpriseNo)) {
            this.checkEnterpriseInfo(newEnterprise);
        } else {
            this.checkCancelled();
        }
    }

    private void updateState(boolean buttonEnabled, boolean error, String text, Icon icon) {
        this.txtEnterpriseNo.setEnabled(buttonEnabled);
        this.btnConfirm.setEnabled(buttonEnabled);
        this.btnCancel.setEnabled(buttonEnabled);
        this.lblMessage.setForeground(error ? Color.RED : Color.BLACK);
        this.lblMessage.setText(text);
        this.lblMessage.setIcon(icon);
        this.lblMessage.setVisible(true);
        this.setDialogSize();
    }

    private void checkEnterpriseInfo(String tenantNo) {
        if (this.mQueryTask != null) {
            this.mQueryTask.cancel(true);
            this.mQueryTask = null;
        }
        this.updateState(false, false, I18NUtil.getString("login_enterprise_fetch_processing"), UIConstants.ICON_LOADING24);
        if (IPValidator.isIpAddress(tenantNo)) {
            this.mQueryTask = new VerifyEnterpriseIpTask(UCChatClient.context, tenantNo, this);
            this.mQueryTask.execute((Void[])new Void[0]);
        } else {
            this.mQueryTask = new VerifyEnterpriseNoTask(UCChatClient.context, tenantNo, this);
            this.mQueryTask.execute((Void[])new Void[0]);
        }
    }

    @Override
    public void onCheckCompleted(Object data, int type) {
        switch (type) {
            case 0: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EnterpriseNoDialog.this.updateState(false, false, I18NUtil.getString("login_enterprise_fetch_success"), UIConstants.ICON_LOADING24);
                    }
                });
                CheckAuthOptionTask task2 = new CheckAuthOptionTask(UCChatClient.context, new TaskComplete<Void>(){

                    @Override
                    public void onLoadFinished(Void data) {
                        EnterpriseNoDialog.this.checkCompleted();
                    }
                });
                task2.execute(new String[0]);
                break;
            }
            case 1: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EnterpriseNoDialog.this.updateState(true, true, I18NUtil.getString("login_notice_ucds_conn_failed"), null);
                    }
                });
                break;
            }
            case 2: {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        EnterpriseNoDialog.this.updateState(true, true, I18NUtil.getString("login_enterprise_no_failed"), null);
                    }
                });
            }
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                EnterpriseNoDialog inst = new EnterpriseNoDialog(frame, "127.0.0.1");
                inst.setVisible(true);
            }
        });
    }

    class LowercaseDocumentFilter
    extends DocumentFilter {
        LowercaseDocumentFilter(EnterpriseNoDialog this$0) {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
            if (fb != null && text != null) {
                fb.insertString(offset, text.toLowerCase(), attr);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (fb != null && text != null) {
                fb.replace(offset, length, text.toLowerCase(), attrs);
            }
        }
    }
}

