/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.login;

import com.blisscloud.ezuc.client.UCBaseActivity;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.GreenButton;
import com.blisscloud.ezuc.client.login.EnterpriseNoDialog;
import com.blisscloud.ezuc.client.login.ForgotPasswordDialog;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.LoginMsgUtil;
import com.blisscloud.ezuc.client.util.PackageInfo;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.VersionCheckUtils;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.BroadcastReceiver;
import com.blisscloud.ezuc.client.util.simulate.Bundle;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Intent;
import com.blisscloud.ezuc.client.util.simulate.IntentFilter;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.NetworkService;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.AuthOption;
import com.blisscloud.mobile.ezuc.manager.task.CheckAuthOptionTask;
import com.blisscloud.mobile.ezuc.manager.task.TaskComplete;
import com.blisscloud.mobile.ezuc.manager.task.VerifyEnterpriseNoTask;
import com.blisscloud.mobile.ezuc.util.AppConstUtil;
import com.blisscloud.mobile.ezuc.util.DataCleanUtil;
import com.blisscloud.mobile.ezuc.util.ICheckCompleteListener;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextAttribute;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class LoginPanel
extends UCBaseActivity
implements ICheckCompleteListener {
    private Mode mode;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JTextField txtLoginId;
    private JPasswordField txtPassword;
    private JLabel lblMessage;
    private JLabel lblPadding;
    private JLabel lblForgotPassword;
    private JCheckBox chbSavePassword;
    private JButton btnLogin;
    private JButton btnExit;
    private JButton btnChangeEnteriseNo;
    private LoginThread loginThread;
    BroadcastReceiver receiver = null;
    IntentFilter filter = null;
    private VerifyEnterpriseNoTask mEnterpriseTask;
    Font originalFont;

    public LoginPanel() {
        this.onCreate(null);
        this.initGUI();
        this.loadSetting();
    }

    public void checkBackground() {
        CheckAuthOptionTask task2 = new CheckAuthOptionTask(UCChatClient.context, new TaskComplete<Void>(this){

            @Override
            public void onLoadFinished(Void data) {
            }
        });
        task2.execute(new String[0]);
    }

    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    @Override
    public void onResume() {
        super.onResume();
        this.initReceiver();
        this.btnLogin.setEnabled(true);
        this.cleanMsg();
    }

    @Override
    public void onStop() {
        super.onStop();
        this.stopLoginThread();
        this.cleanMsg();
        if (this.receiver != null) {
            UCChatClient.context.unregisterReceiver(this.receiver);
        }
    }

    private void cleanMsg() {
        this.lblMessage.setText("");
        this.lblMessage.setIcon(null);
        this.lblMessage.setVisible(false);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(UIConstants.IMAGE_LOGIN_BACKGROUND, 0, 0, this.getWidth(), this.getHeight(), this);
    }

    private synchronized void initGUI() {
        try {
            this.setPreferredSize(new Dimension(340, 560));
            GridBagLayout thisLayout = new GridBagLayout();
            this.setLayout(thisLayout);
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.setBackground(UIConstants.BACKGROUND_LOGIN);
            int width = 120;
            int height = 106;
            int leftright = (290 - width) / 2;
            int topbottom = (150 - height) / 2;
            this.jLabel1 = new JLabel();
            this.add((Component)this.jLabel1, new GridBagConstraints(0, 0, 2, 1, 1.0, 0.0, 10, 0, new Insets(topbottom, leftright, topbottom, leftright), 0, 0));
            this.jLabel1.setText(I18NUtil.getAppName());
            this.jLabel1.setForeground(AppConstUtil.LOGIN_FORGROUND_COLOR);
            this.jLabel1.setFont(UIConstants.FONT_24_BOLD);
            this.jLabel1.setIcon(AppConstUtil.COMPANY_LOGO);
            this.jLabel1.setIconTextGap(10);
            this.jLabel1.setHorizontalTextPosition(0);
            this.jLabel1.setVerticalTextPosition(3);
            this.jLabel3 = new JLabel();
            this.add((Component)this.jLabel3, new GridBagConstraints(0, 1, 2, 1, 0.0, 0.0, 17, 0, new Insets(12, 40, 0, 40), 0, 0));
            this.jLabel3.setText(I18NUtil.getString("login_label_account_s"));
            this.jLabel3.setFont(UIConstants.FONT_14_PLAIN);
            this.jLabel3.setForeground(AppConstUtil.LOGIN_FORGROUND_COLOR);
            this.txtLoginId = new JTextField();
            this.txtLoginId.enableInputMethods(false);
            this.add((Component)this.txtLoginId, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 17, 2, new Insets(2, 40, 0, 40), 0, 0));
            this.txtLoginId.setPreferredSize(new Dimension(160, 30));
            this.txtLoginId.setFont(UIConstants.FONT_14_PLAIN);
            ((AbstractDocument)this.txtLoginId.getDocument()).setDocumentFilter(new LowercaseDocumentFilter(this));
            this.txtLoginId.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    LoginPanel.this.txtLoginIdActionPerformed(evt);
                }
            });
            this.jLabel4 = new JLabel();
            this.add((Component)this.jLabel4, new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 40, 0, 40), 0, 0));
            this.jLabel4.setText(I18NUtil.getString("login_label_password_s"));
            this.jLabel4.setFont(UIConstants.FONT_14_PLAIN);
            this.jLabel4.setForeground(AppConstUtil.LOGIN_FORGROUND_COLOR);
            this.txtPassword = new JPasswordField();
            this.add((Component)this.txtPassword, new GridBagConstraints(0, 4, 2, 1, 0.0, 0.0, 17, 2, new Insets(2, 40, 0, 40), 0, 0));
            this.txtPassword.setPreferredSize(new Dimension(160, 30));
            this.txtPassword.setFont(UIConstants.FONT_14_PLAIN);
            this.txtPassword.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    LoginPanel.this.txtPasswordActionPerformed(evt);
                }
            });
            this.chbSavePassword = new JCheckBox();
            this.add((Component)this.chbSavePassword, new GridBagConstraints(0, 5, 2, 1, 0.0, 0.0, 17, 0, new Insets(10, 40, 0, 5), 0, 0));
            this.chbSavePassword.setText(I18NUtil.getString("login_label_save_pwd"));
            this.chbSavePassword.setFont(UIConstants.FONT_12_PLAIN);
            this.chbSavePassword.setOpaque(false);
            this.chbSavePassword.setForeground(Color.DARK_GRAY);
            this.chbSavePassword.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent evt) {
                    LoginPanel.this.chbSavePasswordItemStateChanged(evt);
                }
            });
            this.lblForgotPassword = new JLabel();
            this.add((Component)this.lblForgotPassword, new GridBagConstraints(1, 5, 2, 1, 0.0, 0.0, 13, 0, new Insets(10, 5, 0, 40), 0, 0));
            this.lblForgotPassword.setText(I18NUtil.getString("login_label_forgot_pwd"));
            this.lblForgotPassword.setOpaque(false);
            this.lblForgotPassword.setCursor(new Cursor(12));
            this.lblForgotPassword.setForeground(Color.DARK_GRAY);
            Font font = new Font("Microsoft YaHei", 0, 12);
            Map<TextAttribute, ?> attributes = font.getAttributes();
            attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            this.lblForgotPassword.setFont(font.deriveFont(attributes));
            this.lblForgotPassword.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    LoginPanel.this.btnForgotPasswordActionPerformed(evt);
                }
            });
            this.btnLogin = new GreenButton();
            this.add((Component)this.btnLogin, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 55, 0, 0), 0, 0));
            this.btnLogin.setText(I18NUtil.getString("login_btn_login"));
            this.btnLogin.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    LoginPanel.this.btnLoginActionPerformed(evt);
                }
            });
            this.btnExit = new GreenButton();
            this.add((Component)this.btnExit, new GridBagConstraints(1, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(10, 0, 0, 55), 0, 0));
            this.btnExit.setText(I18NUtil.getString("common_btn_close"));
            this.btnExit.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    LoginPanel.this.btnExitActionPerformed(evt);
                }
            });
            this.lblMessage = new JLabel();
            this.add((Component)this.lblMessage, new GridBagConstraints(0, 7, 2, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.lblMessage.setFont(UIConstants.FONT_14_BOLD);
            this.lblMessage.setBackground(new Color(255, 220, 220));
            this.lblMessage.setBorder(BorderFactory.createEmptyBorder(6, 30, 6, 30));
            this.lblMessage.setHorizontalAlignment(0);
            this.lblPadding = new JLabel();
            this.add((Component)this.lblPadding, new GridBagConstraints(0, 8, 2, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblPadding.setText(" ");
            this.btnChangeEnteriseNo = new JButton();
            this.add((Component)this.btnChangeEnteriseNo, new GridBagConstraints(0, 9, 2, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            String mode = PreferencesUtil.getEnterpriseNoMode(UCChatClient.context);
            if ("MODE_ENT_NO".equalsIgnoreCase(mode)) {
                String currentEnterpriseNo = PreferencesUtil.getEnterpriseNo(UCChatClient.context);
                if (TextUtils.isBlank((CharSequence)currentEnterpriseNo)) {
                    this.btnChangeEnteriseNo.setText(I18NUtil.getString("login_label_configure_enterprise_no"));
                } else {
                    this.btnChangeEnteriseNo.setText(String.format(I18NUtil.getString("login_label_modify_enterprise_no"), currentEnterpriseNo));
                }
            } else {
                String currentEnterpriseIp = PreferencesUtil.getEnterpriseIp(UCChatClient.context);
                if (TextUtils.isBlank((CharSequence)currentEnterpriseIp)) {
                    this.btnChangeEnteriseNo.setText(I18NUtil.getString("login_label_configure_enterprise_no"));
                } else {
                    this.btnChangeEnteriseNo.setText(String.format(I18NUtil.getString("login_label_modify_enterprise_no"), currentEnterpriseIp));
                }
            }
            this.btnChangeEnteriseNo.setFont(UIConstants.FONT_12_PLAIN);
            this.btnChangeEnteriseNo.setForeground(Color.DARK_GRAY);
            this.btnChangeEnteriseNo.setCursor(new Cursor(12));
            this.btnChangeEnteriseNo.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.btnChangeEnteriseNo.setBorderPainted(false);
            this.btnChangeEnteriseNo.setContentAreaFilled(false);
            this.btnChangeEnteriseNo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    LoginPanel.this.btnChangeEnteriseNoActionPerformed(evt);
                }
            });
            this.btnChangeEnteriseNo.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (LoginPanel.this.btnChangeEnteriseNo.isEnabled()) {
                        LoginPanel.this.toMouseExitedFont(evt);
                    }
                }

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (LoginPanel.this.btnChangeEnteriseNo.isEnabled()) {
                        LoginPanel.this.toMouseEnteredFont(evt);
                    }
                }
            });
            JLabel versionLabel = new JLabel();
            this.add((Component)versionLabel, new GridBagConstraints(0, 10, 2, 1, 0.0, 0.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
            versionLabel.setFont(new Font("SansSerif", 0, 9));
            versionLabel.setForeground(new Color(156, 156, 156));
            PackageInfo versioninfo = VersionCheckUtils.getVersionInfo(UCChatClient.context);
            versionLabel.setText(versioninfo.getVersionLabel());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initReceiver() {
        this.receiver = new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                try {
                    String action = intent.getAction();
                    Bundle bundle = intent.getExtras();
                    Log.i(LoginPanel.class.getSimpleName(), " \u6536\u5230\u5ee3\u64ad:" + action);
                    if (action.equals("ezphone.intent.action.event.WEB_TRY_CONNECT_FAILED")) {
                        int code = bundle.getInt("code");
                        String reason = bundle.getString("reason");
                        LoginPanel.this.web_disconnected(code, reason);
                    } else if (!action.equals("ezphone.intent.action.event.WEB_LOGIN_DONE")) {
                        if (action.equals("ezphone.intent.action.event.WEB_LOGIN_FAILED")) {
                            LoginPanel.this.web_loginFailed(intent);
                        } else if (action.equals("ezphone.intent.action.event.UC_NETWORK_DISCONNECTED")) {
                            LoginPanel.this.checkLoginProcess();
                        } else if (action.equals("ezphone.intent.action.event.UCRM_CONNECTION_EXCEPTION")) {
                            LoginPanel.this.setMode(Mode.ERROR);
                            WebAgent.getInstance().logout(4001, true);
                            LoginPanel.this.showMessage(I18NUtil.getString("login_notice_timeout"), UIConstants.ICON_WARNING, true);
                        } else if (action.equals("ezphone.intent.action.event.UC_NETWORK_CONNECTED")) {
                            LoginPanel.this.checkLoginProcess();
                        } else if (action.equals("ezphone.intent.action.event.AUTH_OPTION_CHANGE")) {
                            AuthOption authOption = PreferencesUtil.getAuthOption(context);
                            if (authOption == AuthOption.AD_ONLY) {
                                LoginPanel.this.lblForgotPassword.setVisible(false);
                            } else {
                                LoginPanel.this.lblForgotPassword.setVisible(true);
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    Log.e(LoginPanel.class.getSimpleName(), "ERROR:" + t.getMessage(), t);
                }
            }
        };
        this.filter = new IntentFilter();
        this.filter.addAction("ezphone.intent.action.event.UC_NETWORK_DISCONNECTED");
        this.filter.addAction("ezphone.intent.action.event.UC_NETWORK_CONNECTED");
        this.filter.addAction("ezphone.intent.action.event.WEB_TRY_CONNECT_FAILED");
        this.filter.addAction("ezphone.intent.action.event.WEB_LOGIN_DONE");
        this.filter.addAction("ezphone.intent.action.event.WEB_LOGIN_FAILED");
        this.filter.addAction("ezphone.intent.action.event.AUTH_OPTION_CHANGE");
        this.filter.addAction("ezphone.intent.action.event.UCRM_CONNECTION_EXCEPTION");
        UCChatClient.context.registerReceiver(this.receiver, this.filter);
    }

    private void loadSetting() {
        boolean retype = PreferencesUtil.isNeedRetypeLoginPWD(UCChatClient.context);
        this.chbSavePassword.setSelected(!retype);
        this.loadLoginID();
        this.checkLoadLoginPassword();
        this.prepareManualLogin();
    }

    public void loadLoginID() {
        Activity ctx = UCChatClient.context;
        String loginId = PreferencesUtil.getLoginID(ctx);
        this.txtLoginId.setText(loginId);
    }

    public void loadLoginPassword() {
        Activity ctx = UCChatClient.context;
        String password = PreferencesUtil.getLoginPWD(ctx);
        this.txtPassword.setText(password);
    }

    public void checkLoadLoginPassword() {
        boolean retype = PreferencesUtil.isNeedRetypeLoginPWD(UCChatClient.context);
        if (retype) {
            this.txtPassword.setText("");
        } else {
            this.loadLoginPassword();
        }
    }

    private boolean checkLoginInfo() {
        String loginId = this.txtLoginId.getText();
        if (loginId != null) {
            loginId = loginId.trim();
            loginId = loginId.replace(" ", "");
            this.txtLoginId.setText(loginId);
        }
        if (TextUtils.isBlank((CharSequence)loginId)) {
            this.showMessage(I18NUtil.getString("login_validation_account_empty"), null, true);
            this.txtLoginId.requestFocus();
            return false;
        }
        String password = this.txtPassword.getText();
        if (TextUtils.isBlank((CharSequence)password)) {
            this.showMessage(I18NUtil.getString("login_validation_password_empty"), null, true);
            this.txtPassword.requestFocus();
            return false;
        }
        return true;
    }

    private void txtLoginIdActionPerformed(ActionEvent evt) {
        if (TextUtils.isBlank((CharSequence)this.txtPassword.getText())) {
            this.txtPassword.requestFocus();
        } else {
            this.prepareManualLogin();
        }
    }

    private void btnForgotPasswordActionPerformed(MouseEvent evt) {
        String enterpriseIp;
        boolean checkCompleted;
        String enterpriseNo;
        Activity ctx = UCChatClient.context;
        String mode = PreferencesUtil.getEnterpriseNoMode(ctx);
        if ("MODE_ENT_NO".equalsIgnoreCase(mode) ? TextUtils.isBlank((CharSequence)(enterpriseNo = PreferencesUtil.getEnterpriseNo(ctx))) && !(checkCompleted = this.showEnterpriseNoDialog()) : TextUtils.isBlank((CharSequence)(enterpriseIp = PreferencesUtil.getEnterpriseIp(ctx))) && !(checkCompleted = this.showEnterpriseNoDialog())) {
            return;
        }
        this.showForwardPasswordDialog();
    }

    private void showForwardPasswordDialog() {
        Activity ctx = UCChatClient.context;
        String loginId = this.txtLoginId.getText();
        if (loginId != null) {
            loginId = loginId.trim();
            loginId = loginId.toLowerCase();
            this.txtLoginId.setText(loginId);
        }
        PreferencesUtil.setLoginInfo(ctx, loginId);
        ForgotPasswordDialog dialog = new ForgotPasswordDialog(UCChatClient.getInstance(), loginId);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        boolean checkComplete = dialog.isCheckCompleted();
        if (checkComplete) {
            this.showMessage(I18NUtil.getString("login_reset_pwd_request_sent"), null, false);
            Timer timer = new Timer(2000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ld2) {
                    LoginPanel.this.lblMessage.setText("");
                    LoginPanel.this.lblMessage.setVisible(false);
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
    }

    private void txtPasswordActionPerformed(ActionEvent evt) {
        this.prepareManualLogin();
    }

    private void btnLoginActionPerformed(ActionEvent evt) {
        this.prepareManualLogin();
    }

    private void btnExitActionPerformed(ActionEvent evt) {
        UCChatClient.getInstance().exit();
    }

    private void prepareManualLogin() {
        String enterpriseIp;
        boolean checkCompleted;
        String enterpriseNo;
        String mode;
        Activity ctx = UCChatClient.context;
        boolean valid = this.checkLoginInfo();
        if (!valid) {
            return;
        }
        String loginId = this.txtLoginId.getText().trim().replaceAll("\\s+", "");
        char[] pwdChars = this.txtPassword.getPassword();
        String password = new String(pwdChars).trim();
        String oldLoginId = PreferencesUtil.getLoginID(ctx);
        if (TextUtils.isNotBlank((CharSequence)oldLoginId) && !loginId.equalsIgnoreCase(oldLoginId.trim())) {
            int result = JOptionPane.showConfirmDialog(this, I18NUtil.getString("login_confirm_update_account"), I18NUtil.getString("common_select_one_option"), 2, 2);
            if (result == 0) {
                Log.i(LoginPanel.class.getSimpleName(), "\u767b\u5165\u5e33\u865f\u5df2\u8b8a\u66f4\uff0c\u6e05\u9664Preferences");
                DataCleanUtil.cleanUserData(ctx);
            } else {
                return;
            }
        }
        if ("MODE_ENT_NO".equalsIgnoreCase(mode = PreferencesUtil.getEnterpriseNoMode(ctx)) ? TextUtils.isBlank((CharSequence)(enterpriseNo = PreferencesUtil.getEnterpriseNo(ctx))) && !(checkCompleted = this.showEnterpriseNoDialog()) : TextUtils.isBlank((CharSequence)(enterpriseIp = PreferencesUtil.getEnterpriseIp(ctx))) && !(checkCompleted = this.showEnterpriseNoDialog())) {
            return;
        }
        PreferencesUtil.setLoginInfo(ctx, loginId, password);
        PreferencesUtil.setLoginRetype(UCChatClient.context, !this.chbSavePassword.isSelected());
        this.setMode(Mode.CHECK_MANUAL);
        if (NetworkService.getInstance().isOnline()) {
            this.checkLoginProcess();
        }
    }

    private void doLogin(int loginRequestType) {
        Log.i(LoginPanel.class.getSimpleName(), "doLogin " + loginRequestType);
        this.startLoginThread();
        this.setMode(Mode.LOGINNING);
        if (loginRequestType == 1) {
            PreferencesUtil.putString(UCChatClient.context, "LOGIN_SESSION_ID", "");
        }
        WebAgent.getInstance().login(loginRequestType);
    }

    private void recheckEnterpriseNo() {
        Activity ctx = UCChatClient.context;
        String mode = PreferencesUtil.getEnterpriseNoMode(ctx);
        if ("MODE_ENT_NO".equalsIgnoreCase(mode)) {
            if (this.mEnterpriseTask != null) {
                this.mEnterpriseTask.cancel(true);
                this.mEnterpriseTask = null;
            }
            this.mEnterpriseTask = new VerifyEnterpriseNoTask(ctx, PreferencesUtil.getEnterpriseNo(ctx), this);
            this.mEnterpriseTask.execute(new Void[0]);
        }
    }

    @Override
    public void onCheckCompleted(Object data, int type) {
    }

    private void stopLogin(String message) {
        this.stopLoginThread();
        this.setMode(Mode.ERROR);
        WebAgent.getInstance().logout(4002, true);
        if (message != null) {
            this.showMessage(message, UIConstants.ICON_WARNING, true);
        }
    }

    private void startLoginThread() {
        if (UCChatClient.getInstance().getContentPane() == this) {
            Log.i(LoginPanel.class.getSimpleName(), "\u555f\u52d5 LoginThread");
            this.loginThread = new LoginThread();
            this.loginThread.start();
        }
    }

    private void stopLoginThread() {
        if (this.loginThread != null && this.loginThread.isAlive()) {
            Log.i(LoginPanel.class.getSimpleName(), "\u505c\u6b62 LoginThread");
            this.loginThread.stopLogin();
        }
    }

    public void connectionClosedOnError(String message) {
        this.setMode(Mode.ERROR);
        this.showMessage(message, UIConstants.ICON_LOADING24, false);
    }

    private void showMessage(String text, Icon icon, boolean error) {
        text = text == null ? "" : text;
        this.lblMessage.setForeground(error ? Color.red : Color.black);
        this.lblMessage.setText("<html>" + text + "</html>");
        this.lblMessage.setIcon(icon);
        this.lblMessage.setVisible(true);
    }

    public void setMode(Mode mode) {
        this.mode = mode;
        switch (mode) {
            case CHECK_RECONNECT: {
                this.txtLoginId.setEnabled(false);
                this.txtPassword.setEnabled(false);
                this.btnLogin.setEnabled(false);
                this.btnChangeEnteriseNo.setEnabled(false);
                this.showMessage(I18NUtil.getString("login_notice_network_checking"), UIConstants.ICON_LOADING24, false);
                break;
            }
            case CHECK_MANUAL: {
                this.txtLoginId.setEnabled(false);
                this.txtPassword.setEnabled(false);
                this.btnLogin.setEnabled(false);
                this.btnChangeEnteriseNo.setEnabled(false);
                this.showMessage(I18NUtil.getString("login_notice_network_checking"), UIConstants.ICON_LOADING24, false);
                break;
            }
            case LOGINNING: {
                this.txtLoginId.setEnabled(false);
                this.txtPassword.setEnabled(false);
                this.btnLogin.setEnabled(false);
                this.btnChangeEnteriseNo.setEnabled(false);
                this.showMessage(I18NUtil.getString("login_notice_server_loginning"), UIConstants.ICON_LOADING24, false);
                break;
            }
            case WAIT: {
                this.txtLoginId.setEnabled(true);
                this.txtPassword.setEnabled(true);
                this.btnLogin.setEnabled(true);
                this.btnChangeEnteriseNo.setEnabled(true);
                break;
            }
            case ERROR: {
                this.txtLoginId.setEnabled(true);
                this.txtPassword.setEnabled(true);
                this.btnLogin.setEnabled(true);
                this.btnChangeEnteriseNo.setEnabled(true);
            }
        }
    }

    public String getLoginId() {
        return this.txtLoginId.getText();
    }

    public String getPassword() {
        return this.txtPassword.getText();
    }

    private void btnChangeEnteriseNoActionPerformed(ActionEvent evt) {
        this.showEnterpriseNoDialog();
    }

    private void toMouseEnteredFont(MouseEvent evt) {
        this.originalFont = evt.getComponent().getFont();
        Map<TextAttribute, ?> attributes = this.originalFont.getAttributes();
        attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
        evt.getComponent().setFont(this.originalFont.deriveFont(attributes));
    }

    private void toMouseExitedFont(MouseEvent evt) {
        evt.getComponent().setFont(this.originalFont);
    }

    private boolean showEnterpriseNoDialog() {
        String currentEnterpriseNo = null;
        String mode = PreferencesUtil.getEnterpriseNoMode(UCChatClient.context);
        currentEnterpriseNo = "MODE_ENT_NO".equalsIgnoreCase(mode) ? PreferencesUtil.getEnterpriseNo(UCChatClient.context) : PreferencesUtil.getEnterpriseIp(UCChatClient.context);
        this.cleanMsg();
        EnterpriseNoDialog dialog = new EnterpriseNoDialog(UCChatClient.getInstance(), currentEnterpriseNo);
        dialog.setLocationRelativeTo(this);
        dialog.setVisible(true);
        boolean checkComplete = dialog.isCheckCompleted();
        if (checkComplete) {
            Log.i(LoginPanel.class.getSimpleName(), "\u4f01\u696d\u7de8\u865f\u5df2\u8b8a\u66f4\u70ba ==>" + dialog.getEnterpriseNo());
            String afterMode = PreferencesUtil.getEnterpriseNoMode(UCChatClient.context);
            if ("MODE_ENT_NO".equalsIgnoreCase(afterMode)) {
                currentEnterpriseNo = PreferencesUtil.getEnterpriseNo(UCChatClient.context);
                this.btnChangeEnteriseNo.setText(String.format(I18NUtil.getString("login_label_modify_enterprise_no"), currentEnterpriseNo));
            } else {
                currentEnterpriseNo = PreferencesUtil.getEnterpriseIp(UCChatClient.context);
                this.btnChangeEnteriseNo.setText(String.format(I18NUtil.getString("login_label_modify_enterprise_no"), currentEnterpriseNo));
            }
        } else {
            Log.i(LoginPanel.class.getSimpleName(), "\u4f01\u696d\u7de8\u865f\u672a\u8b8a\u66f4");
        }
        return checkComplete;
    }

    private void chbSavePasswordItemStateChanged(ItemEvent evt) {
        PreferencesUtil.setLoginRetype(UCChatClient.context, !this.chbSavePassword.isSelected());
    }

    private void web_disconnected(int code, String reason) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoginPanel.this.stopLogin(I18NUtil.getString("login_notice_connection_failed"));
            }
        });
    }

    private void web_loginFailed(Intent intent) {
        int logoutReason = 1000;
        if (intent.hasExtra("LOGOUTREASON")) {
            logoutReason = intent.getIntExtra("LOGOUTREASON", 1000);
        }
        Bundle bundle = intent.getExtras();
        String returnInfo = bundle.getString("returnInfo");
        if (logoutReason != -1) {
            returnInfo = LoginMsgUtil.getLoginMsg(logoutReason);
        }
        Log.e(LoginPanel.class.getSimpleName(), "web_loginFailed. reason:" + logoutReason + ", error:" + returnInfo);
        final String msg = returnInfo;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                LoginPanel.this.stopLogin(msg);
            }
        });
    }

    private void checkLoginProcess() {
        if (!NetworkService.getInstance().isOnline()) {
            Log.i(LoginPanel.class.getSimpleName(), "no network .... skip ");
            this.stopLogin(I18NUtil.getString("network_notice_unavailable_s"));
            return;
        }
        if (this.mode == Mode.CHECK_RECONNECT || this.mode == Mode.CHECK_MANUAL) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (LoginPanel.this.mode == Mode.CHECK_RECONNECT) {
                        LoginPanel.this.doLogin(0);
                    } else if (LoginPanel.this.mode == Mode.CHECK_MANUAL) {
                        LoginPanel.this.recheckEnterpriseNo();
                        LoginPanel.this.doLogin(1);
                    }
                }
            });
        } else {
            String mode = PreferencesUtil.getEnterpriseNoMode(UCChatClient.context);
            if ("MODE_ENT_NO".equalsIgnoreCase(mode)) {
                String enterpriseNo = PreferencesUtil.getEnterpriseNo(UCChatClient.context);
                if (!TextUtils.isBlank((CharSequence)enterpriseNo)) {
                    this.checkBackground();
                }
            } else {
                String enterpriseIp = PreferencesUtil.getEnterpriseIp(UCChatClient.context);
                if (!TextUtils.isBlank((CharSequence)enterpriseIp)) {
                    this.checkBackground();
                }
            }
        }
    }

    class LowercaseDocumentFilter
    extends DocumentFilter {
        LowercaseDocumentFilter(LoginPanel this$0) {
        }

        @Override
        public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
            if (fb != null && text != null) {
                fb.insertString(offset, text.toLowerCase(), attr);
            }
        }

        @Override
        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attrs) throws BadLocationException {
            if (fb != null && text != null) {
                fb.replace(offset, length, text.toLowerCase(), attrs);
            }
        }
    }

    public static enum Mode {
        CHECK_RECONNECT,
        CHECK_MANUAL,
        LOGINNING,
        WAIT,
        ERROR;

    }

    class LoginThread
    extends Thread {
        final int MAX_WAITINT_TIME = 60000;
        long elapsedTime;
        boolean goon;

        public LoginThread() {
            super("UC-LoginThread");
            this.MAX_WAITINT_TIME = 60000;
            this.elapsedTime = 0L;
            this.goon = true;
        }

        public void stopLogin() {
            this.goon = false;
            this.interrupt();
        }

        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            while (this.elapsedTime < 60000L && this.goon) {
                if (WebAgent.isLogin) {
                    return;
                }
                try {
                    LoginThread.sleep(1000L);
                    this.elapsedTime = System.currentTimeMillis() - startTime;
                }
                catch (InterruptedException e) {
                    return;
                }
            }
            if (!WebAgent.isLogin) {
                Log.e(LoginPanel.class.getSimpleName(), "*** LoginThread \u767b\u5165\u903e\u6642!");
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LoginPanel.this.setMode(Mode.ERROR);
                        WebAgent.getInstance().logout(4001, true);
                        LoginPanel.this.showMessage(I18NUtil.getString("login_notice_timeout"), UIConstants.ICON_WARNING, true);
                    }
                });
            }
        }
    }
}

