/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.main;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.EntryPanel;
import com.blisscloud.ezuc.client.component.PersonalPhoto;
import com.blisscloud.ezuc.client.component.RoundedCornerLabel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.agent.CallLine;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.bean.PhoneLineInfo;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBExternalContact;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.PhotoType;
import com.blisscloud.mobile.ezuc.phone.CallState;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.KeyUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ActivePhonePanel
extends JPanel {
    private PersonalPhoto lblHeadIcon;
    private JLabel callTimer;
    private JLabel lblName;
    private JLabel lblStatus;
    private JPanel panelCall;
    private RoundedCornerLabel btnAnswer;
    private RoundedCornerLabel btnHangup;
    private int mPhoneLineIndex;
    private boolean selected;

    public ActivePhonePanel(int phoneLineIndex) {
        this.initGUI();
        this.mPhoneLineIndex = phoneLineIndex;
        this.lblName.setText("");
        this.setImageWithPhoneState(UIConstants.ICON_PERSON48.getImage(), CallState.IDLE);
    }

    public void updateTimer() {
        CallLine callLine = PhoneAgent.getInstance().getCallLine(this.mPhoneLineIndex);
        PhoneLineInfo info = callLine.getLineInfo();
        if (info != null && info.getCallerStartTime() > 0L) {
            String dislTime = info.getCallDuration();
            this.callTimer.setText(dislTime);
            this.callTimer.setVisible(true);
        } else {
            this.callTimer.setText("");
            this.callTimer.setVisible(false);
        }
    }

    public void cancelTimer() {
        this.callTimer.setText("");
        this.callTimer.setVisible(false);
    }

    public CallLine getCallLine() {
        return PhoneAgent.getInstance().getCallLine(this.mPhoneLineIndex);
    }

    public void updateCurrentPhoneInfo() {
        Activity ctx = UCChatClient.context;
        CallLine callLine = this.getCallLine();
        CallState lineState = callLine.getState();
        PhoneLineInfo lineInfo = callLine.getLineInfo();
        CallState otherState = CallState.IDLE;
        otherState = this.mPhoneLineIndex == 0 ? PhoneAgent.getInstance().getCallLine(1).getState() : PhoneAgent.getInstance().getCallLine(0).getState();
        if (lineState == CallState.IDLE) {
            this.panelCall.setVisible(false);
            this.btnAnswer.setVisible(false);
            this.btnHangup.setVisible(false);
        } else if (lineState == CallState.INCOMING_CALL && !lineInfo.isMeetme()) {
            this.panelCall.setVisible(true);
            this.btnAnswer.setVisible(true);
            this.btnHangup.setVisible(true);
            this.btnHangup.setText(I18NUtil.getString("call_btn_reject"));
        } else {
            this.panelCall.setVisible(true);
            this.btnAnswer.setVisible(false);
            this.btnHangup.setVisible(true);
            this.btnHangup.setText(I18NUtil.getString("call_btn_hangup"));
        }
        if (lineInfo == null) {
            this.lblName.setText("");
            this.setImageWithPhoneState(UIConstants.ICON_PERSON48.getImage(), lineState);
        } else {
            String name = lineInfo.getMainDispName();
            Object status = "";
            ImageIcon icon = null;
            if (lineState == CallState.INCOMING_CALL) {
                icon = UIConstants.ICON_LIGHT_RED;
                status = otherState != CallState.IDLE ? (this.mPhoneLineIndex == 0 ? I18NUtil.getString("phone_notification_ringing_line1") : I18NUtil.getString("phone_notification_ringing_line2")) : I18NUtil.getString("phone_notification_ringing");
            } else if (lineState == CallState.OUTGOING_CALL) {
                icon = UIConstants.ICON_LIGHT_RED;
                status = otherState != CallState.IDLE ? (this.mPhoneLineIndex == 0 ? I18NUtil.getString("phone_notification_dialing_line1") : I18NUtil.getString("phone_notification_dialing_line2")) : I18NUtil.getString("phone_notification_dialing");
            } else if (lineState == CallState.INCALL) {
                icon = UIConstants.ICON_LIGHT_RED;
                boolean isMuted = callLine.isMute();
                status = otherState != CallState.IDLE ? (this.mPhoneLineIndex == 0 ? I18NUtil.getString("phone_notification_talking_line1") + (String)(isMuted ? " (" + I18NUtil.getString("call_notice_call_muted") + ")" : "") : I18NUtil.getString("phone_notification_talking_line2") + (String)(isMuted ? " (" + I18NUtil.getString("call_notice_call_muted") + ")" : "")) : I18NUtil.getString("phone_notification_talking") + (String)(isMuted ? " (" + I18NUtil.getString("call_notice_call_muted") + ")" : "");
            } else if (lineState == CallState.HOLD) {
                icon = UIConstants.ICON_LIGHT_YELLOW;
                status = otherState != CallState.IDLE ? (this.mPhoneLineIndex == 0 ? I18NUtil.getString("phone_notification_hold_line1") : I18NUtil.getString("phone_notification_hold_line2")) : I18NUtil.getString("phone_notification_hold");
            }
            this.lblName.setText(name);
            this.lblStatus.setIcon(icon);
            this.lblStatus.setText((String)status);
            if (lineInfo.getType() == 1) {
                LiteContact contact = ContactManager.getContact((Context)ctx, lineInfo.getJid());
                this.fetchPhoto(contact, lineState);
            } else if (lineInfo.getType() == 2) {
                this.setImageWithPhoneState(UIConstants.ICON_PHONE_PUBLIC_PHONE48.getImage(), lineState);
            } else if (lineInfo.getType() == 6) {
                LiteMyContact myContact = UCDBExternalContact.getExternalContactById(UCChatClient.context, JidUtil.trimExternalContactId(lineInfo.getJid()));
                this.fetchPhoto(myContact, lineState);
            } else if (lineInfo.getType() == 8) {
                this.setImageWithPhoneState(UIConstants.ICON_PERSON48.getImage(), lineState);
            } else if (lineInfo.getType() == 4) {
                ArrayList<String> participantJidList = UCDBChatRoom.findChatRoomParticipants((Context)ctx, lineInfo.getJid());
                this.setImageWithPhoneState(GraphicUtil.getChatRoomImage(ctx, participantJidList, null, false, true), lineState);
            } else if (lineInfo.getType() == 5) {
                this.setImageWithPhoneState(UIConstants.ICON_PHONE_CONFERENCE.getImage(), lineState);
            } else {
                this.setImageWithPhoneState(UIConstants.ICON_PERSON48.getImage(), lineState);
            }
        }
    }

    private void setImageWithPhoneState(Image image, CallState phoneState) {
        this.lblHeadIcon.setImage(image);
    }

    protected void fetchPhoto(LiteContact contact, CallState lineState) {
        if (contact != null && contact.isPhotoFlag()) {
            BufferedImage img = ContactManager.getPhotoWithRefresh(UCChatClient.context, PhotoType.SMALL, KeyUtil.genEmpKey(contact), true);
            if (img != null) {
                img = GraphicUtil.getPresencedPersonalPhoto(32, 32, img, null, true);
                this.setImageWithPhoneState(img, lineState);
            } else {
                this.setImageWithPhoneState(UIConstants.ICON_PERSON48.getImage(), lineState);
            }
        } else {
            this.setImageWithPhoneState(UIConstants.ICON_PERSON48.getImage(), lineState);
        }
    }

    private void fetchPhoto(LiteMyContact contact, CallState lineState) {
        if (contact != null && contact.isPhotoFlag()) {
            BufferedImage img = ContactManager.getExternalPhotoWithRefresh(UCChatClient.context, PhotoType.SMALL, contact.getId(), true);
            if (img != null) {
                img = GraphicUtil.getPresencedPersonalPhoto(32, 32, img, null, true);
                this.setImageWithPhoneState(img, lineState);
            } else {
                this.setImageWithPhoneState(UIConstants.ICON_PERSON48.getImage(), lineState);
            }
        } else {
            this.setImageWithPhoneState(UIConstants.ICON_PERSON48.getImage(), lineState);
        }
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            this.setLayout(thisLayout);
            this.setBorder(EntryPanel.ENTRY_BORDER);
            this.setBackground(EntryPanel.ENTRY_BACKGROUND);
            this.setPreferredSize(new Dimension(305, 60));
            this.setMinimumSize(new Dimension(200, 60));
            this.setOpaque(false);
            this.lblHeadIcon = new PersonalPhoto();
            this.add((Component)this.lblHeadIcon, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.lblHeadIcon.setPreferredSize(new Dimension(48, 48));
            this.lblHeadIcon.setMinimumSize(new Dimension(48, 48));
            this.lblStatus = new JLabel();
            this.add((Component)this.lblStatus, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
            this.lblStatus.setFont(UIConstants.FONT_14_PLAIN);
            this.callTimer = new JLabel();
            this.add((Component)this.callTimer, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(2, 5, 0, 0), 0, 0));
            this.callTimer.setFont(UIConstants.FONT_12_BOLD);
            this.callTimer.setText("00:00");
            this.callTimer.setVisible(false);
            this.lblName = new JLabel();
            this.add((Component)this.lblName, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
            this.lblName.setFont(UIConstants.FONT_14_PLAIN);
            this.panelCall = new JPanel();
            this.panelCall.setVisible(false);
            this.add((Component)this.panelCall, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
            FlowLayout panelCallLayout = new FlowLayout();
            panelCallLayout.setHgap(4);
            panelCallLayout.setVgap(0);
            this.panelCall.setLayout(panelCallLayout);
            this.panelCall.setOpaque(false);
            this.btnHangup = new RoundedCornerLabel(I18NUtil.getString("call_btn_reject"), UIConstants.ICON_HANGUP, UIConstants.BACKGROUND_HANGUP_NORMAL, UIConstants.BACKGROUND_HANGUP_OVER, UIConstants.BACKGROUND_HANGUP_PRESSED);
            this.panelCall.add(this.btnHangup);
            this.btnHangup.setForeground(Color.WHITE);
            this.btnHangup.setToolTipText(I18NUtil.getString("call_btn_reject"));
            this.btnHangup.setVisible(false);
            this.btnHangup.setCursor(UIConstants.CURSOR_HAND);
            this.btnHangup.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (ActivePhonePanel.this.btnHangup.isEnabled() && evt.getButton() == 1) {
                        CallLine callLine = PhoneAgent.getInstance().getCallLine(ActivePhonePanel.this.mPhoneLineIndex);
                        PhoneLineInfo lineInfo = callLine.getLineInfo();
                        if (lineInfo != null && JidUtil.isChatConfJid(lineInfo.getJid())) {
                            int result = JOptionPane.showConfirmDialog(ActivePhonePanel.this, I18NUtil.getString("call_title_meetme_hangup_confirm"), I18NUtil.getString("common_title_warning"), 2, 2);
                            if (result == 0) {
                                PhoneAgent.getInstance().hangupLine(ActivePhonePanel.this.mPhoneLineIndex);
                            }
                        } else {
                            PhoneAgent.getInstance().hangupLine(ActivePhonePanel.this.mPhoneLineIndex);
                        }
                    }
                }
            });
            this.btnAnswer = new RoundedCornerLabel(I18NUtil.getString("call_btn_answer"), UIConstants.ICON_DIAL, UIConstants.BACKGROUND_CALL_NORMAL, UIConstants.BACKGROUND_CALL_OVER, UIConstants.BACKGROUND_CALL_PRESSED);
            this.panelCall.add(this.btnAnswer);
            this.btnAnswer.setForeground(Color.WHITE);
            this.btnAnswer.setToolTipText(I18NUtil.getString("call_btn_answer"));
            this.btnAnswer.setVisible(false);
            this.btnAnswer.setCursor(UIConstants.CURSOR_HAND);
            this.btnAnswer.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    CallLine callLine;
                    if (ActivePhonePanel.this.btnAnswer.isEnabled() && evt.getButton() == 1 && (callLine = PhoneAgent.getInstance().getCallLine(ActivePhonePanel.this.mPhoneLineIndex)).getState() == CallState.INCOMING_CALL) {
                        PhoneAgent.getInstance().answerLine(ActivePhonePanel.this.mPhoneLineIndex);
                        UCChatClient.getInstance().getMainPanel().getViewContainer().showPhonePanel(ActivePhonePanel.this.mPhoneLineIndex);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean b) {
        this.selected = b;
        this.setBackground(EntryPanel.ENTRY_BACKGROUND);
        this.setOpaque(this.selected);
        this.revalidate();
        this.repaint();
    }

    public void setMenuDisplayed(boolean b) {
        if (!this.selected) {
            this.setBackground(EntryPanel.ENTRY_MENU_DISPLAYED_BACKGROUND);
            this.setOpaque(b);
        }
        this.revalidate();
        this.repaint();
    }
}

