/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.main;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.EntryPanel;
import com.blisscloud.ezuc.client.component.HighlightToggleButton;
import com.blisscloud.ezuc.client.component.PersonalPhoto;
import com.blisscloud.ezuc.client.main.ToastInterface;
import com.blisscloud.ezuc.client.phone.ConferenceDialog;
import com.blisscloud.ezuc.client.phone.TransferDialog;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.util.GraphicUtil;
import com.blisscloud.ezuc.client.util.TextUtils;
import com.blisscloud.ezuc.client.util.simulate.Activity;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.ezuc.client.util.simulate.Log;
import com.blisscloud.mobile.ezuc.agent.CallLine;
import com.blisscloud.mobile.ezuc.agent.PhoneAgent;
import com.blisscloud.mobile.ezuc.agent.WebAgent;
import com.blisscloud.mobile.ezuc.bean.PhoneLineInfo;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBExternalContact;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import com.blisscloud.mobile.ezuc.manager.PhotoType;
import com.blisscloud.mobile.ezuc.phone.CallState;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import com.blisscloud.mobile.ezuc.util.KeyUtil;
import com.blisscloud.mobile.ezuc.util.PreferencesUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.StringUtils;

public class ActivePhoneWithControlPanel
extends JPanel {
    private static final long serialVersionUID = 1174848037430478462L;
    private PersonalPhoto lblHeadIcon;
    private JLabel callTimer;
    private JTextField lblName;
    private JLabel lblStatus;
    private JPanel panelCall;
    private JLabel phoneHangup;
    private JLabel phoneTransfer;
    private JLabel phoneMeeting;
    private HighlightToggleButton phoneMute;
    private HighlightToggleButton phoneHold;
    private HighlightToggleButton phoneRecording;
    private int mPhoneLineIndex;
    private boolean selected;
    private ToastInterface mToastUtil;
    private JPopupMenu popupMenu;
    private TransferDialog transferDialog;
    private ConferenceDialog conferenceDialog;

    public ActivePhoneWithControlPanel(int phoneLineIndex, ToastInterface toastUtil) {
        this.initGUI();
        this.initPopupMenu();
        this.mPhoneLineIndex = phoneLineIndex;
        this.mToastUtil = toastUtil;
        this.lblName.setText("");
        this.setImageWithPhoneState(UIConstants.ICON_PERSON48.getImage(), CallState.IDLE);
    }

    private void initPopupMenu() {
        JMenuItem miCopy = new JMenuItem();
        miCopy.setText(I18NUtil.getString("common_btn_copy"));
        miCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (ActivePhoneWithControlPanel.this.lblName != null) {
                    String selection = ActivePhoneWithControlPanel.this.lblName.getSelectedText();
                    StringSelection stringSelection = new StringSelection(selection);
                    Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                    clipboard.setContents(stringSelection, null);
                }
            }
        });
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(miCopy);
    }

    public void updateTimer() {
        CallLine callLine = PhoneAgent.getInstance().getCallLine(this.mPhoneLineIndex);
        PhoneLineInfo info = callLine.getLineInfo();
        if (info != null && info.getCallerStartTime() > 0L) {
            String dislTime = info.getCallDuration();
            this.callTimer.setText(dislTime);
            this.callTimer.setVisible(true);
        } else {
            this.callTimer.setText("");
            this.callTimer.setVisible(false);
        }
    }

    public void cancelTimer() {
        this.callTimer.setText("");
        this.callTimer.setVisible(false);
    }

    public CallLine getCallLine() {
        return PhoneAgent.getInstance().getCallLine(this.mPhoneLineIndex);
    }

    public void updateCurrentPhoneInfo() {
        Activity ctx = UCChatClient.context;
        CallLine callLine = this.getCallLine();
        CallState lineState = callLine.getState();
        PhoneLineInfo lineInfo = callLine.getLineInfo();
        CallState otherState = CallState.IDLE;
        otherState = this.mPhoneLineIndex == 0 ? PhoneAgent.getInstance().getCallLine(1).getState() : PhoneAgent.getInstance().getCallLine(0).getState();
        if (lineState == CallState.IDLE) {
            this.setHold(false, false);
            this.setRecording(false, false);
            this.setMute(true, false);
        } else if (lineState == CallState.INCOMING_CALL) {
            this.setHold(false, false);
            this.setRecording(false, false);
            this.setMute(true, callLine.isMute());
        } else if (lineState == CallState.OUTGOING_CALL) {
            this.setHold(false, false);
            this.setRecording(false, false);
            this.setMute(true, callLine.isMute());
        } else if (lineState == CallState.INCALL) {
            this.setHold(true, false);
            this.setRecording(true, callLine.isRecordingFlag());
            this.setMute(true, callLine.isMute());
        } else if (lineState == CallState.HOLD) {
            this.setHold(true, true);
            this.setRecording(true, callLine.isRecordingFlag());
            this.setMute(true, callLine.isMute());
        }
        boolean transferAvailable = PhoneAgent.getInstance().checkTransferFuncAvailable(this.mPhoneLineIndex);
        boolean conferenceAvailable = PhoneAgent.getInstance().checkConferenceferFuncAvailable(this.mPhoneLineIndex);
        this.phoneTransfer.setEnabled(transferAvailable);
        this.phoneTransfer.setVisible(transferAvailable);
        this.phoneMeeting.setEnabled(conferenceAvailable);
        this.phoneMeeting.setVisible(conferenceAvailable);
        if (lineState == CallState.IDLE) {
            this.panelCall.setVisible(false);
            this.phoneHangup.setVisible(false);
        } else if (lineState == CallState.INCOMING_CALL && !lineInfo.isMeetme()) {
            this.panelCall.setVisible(true);
            this.phoneHangup.setVisible(true);
        } else {
            this.panelCall.setVisible(true);
            this.phoneHangup.setVisible(true);
        }
        if (lineInfo == null) {
            this.lblName.setText("");
            this.setImageWithPhoneState(UIConstants.ICON_PERSON48.getImage(), lineState);
        } else {
            String name = lineInfo.getMainDispName();
            String status = "";
            ImageIcon icon = null;
            if (lineState == CallState.INCOMING_CALL) {
                icon = UIConstants.ICON_LIGHT_RED;
                status = otherState != CallState.IDLE ? (this.mPhoneLineIndex == 0 ? I18NUtil.getString("phone_notification_ringing_line1") : I18NUtil.getString("phone_notification_ringing_line2")) : I18NUtil.getString("phone_notification_ringing");
            } else if (lineState == CallState.OUTGOING_CALL) {
                icon = UIConstants.ICON_LIGHT_RED;
                status = otherState != CallState.IDLE ? (this.mPhoneLineIndex == 0 ? I18NUtil.getString("phone_notification_dialing_line1") : I18NUtil.getString("phone_notification_dialing_line2")) : I18NUtil.getString("phone_notification_dialing");
            } else if (lineState == CallState.INCALL) {
                icon = UIConstants.ICON_LIGHT_RED;
                status = I18NUtil.getString("phone_notification_talking");
            } else if (lineState == CallState.HOLD) {
                icon = UIConstants.ICON_LIGHT_YELLOW;
                status = I18NUtil.getString("phone_notification_hold");
            }
            this.lblName.setText(name);
            this.lblStatus.setIcon(icon);
            this.lblStatus.setText(status);
            if (lineInfo.getType() == 1) {
                LiteContact contact = ContactManager.getContact((Context)ctx, lineInfo.getJid());
                this.fetchPhoto(contact, lineState);
            } else if (lineInfo.getType() == 2) {
                this.setImageWithPhoneState(UIConstants.ICON_PHONE_PUBLIC_PHONE48.getImage(), lineState);
            } else if (lineInfo.getType() == 6) {
                LiteMyContact myContact = UCDBExternalContact.getExternalContactById(UCChatClient.context, JidUtil.trimExternalContactId(lineInfo.getJid()));
                this.fetchPhoto(myContact, lineState);
            } else if (lineInfo.getType() == 8) {
                this.setImageWithPhoneState(UIConstants.ICON_PERSON48.getImage(), lineState);
            } else if (lineInfo.getType() == 4) {
                ArrayList<String> participantJidList = UCDBChatRoom.findChatRoomParticipants((Context)ctx, lineInfo.getJid());
                this.setImageWithPhoneState(GraphicUtil.getChatRoomImage(ctx, participantJidList, null, false, true), lineState);
            } else if (lineInfo.getType() == 5) {
                this.setImageWithPhoneState(UIConstants.ICON_PHONE_CONFERENCE.getImage(), lineState);
            } else {
                this.setImageWithPhoneState(UIConstants.ICON_PERSON48.getImage(), lineState);
            }
        }
    }

    private void setImageWithPhoneState(Image image, CallState phoneState) {
        this.lblHeadIcon.setImage(image);
    }

    protected void fetchPhoto(LiteContact contact, CallState lineState) {
        if (contact != null && contact.isPhotoFlag()) {
            BufferedImage img = ContactManager.getPhotoWithRefresh(UCChatClient.context, PhotoType.SMALL, KeyUtil.genEmpKey(contact), true);
            if (img != null) {
                img = GraphicUtil.getPresencedPersonalPhoto(32, 32, img, null, true);
                this.setImageWithPhoneState(img, lineState);
            } else {
                this.setImageWithPhoneState(UIConstants.ICON_PERSON48.getImage(), lineState);
            }
        } else {
            this.setImageWithPhoneState(UIConstants.ICON_PERSON48.getImage(), lineState);
        }
    }

    private void fetchPhoto(LiteMyContact contact, CallState lineState) {
        if (contact != null && contact.isPhotoFlag()) {
            BufferedImage img = ContactManager.getExternalPhotoWithRefresh(UCChatClient.context, PhotoType.SMALL, contact.getId(), true);
            if (img != null) {
                img = GraphicUtil.getPresencedPersonalPhoto(32, 32, img, null, true);
                this.setImageWithPhoneState(img, lineState);
            } else {
                this.setImageWithPhoneState(UIConstants.ICON_PERSON48.getImage(), lineState);
            }
        } else {
            this.setImageWithPhoneState(UIConstants.ICON_PERSON48.getImage(), lineState);
        }
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            this.setLayout(thisLayout);
            this.setBorder(EntryPanel.ENTRY_BORDER);
            this.setPreferredSize(new Dimension(305, 60));
            this.setMinimumSize(new Dimension(200, 60));
            this.setOpaque(false);
            this.lblHeadIcon = new PersonalPhoto();
            this.add((Component)this.lblHeadIcon, new GridBagConstraints(0, 0, 1, 2, 0.0, 1.0, 17, 0, new Insets(0, 0, 0, 10), 0, 0));
            this.lblHeadIcon.setPreferredSize(new Dimension(48, 48));
            this.lblHeadIcon.setMinimumSize(new Dimension(48, 48));
            this.lblStatus = new JLabel();
            this.add((Component)this.lblStatus, new GridBagConstraints(1, 0, 1, 1, 0.0, 1.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
            this.lblStatus.setForeground(Color.WHITE);
            this.lblStatus.setFont(UIConstants.FONT_14_PLAIN);
            this.callTimer = new JLabel();
            this.add((Component)this.callTimer, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(2, 5, 0, 0), 0, 0));
            this.callTimer.setFont(UIConstants.FONT_12_BOLD);
            this.callTimer.setForeground(Color.WHITE);
            this.callTimer.setText("00:00");
            this.callTimer.setVisible(false);
            this.lblName = new JTextField();
            this.add((Component)this.lblName, new GridBagConstraints(1, 1, 2, 1, 1.0, 1.0, 17, 0, new Insets(2, 0, 0, 0), 0, 0));
            this.lblName.setFont(UIConstants.FONT_14_PLAIN);
            this.lblName.setForeground(Color.WHITE);
            this.lblName.setBorder(null);
            this.lblName.setOpaque(false);
            this.lblName.setEditable(false);
            this.lblName.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent evt) {
                    String selection;
                    if (SwingUtilities.isRightMouseButton(evt) && StringUtils.isNotBlank((CharSequence)(selection = ActivePhoneWithControlPanel.this.lblName.getSelectedText()))) {
                        ActivePhoneWithControlPanel.this.popupMenu.show(ActivePhoneWithControlPanel.this.lblName, evt.getX(), evt.getY());
                    }
                    if (evt.getClickCount() == 2) {
                        ActivePhoneWithControlPanel.this.lblName.selectAll();
                    }
                }
            });
            this.panelCall = new JPanel();
            this.panelCall.setVisible(false);
            this.add((Component)this.panelCall, new GridBagConstraints(2, 0, 1, 2, 0.0, 0.0, 13, 0, new Insets(0, 10, 0, 0), 0, 0));
            FlowLayout panelCallLayout = new FlowLayout();
            panelCallLayout.setHgap(1);
            panelCallLayout.setVgap(0);
            this.panelCall.setLayout(panelCallLayout);
            this.panelCall.setOpaque(false);
            this.phoneMute = new HighlightToggleButton(UIConstants.COLOR_ENTERED_ITEM_FROM, UIConstants.COLOR_ENTERED_ITEM_TO, UIConstants.COLOR_SELECTED_ITEM_FROM, UIConstants.COLOR_SELECTED_ITEM_TO);
            this.panelCall.add(this.phoneMute);
            this.phoneMute.setIcon(UIConstants.ICON_MUTE_ON_SMALL);
            this.phoneMute.setSelectedIcon(UIConstants.ICON_MUTE_ON_SMALL);
            this.phoneMute.setDisabledIcon(UIConstants.ICON_MUTE_OFF_SMALL);
            this.phoneMute.setForeground(UIConstants.COLOR_ITEM_FOREGROUND);
            this.phoneMute.setHorizontalAlignment(0);
            this.phoneMute.setHorizontalTextPosition(0);
            this.phoneMute.setVerticalTextPosition(3);
            this.phoneMute.setPreferredSize(new Dimension(30, 30));
            this.phoneMute.setCursor(new Cursor(12));
            this.phoneMute.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ActivePhoneWithControlPanel.this.onClickMuteButton();
                }
            });
            this.phoneMute.getInputMap(2).put(KeyStroke.getKeyStroke(77, 512), "Alt+M");
            this.phoneMute.getActionMap().put("Alt+M", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActivePhoneWithControlPanel.this.onClickMuteButton();
                }
            });
            this.phoneRecording = new HighlightToggleButton(UIConstants.COLOR_ENTERED_ITEM_FROM, UIConstants.COLOR_ENTERED_ITEM_TO, UIConstants.COLOR_SELECTED_ITEM_FROM, UIConstants.COLOR_SELECTED_ITEM_TO);
            this.panelCall.add(this.phoneRecording);
            this.phoneRecording.setIcon(UIConstants.ICON_RECORDING_ON_SMALL);
            this.phoneRecording.setSelectedIcon(UIConstants.ICON_RECORDING_ON_SMALL);
            this.phoneRecording.setDisabledIcon(UIConstants.ICON_RECORDING_OFF_SMALL);
            this.phoneRecording.setForeground(UIConstants.COLOR_ITEM_FOREGROUND);
            this.phoneRecording.setHorizontalAlignment(0);
            this.phoneRecording.setHorizontalTextPosition(0);
            this.phoneRecording.setVerticalTextPosition(3);
            this.phoneRecording.setPreferredSize(new Dimension(30, 30));
            this.phoneRecording.setCursor(new Cursor(12));
            this.phoneRecording.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ActivePhoneWithControlPanel.this.onClickRecording();
                }
            });
            this.phoneRecording.getInputMap(2).put(KeyStroke.getKeyStroke(82, 512), "Alt+R");
            this.phoneRecording.getActionMap().put("Alt+R", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActivePhoneWithControlPanel.this.onClickRecording();
                }
            });
            this.phoneHold = new HighlightToggleButton(UIConstants.COLOR_ENTERED_ITEM_FROM, UIConstants.COLOR_ENTERED_ITEM_TO, UIConstants.COLOR_SELECTED_ITEM_FROM, UIConstants.COLOR_SELECTED_ITEM_TO);
            this.panelCall.add(this.phoneHold);
            this.phoneHold.setIcon(UIConstants.ICON_HOLD_ON_SMALL);
            this.phoneHold.setSelectedIcon(UIConstants.ICON_HOLD_ON_SMALL);
            this.phoneHold.setDisabledIcon(UIConstants.ICON_HOLD_OFF_SMALL);
            this.phoneHold.setForeground(UIConstants.COLOR_ITEM_FOREGROUND);
            this.phoneHold.setHorizontalAlignment(0);
            this.phoneHold.setHorizontalTextPosition(0);
            this.phoneHold.setVerticalTextPosition(3);
            this.phoneHold.setPreferredSize(new Dimension(30, 30));
            this.phoneHold.setCursor(new Cursor(12));
            this.phoneHold.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ActivePhoneWithControlPanel.this.onClickHoldButton();
                }
            });
            this.phoneHold.getInputMap(2).put(KeyStroke.getKeyStroke(72, 512), "Alt+H");
            this.phoneHold.getActionMap().put("Alt+H", new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ActivePhoneWithControlPanel.this.onClickHoldButton();
                }
            });
            this.phoneHangup = new JLabel();
            this.panelCall.add(this.phoneHangup);
            this.phoneHangup.setIcon(UIConstants.ICON_ENDCALL_NORMAL_SMALL);
            this.phoneHangup.setDisabledIcon(UIConstants.ICON_ENDCALL_NORMAL_SMALL);
            this.phoneHangup.setForeground(UIConstants.COLOR_ITEM_FOREGROUND);
            this.phoneHangup.setHorizontalAlignment(0);
            this.phoneHangup.setHorizontalTextPosition(0);
            this.phoneHangup.setVerticalTextPosition(3);
            this.phoneHangup.setPreferredSize(new Dimension(30, 30));
            this.phoneHangup.setCursor(new Cursor(12));
            this.phoneHangup.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (ActivePhoneWithControlPanel.this.phoneHangup.isEnabled()) {
                        ActivePhoneWithControlPanel.this.phoneHangup.setIcon(UIConstants.ICON_ENDCALL_OVER_SMALL);
                    }
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (ActivePhoneWithControlPanel.this.phoneHangup.isEnabled()) {
                        ActivePhoneWithControlPanel.this.phoneHangup.setIcon(UIConstants.ICON_ENDCALL_NORMAL_SMALL);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (ActivePhoneWithControlPanel.this.phoneHangup.isEnabled()) {
                        ActivePhoneWithControlPanel.this.phoneHangup.setIcon(UIConstants.ICON_ENDCALL_CLICK_SMALL);
                        ActivePhoneWithControlPanel.this.onClickHangup();
                    }
                }
            });
            this.phoneTransfer = new JLabel();
            this.panelCall.add(this.phoneTransfer);
            this.phoneTransfer.setIcon(UIConstants.ICON_TRANSFER_NORMAL_SMALL);
            this.phoneTransfer.setDisabledIcon(UIConstants.ICON_TRANSFER_NORMAL_SMALL);
            this.phoneTransfer.setForeground(UIConstants.COLOR_ITEM_FOREGROUND);
            this.phoneTransfer.setHorizontalAlignment(0);
            this.phoneTransfer.setHorizontalTextPosition(0);
            this.phoneTransfer.setVerticalTextPosition(3);
            this.phoneTransfer.setPreferredSize(new Dimension(30, 30));
            this.phoneTransfer.setCursor(new Cursor(12));
            this.phoneTransfer.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (ActivePhoneWithControlPanel.this.phoneTransfer.isEnabled()) {
                        ActivePhoneWithControlPanel.this.phoneTransfer.setIcon(UIConstants.ICON_TRANSFER_OVER_SMALL);
                    }
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (ActivePhoneWithControlPanel.this.phoneTransfer.isEnabled()) {
                        ActivePhoneWithControlPanel.this.phoneTransfer.setIcon(UIConstants.ICON_TRANSFER_NORMAL_SMALL);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (ActivePhoneWithControlPanel.this.phoneTransfer.isEnabled()) {
                        ActivePhoneWithControlPanel.this.phoneTransfer.setIcon(UIConstants.ICON_TRANSFER_CLICK_SMALL);
                        ActivePhoneWithControlPanel.this.onClickTransfer();
                    }
                }
            });
            this.phoneMeeting = new JLabel();
            this.panelCall.add(this.phoneMeeting);
            this.phoneMeeting.setIcon(UIConstants.ICON_MEETING_NORMAL_SMALL);
            this.phoneMeeting.setDisabledIcon(UIConstants.ICON_MEETING_NORMAL_SMALL);
            this.phoneMeeting.setForeground(UIConstants.COLOR_ITEM_FOREGROUND);
            this.phoneMeeting.setHorizontalAlignment(0);
            this.phoneMeeting.setHorizontalTextPosition(0);
            this.phoneMeeting.setVerticalTextPosition(3);
            this.phoneMeeting.setPreferredSize(new Dimension(30, 30));
            this.phoneMeeting.setCursor(new Cursor(12));
            this.phoneMeeting.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent evt) {
                    if (ActivePhoneWithControlPanel.this.phoneMeeting.isEnabled()) {
                        ActivePhoneWithControlPanel.this.phoneMeeting.setIcon(UIConstants.ICON_MEETING_OVER_SMALL);
                    }
                }

                @Override
                public void mouseExited(MouseEvent evt) {
                    if (ActivePhoneWithControlPanel.this.phoneMeeting.isEnabled()) {
                        ActivePhoneWithControlPanel.this.phoneMeeting.setIcon(UIConstants.ICON_MEETING_NORMAL_SMALL);
                    }
                }

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (ActivePhoneWithControlPanel.this.phoneMeeting.isEnabled()) {
                        ActivePhoneWithControlPanel.this.phoneMeeting.setIcon(UIConstants.ICON_MEETING_CLICK_SMALL);
                        ActivePhoneWithControlPanel.this.onClickInvite();
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void onClickHangup() {
        if (this.phoneHangup.isEnabled()) {
            CallLine callLine = PhoneAgent.getInstance().getCallLine(this.mPhoneLineIndex);
            PhoneLineInfo lineInfo = callLine.getLineInfo();
            if (JidUtil.isChatConfJid(lineInfo.getJid())) {
                int result = JOptionPane.showConfirmDialog(this, I18NUtil.getString("call_title_meetme_hangup_confirm"), I18NUtil.getString("common_title_warning"), 2, 2);
                if (result == 0) {
                    PhoneAgent.getInstance().hangupLine(this.mPhoneLineIndex);
                }
            } else {
                PhoneAgent.getInstance().hangupLine(this.mPhoneLineIndex);
            }
        }
    }

    private void onClickTransfer() {
        List<CallLine> lineList;
        if (PreferencesUtil.isNoPopupTransferEnabled() && (lineList = PhoneAgent.getInstance().getOtherLineAbleToTransfer(this.mPhoneLineIndex)) != null && lineList.size() == 1) {
            CallLine callLine1 = PhoneAgent.getInstance().getCallLine(this.mPhoneLineIndex);
            CallLine callLine2 = lineList.get(0);
            WebAgent.getInstance().makeTwoStepTransfer(callLine1.getSipCallId(), callLine2.getSipCallId());
            return;
        }
        if (this.transferDialog != null) {
            this.transferDialog.dispose();
            this.transferDialog = null;
        }
        this.transferDialog = new TransferDialog((JFrame)UCChatClient.getInstance(), this.mPhoneLineIndex);
        Dimension d = this.transferDialog.getSize();
        int x = UCChatClient.getInstance().getX() + (UCChatClient.getInstance().getWidth() - (int)d.getWidth()) / 2;
        int y = UCChatClient.getInstance().getY() + (UCChatClient.getInstance().getHeight() - (int)d.getHeight()) / 2;
        this.transferDialog.setLocation(x, y);
        this.transferDialog.setVisible(true);
        this.transferDialog = null;
    }

    public void onClickInvite() {
        int currentLineIndex = PhoneAgent.getInstance().getCurrentLineIndex();
        List<CallLine> lineList = PhoneAgent.getInstance().getOtherLineAbleToNewConf(currentLineIndex);
        List<CallLine> meetmeLineList = PhoneAgent.getInstance().getOtherConferenceLine(currentLineIndex);
        if (meetmeLineList.size() == 0 && lineList.size() == 1) {
            CallLine otherLine;
            HashSet<String> participantJidSet = new HashSet<String>();
            participantJidSet.add(PreferencesUtil.getUserJid(UCChatClient.context));
            CallLine currentLine = PhoneAgent.getInstance().getCallLine(currentLineIndex);
            String sipCallId1 = null;
            String sipCallId2 = null;
            if (currentLineIndex == 0) {
                sipCallId1 = currentLine.getSipCallId();
            } else if (currentLineIndex == 1) {
                sipCallId2 = currentLine.getSipCallId();
            }
            PhoneLineInfo lineInfo = currentLine.getLineInfo();
            if (TextUtils.isNotBlank((CharSequence)lineInfo.getJid())) {
                participantJidSet.add(lineInfo.getJid());
            }
            if ((otherLine = lineList.get(0)).getLineId() == 0) {
                sipCallId1 = otherLine.getSipCallId();
            } else if (otherLine.getLineId() == 1) {
                sipCallId2 = otherLine.getSipCallId();
            }
            PhoneLineInfo otherLineInfo = otherLine.getLineInfo();
            if (TextUtils.isNotBlank((CharSequence)otherLineInfo.getJid())) {
                participantJidSet.add(otherLineInfo.getJid());
            }
            String roomId = UCDBChatRoom.findThreeWayCallingChatRoom(UCChatClient.context, participantJidSet);
            WebAgent.getInstance().makeThreeWayCalling(roomId, participantJidSet, sipCallId1, sipCallId2, null);
            return;
        }
        if (meetmeLineList.size() == 1 && lineList.size() == 0) {
            CallLine currentLine = PhoneAgent.getInstance().getCallLine(currentLineIndex);
            CallLine meetmeLine = meetmeLineList.get(0);
            WebAgent.getInstance().makeInviteConference(meetmeLine.getLineInfo().getJid(), currentLine.getSipCallId());
            return;
        }
        if (this.conferenceDialog != null) {
            this.conferenceDialog.dispose();
            this.conferenceDialog = null;
        }
        this.conferenceDialog = new ConferenceDialog((JFrame)UCChatClient.getInstance(), currentLineIndex);
        Dimension d = this.conferenceDialog.getSize();
        int x = UCChatClient.getInstance().getX() + (UCChatClient.getInstance().getWidth() - (int)d.getWidth()) / 2;
        int y = UCChatClient.getInstance().getY() + (UCChatClient.getInstance().getHeight() - (int)d.getHeight()) / 2;
        this.conferenceDialog.setLocation(x, y);
        this.conferenceDialog.setVisible(true);
        this.conferenceDialog = null;
    }

    public void onClickMuteButton() {
        try {
            if (!PhoneAgent.getInstance().toggleMute(this.mPhoneLineIndex)) {
                CallLine callLine = PhoneAgent.getInstance().getCallLine(this.mPhoneLineIndex);
                if (callLine.isMute()) {
                    this.phoneMute.setSelected(true);
                } else {
                    this.phoneMute.setSelected(false);
                }
            }
        }
        catch (Throwable t) {
            Log.e(ActivePhoneWithControlPanel.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
        }
    }

    public void onClickRecording() {
        if (!PreferencesUtil.hasRecordingLicense(UCChatClient.context)) {
            this.phoneRecording.setSelected(false);
            this.mToastUtil.showToastPanel(I18NUtil.getString("permission_no_rec_license"), 3500);
            return;
        }
        try {
            CallLine callLine = PhoneAgent.getInstance().getCallLine(this.mPhoneLineIndex);
            if (callLine.getState() == CallState.HOLD && !callLine.isRecordingFlag()) {
                this.mToastUtil.showToastPanel(I18NUtil.getString("call_record_not_allow_while_hold"), 3500);
                this.phoneRecording.setSelected(false);
                return;
            }
            if (!PhoneAgent.getInstance().toggleRecording(this.mPhoneLineIndex)) {
                if (callLine.isRecordingFlag()) {
                    this.phoneRecording.setSelected(true);
                } else {
                    this.phoneRecording.setSelected(false);
                }
            }
        }
        catch (Throwable t) {
            Log.e(ActivePhoneWithControlPanel.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
        }
    }

    public void onClickHoldButton() {
        try {
            if (!PhoneAgent.getInstance().toggleHold(this.mPhoneLineIndex)) {
                CallLine callLine = PhoneAgent.getInstance().getCallLine(this.mPhoneLineIndex);
                if (callLine.getState() == CallState.HOLD) {
                    this.phoneHold.setSelected(true);
                } else {
                    this.phoneHold.setSelected(false);
                }
            }
        }
        catch (Throwable t) {
            Log.e(ActivePhoneWithControlPanel.class.getSimpleName(), "ERROR:" + t.getLocalizedMessage(), t);
        }
    }

    public void setMute(boolean isEnabled, boolean isSelected) {
        this.phoneMute.setEnabled(isEnabled);
        this.phoneMute.setSelected(isSelected);
    }

    public void setRecording(boolean isEnabled, boolean isSelected) {
        this.phoneRecording.setEnabled(isEnabled);
        this.phoneRecording.setSelected(isSelected);
    }

    public void setHold(boolean isEnabled, boolean isSelected) {
        this.phoneHold.setEnabled(isEnabled);
        this.phoneHold.setSelected(isSelected);
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean b) {
        this.selected = b;
        this.setBackground(EntryPanel.ENTRY_BACKGROUND);
        this.setOpaque(this.selected);
        this.revalidate();
        this.repaint();
    }

    public void setMenuDisplayed(boolean b) {
        if (!this.selected) {
            this.setBackground(EntryPanel.ENTRY_MENU_DISPLAYED_BACKGROUND);
            this.setOpaque(b);
        }
        this.revalidate();
        this.repaint();
    }

    public void dispose() {
        if (this.transferDialog != null) {
            this.transferDialog.dispose();
            this.transferDialog = null;
        }
        if (this.conferenceDialog != null) {
            this.conferenceDialog.dispose();
            this.conferenceDialog = null;
        }
    }
}

