/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.main;

import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.component.RoundedCornerPanel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;

public class ChoosePBXSitePanel
extends RoundedCornerPanel {
    private JLabel lblTitle;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JLabel lblPadding;
    private JButton btnConfirm;
    ButtonGroup buttonGroup1 = new ButtonGroup();
    String[] siteIds;
    String[] siteNames;
    int currentSiteIndex;
    boolean ringOnChoosePbxSite = false;
    ChoosePBXSiteCallback callback;

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        frame.getContentPane().add(new ChoosePBXSitePanel(new String[]{"0", "1", "2"}, new String[]{"\u53f0\u5317", "\u4e0a\u6d77", "\u5317\u4eac"}, 1, true, null));
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    public ChoosePBXSitePanel(String[] siteIds, String[] siteNames, int currentSiteIndex, boolean ringOnChoosePbxSite, ChoosePBXSiteCallback callback) {
        this.siteIds = siteIds;
        this.siteNames = siteNames;
        this.currentSiteIndex = currentSiteIndex;
        this.ringOnChoosePbxSite = ringOnChoosePbxSite;
        this.callback = callback;
        this.initGUI();
        this.initSiteGUI();
    }

    private void initGUI() {
        try {
            GridBagLayout thisLayout = new GridBagLayout();
            this.setLayout(thisLayout);
            this.setBackground(UIConstants.COLOR_DIALOG_BACKGROUND);
            this.lblTitle = new JLabel();
            this.add((Component)this.lblTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 20, 10, 20), 0, 0));
            this.lblTitle.setText(I18NUtil.getString("setting_label_select_phone_site"));
            this.lblTitle.setFont(UIConstants.FONT_16_BOLD);
            this.lblTitle.setForeground(UIConstants.COLOR_DIALOG_TITLE);
            this.lblTitle.setPreferredSize(new Dimension(300, 20));
            this.jSeparator1 = new JSeparator();
            this.add((Component)this.jSeparator1, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(0, 0, 20, 0), 0, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initSiteGUI() {
        int rowIndex = 3;
        for (int i = 0; i < this.siteIds.length; ++i) {
            JRadioButton rbSite = new JRadioButton();
            this.add((Component)rbSite, new GridBagConstraints(0, rowIndex++, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 40, 5, 40), 0, 0));
            rbSite.setText(this.siteNames[i]);
            rbSite.setOpaque(false);
            rbSite.setFont(UIConstants.FONT_14_BOLD);
            rbSite.setForeground(UIConstants.COLOR_DIALOG_ITEM_BLUE);
            rbSite.setFocusPainted(false);
            rbSite.setActionCommand(String.valueOf(i));
            this.buttonGroup1.add(rbSite);
            if (this.currentSiteIndex >= 0 && i == this.currentSiteIndex) {
                rbSite.setSelected(true);
                continue;
            }
            if (this.currentSiteIndex != -1 || i != 0) continue;
            rbSite.setSelected(true);
        }
        this.jSeparator2 = new JSeparator();
        this.add((Component)this.jSeparator2, new GridBagConstraints(0, rowIndex++, 1, 1, 1.0, 0.0, 10, 2, new Insets(20, 0, 0, 0), 0, 0));
        this.btnConfirm = new JButton();
        this.add((Component)this.btnConfirm, new GridBagConstraints(0, rowIndex++, 1, 1, 0.0, 0.0, 10, 0, new Insets(10, 10, 10, 10), 0, 0));
        this.btnConfirm.setText(I18NUtil.getString("common_btn_ok"));
        this.btnConfirm.setMinimumSize(new Dimension(75, 30));
        this.btnConfirm.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ChoosePBXSitePanel.this.btnConfirmActionPerformed(evt);
            }
        });
    }

    private void btnConfirmActionPerformed(ActionEvent evt) {
        if (this.callback != null) {
            int siteIndex = Integer.parseInt(this.buttonGroup1.getSelection().getActionCommand());
            boolean ringOnChoosePbxSite = false;
            this.callback.pbxSiteConfirmed(siteIndex, ringOnChoosePbxSite);
        }
    }

    public static interface ChoosePBXSiteCallback {
        public void pbxSiteConfirmed(int var1, boolean var2);
    }
}

