/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.main;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.bean.LiteMyContact;
import com.blisscloud.ezuc.bean.web.LiteConferenceRoom;
import com.blisscloud.ezuc.client.UCChatClient;
import com.blisscloud.ezuc.client.UIConstants;
import com.blisscloud.ezuc.client.addressbook.AddressBookGroup;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.component.SearchField;
import com.blisscloud.ezuc.client.main.ChatroomCellRenderer;
import com.blisscloud.ezuc.client.model.ToggleListSelectionModel;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.ezuc.client.sorter.ChatRoomMsgTimeSorter;
import com.blisscloud.ezuc.client.sorter.ConferenceListSorter;
import com.blisscloud.ezuc.client.util.simulate.Context;
import com.blisscloud.mobile.ezuc.bean.ChatRoomInfo;
import com.blisscloud.mobile.ezuc.bean.Message;
import com.blisscloud.mobile.ezuc.db.UCDBChatRoom;
import com.blisscloud.mobile.ezuc.db.UCDBContact;
import com.blisscloud.mobile.ezuc.db.UCDBGroup;
import com.blisscloud.mobile.ezuc.db.UCDBMessage;
import com.blisscloud.mobile.ezuc.manager.ContactHistoryManager;
import com.blisscloud.mobile.ezuc.manager.MeetmeManager;
import com.blisscloud.mobile.ezuc.util.JidUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectChatroomDialog
extends GenericDialog
implements ListSelectionListener {
    private static final Color TITLE_FOREGROUND = new Color(0x808080);
    private JPanel panelContent;
    private JScrollPane jScrollPane1;
    private JLabel lblEmployees;
    private JList listEmployees;
    DefaultComboBoxModel listModelEmployees = new DefaultComboBoxModel();
    boolean expandedEmployees;
    private JLabel lblPadding;
    private JLabel lblConferenceRoom;
    private JList listConferenceRoom;
    DefaultComboBoxModel listModelConferenceRoom = new DefaultComboBoxModel();
    boolean expandedConferenceRoom;
    private JLabel lblMyChatRoom;
    private JList listMyChatRoom;
    DefaultComboBoxModel listModelMyChatRoom = new DefaultComboBoxModel();
    boolean expandedMyChatRoom;
    private JLabel lblFavorite;
    private JList listFavorite;
    DefaultComboBoxModel listModelFavorite = new DefaultComboBoxModel();
    boolean expandedFavorite;
    private JLabel lblUC;
    private JList listUC;
    DefaultComboBoxModel listModelUC = new DefaultComboBoxModel();
    boolean expandedUC;
    private JPanel jPanel2;
    private JPanel jPanel1;
    private JLabel lblTitle;
    private SearchField sfContact;
    private JLabel lblSelectionCount;
    private JButton btnConfirm;
    private JButton btnCancel;
    boolean mOK = false;
    ChatroomCellRenderer ccr = new ChatroomCellRenderer(48);

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                SelectChatroomDialog inst = new SelectChatroomDialog(frame);
                inst.showDialog();
            }
        });
    }

    public SelectChatroomDialog(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle(I18NUtil.getAppName());
            this.setModal(true);
            this.setLocationRelativeTo(null);
            this.panelContent = new JPanel();
            GridBagLayout panelContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.panelContent, "Center");
            this.panelContent.setLayout(panelContentLayout);
            this.panelContent.setBackground(Color.WHITE);
            this.sfContact = new SearchField();
            this.panelContent.add((Component)this.sfContact, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
            this.sfContact.setSearchCallback(new SearchField.SearchCallback(){

                @Override
                public void doSearch(String key) {
                    SelectChatroomDialog.this.searchContact(key);
                }
            });
            this.lblTitle = new JLabel();
            this.panelContent.add((Component)this.lblTitle, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
            this.lblTitle.setText(I18NUtil.getString("chat_contact_selection"));
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(60);
            this.panelContent.add((Component)this.jScrollPane1, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 17, 1, new Insets(3, 10, 0, 10), 0, 0));
            this.jPanel2 = new JPanel();
            GridBagLayout jPanel2Layout = new GridBagLayout();
            this.jPanel2.setLayout(jPanel2Layout);
            this.jScrollPane1.setViewportView(this.jPanel2);
            this.jPanel2.setBackground(Color.WHITE);
            this.lblUC = new JLabel();
            this.jPanel2.add((Component)this.lblUC, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.lblUC.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            this.lblUC.setText(I18NUtil.getString("tab_uclist"));
            this.lblUC.setIcon(UIConstants.ICON_EXPAND);
            this.lblUC.setForeground(TITLE_FOREGROUND);
            this.lblUC.setFont(UIConstants.FONT_14_BOLD);
            this.lblUC.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (evt.getButton() == 1) {
                        SelectChatroomDialog.this.expandedUC = !SelectChatroomDialog.this.expandedUC;
                        SelectChatroomDialog.toggleGroup(SelectChatroomDialog.this.expandedUC, SelectChatroomDialog.this.lblUC, SelectChatroomDialog.this.listUC);
                    }
                }
            });
            this.lblUC.setVisible(false);
            this.listUC = new JList();
            this.jPanel2.add((Component)this.listUC, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.listUC.setVisible(false);
            this.listUC.setCellRenderer(this.ccr);
            this.listUC.setModel(this.listModelUC);
            this.listUC.setSelectionMode(2);
            this.listUC.setSelectionModel(new ToggleListSelectionModel(this.listUC));
            this.listUC.getSelectionModel().addListSelectionListener(this);
            this.lblFavorite = new JLabel();
            this.jPanel2.add((Component)this.lblFavorite, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.lblFavorite.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            this.lblFavorite.setText(I18NUtil.getString("abook_my_favorites"));
            this.lblFavorite.setIcon(UIConstants.ICON_EXPAND);
            this.lblFavorite.setForeground(TITLE_FOREGROUND);
            this.lblFavorite.setFont(UIConstants.FONT_14_BOLD);
            this.lblFavorite.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (evt.getButton() == 1) {
                        SelectChatroomDialog.this.expandedFavorite = !SelectChatroomDialog.this.expandedFavorite;
                        SelectChatroomDialog.toggleGroup(SelectChatroomDialog.this.expandedFavorite, SelectChatroomDialog.this.lblFavorite, SelectChatroomDialog.this.listFavorite);
                    }
                }
            });
            this.lblFavorite.setVisible(false);
            this.listFavorite = new JList();
            this.jPanel2.add((Component)this.listFavorite, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.listFavorite.setVisible(false);
            this.listFavorite.setCellRenderer(this.ccr);
            this.listFavorite.setModel(this.listModelFavorite);
            this.listFavorite.setSelectionMode(2);
            this.listFavorite.setSelectionModel(new ToggleListSelectionModel(this.listFavorite));
            this.listFavorite.getSelectionModel().addListSelectionListener(this);
            this.lblMyChatRoom = new JLabel();
            this.jPanel2.add((Component)this.lblMyChatRoom, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.lblMyChatRoom.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            this.lblMyChatRoom.setText(I18NUtil.getString("abook_my_chatrooms"));
            this.lblMyChatRoom.setIcon(UIConstants.ICON_EXPAND);
            this.lblMyChatRoom.setForeground(TITLE_FOREGROUND);
            this.lblMyChatRoom.setFont(UIConstants.FONT_14_BOLD);
            this.lblMyChatRoom.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (evt.getButton() == 1) {
                        SelectChatroomDialog.this.expandedMyChatRoom = !SelectChatroomDialog.this.expandedMyChatRoom;
                        SelectChatroomDialog.toggleGroup(SelectChatroomDialog.this.expandedMyChatRoom, SelectChatroomDialog.this.lblMyChatRoom, SelectChatroomDialog.this.listMyChatRoom);
                    }
                }
            });
            this.lblMyChatRoom.setVisible(false);
            this.listMyChatRoom = new JList();
            this.jPanel2.add((Component)this.listMyChatRoom, new GridBagConstraints(0, 7, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.listMyChatRoom.setVisible(false);
            this.listMyChatRoom.setCellRenderer(this.ccr);
            this.listMyChatRoom.setModel(this.listModelMyChatRoom);
            this.listMyChatRoom.setSelectionMode(2);
            this.listMyChatRoom.setSelectionModel(new ToggleListSelectionModel(this.listMyChatRoom));
            this.listMyChatRoom.getSelectionModel().addListSelectionListener(this);
            this.lblConferenceRoom = new JLabel();
            this.jPanel2.add((Component)this.lblConferenceRoom, new GridBagConstraints(0, 8, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.lblConferenceRoom.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            this.lblConferenceRoom.setText(I18NUtil.getString("conference_label"));
            this.lblConferenceRoom.setIcon(UIConstants.ICON_EXPAND);
            this.lblConferenceRoom.setForeground(TITLE_FOREGROUND);
            this.lblConferenceRoom.setFont(UIConstants.FONT_14_BOLD);
            this.lblConferenceRoom.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (evt.getButton() == 1) {
                        SelectChatroomDialog.this.expandedConferenceRoom = !SelectChatroomDialog.this.expandedConferenceRoom;
                        SelectChatroomDialog.toggleGroup(SelectChatroomDialog.this.expandedConferenceRoom, SelectChatroomDialog.this.lblConferenceRoom, SelectChatroomDialog.this.listConferenceRoom);
                    }
                }
            });
            this.lblConferenceRoom.setVisible(false);
            this.listConferenceRoom = new JList();
            this.jPanel2.add((Component)this.listConferenceRoom, new GridBagConstraints(0, 9, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.listConferenceRoom.setVisible(false);
            this.listConferenceRoom.setCellRenderer(this.ccr);
            this.listConferenceRoom.setModel(this.listModelConferenceRoom);
            this.listConferenceRoom.setSelectionMode(2);
            this.listConferenceRoom.setSelectionModel(new ToggleListSelectionModel(this.listConferenceRoom));
            this.listConferenceRoom.getSelectionModel().addListSelectionListener(this);
            this.lblEmployees = new JLabel();
            this.jPanel2.add((Component)this.lblEmployees, new GridBagConstraints(0, 10, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.lblEmployees.setBorder(BorderFactory.createEmptyBorder(3, 5, 3, 5));
            this.lblEmployees.setText(I18NUtil.getString("abook_company_address_book"));
            this.lblEmployees.setIcon(UIConstants.ICON_EXPAND);
            this.lblEmployees.setForeground(TITLE_FOREGROUND);
            this.lblEmployees.setFont(UIConstants.FONT_14_BOLD);
            this.lblEmployees.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    if (evt.getButton() == 1) {
                        SelectChatroomDialog.this.expandedEmployees = !SelectChatroomDialog.this.expandedEmployees;
                        SelectChatroomDialog.toggleGroup(SelectChatroomDialog.this.expandedEmployees, SelectChatroomDialog.this.lblEmployees, SelectChatroomDialog.this.listEmployees);
                    }
                }
            });
            this.lblEmployees.setVisible(false);
            this.listEmployees = new JList();
            this.jPanel2.add((Component)this.listEmployees, new GridBagConstraints(0, 11, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            this.listEmployees.setVisible(false);
            this.listEmployees.setCellRenderer(this.ccr);
            this.listEmployees.setModel(this.listModelEmployees);
            this.listEmployees.setSelectionMode(2);
            this.listEmployees.setSelectionModel(new ToggleListSelectionModel(this.listEmployees));
            this.listEmployees.getSelectionModel().addListSelectionListener(this);
            this.lblPadding = new JLabel();
            this.jPanel2.add((Component)this.lblPadding, new GridBagConstraints(0, 12, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.lblPadding.setText(" ");
            this.lblSelectionCount = new JLabel();
            this.panelContent.add((Component)this.lblSelectionCount, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
            this.lblSelectionCount.setText(I18NUtil.getString("chatroom_label_selection_count") + " : 0");
            this.jPanel1 = new JPanel();
            FlowLayout jPanel1Layout = new FlowLayout();
            jPanel1Layout.setAlignment(2);
            jPanel1Layout.setHgap(10);
            this.jPanel1.setLayout(jPanel1Layout);
            this.panelContent.add((Component)this.jPanel1, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.jPanel1.setOpaque(false);
            this.btnConfirm = new JButton();
            this.jPanel1.add(this.btnConfirm);
            this.btnConfirm.setText(I18NUtil.getString("common_btn_ok"));
            this.btnConfirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SelectChatroomDialog.this.btnConfirmActionPerformed(evt);
                }
            });
            this.btnCancel = new JButton();
            this.jPanel1.add(this.btnCancel);
            this.btnCancel.setText(I18NUtil.getString("common_btn_cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SelectChatroomDialog.this.btnCancelActionPerformed(evt);
                }
            });
            this.setSize(430, 600);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void toggleGroup(boolean expanded, JLabel lblCaption, JList listContent) {
        if (expanded) {
            lblCaption.setIcon(UIConstants.ICON_COLLAPSE);
            listContent.setVisible(true);
        } else {
            lblCaption.setIcon(UIConstants.ICON_EXPAND);
            listContent.setVisible(false);
        }
    }

    private void btnConfirmActionPerformed(ActionEvent evt) {
        Set<String> jidSet = this.getSelectedUniqueKeySet();
        int count = jidSet.size();
        if (count < 0) {
            JOptionPane.showMessageDialog(this, I18NUtil.getString("chatroom_select_members"), I18NUtil.getString("common_title_error"), 0);
            return;
        }
        this.mOK = true;
        this.dispose();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.mOK = false;
        this.dispose();
    }

    @Override
    protected void onESCPressed() {
        this.mOK = false;
        this.dispose();
    }

    private void searchContact(String key) {
        this.loadChatroom(key);
    }

    public SelectChatroomResult showDialog() {
        this.loadChatroom(null);
        this.mOK = false;
        this.setVisible(true);
        if (this.mOK) {
            SelectChatroomResult res = new SelectChatroomResult(this);
            Set<String> jidSet = this.getSelectedUniqueKeySet();
            res.setChatroomJids(new ArrayList<String>(jidSet));
            return res;
        }
        return null;
    }

    private void loadChatroom(String searchKey) {
        boolean joined;
        this.listModelUC.removeAllElements();
        List<String> jidsList = null;
        jidsList = searchKey != null && !"".equals(searchKey.trim()) ? ContactHistoryManager.getContactHistory(UCChatClient.context, searchKey.trim()) : ContactHistoryManager.getAllContactHistory(UCChatClient.context);
        HashSet<String> jidsSet = new HashSet<String>(jidsList);
        List<ChatRoomInfo> roomInfoList = UCDBChatRoom.getChatRoomsByContactJids(UCChatClient.context, jidsSet);
        Map<String, LiteContact> contactsMap = UCDBContact.findAllRelatedContactsByJids(UCChatClient.context, jidsSet);
        Map<String, List<String>> participantJidMap = UCDBChatRoom.findChatRoomParticipants((Context)UCChatClient.context, jidsSet);
        ArrayList<ChatRoomInfo> finalRoomInfoList = new ArrayList<ChatRoomInfo>();
        for (ChatRoomInfo chatRoomInfo : roomInfoList) {
            LiteContact liteContact;
            String string = chatRoomInfo.getChatRoomId();
            if (JidUtil.isConfJid(string)) {
                List<String> list;
                LiteConferenceRoom liteConferenceRoom = MeetmeManager.getStaticMeetme(UCChatClient.context, chatRoomInfo.getChatRoomId());
                if (liteConferenceRoom == null || (list = participantJidMap.get(string)) == null || list.size() == 0) continue;
                finalRoomInfoList.add(chatRoomInfo);
                continue;
            }
            if (JidUtil.isChatJid(string)) {
                List<String> list = participantJidMap.get(string);
                if (list == null || list.size() == 0) continue;
                finalRoomInfoList.add(chatRoomInfo);
                continue;
            }
            if (!JidUtil.isEmployeeJid(string) || (liteContact = contactsMap.get(string)) == null) continue;
            finalRoomInfoList.add(chatRoomInfo);
        }
        Map<String, Message> lastMsgMap = UCDBMessage.getLastMsgMap(UCChatClient.context, jidsSet);
        block1: for (String string : lastMsgMap.keySet()) {
            Message message = lastMsgMap.get(string);
            for (ChatRoomInfo chatRoomInfo : finalRoomInfoList) {
                if (!string.equals(chatRoomInfo.getChatRoomId())) continue;
                chatRoomInfo.setLastMsgTime(message.getServerTime());
                continue block1;
            }
        }
        Collections.sort(finalRoomInfoList, new ChatRoomMsgTimeSorter());
        for (ChatRoomInfo chatRoomInfo : finalRoomInfoList) {
            this.listModelUC.addElement(chatRoomInfo);
        }
        this.lblUC.setVisible(this.listModelUC.getSize() > 0);
        this.listModelFavorite.removeAllElements();
        List<Object> list = UCDBGroup.findMyFavoriteGroup(UCChatClient.context, searchKey, true, true);
        for (Object object : list) {
            ChatRoomInfo chatRoomInfo;
            boolean bl;
            if (object instanceof LiteMyContact) continue;
            if (object instanceof LiteContact) {
                LiteContact liteContact = (LiteContact)object;
                if (!JidUtil.isEmployeeJid(liteContact.getJid())) continue;
                this.listModelFavorite.addElement(object);
                continue;
            }
            if (!(object instanceof ChatRoomInfo) || !(bl = UCDBChatRoom.hasParticipants(UCChatClient.context, (chatRoomInfo = (ChatRoomInfo)object).getChatRoomId()))) continue;
            this.listModelFavorite.addElement(object);
        }
        this.lblFavorite.setVisible(this.listModelFavorite.getSize() > 0);
        this.listModelMyChatRoom.removeAllElements();
        List<Object> list2 = UCDBGroup.findMyChatRoomGroup(UCChatClient.context, searchKey);
        for (Object object : list2) {
            ChatRoomInfo chatRoomInfo;
            if (!(object instanceof ChatRoomInfo) || !(joined = UCDBChatRoom.hasParticipants(UCChatClient.context, (chatRoomInfo = (ChatRoomInfo)object).getChatRoomId()))) continue;
            this.listModelMyChatRoom.addElement(object);
        }
        this.lblMyChatRoom.setVisible(this.listModelMyChatRoom.getSize() > 0);
        this.listModelConferenceRoom.removeAllElements();
        List<LiteConferenceRoom> list3 = MeetmeManager.getStaticMeetmeList(UCChatClient.context);
        if (list3 != null) {
            Collections.sort(list3, new ConferenceListSorter(UCChatClient.context));
        }
        for (LiteConferenceRoom liteConferenceRoom : list3) {
            joined = UCDBChatRoom.hasParticipants(UCChatClient.context, liteConferenceRoom.getChatRoomId());
            if (!joined) continue;
            if (searchKey == null || "".equals(searchKey.trim())) {
                this.listModelConferenceRoom.addElement(liteConferenceRoom);
                continue;
            }
            if (liteConferenceRoom.getName().indexOf(searchKey) < 0) continue;
            this.listModelConferenceRoom.addElement(liteConferenceRoom);
        }
        this.lblConferenceRoom.setVisible(this.listModelConferenceRoom.getSize() > 0);
        this.listModelEmployees.removeAllElements();
        HashSet<String> hashSet = new HashSet<String>();
        List list4 = UCDBContact.getContactsOrderByName(UCChatClient.context, searchKey, 0, hashSet);
        for (AddressBookGroup contactGroup : list4) {
            for (LiteContact contact : contactGroup.getDataList()) {
                if (!JidUtil.isEmployeeJid(contact.getJid())) continue;
                this.listModelEmployees.addElement(contact);
            }
        }
        this.lblEmployees.setVisible(this.listModelEmployees.getSize() > 0);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Set<String> jidSet = this.getSelectedUniqueKeySet();
        int count = jidSet.size();
        this.lblSelectionCount.setText(I18NUtil.getString("chatroom_label_selection_count") + " : " + count);
    }

    private Set<String> getSelectedUniqueKeySet() {
        HashSet chatrooms = new HashSet();
        for (Object obj : this.listUC.getSelectedValuesList()) {
            chatrooms.add(obj);
        }
        for (Object obj : this.listFavorite.getSelectedValuesList()) {
            chatrooms.add(obj);
        }
        for (Object obj : this.listMyChatRoom.getSelectedValuesList()) {
            chatrooms.add(obj);
        }
        for (Object obj : this.listConferenceRoom.getSelectedValuesList()) {
            chatrooms.add(obj);
        }
        for (Object obj : this.listEmployees.getSelectedValuesList()) {
            chatrooms.add(obj);
        }
        HashSet<String> chatroomJids = new HashSet<String>();
        for (Object chatroom : chatrooms) {
            if (chatroom instanceof ChatRoomInfo) {
                ChatRoomInfo chatRoomInfo = (ChatRoomInfo)chatroom;
                chatroomJids.add(chatRoomInfo.getChatRoomId());
                continue;
            }
            if (chatroom instanceof LiteContact) {
                LiteContact contact = (LiteContact)chatroom;
                chatroomJids.add(contact.getJid());
                continue;
            }
            if (chatroom instanceof LiteConferenceRoom) {
                LiteConferenceRoom confRoom = (LiteConferenceRoom)chatroom;
                chatroomJids.add(confRoom.getChatRoomId());
                continue;
            }
            if (!(chatroom instanceof String)) continue;
            String groupName = (String)chatroom;
            List<String> participants = UCDBGroup.findGroupParticipants(UCChatClient.context, groupName);
            chatroomJids.addAll(participants);
        }
        return chatroomJids;
    }

    public class SelectChatroomResult {
        private List<String> chatroomJids;

        public SelectChatroomResult(SelectChatroomDialog this$0) {
        }

        public List<String> getChatroomJids() {
            return this.chatroomJids;
        }

        public void setChatroomJids(List<String> chatroomJids) {
            this.chatroomJids = chatroomJids;
        }
    }
}

