/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.main;

import com.blisscloud.ezuc.bean.LiteContact;
import com.blisscloud.ezuc.client.component.ContactCellRenderer;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.component.SearchField;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import com.blisscloud.mobile.ezuc.manager.ContactManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class SelectSingleContactDialog
extends GenericDialog
implements ListSelectionListener {
    private JPanel panelContent;
    private JScrollPane jScrollPane1;
    private JList<LiteContact> listContact;
    private JPanel jPanel1;
    private JLabel lblTitle;
    private SearchField sfContact;
    private JButton btnConfirm;
    private JButton btnCancel;
    private boolean mOK = false;
    private boolean mAllowEmptySelection = false;
    private List<LiteContact> mCandidateContacts = new ArrayList<LiteContact>();
    private List<LiteContact> mCurrentMatchedContacts = new ArrayList<LiteContact>();
    private List<LiteContact> targetParticipants = new ArrayList<LiteContact>();
    boolean processing = false;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                SelectSingleContactDialog inst = new SelectSingleContactDialog(frame);
                inst.setVisible(true);
            }
        });
    }

    public SelectSingleContactDialog(JFrame frame) {
        super(frame);
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle(I18NUtil.getAppName());
            this.setModal(true);
            this.setLocationRelativeTo(null);
            this.panelContent = new JPanel();
            GridBagLayout panelContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.panelContent, "Center");
            this.panelContent.setLayout(panelContentLayout);
            this.panelContent.setBackground(Color.WHITE);
            this.sfContact = new SearchField();
            this.panelContent.add((Component)this.sfContact, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(10, 10, 0, 10), 0, 0));
            this.sfContact.setSearchCallback(new SearchField.SearchCallback(){

                @Override
                public void doSearch(String key) {
                    SelectSingleContactDialog.this.searchContact(key);
                }
            });
            this.lblTitle = new JLabel();
            this.panelContent.add((Component)this.lblTitle, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
            this.lblTitle.setText("");
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(60);
            this.panelContent.add((Component)this.jScrollPane1, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 10, 0, 10), 0, 0));
            this.listContact = new JList();
            this.jScrollPane1.setViewportView(this.listContact);
            this.listContact.setCellRenderer(new ContactCellRenderer());
            this.listContact.setSelectionMode(1);
            this.listContact.getSelectionModel().addListSelectionListener(this);
            this.jPanel1 = new JPanel();
            FlowLayout jPanel1Layout = new FlowLayout();
            jPanel1Layout.setAlignment(2);
            jPanel1Layout.setHgap(10);
            this.jPanel1.setLayout(jPanel1Layout);
            this.panelContent.add((Component)this.jPanel1, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 2, new Insets(10, 10, 10, 10), 0, 0));
            this.jPanel1.setOpaque(false);
            this.btnConfirm = new JButton();
            this.jPanel1.add(this.btnConfirm);
            this.btnConfirm.setText(I18NUtil.getString("common_btn_ok"));
            this.btnConfirm.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SelectSingleContactDialog.this.btnConfirmActionPerformed(evt);
                }
            });
            this.btnCancel = new JButton();
            this.jPanel1.add(this.btnCancel);
            this.btnCancel.setText(I18NUtil.getString("common_btn_cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    SelectSingleContactDialog.this.btnCancelActionPerformed(evt);
                }
            });
            this.setSize(380, 600);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void btnConfirmActionPerformed(ActionEvent evt) {
        if (!this.mAllowEmptySelection && this.listContact.getSelectedIndex() < 0) {
            JOptionPane.showMessageDialog(this, I18NUtil.getString("chatroom_select_members"), I18NUtil.getString("common_title_error"), 0);
            return;
        }
        this.mOK = true;
        this.dispose();
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.mOK = false;
        this.dispose();
    }

    @Override
    protected void onESCPressed() {
        this.mOK = false;
        this.dispose();
    }

    private void searchContact(String key) {
        this.processing = true;
        this.mCurrentMatchedContacts.clear();
        for (LiteContact candidateContact : this.mCandidateContacts) {
            String contactName = ContactManager.getContactFullName(candidateContact);
            if (contactName.toLowerCase().indexOf(key.toLowerCase()) < 0) continue;
            this.mCurrentMatchedContacts.add(candidateContact);
        }
        int index = 0;
        DefaultComboBoxModel<LiteContact> listModelContact = new DefaultComboBoxModel<LiteContact>(this.mCurrentMatchedContacts.toArray(new LiteContact[this.mCurrentMatchedContacts.size()]));
        this.listContact.setModel(listModelContact);
        for (LiteContact currentContact : this.mCurrentMatchedContacts) {
            listModelContact.addElement(currentContact);
            if (this.targetParticipants.contains(currentContact)) {
                this.listContact.addSelectionInterval(index, index);
            }
            ++index;
        }
        this.processing = false;
    }

    public LiteContact showDialog(String title, List<LiteContact> candidateContacts) {
        return this.showDialog(title, candidateContacts, false);
    }

    public LiteContact showDialog(String title, List<LiteContact> candidateContacts, boolean allowEmptySelection) {
        this.prepare();
        this.mCandidateContacts = candidateContacts;
        this.lblTitle.setText(title);
        String key = this.sfContact.getSearchKey();
        this.searchContact(key);
        this.mOK = false;
        this.mAllowEmptySelection = allowEmptySelection;
        this.setVisible(true);
        if (this.mOK) {
            LiteContact result = this.targetParticipants.isEmpty() ? null : this.targetParticipants.get(0);
            this.clean();
            return result;
        }
        this.clean();
        return null;
    }

    private void prepare() {
        this.mCandidateContacts = new ArrayList<LiteContact>();
        this.mCurrentMatchedContacts = new ArrayList<LiteContact>();
        this.targetParticipants = new ArrayList<LiteContact>();
    }

    private void clean() {
        this.mCandidateContacts = null;
        this.mCurrentMatchedContacts = null;
        this.targetParticipants = null;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.processing) {
            return;
        }
        if (this.mCurrentMatchedContacts == null) {
            return;
        }
        List<LiteContact> selection = this.listContact.getSelectedValuesList();
        for (LiteContact x : this.mCurrentMatchedContacts) {
            if (selection != null && selection.contains(x)) {
                if (this.targetParticipants.contains(x)) continue;
                this.targetParticipants.add(x);
                continue;
            }
            if (!this.targetParticipants.contains(x)) continue;
            this.targetParticipants.remove(x);
        }
        if (this.targetParticipants != null && this.targetParticipants.size() != 0) {
            this.mOK = true;
            this.dispose();
        }
    }
}

