/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.main;

import com.blisscloud.ezuc.client.util.simulate.Log;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineListener;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class VolumeMeter
extends JFrame {
    private List<Bar> bars = new ArrayList<Bar>();
    protected TargetDataLine line = null;

    public VolumeMeter() {
        super("Volume Meter");
        this.initGUI();
    }

    public void initGUI() {
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 3));
        mainPanel.setBackground(new Color(0, 0, 0, 0));
        this.getContentPane().add(mainPanel);
        this.setUndecorated(true);
        this.setAlwaysOnTop(true);
        this.setSize(50, 100);
        this.setLocation(16, 20);
        this.setDefaultCloseOperation(3);
        this.setBackground(new Color(0, 0, 0, 0));
        this.setType(Window.Type.UTILITY);
        Bar bar10 = new Bar(new Color(0xFF0000));
        mainPanel.add(bar10);
        Bar bar9 = new Bar(new Color(0xFF0000));
        mainPanel.add(bar9);
        Bar bar8 = new Bar(new Color(0xFFFF00));
        mainPanel.add(bar8);
        Bar bar7 = new Bar(new Color(0xFFFF00));
        mainPanel.add(bar7);
        Bar bar6 = new Bar(new Color(65280));
        mainPanel.add(bar6);
        Bar bar5 = new Bar(new Color(65280));
        mainPanel.add(bar5);
        Bar bar4 = new Bar(new Color(65280));
        mainPanel.add(bar4);
        Bar bar3 = new Bar(new Color(65280));
        mainPanel.add(bar3);
        Bar bar2 = new Bar(new Color(65280));
        mainPanel.add(bar2);
        Bar bar1 = new Bar(new Color(65280));
        mainPanel.add(bar1);
        this.bars.add(bar1);
        this.bars.add(bar2);
        this.bars.add(bar3);
        this.bars.add(bar4);
        this.bars.add(bar5);
        this.bars.add(bar6);
        this.bars.add(bar7);
        this.bars.add(bar8);
        this.bars.add(bar9);
        this.bars.add(bar10);
        this.pack();
        MouseAdapter ma = new MouseAdapter(){
            int lastX;
            int lastY;

            @Override
            public void mousePressed(MouseEvent e) {
                this.lastX = e.getXOnScreen();
                this.lastY = e.getYOnScreen();
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                int x = e.getXOnScreen();
                int y = e.getYOnScreen();
                VolumeMeter.this.setLocation(VolumeMeter.this.getLocationOnScreen().x + x - this.lastX, VolumeMeter.this.getLocationOnScreen().y + y - this.lastY);
                this.lastX = x;
                this.lastY = y;
            }
        };
        this.addMouseListener(ma);
        this.addMouseMotionListener(ma);
    }

    public void startListening() {
        Mixer.Info[] mixers = AudioSystem.getMixerInfo();
        Object targetInfo = null;
        for (Mixer.Info mixerInfo : mixers) {
            Line.Info[] lineInfos;
            Log.i(VolumeMeter.class.getSimpleName(), "mixer name: " + mixerInfo.getName());
            Mixer mixer = AudioSystem.getMixer(mixerInfo);
            for (Line.Info lineInfo : lineInfos = mixer.getTargetLineInfo()) {
                Log.i(VolumeMeter.class.getSimpleName(), "Line.Info: " + String.valueOf(lineInfo) + " " + String.valueOf(lineInfo.getLineClass()));
            }
        }
        AudioFormat format = new AudioFormat(42000.0f, 16, 1, true, true);
        DataLine.Info info = new DataLine.Info(TargetDataLine.class, format);
        Log.i(VolumeMeter.class.getSimpleName(), ">>>>>>>> " + String.valueOf(info));
        if (!AudioSystem.isLineSupported(info)) {
            System.out.println("The TargetDataLine is unavailable");
        }
        try {
            this.line = (TargetDataLine)AudioSystem.getLine(info);
            this.line.addLineListener(new LineListener(this){

                @Override
                public void update(LineEvent event) {
                    System.out.println("=>" + String.valueOf(event));
                }
            });
            this.line.open(format);
            this.line.start();
        }
        catch (LineUnavailableException ex) {
            System.out.println("The TargetDataLine is Unavailable.");
        }
        int level = 0;
        byte[] tempBuffer = new byte[6000];
        try {
            while (true) {
                if (this.line.read(tempBuffer, 0, tempBuffer.length) <= 0) {
                    continue;
                }
                level = VolumeMeter.calculateRMSLevel(tempBuffer);
                this.updateBars(level);
            }
        }
        catch (Throwable e) {
            System.err.println(e);
            System.exit(0);
            return;
        }
    }

    protected static int calculateRMSLevel(byte[] audioData) {
        long lSum = 0L;
        for (int i = 0; i < audioData.length; ++i) {
            lSum += (long)audioData[i];
        }
        double dAvg = lSum / (long)audioData.length;
        double sumMeanSquare = 0.0;
        for (int j = 0; j < audioData.length; ++j) {
            sumMeanSquare += Math.pow((double)audioData[j] - dAvg, 2.0);
        }
        double averageMeanSquare = sumMeanSquare / (double)audioData.length;
        return (int)(Math.pow(averageMeanSquare, 0.5) + 0.5) - 50;
    }

    public void updateBars(final int level) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (int i = 0; i < 10; ++i) {
                    VolumeMeter.this.bars.get((int)i).show = level > i;
                    VolumeMeter.this.bars.get(i).repaint();
                    VolumeMeter.this.bars.get(i).revalidate();
                }
            }
        });
    }

    public void close() {
        this.line.close();
    }

    public static void main(String[] args) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        boolean isTranslucencySupported = gd.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.TRANSLUCENT);
        if (!isTranslucencySupported) {
            System.err.println("Translucency not supported, exitting");
            System.exit(0);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final VolumeMeter main = new VolumeMeter();
                main.setVisible(true);
                Runnable r = new Runnable(){

                    @Override
                    public void run() {
                        main.startListening();
                        Runtime.getRuntime().addShutdownHook(new Thread(){

                            @Override
                            public void run() {
                                main.close();
                            }
                        });
                    }
                };
                new Thread(r).start();
            }
        });
    }

    class Bar
    extends JPanel {
        private static final int RECT_X = 0;
        private static final int RECT_Y = 0;
        private static final int RECT_WIDTH = 24;
        private static final int RECT_HEIGHT = 8;
        private Color color;
        public boolean show = false;

        public Bar(Color color) {
            this.color = color;
            this.setBackground(new Color(0, 0, 0, 0));
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.show) {
                g.setColor(this.color);
                g.fillRect(0, 0, 24, 8);
            } else {
                g.setColor(new Color(0, 0, 0, 0));
                g.clearRect(0, 0, 24, 8);
                g.fillRect(0, 0, 24, 8);
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(24, 8);
        }
    }
}

