/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.media;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.ImageIcon;

public class Archive {
    public static String BASE_PATH = new File("").getAbsolutePath();

    public static URL getJarURL(String jar_archive, String file_name) {
        if (jar_archive == null || file_name == null) {
            return null;
        }
        String url = "jar:file:" + BASE_PATH + "/" + jar_archive + "!/" + file_name;
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            System.err.println("ERROR: malformed url " + url);
            return null;
        }
    }

    public static URL getFileURL(String file_name) {
        if (file_name == null) {
            return null;
        }
        String url = "file:" + BASE_PATH + "/" + file_name;
        try {
            return new URL("file:" + BASE_PATH + "/" + file_name);
        }
        catch (MalformedURLException e) {
            System.err.println("ERROR: malformed url " + url);
            return null;
        }
    }

    public static Image getImage(String file_name) {
        if (file_name == null) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = null;
        if (new File((String)(file_name = BASE_PATH + "/" + (String)file_name)).canRead()) {
            image = toolkit.getImage((String)file_name);
            for (int i = 0; i < 4 && image.getWidth(null) < 0; ++i) {
                try {
                    Thread.sleep(80L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return image;
    }

    public static Image getImage(URL url) {
        if (url == null) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Image image = null;
        try {
            url.openConnection().connect();
            image = toolkit.getImage(url);
            for (int i = 0; i < 4 && image.getWidth(null) < 0; ++i) {
                try {
                    Thread.sleep(80L);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        catch (IOException e) {
            System.err.println("ERROR: can't read the file " + url.toString());
        }
        return image;
    }

    public static ImageIcon getImageIcon(String file_name) {
        file_name = BASE_PATH + "/" + (String)file_name;
        return new ImageIcon((String)file_name);
    }

    public static ImageIcon getImageIcon(URL url) {
        if (url == null) {
            return null;
        }
        ImageIcon icon = null;
        try {
            url.openConnection().connect();
            icon = new ImageIcon(url);
        }
        catch (IOException e) {
            System.err.println("ERROR: can't read the file " + url.toString());
        }
        return icon;
    }

    public static InputStream getInputStream(URL url) {
        if (url == null) {
            return null;
        }
        InputStream in = null;
        try {
            in = url.openStream();
        }
        catch (IOException e) {
            System.err.println("ERROR: can't read the file " + url.toString());
        }
        return in;
    }

    public static AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException {
        if (url == null) {
            return null;
        }
        AudioInputStream in = null;
        try {
            in = AudioSystem.getAudioInputStream(url);
        }
        catch (IOException e) {
            System.err.println("ERROR: can't read the file " + url.toString());
        }
        return in;
    }
}

