/*
 * Decompiled with CFR 0.152.
 */
package com.blisscloud.ezuc.client.phone;

import com.blisscloud.ezuc.client.bean.Node;
import com.blisscloud.ezuc.client.component.GenericDialog;
import com.blisscloud.ezuc.client.component.PhoneNodeCellRenderer;
import com.blisscloud.ezuc.client.resource.I18NUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class PhonePickerDialog
extends GenericDialog
implements ListSelectionListener {
    private JPanel panelContent;
    private JScrollPane jScrollPane1;
    private JList<Node> listContact;
    private JPanel jPanel1;
    private JLabel lblTitle;
    private JButton btnCancel;
    private boolean mOK = false;
    private DefaultComboBoxModel<Node> listModelContact = new DefaultComboBoxModel();
    private List<Node> mCandidateNodes;
    private boolean mShowSite = false;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame();
                PhonePickerDialog inst = new PhonePickerDialog(frame, false);
                inst.setVisible(true);
            }
        });
    }

    public PhonePickerDialog(JFrame frame, boolean showSite) {
        super(frame);
        this.mShowSite = showSite;
        this.initGUI();
    }

    private void initGUI() {
        try {
            this.setTitle(I18NUtil.getAppName());
            this.setModal(true);
            this.setLocationRelativeTo(null);
            this.panelContent = new JPanel();
            GridBagLayout panelContentLayout = new GridBagLayout();
            this.getContentPane().add((Component)this.panelContent, "Center");
            this.panelContent.setLayout(panelContentLayout);
            this.panelContent.setBackground(Color.WHITE);
            this.lblTitle = new JLabel();
            this.panelContent.add((Component)this.lblTitle, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(10, 10, 0, 10), 0, 0));
            this.lblTitle.setText(I18NUtil.getString("call_title_select_number_to_call"));
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(60);
            this.panelContent.add((Component)this.jScrollPane1, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 1, new Insets(3, 10, 0, 10), 0, 0));
            this.listContact = new JList();
            this.jScrollPane1.setViewportView(this.listContact);
            this.listContact.setCellRenderer(new PhoneNodeCellRenderer(this.mShowSite));
            this.listContact.setModel(this.listModelContact);
            this.listContact.setSelectionMode(0);
            this.listContact.getSelectionModel().addListSelectionListener(this);
            this.jPanel1 = new JPanel();
            FlowLayout jPanel1Layout = new FlowLayout();
            jPanel1Layout.setAlignment(2);
            jPanel1Layout.setHgap(10);
            this.jPanel1.setLayout(jPanel1Layout);
            this.panelContent.add((Component)this.jPanel1, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
            this.jPanel1.setOpaque(false);
            this.btnCancel = new JButton();
            this.jPanel1.add(this.btnCancel);
            this.btnCancel.setText(I18NUtil.getString("common_btn_cancel"));
            this.btnCancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    PhonePickerDialog.this.btnCancelActionPerformed(evt);
                }
            });
            this.setSize(280, 200);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void btnCancelActionPerformed(ActionEvent evt) {
        this.mOK = false;
        this.dispose();
    }

    @Override
    protected void onESCPressed() {
        this.mOK = false;
        this.dispose();
    }

    public Node showDialog(List<Node> candidateNodes) {
        this.mCandidateNodes = candidateNodes;
        this.listModelContact.removeAllElements();
        for (Node m : this.mCandidateNodes) {
            this.listModelContact.addElement(m);
        }
        this.mOK = false;
        this.setVisible(true);
        if (this.mOK) {
            return this.listContact.getSelectedValue();
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Node node = this.listContact.getSelectedValue();
        if (node != null) {
            Timer timer = new Timer(500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ld2) {
                    PhonePickerDialog.this.mOK = true;
                    PhonePickerDialog.this.dispose();
                }
            });
            timer.setRepeats(false);
            timer.start();
        }
    }
}

